/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RingQueueTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private final SimpleString address = SimpleString.of((String)"RingQueueTestAddress");
    private final SimpleString qName = SimpleString.of((String)"RingQueueTestQ1");

    @Test
    public void testSimple() throws Exception {
        ServerLocator locator = this.createNettyNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession clientSession = this.addClientSession(sf.createSession(false, true, true));
        clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName).setAddress(this.address).setRingSize(Long.valueOf(1L)));
        clientSession.start();
        Queue queue = this.server.locateQueue(this.qName);
        Assertions.assertEquals((long)1L, (long)queue.getRingSize());
        ClientProducer producer = clientSession.createProducer(this.address);
        int i = 0;
        int j = 0;
        while (i < 500) {
            ClientMessage m0 = this.createTextMessage(clientSession, "hello" + i);
            producer.send((Message)m0);
            Wait.assertTrue(() -> queue.getMessageCount() == 1L);
            ClientMessage m1 = this.createTextMessage(clientSession, "hello" + (i + 1));
            producer.send((Message)m1);
            int expectedMessagesReplaced = j + 1;
            Wait.assertTrue(() -> queue.getMessagesReplaced() == (long)expectedMessagesReplaced);
            Wait.assertTrue(() -> queue.getMessageCount() == 1L);
            ClientConsumer consumer = clientSession.createConsumer(this.qName);
            ClientMessage message = consumer.receiveImmediate();
            message.acknowledge();
            consumer.close();
            Assertions.assertEquals((Object)("hello" + (i + 1)), (Object)message.getBodyBuffer().readString());
            i += 2;
            ++j;
        }
    }

    @Test
    public void testRollback() throws Exception {
        ServerLocator locator = this.createNettyNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession clientSession = this.addClientSession(sf.createSession(false, true, false));
        clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName).setAddress(this.address).setRingSize(Long.valueOf(1L)));
        clientSession.start();
        Queue queue = this.server.locateQueue(this.qName);
        Assertions.assertEquals((long)1L, (long)queue.getRingSize());
        ClientProducer producer = clientSession.createProducer(this.address);
        ClientMessage m0 = this.createTextMessage(clientSession, "hello0");
        producer.send((Message)m0);
        Wait.assertTrue(() -> queue.getMessageCount() == 1L);
        ClientConsumer consumer = clientSession.createConsumer(this.qName);
        ClientMessage message = consumer.receiveImmediate();
        Assertions.assertNotNull((Object)message);
        Wait.assertTrue(() -> queue.getDeliveringCount() == 1);
        message.acknowledge();
        Assertions.assertEquals((Object)"hello0", (Object)message.getBodyBuffer().readString());
        ClientMessage m1 = this.createTextMessage(clientSession, "hello1");
        producer.send((Message)m1);
        Wait.assertTrue(() -> queue.getDeliveringCount() == 2);
        Wait.assertTrue(() -> queue.getMessagesReplaced() == 0L);
        Wait.assertTrue(() -> queue.getMessageCount() == 2L);
        clientSession.rollback();
        consumer.close();
        Wait.assertTrue(() -> queue.getDeliveringCount() == 0);
        Wait.assertTrue(() -> queue.getMessagesReplaced() == 1L);
        Wait.assertTrue(() -> queue.getMessageCount() == 1L);
        consumer = clientSession.createConsumer(this.qName);
        message = consumer.receiveImmediate();
        Assertions.assertNotNull((Object)message);
        Wait.assertTrue(() -> queue.getDeliveringCount() == 1);
        message.acknowledge();
        clientSession.commit();
        Wait.assertTrue(() -> queue.getMessagesAcknowledged() == 1L);
        Assertions.assertEquals((Object)"hello1", (Object)message.getBodyBuffer().readString());
    }

    @Test
    public void testConsumerCloseWithDirectDeliver() throws Exception {
        ServerLocator locator = this.createNettyNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession clientSession = this.addClientSession(sf.createSession(false, true, false));
        clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName).setAddress(this.address).setRingSize(Long.valueOf(1L)));
        clientSession.start();
        Queue queue = this.server.locateQueue(this.qName);
        Assertions.assertEquals((long)1L, (long)queue.getRingSize());
        ClientConsumer consumer = clientSession.createConsumer(this.qName);
        ClientProducer producer = clientSession.createProducer(this.address);
        ClientMessage message = this.createTextMessage(clientSession, "hello0");
        producer.send((Message)message);
        message = this.createTextMessage(clientSession, "hello1");
        producer.send((Message)message);
        Wait.assertEquals((long)2L, () -> ((Queue)queue).getMessageCount());
        Wait.assertEquals((int)2, () -> ((Queue)queue).getDeliveringCount());
        consumer.close();
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        Wait.assertEquals((int)0, () -> ((Queue)queue).getDeliveringCount());
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessagesReplaced());
        consumer = clientSession.createConsumer(this.qName);
        message = consumer.receiveImmediate();
        Assertions.assertNotNull((Object)message);
        Wait.assertTrue(() -> queue.getDeliveringCount() == 1);
        message.acknowledge();
        clientSession.commit();
        Wait.assertTrue(() -> queue.getMessagesAcknowledged() == 1L);
        Assertions.assertEquals((Object)"hello1", (Object)message.getBodyBuffer().readString());
        consumer.close();
        Wait.assertTrue(() -> queue.getMessageCount() == 0L);
        Wait.assertTrue(() -> queue.getDeliveringCount() == 0);
        Wait.assertTrue(() -> queue.getMessagesReplaced() == 1L);
    }

    @Test
    public void testScheduled() throws Exception {
        ServerLocator locator = this.createNettyNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession clientSession = this.addClientSession(sf.createSession(false, true, false));
        clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName).setAddress(this.address).setRingSize(Long.valueOf(1L)));
        clientSession.start();
        Queue queue = this.server.locateQueue(this.qName);
        Assertions.assertEquals((long)1L, (long)queue.getRingSize());
        ClientProducer producer = clientSession.createProducer(this.address);
        ClientMessage m0 = this.createTextMessage(clientSession, "hello0");
        long time = System.currentTimeMillis();
        m0.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time += 500L);
        producer.send((Message)m0);
        Wait.assertTrue(() -> queue.getScheduledCount() == 1);
        Wait.assertTrue(() -> ((QueueImpl)queue).getPendingMessageCount() == 0L);
        time = System.currentTimeMillis();
        m0.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time += 500L);
        producer.send((Message)m0);
        Wait.assertTrue(() -> queue.getScheduledCount() == 2);
        Wait.assertTrue(() -> ((QueueImpl)queue).getPendingMessageCount() == 0L);
        Wait.assertTrue(() -> queue.getMessagesReplaced() == 1L);
        Wait.assertTrue(() -> ((QueueImpl)queue).getPendingMessageCount() == 1L);
    }

    @Test
    public void testDefaultAddressSetting() throws Exception {
        SimpleString random = RandomUtil.randomSimpleString();
        this.server.getAddressSettingsRepository().addMatch(this.address.toString(), (Object)new AddressSettings().setDefaultRingSize(100L));
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://0");
        Connection c = cf.createConnection();
        Session s = c.createSession();
        MessageProducer producer = s.createProducer((Destination)s.createQueue(this.address.toString()));
        producer.send(s.createMessage());
        Wait.assertTrue(() -> this.server.locateQueue(this.address) != null);
        Assertions.assertEquals((long)100L, (long)this.server.locateQueue(this.address).getRingSize());
        producer.close();
        producer = s.createProducer((Destination)s.createQueue(random.toString()));
        producer.send(s.createMessage());
        Wait.assertTrue(() -> this.server.locateQueue(random) != null);
        Assertions.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultRingSize(), (long)this.server.locateQueue(random).getRingSize());
    }

    @Test
    public void testUpdate() throws Exception {
        int i;
        ClientMessage message;
        int j;
        ServerLocator locator = this.createNettyNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession clientSession = this.addClientSession(sf.createSession(false, true, true));
        clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName).setAddress(this.address).setRoutingType(RoutingType.ANYCAST));
        clientSession.start();
        Queue queue = this.server.locateQueue(this.qName);
        Assertions.assertEquals((long)-1L, (long)queue.getRingSize());
        ClientProducer producer = clientSession.createProducer(this.address);
        for (int i2 = 0; i2 < 100; ++i2) {
            producer.send((Message)clientSession.createMessage(true));
        }
        Wait.assertTrue(() -> queue.getMessageCount() == 100L);
        queue.setRingSize(10L);
        ClientConsumer consumer = clientSession.createConsumer(this.qName);
        for (j = 0; j < 95; ++j) {
            message = consumer.receiveImmediate();
            message.acknowledge();
        }
        consumer.close();
        Wait.assertEquals((long)5L, () -> ((Queue)queue).getMessageCount());
        for (i = 0; i < 5; ++i) {
            producer.send((Message)clientSession.createMessage(true));
        }
        Wait.assertEquals((long)10L, () -> ((Queue)queue).getMessageCount());
        for (i = 0; i < 5; ++i) {
            producer.send((Message)clientSession.createMessage(true));
            Wait.assertEquals((long)10L, () -> ((Queue)queue).getMessageCount());
        }
        Wait.assertEquals((long)5L, () -> ((Queue)queue).getMessagesReplaced());
        consumer = clientSession.createConsumer(this.qName);
        message = consumer.receiveImmediate();
        Assertions.assertNotNull((Object)message);
        message.acknowledge();
        consumer.close();
        Wait.assertTrue(() -> queue.getMessageCount() == 9L);
        queue.setRingSize(5L);
        consumer = clientSession.createConsumer(this.qName);
        for (j = 0; j < 4; ++j) {
            message = consumer.receiveImmediate();
            message.acknowledge();
        }
        consumer.close();
        Wait.assertTrue(() -> queue.getMessageCount() == 5L);
        producer.send((Message)clientSession.createMessage(true));
        Wait.assertTrue(() -> queue.getMessagesReplaced() == 6L);
        queue.setRingSize(10L);
        for (i = 0; i < 5; ++i) {
            producer.send((Message)clientSession.createMessage(true));
        }
        Wait.assertTrue(() -> queue.getMessageCount() == 10L);
        producer.send((Message)clientSession.createMessage(true));
        Wait.assertTrue(() -> queue.getMessagesReplaced() == 7L);
        Wait.assertTrue(() -> queue.getMessageCount() == 10L);
    }

    @Test
    public void testNonDestructive() throws Exception {
        ServerLocator locator = this.createNettyNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession clientSession = this.addClientSession(sf.createSession(false, true, true));
        clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName).setAddress(this.address).setRingSize(Long.valueOf(1L)).setNonDestructive(Boolean.valueOf(true)));
        clientSession.start();
        Queue queue = this.server.locateQueue(this.qName);
        Assertions.assertEquals((long)1L, (long)queue.getRingSize());
        ClientProducer producer = clientSession.createProducer(this.address);
        ClientMessage message = this.createTextMessage(clientSession, "hello0");
        producer.send((Message)message);
        for (int i = 0; i < 5; ++i) {
            Wait.assertTrue(() -> queue.getMessageCount() == 1L);
            message = this.createTextMessage(clientSession, "hello" + (i + 1));
            producer.send((Message)message);
            int finalI = i + 1;
            Wait.assertTrue(() -> queue.getMessagesReplaced() == (long)finalI);
            Wait.assertTrue(() -> queue.getMessageCount() == 1L);
            ClientConsumer consumer = clientSession.createConsumer(this.qName);
            message = consumer.receiveImmediate();
            Assertions.assertNotNull((Object)message);
            message.acknowledge();
            consumer.close();
            Assertions.assertEquals((Object)("hello" + (i + 1)), (Object)message.getBodyBuffer().readString());
        }
    }

    @Test
    public void testNonDestructiveWithConsumerClose() throws Exception {
        ServerLocator locator = this.createNettyNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession clientSession = this.addClientSession(sf.createSession(false, true, true));
        clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName).setAddress(this.address).setRingSize(Long.valueOf(1L)).setNonDestructive(Boolean.valueOf(true)));
        clientSession.start();
        Queue queue = this.server.locateQueue(this.qName);
        Assertions.assertEquals((long)1L, (long)queue.getRingSize());
        ClientProducer producer = clientSession.createProducer(this.address);
        ClientMessage m0 = this.createTextMessage(clientSession, "hello0");
        producer.send((Message)m0);
        Wait.assertTrue(() -> queue.getMessageCount() == 1L);
        ClientConsumer consumer = clientSession.createConsumer(this.qName);
        Wait.assertTrue(() -> queue.getDeliveringCount() == 1);
        consumer.close();
        Wait.assertTrue(() -> queue.getDeliveringCount() == 0);
        Wait.assertTrue(() -> queue.getMessageCount() == 1L);
    }

    @Test
    public void testMultipleConcurrentProducers() throws Exception {
        long RING_SIZE = 25L;
        ServerLocator locator = this.createNettyNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession clientSession = this.addClientSession(sf.createSession(false, true, true));
        clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName).setAddress(this.address).setRingSize(Long.valueOf(25L)));
        clientSession.start();
        Queue queue = this.server.locateQueue(this.qName);
        Assertions.assertEquals((long)25L, (long)queue.getRingSize());
        int nThreads = 25;
        long numberOfMessages = 25L;
        SomeProducer[] producers = new SomeProducer[25];
        try {
            int i;
            for (i = 0; i < 25; ++i) {
                producers[i] = new SomeProducer(25L, 25, this.address);
            }
            for (i = 0; i < 25; ++i) {
                producers[i].start();
            }
            for (SomeProducer producer : producers) {
                producer.join();
                Assertions.assertEquals((int)0, (int)producer.errors.get());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
        Wait.assertTrue((String)("message count should be 25 but it's actually " + queue.getMessageCount()), () -> queue.getMessageCount() == 25L);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultNettyConfig(), (boolean)true));
        this.server.start();
    }

    class SomeProducer
    extends Thread {
        final ClientSessionFactory factory;
        final ServerLocator locator;
        final ClientSession prodSession;
        public final AtomicInteger errors = new AtomicInteger(0);
        final long numberOfMessages;
        final int nThreads;
        final SimpleString address;

        SomeProducer(long numberOfMessages, int nThreads, SimpleString address) throws Exception {
            this.locator = RingQueueTest.this.createNettyNonHALocator();
            this.factory = this.locator.createSessionFactory();
            this.prodSession = this.factory.createSession(true, false);
            this.numberOfMessages = numberOfMessages;
            this.nThreads = nThreads;
            this.address = address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ClientProducer producer = this.prodSession.createProducer(this.address);
                int i = 0;
                while ((long)i < this.numberOfMessages) {
                    ClientMessage message = this.prodSession.createMessage(true);
                    message.putIntProperty("prodNR", i % this.nThreads);
                    producer.send((Message)message);
                    ++i;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.errors.incrementAndGet();
            }
            finally {
                try {
                    this.prodSession.close();
                    this.locator.close();
                }
                catch (Throwable ignored) {
                    ignored.printStackTrace();
                }
            }
        }
    }
}

