/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.PrimaryOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.ClusterController;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.collections.IterableStream;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class ScaleDownTest
extends ClusterTestBase {
    private static final String AMQP_ACCEPTOR_URI = "tcp://127.0.0.1:5672";
    private boolean useScaleDownGroupName;

    @Parameters(name="useScaleDownGroupName={0}")
    public static Collection getParameters() {
        return Arrays.asList({true}, {false});
    }

    public ScaleDownTest(boolean useScaleDownGroupName) {
        this.useScaleDownGroupName = useScaleDownGroupName;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setupPrimaryServer(0, this.isFileStorage(), this.isNetty(), true);
        this.setupPrimaryServer(1, this.isFileStorage(), this.isNetty(), true);
        this.servers[0].getConfiguration().addAcceptorConfiguration("amqp", "tcp://127.0.0.1:5672?protocols=AMQP");
        PrimaryOnlyPolicyConfiguration haPolicyConfiguration0 = (PrimaryOnlyPolicyConfiguration)this.servers[0].getConfiguration().getHAPolicyConfiguration();
        haPolicyConfiguration0.setScaleDownConfiguration(new ScaleDownConfiguration());
        PrimaryOnlyPolicyConfiguration haPolicyConfiguration1 = (PrimaryOnlyPolicyConfiguration)this.servers[1].getConfiguration().getHAPolicyConfiguration();
        haPolicyConfiguration1.setScaleDownConfiguration(new ScaleDownConfiguration());
        if (this.useScaleDownGroupName) {
            haPolicyConfiguration0.getScaleDownConfiguration().setGroupName("bill");
            haPolicyConfiguration1.getScaleDownConfiguration().setGroupName("bill");
        }
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        haPolicyConfiguration0.getScaleDownConfiguration().getConnectors().addAll(((ClusterConnectionConfiguration)this.servers[0].getConfiguration().getClusterConfigurations().iterator().next()).getStaticConnectors());
        haPolicyConfiguration1.getScaleDownConfiguration().getConnectors().addAll(((ClusterConnectionConfiguration)this.servers[1].getConfiguration().getClusterConfigurations().iterator().next()).getStaticConnectors());
        this.servers[0].getConfiguration().getAddressSettings().put("#", new AddressSettings().setRedistributionDelay(0L));
        this.servers[1].getConfiguration().getAddressSettings().put("#", new AddressSettings().setRedistributionDelay(0L));
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
    }

    protected boolean isNetty() {
        return true;
    }

    @Override
    protected boolean isResolveProtocols() {
        return true;
    }

    @TestTemplate
    public void testBasicScaleDown() throws Exception {
        int TEST_SIZE = 2;
        String addressName = "testAddress";
        String queueName1 = "testQueue1";
        String queueName2 = "testQueue2";
        this.createQueue(0, "testAddress", "testQueue1", null, true);
        this.createQueue(0, "testAddress", "testQueue2", null, true);
        this.createQueue(1, "testAddress", "testQueue1", null, true);
        this.createQueue(1, "testAddress", "testQueue2", null, true);
        this.send(0, "testAddress", 2, true, null);
        this.addConsumer(1, 0, "testQueue2", null, false);
        ClientMessage clientMessage = this.consumers[1].getConsumer().receive(1000L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        this.consumers[1].getSession().commit();
        Assertions.assertEquals((int)2, (int)this.getMessageCount(((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(SimpleString.of((String)"testQueue1"))).getQueue()));
        Assertions.assertEquals((int)1, (int)this.getMessageCount(((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(SimpleString.of((String)"testQueue2"))).getQueue()));
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue1", null);
        clientMessage = this.consumers[0].getConsumer().receive(1000L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receive(1000L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receiveImmediate();
        Assertions.assertNull((Object)clientMessage);
        this.removeConsumer(0);
        this.addConsumer(0, 1, "testQueue2", null);
        clientMessage = this.consumers[0].getConsumer().receive(1000L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receiveImmediate();
        Assertions.assertNull((Object)clientMessage);
        this.removeConsumer(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testScaleDownNodeReconnect() throws Exception {
        try {
            ClusterController controller = this.servers[0].getClusterManager().getClusterController();
            Map locatorsMap = controller.getLocators();
            Iterator iter = locatorsMap.entrySet().iterator();
            Assertions.assertTrue((boolean)iter.hasNext());
            Map.Entry entry = iter.next();
            ServerLocatorImpl locator = (ServerLocatorImpl)entry.getValue();
            this.waitForClusterConnected(locator);
            this.servers[1].stop();
            this.servers[1].start();
            this.checkClusterConnectionExecutorNotBlocking(locator);
        }
        finally {
            this.servers[1].stop();
            this.servers[0].stop();
        }
    }

    private void checkClusterConnectionExecutorNotBlocking(ServerLocatorImpl locator) throws NoSuchFieldException, IllegalAccessException {
        Field factoriesField = locator.getClass().getDeclaredField("factories");
        factoriesField.setAccessible(true);
        Set factories = (Set)factoriesField.get(locator);
        Assertions.assertEquals((int)1, (int)factories.size());
        ClientSessionFactoryImpl factory = (ClientSessionFactoryImpl)factories.iterator().next();
        Field executorField = factory.getClass().getDeclaredField("closeExecutor");
        executorField.setAccessible(true);
        Executor pool = (Executor)executorField.get(factory);
        CountDownLatch latch = new CountDownLatch(1);
        pool.execute(() -> latch.countDown());
        boolean result = false;
        try {
            result = latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)result, (String)"executor got blocked.");
    }

    private void waitForClusterConnected(ServerLocatorImpl locator) throws Exception {
        boolean result = Wait.waitFor(() -> !locator.getTopology().isEmpty(), (long)5000L);
        Assertions.assertTrue((boolean)result, (String)"topology should not be empty");
    }

    @TestTemplate
    public void testStoreAndForward() throws Exception {
        int TEST_SIZE = 50;
        String addressName1 = "testAddress1";
        String addressName2 = "testAddress2";
        String queueName1 = "testQueue1";
        String queueName2 = "testQueue2";
        this.createQueue(0, "testAddress1", "testQueue1", null, false);
        this.createQueue(1, "testAddress1", "testQueue1", null, false);
        this.createQueue(0, "testAddress2", "testQueue2", null, false);
        this.createQueue(1, "testAddress2", "testQueue2", null, false);
        String sfQueueName = null;
        for (Binding binding : IterableStream.iterableOf((Stream)this.servers[0].getPostOffice().getAllBindings())) {
            String temp = binding.getAddress().toString();
            if (!temp.startsWith(this.servers[1].getInternalNamingPrefix() + "sf.") || !temp.endsWith(this.servers[1].getNodeID().toString())) continue;
            ((LocalQueueBinding)binding).getQueue().pause();
            sfQueueName = temp;
        }
        Assertions.assertNotNull(sfQueueName);
        this.send(0, "testAddress1", 50, false, null);
        this.send(0, "testAddress2", 50, false, null);
        this.addConsumer(0, 1, "testQueue1", null);
        this.addConsumer(1, 1, "testQueue2", null);
        LocalQueueBinding queue1Binding = (LocalQueueBinding)this.servers[0].getPostOffice().getBinding(SimpleString.of((String)"testQueue1"));
        LocalQueueBinding queue2Binding = (LocalQueueBinding)this.servers[0].getPostOffice().getBinding(SimpleString.of((String)"testQueue2"));
        LocalQueueBinding sfQueueBinding = (LocalQueueBinding)this.servers[0].getPostOffice().getBinding(SimpleString.of((String)sfQueueName));
        long timeout = 5000L;
        long start = System.currentTimeMillis();
        while (this.getMessageCount(queue1Binding.getQueue()) > 0 && System.currentTimeMillis() - start <= timeout) {
            Thread.sleep(50L);
        }
        start = System.currentTimeMillis();
        while (this.getMessageCount(queue2Binding.getQueue()) > 0 && System.currentTimeMillis() - start <= timeout) {
            Thread.sleep(50L);
        }
        start = System.currentTimeMillis();
        while (this.getMessageCount(sfQueueBinding.getQueue()) < 100 && System.currentTimeMillis() - start <= timeout) {
            Thread.sleep(50L);
        }
        Assertions.assertEquals((int)0, (int)this.getMessageCount(queue1Binding.getQueue()));
        Assertions.assertEquals((int)0, (int)this.getMessageCount(queue2Binding.getQueue()));
        Assertions.assertEquals((int)100, (int)this.getMessageCount(sfQueueBinding.getQueue()));
        this.removeConsumer(0);
        this.removeConsumer(1);
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue1", null);
        for (int i = 0; i < 50; ++i) {
            ClientMessage clientMessage = this.consumers[0].getConsumer().receive(250L);
            Assertions.assertNotNull((Object)clientMessage);
            clientMessage.acknowledge();
        }
        ClientMessage clientMessage = this.consumers[0].getConsumer().receiveImmediate();
        Assertions.assertNull((Object)clientMessage);
        this.removeConsumer(0);
        this.addConsumer(0, 1, "testQueue2", null);
        for (int i = 0; i < 50; ++i) {
            clientMessage = this.consumers[0].getConsumer().receive(250L);
            Assertions.assertNotNull((Object)clientMessage);
            clientMessage.acknowledge();
        }
        clientMessage = this.consumers[0].getConsumer().receiveImmediate();
        Assertions.assertNull((Object)clientMessage);
        this.removeConsumer(0);
    }

    @TestTemplate
    public void testScaleDownWithMissingQueue() throws Exception {
        int TEST_SIZE = 2;
        String addressName = "testAddress";
        String queueName1 = "testQueue1";
        String queueName2 = "testQueue2";
        this.createQueue(0, "testAddress", "testQueue1", null, false);
        this.createQueue(0, "testAddress", "testQueue2", null, false);
        this.createQueue(1, "testAddress", "testQueue1", null, false);
        this.send(0, "testAddress", 2, false, null);
        this.addConsumer(1, 0, "testQueue2", null, false);
        ClientMessage clientMessage = this.consumers[1].getConsumer().receive(250L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        this.consumers[1].getSession().commit();
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue1", null);
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receiveImmediate();
        Assertions.assertNull((Object)clientMessage);
        this.removeConsumer(0);
        this.addConsumer(0, 1, "testQueue2", null);
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receiveImmediate();
        Assertions.assertNull((Object)clientMessage);
        this.removeConsumer(0);
    }

    @TestTemplate
    public void testScaleDownWithMissingAnycastQueue() throws Exception {
        int TEST_SIZE = 2;
        String addressName = "testAddress";
        String queueName = "testQueue";
        this.createQueue(0, "testAddress", "testQueue", null, false, null, null, RoutingType.ANYCAST);
        this.send(0, "testAddress", 2, false, null);
        this.servers[0].stop();
        Assertions.assertEquals((Object)((QueueImpl)((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(SimpleString.of((String)"testQueue"))).getBindable()).getRoutingType(), (Object)RoutingType.ANYCAST);
        this.addConsumer(0, 1, "testQueue", null);
        ClientMessage clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAMQPMessages(String address, int numMessages, boolean durable) throws Exception {
        AmqpClient client = new AmqpClient(new URI(AMQP_ACCEPTOR_URI), "admin", "admin");
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(address);
            for (int i = 0; i < numMessages; ++i) {
                AmqpMessage message = new AmqpMessage();
                message.setMessageId("MessageID:" + i);
                message.setDurable(durable);
                sender.send(message);
            }
        }
    }

    @TestTemplate
    public void testScaleDownAMQPMessagesWithMissingAnycastQueue() throws Exception {
        int TEST_SIZE = 2;
        String addressName = "testAddress";
        String queueName = "testQueue";
        this.createQueue(0, "testAddress", "testQueue", null, false, null, null, RoutingType.ANYCAST);
        this.sendAMQPMessages("testAddress", 2, false);
        this.servers[0].stop();
        Assertions.assertEquals((Object)((QueueImpl)((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(SimpleString.of((String)"testQueue"))).getBindable()).getRoutingType(), (Object)RoutingType.ANYCAST);
        this.addConsumer(0, 1, "testQueue", null);
        ClientMessage clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
    }

    @TestTemplate
    public void testScaleDownAMQPMessagesWithMissingMulticastQueues() throws Exception {
        int TEST_SIZE = 2;
        String addressName = "testAddress";
        String queueName1 = "testQueue1";
        String queueName2 = "testQueue2";
        this.createQueue(0, "testAddress", "testQueue1", null, false, null, null, RoutingType.MULTICAST);
        this.createQueue(0, "testAddress", "testQueue2", null, false, null, null, RoutingType.MULTICAST);
        this.sendAMQPMessages("testAddress", 2, false);
        Assertions.assertEquals((long)((QueueImpl)((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(SimpleString.of((String)"testQueue1"))).getBindable()).getMessageCount(), (long)2L);
        Assertions.assertEquals((long)((QueueImpl)((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(SimpleString.of((String)"testQueue2"))).getBindable()).getMessageCount(), (long)2L);
        this.servers[0].stop();
        Assertions.assertEquals((Object)((QueueImpl)((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(SimpleString.of((String)"testQueue1"))).getBindable()).getRoutingType(), (Object)RoutingType.MULTICAST);
        Assertions.assertEquals((Object)((QueueImpl)((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(SimpleString.of((String)"testQueue2"))).getBindable()).getRoutingType(), (Object)RoutingType.MULTICAST);
        Assertions.assertEquals((long)((QueueImpl)((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(SimpleString.of((String)"testQueue1"))).getBindable()).getMessageCount(), (long)2L);
        Assertions.assertEquals((long)((QueueImpl)((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(SimpleString.of((String)"testQueue2"))).getBindable()).getMessageCount(), (long)2L);
        this.addConsumer(0, 1, "testQueue1", null);
        ClientMessage clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        this.addConsumer(1, 1, "testQueue2", null);
        clientMessage = this.consumers[1].getConsumer().receive(250L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
    }

    @TestTemplate
    public void testMessageProperties() throws Exception {
        int TEST_SIZE = 5;
        String addressName = "testAddress";
        String queueName = "testQueue";
        this.createQueue(0, "testAddress", "testQueue", null, false);
        this.createQueue(1, "testAddress", "testQueue", null, false);
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        ClientProducer producer = this.addClientProducer(session.createProducer("testAddress"));
        StringBuilder international = new StringBuilder();
        for (char x = '\u0320'; x < '\u04b0'; x = (char)(x + '\u0001')) {
            international.append(x);
        }
        String special = "\"<>'&";
        for (int i = 0; i < 5; ++i) {
            ClientMessage msg = session.createMessage(true);
            msg.getBodyBuffer().writeString("Bob the giant pig " + i);
            msg.putBooleanProperty("myBooleanProperty", Boolean.TRUE.booleanValue());
            msg.putByteProperty("myByteProperty", Byte.parseByte("0"));
            msg.putBytesProperty("myBytesProperty", new byte[]{0, 1, 2, 3, 4});
            msg.putDoubleProperty("myDoubleProperty", (double)i * 1.6);
            msg.putFloatProperty("myFloatProperty", (float)i * 2.5f);
            msg.putIntProperty("myIntProperty", i);
            msg.putLongProperty("myLongProperty", Long.MAX_VALUE - (long)i);
            msg.putObjectProperty("myObjectProperty", (Object)i);
            msg.putShortProperty("myShortProperty", Integer.valueOf(i).shortValue());
            msg.putStringProperty("myStringProperty", "myStringPropertyValue_" + i);
            msg.putStringProperty("myNonAsciiStringProperty", international.toString());
            msg.putStringProperty("mySpecialCharacters", special);
            producer.send((Message)msg);
        }
        this.servers[0].stop();
        sf = this.sfs[1];
        session = this.addClientSession(sf.createSession(false, true, true));
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer("testQueue"));
        session.start();
        for (int i = 0; i < 5; ++i) {
            ClientMessage msg = consumer.receive(250L);
            byte[] body = new byte[msg.getBodySize()];
            msg.getBodyBuffer().readBytes(body);
            Assertions.assertTrue((boolean)new String(body).contains("Bob the giant pig " + i));
            Assertions.assertEquals((Object)msg.getBooleanProperty("myBooleanProperty"), (Object)Boolean.TRUE);
            Assertions.assertEquals((Byte)msg.getByteProperty("myByteProperty"), (Byte)Byte.valueOf("0"));
            byte[] bytes = msg.getBytesProperty("myBytesProperty");
            for (int j = 0; j < 5; ++j) {
                Assertions.assertEquals((int)j, (int)bytes[j]);
            }
            Assertions.assertEquals((double)((double)i * 1.6), (double)msg.getDoubleProperty("myDoubleProperty"), (double)1.0E-6);
            Assertions.assertEquals((double)((float)i * 2.5f), (double)msg.getFloatProperty("myFloatProperty").floatValue(), (double)1.0E-6);
            Assertions.assertEquals((int)i, (int)msg.getIntProperty("myIntProperty"));
            Assertions.assertEquals((long)(Long.MAX_VALUE - (long)i), (long)msg.getLongProperty("myLongProperty"));
            Assertions.assertEquals((Object)i, (Object)msg.getObjectProperty("myObjectProperty"));
            Assertions.assertEquals((short)Integer.valueOf(i).shortValue(), (short)msg.getShortProperty("myShortProperty"));
            Assertions.assertEquals((Object)("myStringPropertyValue_" + i), (Object)msg.getStringProperty("myStringProperty"));
            Assertions.assertEquals((Object)international.toString(), (Object)msg.getStringProperty("myNonAsciiStringProperty"));
            Assertions.assertEquals((Object)special, (Object)msg.getStringProperty("mySpecialCharacters"));
        }
    }

    @TestTemplate
    public void testLargeMessage() throws Exception {
        String addressName = "testAddress";
        String queueName = "testQueue";
        this.createQueue(0, "testAddress", "testQueue", null, true);
        this.createQueue(1, "testAddress", "testQueue", null, true);
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = this.addClientSession(sf.createSession(false, false));
        ClientProducer producer = this.addClientProducer(session.createProducer("testAddress"));
        byte[] buffer = new byte[204800];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = ScaleDownTest.getSamplebyte(i);
        }
        for (int nmsg = 0; nmsg < 10; ++nmsg) {
            ClientMessage message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(buffer);
            producer.send((Message)message);
            session.commit();
        }
        this.servers[0].stop();
        sf = this.sfs[1];
        session = this.addClientSession(sf.createSession(false, true, true));
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer("testQueue"));
        session.start();
        for (int nmsg = 0; nmsg < 10; ++nmsg) {
            ClientMessage msg = consumer.receive(250L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((int)204800, (int)msg.getBodySize());
            for (int i = 0; i < 204800; ++i) {
                byte byteRead = msg.getBodyBuffer().readByte();
                Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)byteRead, (String)(msg + " Is different"));
            }
            msg.acknowledge();
            session.commit();
        }
    }

    @TestTemplate
    public void testPaging() throws Exception {
        int i;
        int CHUNK_SIZE = 50;
        int messageCount = 0;
        String addressName = "testAddress";
        String queueName = "testQueue";
        this.createQueue(0, "testAddress", "testQueue", null, false);
        this.createQueue(1, "testAddress", "testQueue", null, false);
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = this.addClientSession(sf.createSession(false, false));
        ClientProducer producer = this.addClientProducer(session.createProducer("testAddress"));
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L);
        this.servers[0].getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        while (!this.servers[0].getPagingManager().getPageStore(SimpleString.of((String)"testAddress")).isPaging()) {
            for (i = 0; i < 50; ++i) {
                ClientMessage message = session.createMessage(true);
                message.getBodyBuffer().writeBytes(new byte[1024]);
                producer.send((Message)message);
                ++messageCount;
            }
            session.commit();
        }
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue", null);
        for (i = 0; i < messageCount; ++i) {
            Assertions.assertNotNull((Object)this.consumers[0].getConsumer().receive(250L));
        }
        Assertions.assertNull((Object)this.consumers[0].getConsumer().receiveImmediate());
        this.removeConsumer(0);
    }

    @TestTemplate
    public void testOrderWithPaging() throws Exception {
        int i;
        int CHUNK_SIZE = 50;
        int messageCount = 0;
        String addressName = "testAddress";
        String queueName = "testQueue";
        this.createQueue(0, "testAddress", "testQueue", null, false);
        this.createQueue(1, "testAddress", "testQueue", null, false);
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = this.addClientSession(sf.createSession(false, false));
        ClientProducer producer = this.addClientProducer(session.createProducer("testAddress"));
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L);
        this.servers[0].getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        while (!this.servers[0].getPagingManager().getPageStore(SimpleString.of((String)"testAddress")).isPaging()) {
            for (i = 0; i < 50; ++i) {
                ClientMessage message = session.createMessage(true);
                message.getBodyBuffer().writeBytes(new byte[1024]);
                message.putIntProperty("order", i);
                producer.send((Message)message);
                ++messageCount;
            }
            session.commit();
        }
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue", null);
        for (i = 0; i < messageCount; ++i) {
            Assertions.assertEquals((int)i, (int)this.consumers[0].getConsumer().receive(250L).getIntProperty("order"));
        }
        Assertions.assertNull((Object)this.consumers[0].getConsumer().receiveImmediate());
        this.removeConsumer(0);
    }

    @TestTemplate
    public void testFilters() throws Exception {
        int i;
        int TEST_SIZE = 50;
        String addressName = "testAddress";
        String evenQueue = "evenQueue";
        String oddQueue = "oddQueue";
        this.createQueue(0, "testAddress", "evenQueue", "0", false);
        this.createQueue(0, "testAddress", "oddQueue", "1", false);
        this.createQueue(1, "testAddress", "evenQueue", "0", false);
        this.createQueue(1, "testAddress", "oddQueue", "1", false);
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = this.addClientSession(sf.createSession(false, false));
        ClientProducer producer = this.addClientProducer(session.createProducer("testAddress"));
        for (i = 0; i < 50; ++i) {
            ClientMessage message = session.createMessage(false);
            if (i % 2 == 0) {
                message.putStringProperty(ClusterTestBase.FILTER_PROP, SimpleString.of((String)"0"));
            } else {
                message.putStringProperty(ClusterTestBase.FILTER_PROP, SimpleString.of((String)"1"));
            }
            producer.send((Message)message);
        }
        session.commit();
        this.servers[0].stop();
        this.addConsumer(0, 1, "evenQueue", null);
        this.addConsumer(1, 1, "oddQueue", null);
        for (i = 0; i < 50; ++i) {
            String compare;
            ClientMessage message;
            if (i % 2 == 0) {
                message = this.consumers[0].getConsumer().receive(250L);
                compare = "0";
            } else {
                message = this.consumers[1].getConsumer().receive(250L);
                compare = "1";
            }
            Assertions.assertEquals((Object)compare, (Object)message.getStringProperty(ClusterTestBase.FILTER_PROP));
        }
        Assertions.assertNull((Object)this.consumers[0].getConsumer().receiveImmediate());
        Assertions.assertNull((Object)this.consumers[1].getConsumer().receiveImmediate());
        this.removeConsumer(0);
        this.removeConsumer(1);
    }

    @TestTemplate
    public void testScaleDownMessageWithAutoCreatedDLAResources() throws Exception {
        SimpleString dla = SimpleString.of((String)"DLA");
        SimpleString queueName = SimpleString.of((String)"q1");
        SimpleString addressName = SimpleString.of((String)"q1");
        String sampleText = "Put me on DLA";
        AddressSettings addressSettings = (AddressSettings)this.servers[0].getAddressSettingsRepository().getMatch(addressName.toString());
        this.servers[0].getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla).setAutoCreateDeadLetterResources(true));
        SimpleString dlq = addressSettings.getDeadLetterQueuePrefix().concat(addressName).concat(addressSettings.getDeadLetterQueueSuffix());
        this.createQueue(0, addressName.toString(), queueName.toString(), null, false, null, null, RoutingType.ANYCAST);
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = this.addClientSession(sf.createSession(true, false));
        ClientProducer producer = this.addClientProducer(session.createProducer(addressName));
        ClientMessage m = this.createTextMessage(session, "Put me on DLA");
        m.putByteProperty(Message.HDR_ROUTING_TYPE, (byte)1);
        producer.send((Message)m);
        session.start();
        ClientConsumer consumer = session.createConsumer(queueName);
        ClientMessage message = consumer.receive(1000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((Object)message.getBodyBuffer().readString(), (Object)"Put me on DLA");
        Assertions.assertTrue((message.getRoutingType() == RoutingType.ANYCAST ? (byte)1 : 0) != 0);
        message.acknowledge();
        session.rollback();
        message = consumer.receiveImmediate();
        Assertions.assertNull((Object)message);
        consumer.close();
        consumer = session.createConsumer(dlq.toString());
        message = consumer.receive(1000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertTrue((message.getRoutingType() == null ? (byte)1 : 0) != 0);
        this.servers[0].stop();
        sf = this.sfs[1];
        session = this.addClientSession(sf.createSession(false, true, true));
        consumer = session.createConsumer(dlq.toString());
        session.start();
        message = consumer.receive(1000L);
        Assertions.assertNotNull((Object)message);
        message.acknowledge();
        Assertions.assertEquals((Object)"Put me on DLA", (Object)message.getBodyBuffer().readString());
        consumer.close();
    }

    @TestTemplate
    public void testScaleDownPagedMessageWithMultipleAutoCreatedDLAResources() throws Exception {
        SimpleString dla = SimpleString.of((String)"DLA");
        SimpleString qName = SimpleString.of((String)"Q");
        SimpleString adName = SimpleString.of((String)"ADDR");
        String sampleText = "Put me on DLQ";
        int messageCount = 10;
        int numQueues = 2;
        AddressSettings addressSettings = new AddressSettings().setDeadLetterAddress(dla).setAutoCreateDeadLetterResources(true).setDeadLetterQueuePrefix(dla);
        AddressSettings dlaAddressSettings = new AddressSettings().setDeadLetterAddress(dla).setMaxSizeBytes(200L).setAutoCreateQueues(Boolean.valueOf(true));
        this.servers[0].getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.servers[0].getAddressSettingsRepository().addMatch(dla.toString(), (Object)dlaAddressSettings);
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = this.addClientSession(sf.createSession(true, true));
        MBeanServer mbeanServer = this.servers[0].getMBeanServer();
        for (int i = 0; i < 2; ++i) {
            SimpleString curAddr = adName.concat(String.valueOf(i));
            SimpleString curQ = qName.concat(String.valueOf(i));
            SimpleString dlq = dla.concat(curAddr);
            session.createQueue(QueueConfiguration.of((SimpleString)curQ).setAddress(curAddr).setDurable(Boolean.valueOf(true)));
            ClientProducer producer = session.createProducer(curAddr);
            for (int p = 0; p < 10; ++p) {
                producer.send((Message)this.createTextMessage(session, "Put me on DLQ"));
            }
            QueueControl queueControl = ManagementControlHelper.createQueueControl(curAddr, curQ, mbeanServer);
            Assertions.assertEquals((int)10, (int)queueControl.sendMessagesToDeadLetterAddress(null));
            Assertions.assertEquals((long)0L, (long)queueControl.getMessageCount());
            Wait.assertTrue(() -> ((PagingStore)this.servers[0].locateQueue(dlq).getPagingStore()).isPaging());
        }
        this.servers[0].getActiveMQServerControl().scaleDown((String)((ClusterConnectionConfiguration)this.servers[0].getConfiguration().getClusterConfigurations().iterator().next()).getStaticConnectors().get(0));
        Wait.assertEquals((long)20L, () -> this.servers[1].getTotalMessageCount());
    }
}

