/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrameInterceptor;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class StompWithInterceptorsTest
extends StompTestBase {
    @Override
    public List<String> getIncomingInterceptors() {
        ArrayList<String> stompIncomingInterceptor = new ArrayList<String>();
        stompIncomingInterceptor.add(IncomingStompInterceptor.class.getName());
        stompIncomingInterceptor.add(CoreInterceptor.class.getName());
        return stompIncomingInterceptor;
    }

    @Override
    public List<String> getOutgoingInterceptors() {
        ArrayList<String> stompOutgoingInterceptor = new ArrayList<String>();
        stompOutgoingInterceptor.add(OutgoingStompInterceptor.class.getName());
        return stompOutgoingInterceptor;
    }

    @TestTemplate
    public void stompFrameInterceptor() throws Exception {
        IncomingStompInterceptor.interceptedFrames.clear();
        OutgoingStompInterceptor.interceptedFrames.clear();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> {
            for (Packet packet : new ArrayList<Packet>(CoreInterceptor.incomingInterceptedFrames)) {
                if (packet.getType() != 67) continue;
                return true;
            }
            return false;
        }, (long)2000L, (long)50L));
        CoreInterceptor.incomingInterceptedFrames.clear();
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        conn.connect(this.defUser, this.defPass);
        ClientStompFrame subFrame = conn.createFrame("SUBSCRIBE");
        subFrame.addHeader("subscription-type", "ANYCAST");
        subFrame.addHeader("destination", StompWithInterceptorsTest.getQueuePrefix() + StompWithInterceptorsTest.getQueueName());
        subFrame.addHeader("ack", "auto");
        conn.sendFrame(subFrame);
        Assertions.assertEquals((int)0, (int)CoreInterceptor.incomingInterceptedFrames.size());
        this.sendJmsMessage(this.getName());
        Assertions.assertTrue((CoreInterceptor.incomingInterceptedFrames.size() > 0 ? (byte)1 : 0) != 0, (String)"core interceptor is not working");
        conn.receiveFrame(10000L);
        ClientStompFrame frame = conn.createFrame("SEND");
        frame.addHeader("destination", StompWithInterceptorsTest.getQueuePrefix() + StompWithInterceptorsTest.getQueueName());
        frame.setBody("Hello World");
        conn.sendFrame(frame);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> OutgoingStompInterceptor.interceptedFrames.size() == 3, (long)2000L, (long)50L));
        conn.disconnect();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> IncomingStompInterceptor.interceptedFrames.size() == 4, (long)2000L, (long)50L));
        ArrayList<String> incomingCommands = new ArrayList<String>(4);
        incomingCommands.add("CONNECT");
        incomingCommands.add("SUBSCRIBE");
        incomingCommands.add("SEND");
        incomingCommands.add("DISCONNECT");
        for (int i = 0; i < IncomingStompInterceptor.interceptedFrames.size(); ++i) {
            Assertions.assertEquals(incomingCommands.get(i), (Object)IncomingStompInterceptor.interceptedFrames.get(i).getCommand());
            Assertions.assertEquals((Object)"incomingInterceptedVal", (Object)IncomingStompInterceptor.interceptedFrames.get(i).getHeader("incomingInterceptedProp"));
        }
        ArrayList<String> outgoingCommands = new ArrayList<String>(3);
        outgoingCommands.add("CONNECTED");
        outgoingCommands.add("MESSAGE");
        outgoingCommands.add("MESSAGE");
        for (int i = 0; i < OutgoingStompInterceptor.interceptedFrames.size(); ++i) {
            Assertions.assertEquals(outgoingCommands.get(i), (Object)OutgoingStompInterceptor.interceptedFrames.get(i).getCommand());
        }
        Assertions.assertEquals((Object)"incomingInterceptedVal", (Object)OutgoingStompInterceptor.interceptedFrames.get(2).getHeader("incomingInterceptedProp"));
        Assertions.assertEquals((Object)"outgoingInterceptedVal", (Object)OutgoingStompInterceptor.interceptedFrames.get(2).getHeader("outgoingInterceptedProp"));
    }

    public static class IncomingStompInterceptor
    implements StompFrameInterceptor {
        static List<StompFrame> interceptedFrames = Collections.synchronizedList(new ArrayList());

        public boolean intercept(StompFrame stompFrame, RemotingConnection connection) {
            interceptedFrames.add(stompFrame);
            stompFrame.addHeader("incomingInterceptedProp", "incomingInterceptedVal");
            return true;
        }
    }

    public static class CoreInterceptor
    implements Interceptor {
        static List<Packet> incomingInterceptedFrames = new ArrayList<Packet>();

        public boolean intercept(Packet packet, RemotingConnection connection) {
            incomingInterceptedFrames.add(packet);
            return true;
        }
    }

    public static class OutgoingStompInterceptor
    implements StompFrameInterceptor {
        static List<StompFrame> interceptedFrames = Collections.synchronizedList(new ArrayList());

        public boolean intercept(StompFrame stompFrame, RemotingConnection connection) {
            interceptedFrames.add(stompFrame);
            stompFrame.addHeader("outgoingInterceptedProp", "outgoingInterceptedVal");
            return true;
        }
    }
}

