/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrameInterceptor;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class StompWithRejectingInterceptorTest
extends StompTestBase {
    @Override
    public List<String> getIncomingInterceptors() {
        ArrayList<String> stompIncomingInterceptor = new ArrayList<String>();
        stompIncomingInterceptor.add(IncomingStompFrameRejectInterceptor.class.getName());
        return stompIncomingInterceptor;
    }

    @TestTemplate
    public void stompFrameInterceptor() throws Exception {
        IncomingStompFrameRejectInterceptor.interceptedFrames.clear();
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        conn.connect(this.defUser, this.defPass);
        ClientStompFrame frame = conn.createFrame("SEND");
        frame.addHeader("destination", StompWithRejectingInterceptorTest.getQueuePrefix() + StompWithRejectingInterceptorTest.getQueueName());
        frame.setBody("Hello World");
        conn.sendFrame(frame);
        conn.disconnect();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> IncomingStompFrameRejectInterceptor.interceptedFrames.size() == 3, (long)10000L, (long)50L));
        ArrayList<String> incomingCommands = new ArrayList<String>(4);
        incomingCommands.add("CONNECT");
        incomingCommands.add("SEND");
        incomingCommands.add("DISCONNECT");
        for (int i = 0; i < IncomingStompFrameRejectInterceptor.interceptedFrames.size(); ++i) {
            Assertions.assertEquals(incomingCommands.get(i), (Object)IncomingStompFrameRejectInterceptor.interceptedFrames.get(i).getCommand());
        }
        Wait.assertFalse(() -> this.server.locateQueue(SimpleString.of((String)(StompWithRejectingInterceptorTest.getQueuePrefix() + StompWithRejectingInterceptorTest.getQueueName()))).getMessageCount() > 0L, (long)1000L, (long)100L);
    }

    public static class IncomingStompFrameRejectInterceptor
    implements StompFrameInterceptor {
        static List<StompFrame> interceptedFrames = Collections.synchronizedList(new ArrayList());

        public boolean intercept(StompFrame stompFrame, RemotingConnection connection) {
            interceptedFrames.add(stompFrame);
            return !stompFrame.getCommand().equals("SEND");
        }
    }
}

