/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Transient;
import java.beans.Introspector;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.bytecode.enhance.spi.interceptor.BytecodeLazyAttributeInterceptor;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.internal.util.ReflectHelper;

public class AccessStrategyHelper {
    public static final @UnknownKeyFor @NonNull @Initialized int COMPOSITE_TRACKER_MASK = 1;
    public static final @UnknownKeyFor @NonNull @Initialized int COMPOSITE_OWNER = 2;
    public static final @UnknownKeyFor @NonNull @Initialized int PERSISTENT_ATTRIBUTE_INTERCEPTABLE_MASK = 4;

    public static @Nullable @UnknownKeyFor @Initialized Field fieldOrNull(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName) {
        try {
            return ReflectHelper.findField(containerJavaType, propertyName);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized AccessType getAccessType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName) {
        Field field = AccessStrategyHelper.fieldOrNull(containerJavaType, propertyName);
        AccessType explicitAccessType = AccessStrategyHelper.getExplicitAccessType(containerJavaType, propertyName, field);
        if (explicitAccessType != null) {
            return explicitAccessType;
        }
        AccessType classAccessType = AccessStrategyHelper.getAccessTypeOrNull(containerJavaType);
        if (classAccessType != null) {
            return classAccessType;
        }
        return field != null ? AccessType.FIELD : AccessType.PROPERTY;
    }

    public static @Nullable @UnknownKeyFor @Initialized AccessType getExplicitAccessType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String propertyName, @Nullable @UnknownKeyFor @Initialized Field field) {
        if (ReflectHelper.isRecord(containerClass)) {
            try {
                containerClass.getMethod(propertyName, ReflectHelper.NO_PARAM_SIGNATURE);
                return AccessType.PROPERTY;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (field != null && field.isAnnotationPresent(Access.class) && !field.isAnnotationPresent(Transient.class) && !Modifier.isStatic(field.getModifiers())) {
            return AccessType.FIELD;
        }
        for (Method method : containerClass.getDeclaredMethods()) {
            String decapitalizedStemName;
            String stemName;
            if (method.getParameterCount() != 0 || method.isBridge() || method.isAnnotationPresent(Transient.class) || Modifier.isStatic(method.getModifiers())) continue;
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                stemName = methodName.substring(3);
                decapitalizedStemName = Introspector.decapitalize(stemName);
                if (stemName.equals(propertyName) || decapitalizedStemName.equals(propertyName)) {
                    if (method.isAnnotationPresent(Access.class)) {
                        return AccessType.PROPERTY;
                    }
                    AccessStrategyHelper.checkIsMethodVariant(containerClass, propertyName, method, stemName);
                }
            }
            if (!methodName.startsWith("is")) continue;
            stemName = methodName.substring(2);
            decapitalizedStemName = Introspector.decapitalize(stemName);
            if (!stemName.equals(propertyName) && !decapitalizedStemName.equals(propertyName) || !method.isAnnotationPresent(Access.class)) continue;
            return AccessType.PROPERTY;
        }
        return null;
    }

    private static void checkIsMethodVariant(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Method method, @UnknownKeyFor @NonNull @Initialized String stemName) {
        Method isMethodVariant = AccessStrategyHelper.findIsMethodVariant(containerClass, stemName);
        if (isMethodVariant == null) {
            return;
        }
        if (!isMethodVariant.isAnnotationPresent(Access.class)) {
            throw new MappingException(String.format(Locale.ROOT, "Class '%s' declares both 'get' [%s] and 'is' [%s] variants of getter for property '%s'", containerClass.getName(), method.toString(), isMethodVariant, propertyName));
        }
    }

    public static @Nullable @UnknownKeyFor @Initialized Method findIsMethodVariant(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String stemName) {
        try {
            Method isMethod = containerClass.getDeclaredMethod("is" + stemName, new Class[0]);
            if (!Modifier.isStatic(isMethod.getModifiers()) && isMethod.getAnnotation(Transient.class) == null) {
                return isMethod;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    protected static @Nullable @UnknownKeyFor @Initialized AccessType getAccessTypeOrNull(@Nullable @UnknownKeyFor @Initialized AnnotatedElement element) {
        if (element == null) {
            return null;
        }
        Access elementAccess = element.getAnnotation(Access.class);
        return elementAccess == null ? null : elementAccess.value();
    }

    public static @UnknownKeyFor @NonNull @Initialized int determineEnhancementState(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> attributeType) {
        return (CompositeOwner.class.isAssignableFrom(containerClass) ? 2 : 0) | (CompositeTracker.class.isAssignableFrom(attributeType) ? 1 : 0) | (ManagedTypeHelper.isPersistentAttributeInterceptableType(containerClass) ? 4 : 0);
    }

    public static void handleEnhancedInjection(@UnknownKeyFor @NonNull @Initialized Object target, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized int enhancementState, @UnknownKeyFor @NonNull @Initialized String propertyName) {
        PersistentAttributeInterceptor interceptor;
        if ((enhancementState & 2) != 0 && ((enhancementState & 1) != 0 && value != null || ManagedTypeHelper.isCompositeTracker(value))) {
            ManagedTypeHelper.asCompositeTracker(NullnessUtil.castNonNull(value)).$$_hibernate_setOwner(propertyName, ManagedTypeHelper.asCompositeOwner(target));
        }
        if ((enhancementState & 4) != 0 && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(target).$$_hibernate_getInterceptor()) instanceof BytecodeLazyAttributeInterceptor) {
            ((BytecodeLazyAttributeInterceptor)interceptor).attributeInitialized(propertyName);
        }
    }
}

