/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.logutil;

import com.sun.tools.corba.se.logutil.InputCode;
import com.sun.tools.corba.se.logutil.InputException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Input {
    private String packageName;
    private String className;
    private String groupName;
    private Queue<InputException> exceptions;
    private static final Pattern EXCEPTION_INFO_REGEX = Pattern.compile("(\\w+)\\s*(\\d+)\\s*(\\w+)");

    public Input(String filename) throws FileNotFoundException, IOException {
        Object line;
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
        State state = State.OUTER;
        InputException current = null;
        this.exceptions = new LinkedList<InputException>();
        while ((line = r.readLine()) != null) {
            int index;
            if (((String)line).startsWith(";") || (index = ((String)line).indexOf("(")) == -1) continue;
            switch (state) {
                case OUTER: {
                    state = State.IN_CLASS;
                    String[] classInfo = ((String)line).substring(index).split(" ");
                    this.packageName = classInfo[0].substring(2, classInfo[0].length() - 1);
                    this.className = classInfo[1].substring(1, classInfo[1].length() - 1);
                    this.groupName = classInfo[2];
                    break;
                }
                case IN_CLASS: {
                    state = State.IN_EXCEPTION_LIST;
                    break;
                }
                case IN_EXCEPTION_LIST: {
                    boolean inQuote = false;
                    boolean inCode = false;
                    boolean end = false;
                    int start = index + 1;
                    LinkedList<String> lines = new LinkedList<String>();
                    for (int a = start; a < ((String)line).length(); ++a) {
                        if (((String)line).charAt(a) == '(' && !inCode && !inQuote) {
                            if (current == null) {
                                current = new InputException(((String)line).substring(start, a).trim());
                            }
                            start = a + 1;
                            inCode = true;
                        }
                        if (((String)line).charAt(a) == '\"') {
                            boolean bl = inQuote = !inQuote;
                        }
                        if (((String)line).charAt(a) == ')' && !inQuote) {
                            if (inCode) {
                                lines.offer(((String)line).substring(start, a));
                                inCode = false;
                            } else {
                                end = true;
                            }
                        }
                        if (end || a != ((String)line).length() - 1) continue;
                        line = (String)line + r.readLine();
                    }
                    for (String l : lines) {
                        int stringStart = l.indexOf("\"") + 1;
                        int stringEnd = l.indexOf("\"", stringStart);
                        Matcher matcher = EXCEPTION_INFO_REGEX.matcher(l.substring(0, stringStart));
                        if (!matcher.find()) continue;
                        current.add(new InputCode(matcher.group(1), Integer.parseInt(matcher.group(2)), matcher.group(3), l.substring(stringStart, stringEnd)));
                    }
                    this.exceptions.offer(current);
                    current = null;
                }
            }
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public Queue<InputException> getExceptions() {
        return this.exceptions;
    }

    public String toString() {
        return this.getClass().getName() + "[packageName=" + this.packageName + ",className=" + this.className + ",groupName=" + this.groupName + ",exceptions=" + this.exceptions + "]";
    }

    private static enum State {
        OUTER,
        IN_CLASS,
        IN_EXCEPTION_LIST;

    }
}

