/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.util;

import java.util.Comparator;

public final class ComparableArrayComparator
implements Comparator<Comparable<?>[]> {
    private final boolean[] direction;

    public ComparableArrayComparator(boolean[] direction) {
        if (direction == null) {
            throw new IllegalArgumentException("direction array cannot be null");
        }
        this.direction = direction;
    }

    @Override
    public int compare(Comparable<?>[] array1, Comparable<?>[] array2) {
        if (array1 == null || array2 == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        if (array1.length != this.direction.length || array2.length != this.direction.length) {
            throw new IllegalArgumentException("argument arrays must have the same size as the direction array");
        }
        for (int i = 0; i < this.direction.length; ++i) {
            int r = ComparableArrayComparator.compareElements(array1[i], array2[i]);
            if (r == 0) continue;
            return this.direction[i] ? r : -r;
        }
        return 0;
    }

    private static int compareElements(Comparable o1, Comparable o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }
}

