/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSingleDocumentIndexingWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.SingleDocumentIndexingWork;

public class IndexWork
extends AbstractSingleDocumentIndexingWork
implements SingleDocumentIndexingWork {
    private IndexWork(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends AbstractSingleDocumentIndexingWork.AbstractBuilder<Builder> {
        private final URLEncodedString indexName;
        private final String routingKey;
        private final JsonObject document;

        public static Builder create(String entityTypeName, Object entityIdentifier, URLEncodedString elasticsearchIndexName, String documentIdentifier, String routingKey, JsonObject document) {
            return new Builder(entityTypeName, entityIdentifier, elasticsearchIndexName, documentIdentifier, routingKey, document);
        }

        private Builder(String entityTypeName, Object entityIdentifier, URLEncodedString elasticsearchIndexName, String documentIdentifier, String routingKey, JsonObject document) {
            super(ElasticsearchRequestSuccessAssessor.DEFAULT_INSTANCE, entityTypeName, entityIdentifier, documentIdentifier);
            this.indexName = elasticsearchIndexName;
            this.routingKey = routingKey;
            this.document = document;
        }

        @Override
        protected JsonObject buildBulkableActionMetadata() {
            JsonObject index = new JsonObject();
            index.addProperty("_index", this.indexName.original);
            index.addProperty("_id", this.documentIdentifier);
            if (this.routingKey != null) {
                index.addProperty("routing", this.routingKey);
            }
            JsonObject result = new JsonObject();
            result.add("index", (JsonElement)index);
            return result;
        }

        @Override
        protected JsonObject buildBulkableActionBody() {
            return this.document;
        }

        @Override
        public IndexWork build() {
            return new IndexWork(this);
        }
    }
}

