/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.remote.AssociationImpl;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.ProtocolSocketBinding;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.ListenerHandle;
import org.jboss.ejb.server.ModuleAvailabilityListener;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.server.Group;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.registry.Registry;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.impl.MutableDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryRequest;

public final class AssociationService
implements Service<AssociationService> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb", "association"});
    private final InjectedValue<DeploymentRepository> deploymentRepositoryInjector = new InjectedValue();
    private final List<Map.Entry<Value<ProtocolSocketBinding>, Value<Registry>>> clientMappingsRegistries = new LinkedList<Map.Entry<Value<ProtocolSocketBinding>, Value<Registry>>>();
    private final InjectedValue<SuspendController> suspendControllerInjector = new InjectedValue();
    private final InjectedValue<ServerEnvironment> serverEnvironmentServiceInjector = new InjectedValue();
    private final Object serviceLock = new Object();
    private final Set<EJBModuleIdentifier> ourModules = new HashSet<EJBModuleIdentifier>();
    private volatile ServiceURL cachedServiceURL;
    private final MutableDiscoveryProvider mutableDiscoveryProvider = new MutableDiscoveryProvider();
    private volatile AssociationImpl value;
    private volatile ListenerHandle moduleAvailabilityListener;

    public void start(StartContext context) throws StartException {
        ArrayList<Map.Entry<ProtocolSocketBinding, Registry<GroupMember, String, List<ClientMapping>>>> clientMappingsRegistries = this.clientMappingsRegistries.isEmpty() ? Collections.emptyList() : new ArrayList<Map.Entry<ProtocolSocketBinding, Registry<GroupMember, String, List<ClientMapping>>>>(this.clientMappingsRegistries.size());
        for (Map.Entry<Value<ProtocolSocketBinding>, Value<Registry>> entry : this.clientMappingsRegistries) {
            clientMappingsRegistries.add(new AbstractMap.SimpleImmutableEntry<ProtocolSocketBinding, Registry>((ProtocolSocketBinding)entry.getKey().getValue(), (Registry)entry.getValue().getValue()));
        }
        this.value = new AssociationImpl((DeploymentRepository)this.deploymentRepositoryInjector.getValue(), clientMappingsRegistries);
        String ourNodeName = ((ServerEnvironment)this.serverEnvironmentServiceInjector.getValue()).getNodeName();
        this.moduleAvailabilityListener = this.value.registerModuleAvailabilityListener(new ModuleAvailabilityListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void moduleAvailable(List<EJBModuleIdentifier> modules) {
                Object object = AssociationService.this.serviceLock;
                synchronized (object) {
                    AssociationService.this.ourModules.addAll(modules);
                    AssociationService.this.cachedServiceURL = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void moduleUnavailable(List<EJBModuleIdentifier> modules) {
                Object object = AssociationService.this.serviceLock;
                synchronized (object) {
                    AssociationService.this.ourModules.removeAll(modules);
                    AssociationService.this.cachedServiceURL = null;
                }
            }
        });
        this.mutableDiscoveryProvider.setDiscoveryProvider((serviceType, filterSpec, result) -> {
            ServiceURL serviceURL = this.cachedServiceURL;
            if (serviceURL == null) {
                Object object = this.serviceLock;
                synchronized (object) {
                    serviceURL = this.cachedServiceURL;
                    if (serviceURL == null) {
                        ServiceURL.Builder b = new ServiceURL.Builder();
                        b.setUri(Affinity.LOCAL.getUri()).setAbstractType("ejb").setAbstractTypeAuthority("jboss");
                        b.addAttribute("node", AttributeValue.fromString((String)ourNodeName));
                        for (Map.Entry entry : clientMappingsRegistries) {
                            Group group = ((Registry)entry.getValue()).getGroup();
                            if (group.isSingleton()) continue;
                            b.addAttribute("cluster", AttributeValue.fromString((String)group.getName()));
                        }
                        for (EJBModuleIdentifier moduleIdentifier : this.ourModules) {
                            String appName = moduleIdentifier.getAppName();
                            String moduleName = moduleIdentifier.getModuleName();
                            String distinctName = moduleIdentifier.getDistinctName();
                            if (distinctName.isEmpty()) {
                                if (appName.isEmpty()) {
                                    b.addAttribute("ejb-module", AttributeValue.fromString((String)moduleName));
                                    continue;
                                }
                                b.addAttribute("ejb-module", AttributeValue.fromString((String)(appName + "/" + moduleName)));
                                continue;
                            }
                            if (appName.isEmpty()) {
                                b.addAttribute("ejb-module-distinct", AttributeValue.fromString((String)(moduleName + "/" + distinctName)));
                                continue;
                            }
                            b.addAttribute("ejb-module-distinct", AttributeValue.fromString((String)(appName + "/" + moduleName + "/" + distinctName)));
                        }
                        serviceURL = this.cachedServiceURL = b.create();
                    }
                }
            }
            if (serviceURL.satisfies(filterSpec)) {
                result.addMatch(serviceURL);
            }
            result.complete();
            return DiscoveryRequest.NULL;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        this.value.close();
        this.value = null;
        this.moduleAvailabilityListener.close();
        this.moduleAvailabilityListener = null;
        this.mutableDiscoveryProvider.setDiscoveryProvider(DiscoveryProvider.EMPTY);
        Object object = this.serviceLock;
        synchronized (object) {
            this.cachedServiceURL = null;
            this.ourModules.clear();
        }
    }

    public AssociationService getValue() {
        return this;
    }

    public InjectedValue<ServerEnvironment> getServerEnvironmentServiceInjector() {
        return this.serverEnvironmentServiceInjector;
    }

    public InjectedValue<DeploymentRepository> getDeploymentRepositoryInjector() {
        return this.deploymentRepositoryInjector;
    }

    public Map.Entry<Injector<ProtocolSocketBinding>, Injector<Registry>> addConnectorInjectors(String connectorName) {
        InjectedValue info = new InjectedValue();
        InjectedValue registry = new InjectedValue();
        this.clientMappingsRegistries.add(new AbstractMap.SimpleImmutableEntry<InjectedValue, InjectedValue>(info, registry));
        return new AbstractMap.SimpleImmutableEntry<InjectedValue, InjectedValue>(info, registry);
    }

    public InjectedValue<SuspendController> getSuspendControllerInjector() {
        return this.suspendControllerInjector;
    }

    public DiscoveryProvider getLocalDiscoveryProvider() {
        return this.mutableDiscoveryProvider;
    }

    public Association getAssociation() {
        return this.value;
    }

    void setExecutor(Executor executor) {
        this.value.setExecutor(executor);
    }

    void sendTopologyUpdateIfLastNodeToLeave() {
        this.value.sendTopologyUpdateIfLastNodeToLeave();
    }
}

