/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.state;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.io.IOException;
import java.io.PrintWriter;

public class InputObjectState
extends InputBuffer {
    private Uid bufferUid;
    private String imageType;

    public InputObjectState() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)"InputObjectState::InputObjectState()");
        }
        this.bufferUid = new Uid(Uid.nullUid());
        this._valid = false;
        this.imageType = null;
    }

    public InputObjectState(InputObjectState copyFrom) {
        super(copyFrom);
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("InputObjectState::InputObjectState(" + copyFrom + ")"));
        }
        try {
            this.bufferUid = new Uid(copyFrom.bufferUid);
            this._valid = this.bufferUid.valid();
            this.imageType = new String(copyFrom.imageType == null ? "" : copyFrom.imageType);
        }
        catch (Exception ex) {
            this._valid = false;
        }
    }

    public InputObjectState(OutputObjectState copyFrom) {
        super(copyFrom.buffer());
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("InputObjectState::InputObjectState(" + copyFrom + ")"));
        }
        try {
            this.bufferUid = new Uid(copyFrom.stateUid());
            this._valid = this._valid && this.bufferUid.valid();
            this.imageType = new String(copyFrom.type() == null ? "" : copyFrom.type());
        }
        catch (Exception ex) {
            this._valid = false;
        }
    }

    public InputObjectState(Uid newUid, String tName, byte[] buff) {
        super(buff);
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("InputObjectState::InputObjectState(" + newUid + ", " + tName + ")"));
        }
        this.bufferUid = new Uid(newUid);
        this._valid = this._valid && this.bufferUid.valid();
        this.imageType = new String(tName);
    }

    public final boolean notempty() {
        return this.length() > 0;
    }

    public final int size() {
        return this.length();
    }

    public final Uid stateUid() {
        return this.bufferUid;
    }

    public final String type() {
        return this.imageType;
    }

    public void copyFrom(OutputObjectState copyFrom) {
        super.setBuffer(copyFrom.buffer());
        this.bufferUid = new Uid(copyFrom.stateUid());
        this._valid = this.bufferUid.valid();
        this.imageType = copyFrom.type() == null ? null : new String(copyFrom.type());
    }

    @Override
    public void print(PrintWriter strm) {
        strm.println("InputObjectState Uid   : " + this.bufferUid + "\n");
        if (this.imageType != null) {
            strm.println("InputObjectState Type  : " + this.imageType + "\n");
        } else {
            strm.println("InputObjectState Type  : null\n");
        }
        strm.println("InputObjectState Size  : " + this.size() + "\n");
        strm.println("InputObjectState Buffer: ");
        super.print(strm);
    }

    public String toString() {
        String val = "InputObjectState Uid   : " + this.bufferUid + "\n";
        val = this.imageType != null ? val + "InputObjectState Type  : " + this.imageType + "\n" : val + "InputObjectState Type  : null\n";
        val = val + "InputObjectState Size  : " + this.size() + "\n";
        val = val + "InputObjectState Buffer: ";
        return val;
    }

    public synchronized void copy(InputObjectState objstate) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("InputObjectState::copy for " + this.bufferUid));
        }
        super.copy(objstate);
        this.bufferUid = new Uid(objstate.bufferUid);
        this._valid = this.bufferUid.valid();
        this.imageType = objstate.imageType == null ? null : new String(objstate.imageType);
    }

    @Override
    public synchronized void unpackFrom(InputBuffer buff) throws IOException {
        this.imageType = buff.unpackString();
        this.bufferUid = UidHelper.unpackFrom(buff);
        super.unpackFrom(buff);
    }
}

