/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.common.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.util.common.AssertionFailure;

public final class MultiEntityOperationExecutionReport {
    private final Throwable throwable;
    private final List<EntityReference> failingEntityReferences;

    public static Builder builder() {
        return new Builder();
    }

    public static CompletableFuture<MultiEntityOperationExecutionReport> allOf(List<CompletableFuture<MultiEntityOperationExecutionReport>> reportFutures) {
        if (reportFutures.size() == 1) {
            return reportFutures.get(0);
        }
        CompletionStage<Builder> reportBuilderFuture = CompletableFuture.completedFuture(MultiEntityOperationExecutionReport.builder());
        for (CompletableFuture<MultiEntityOperationExecutionReport> future : reportFutures) {
            reportBuilderFuture = reportBuilderFuture.thenCombine(future, Builder::add);
        }
        return reportBuilderFuture.thenApply(Builder::build);
    }

    private MultiEntityOperationExecutionReport(Builder builder) {
        this.failingEntityReferences = builder.failingEntityReferences == null ? Collections.emptyList() : Collections.unmodifiableList(builder.failingEntityReferences);
        this.throwable = builder.throwable == null && !this.failingEntityReferences.isEmpty() ? new AssertionFailure("Unknown throwable: missing throwable when reporting the failure.") : builder.throwable;
    }

    public Optional<Throwable> throwable() {
        return Optional.ofNullable(this.throwable);
    }

    public List<EntityReference> failingEntityReferences() {
        return this.failingEntityReferences;
    }

    public static final class Builder {
        private Throwable throwable;
        private List<EntityReference> failingEntityReferences;

        private Builder() {
        }

        public Builder add(MultiEntityOperationExecutionReport report) {
            report.throwable().ifPresent(this::throwable);
            for (EntityReference failingEntityReference : report.failingEntityReferences()) {
                this.failingEntityReference(failingEntityReference);
            }
            return this;
        }

        public Builder throwable(Throwable throwable) {
            if (this.throwable == null) {
                this.throwable = throwable;
            } else if (this.throwable != throwable) {
                this.throwable.addSuppressed(throwable);
            }
            return this;
        }

        public Builder failingEntityReference(EntityReference reference) {
            if (this.failingEntityReferences == null) {
                this.failingEntityReferences = new ArrayList<EntityReference>();
            }
            this.failingEntityReferences.add(reference);
            return this;
        }

        public Builder failingEntityReference(EntityReferenceFactory referenceFactory, String typeName, Object entityIdentifier) {
            EntityReference reference = EntityReferenceFactory.safeCreateEntityReference(referenceFactory, typeName, entityIdentifier, this::throwable);
            if (reference != null) {
                this.failingEntityReference(reference);
            }
            return this;
        }

        public MultiEntityOperationExecutionReport build() {
            return new MultiEntityOperationExecutionReport(this);
        }
    }
}

