/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.io.File;
import java.util.function.Consumer;
import org.jboss.as.server.Services;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.moduleservice.ExternalModule;
import org.jboss.as.server.moduleservice.ExternalModuleSpecService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ExternalModuleService
implements org.jboss.msc.service.Service<ExternalModuleService>,
ExternalModule {
    private boolean started;
    private final Consumer<ExternalModuleService> externalModuleServiceConsumer;

    private ExternalModuleService(Consumer<ExternalModuleService> externalModuleServiceConsumer) {
        this.externalModuleServiceConsumer = externalModuleServiceConsumer;
    }

    @Override
    public boolean isValidFile(String path) {
        File f = new File(path);
        return f.exists() && !f.isDirectory();
    }

    @Override
    public ModuleIdentifier addExternalModule(String moduleName, ServiceRegistry serviceRegistry, ServiceTarget serviceTarget) {
        return this.addExternalModule(moduleName, moduleName, serviceRegistry, serviceTarget);
    }

    @Override
    public ModuleIdentifier addExternalModule(String moduleName, String path, ServiceRegistry serviceRegistry, ServiceTarget serviceTarget) {
        ModuleIdentifier identifier = ModuleIdentifier.fromString((String)("deployment.external." + moduleName));
        ServiceName serviceName = ServiceModuleLoader.moduleSpecServiceName(identifier.toString());
        ServiceController controller = serviceRegistry.getService(serviceName);
        if (controller == null) {
            ExternalModuleSpecService service = new ExternalModuleSpecService(identifier, new File(path));
            serviceTarget.addService(serviceName).setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }
        return identifier;
    }

    public synchronized void start(StartContext context) throws StartException {
        if (this.started) {
            throw ServerLogger.ROOT_LOGGER.externalModuleServiceAlreadyStarted();
        }
        this.externalModuleServiceConsumer.accept(this);
        this.started = true;
    }

    public void stop(StopContext context) {
    }

    public ExternalModuleService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public static void addService(ServiceTarget serviceTarget, ServiceName externalModuleServiceName) {
        ServiceBuilder serviceBuilder = serviceTarget.addService(externalModuleServiceName);
        Consumer provides = serviceBuilder.provides(new ServiceName[]{Services.JBOSS_EXTERNAL_MODULE_SERVICE});
        serviceBuilder.setInstance((Service)new ExternalModuleService(provides)).install();
    }
}

