/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Random;
import java.util.UUID;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class JMSMessageProducerTest
extends JMSClientTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testAnonymousProducerWithQueueAutoCreation() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            String queueName = UUID.randomUUID().toString() + ":" + this.getQueueName();
            Queue queue = session.createQueue(queueName);
            MessageProducer p = session.createProducer(null);
            TextMessage message = session.createTextMessage();
            message.setText(this.getTestName());
            p.send((Destination)queue, (Message)message);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            p.send((Destination)queue, (Message)message);
            Message msg = consumer.receive(2000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertTrue((boolean)(msg instanceof TextMessage));
            Assertions.assertEquals((Object)this.getTestName(), (Object)((TextMessage)msg).getText());
            consumer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testAnonymousProducer() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue queue1 = session.createQueue(this.getQueueName(1));
            Queue queue2 = session.createQueue(this.getQueueName(2));
            MessageProducer p = session.createProducer(null);
            TextMessage message = session.createTextMessage();
            message.setText("hello");
            p.send((Destination)queue1, (Message)message);
            p.send((Destination)queue2, (Message)message);
            MessageConsumer consumer = session.createConsumer((Destination)queue1);
            Message msg = consumer.receive(2000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertTrue((boolean)(msg instanceof TextMessage));
            consumer.close();
            consumer = session.createConsumer((Destination)queue2);
            msg = consumer.receive(2000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertTrue((boolean)(msg instanceof TextMessage));
            consumer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testAnonymousProducerWithTopicAutoCreation() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            String topicName = UUID.randomUUID().toString() + ":" + this.getQueueName();
            Topic topic = session.createTopic(topicName);
            MessageProducer p = session.createProducer(null);
            TextMessage message = session.createTextMessage();
            message.setText("creating-topic-address");
            p.send((Destination)topic, (Message)message);
            MessageConsumer consumer = session.createConsumer((Destination)topic);
            TextMessage message2 = message = session.createTextMessage(this.getTestName());
            p.send((Destination)topic, (Message)message2);
            Message msg = consumer.receive(2000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertTrue((boolean)(msg instanceof TextMessage));
            Assertions.assertEquals((Object)this.getTestName(), (Object)((TextMessage)msg).getText());
            consumer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testDuplicateDetection() throws Exception {
        int MSG_COUNT = 10;
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.getQueueName());
            MessageProducer p = session.createProducer(null);
            for (int i = 1; i <= 10; ++i) {
                TextMessage message = session.createTextMessage();
                message.setStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_DUPLICATE_DETECTION_ID.toString(), "123");
                p.send((Destination)queue, (Message)message);
            }
            Wait.assertTrue((String)"Only 1 message should arrive", () -> this.getProxyToQueue(this.getQueueName()).getMessageCount() == 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testAnonymousProducerAcrossManyDestinations() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            MessageProducer p = session.createProducer(null);
            for (int i = 0; i < this.getPrecreatedQueueSize(); ++i) {
                Queue target = session.createQueue(this.getQueueName(i));
                TextMessage message = session.createTextMessage("message for " + target.getQueueName());
                p.send((Destination)target, (Message)message);
            }
            connection.start();
            MessageConsumer messageConsumer = session.createConsumer((Destination)session.createQueue(this.getQueueName()));
            Message m = messageConsumer.receive(200L);
            Assertions.assertNull((Object)m);
            for (int i = 0; i < this.getPrecreatedQueueSize(); ++i) {
                Queue target = session.createQueue(this.getQueueName(i));
                MessageConsumer consumer = session.createConsumer((Destination)target);
                TextMessage tm = (TextMessage)consumer.receive(2000L);
                Assertions.assertNotNull((Object)tm);
                Assertions.assertEquals((Object)("message for " + target.getQueueName()), (Object)tm.getText());
                consumer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSendingBigMessage() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.getQueueName());
            MessageProducer sender = session.createProducer((Destination)queue);
            String body = JMSMessageProducerTest.createMessage(10240);
            sender.send((Message)session.createTextMessage(body));
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            TextMessage m = (TextMessage)consumer.receive(5000L);
            Assertions.assertEquals((Object)body, (Object)m.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSendWithTimeToLiveExpiresToDLQ() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.getQueueName());
            MessageProducer sender = session.createProducer((Destination)queue);
            sender.setTimeToLive(1L);
            Message message = session.createMessage();
            sender.send(message);
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(this.getDeadLetterAddress()));
            Message m = consumer.receive(10000L);
            Assertions.assertNotNull((Object)m);
            consumer.close();
            consumer = session.createConsumer((Destination)queue);
            m = consumer.receiveNoWait();
            Assertions.assertNull((Object)m);
            consumer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testReplyToUsingQueue() throws Throwable {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            TemporaryQueue queue = session.createTemporaryQueue();
            MessageProducer p = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage();
            message.setText("Message temporary");
            message.setJMSReplyTo((Destination)session.createQueue(this.getQueueName()));
            p.send((Message)message);
            MessageConsumer cons = session.createConsumer((Destination)queue);
            connection.start();
            message = (TextMessage)cons.receive(5000L);
            Assertions.assertNotNull((Object)message);
            Destination jmsReplyTo = message.getJMSReplyTo();
            Assertions.assertNotNull((Object)jmsReplyTo);
            Assertions.assertNotNull((Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testReplyToUsingTempQueue() throws Throwable {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            TemporaryQueue queue = session.createTemporaryQueue();
            MessageProducer p = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage();
            message.setText("Message temporary");
            message.setJMSReplyTo((Destination)session.createTemporaryQueue());
            p.send((Message)message);
            MessageConsumer cons = session.createConsumer((Destination)queue);
            connection.start();
            message = (TextMessage)cons.receive(5000L);
            Destination jmsReplyTo = message.getJMSReplyTo();
            Assertions.assertNotNull((Object)jmsReplyTo);
            Assertions.assertNotNull((Object)message);
        }
    }

    private static String createMessage(int messageSize) {
        String AB = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        Random rnd = new Random();
        StringBuilder sb = new StringBuilder(messageSize);
        for (int j = 0; j < messageSize; ++j) {
            sb.append("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rnd.nextInt("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".length())));
        }
        String body = sb.toString();
        return body;
    }
}

