/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederatedBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationAddressPolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationQueuePolicyElement;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.ActiveMQServerAMQPFederationPlugin;
import org.apache.activemq.artemis.protocol.amqp.federation.Federation;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPFederationBrokerPliuginTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int SERVER_PORT = 5672;
    private static final int SERVER_PORT_REMOTE = 5673;
    protected ActiveMQServer remoteServer;

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,CORE";
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        this.remoteServer = this.createServer(5673, false);
        return this.createServer(5672, false);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        try {
            if (this.remoteServer != null) {
                this.remoteServer.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationBrokerPluginWithAddressPolicyConfigured() throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationAddressPolicyElement localAddressPolicy = new AMQPFederationAddressPolicyElement();
        localAddressPolicy.setName("test-policy");
        localAddressPolicy.addToIncludes("test");
        localAddressPolicy.setAutoDelete(Boolean.valueOf(false));
        localAddressPolicy.setAutoDeleteDelay(Long.valueOf(-1L));
        localAddressPolicy.setAutoDeleteMessageCount(Long.valueOf(-1L));
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addLocalAddressPolicy(localAddressPolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        AMQPTestFederationBrokerPlugin federationPlugin = new AMQPTestFederationBrokerPlugin();
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.remoteServer.start();
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)federationPlugin);
        this.server.start();
        Wait.assertTrue(() -> federationPlugin.started.get());
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        ConnectionFactory factoryRemote = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            Topic topic = sessionL.createTopic("test");
            MessageConsumer consumerL = sessionL.createConsumer((Destination)topic);
            connectionL.start();
            connectionR.start();
            Wait.assertTrue(() -> this.server.addressQuery(SimpleString.of((String)"test")).isExists());
            Wait.assertTrue(() -> this.remoteServer.addressQuery(SimpleString.of((String)"test")).isExists());
            Wait.assertTrue(() -> federationPlugin.beforeCreateConsumerCapture.get() != null);
            Wait.assertTrue(() -> federationPlugin.afterCreateConsumerCapture.get() != null);
            MessageProducer producerR = sessionR.createProducer((Destination)topic);
            TextMessage message = sessionR.createTextMessage("Hello World");
            AtomicReference messagePreHandled = new AtomicReference();
            AtomicReference messagePostHandled = new AtomicReference();
            federationPlugin.beforeMessageHandled = (c, m) -> messagePreHandled.set(m);
            federationPlugin.afterMessageHandled = (c, m) -> messagePostHandled.set(m);
            producerR.send((Message)message);
            Wait.assertTrue(() -> messagePreHandled.get() != null);
            Wait.assertTrue(() -> messagePostHandled.get() != null);
            Assertions.assertSame(messagePreHandled.get(), messagePostHandled.get());
            Message received = consumerL.receive(5000L);
            consumerL.close();
            Wait.assertTrue(() -> federationPlugin.beforeCloseConsumerCapture.get() != null);
            Wait.assertTrue(() -> federationPlugin.afterCloseConsumerCapture.get() != null);
            Assertions.assertNotNull((Object)received);
        }
        this.server.stop();
        Wait.assertTrue(() -> federationPlugin.stopped.get());
    }

    @Test
    @Timeout(value=20L)
    public void testFederationBrokerPluginWithQueuePolicyConfigured() throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationQueuePolicyElement localQueuePolicy = new AMQPFederationQueuePolicyElement();
        localQueuePolicy.setName("test-policy");
        localQueuePolicy.addToIncludes("test", "test");
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addLocalQueuePolicy(localQueuePolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        AMQPTestFederationBrokerPlugin federationPlugin = new AMQPTestFederationBrokerPlugin();
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.remoteServer.start();
        this.remoteServer.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)federationPlugin);
        this.server.start();
        Wait.assertTrue(() -> federationPlugin.started.get());
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        ConnectionFactory factoryRemote = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            jakarta.jms.Queue queue = sessionL.createQueue("test");
            MessageConsumer consumerL = sessionL.createConsumer((Destination)queue);
            connectionL.start();
            connectionR.start();
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"test")).isExists());
            Wait.assertTrue(() -> federationPlugin.beforeCreateConsumerCapture.get() != null);
            Wait.assertTrue(() -> federationPlugin.afterCreateConsumerCapture.get() != null);
            MessageProducer producerR = sessionR.createProducer((Destination)queue);
            TextMessage message = sessionR.createTextMessage("Hello World");
            AtomicReference messagePreHandled = new AtomicReference();
            AtomicReference messagePostHandled = new AtomicReference();
            federationPlugin.beforeMessageHandled = (c, m) -> messagePreHandled.set(m);
            federationPlugin.afterMessageHandled = (c, m) -> messagePostHandled.set(m);
            producerR.send((Message)message);
            Wait.assertTrue(() -> messagePreHandled.get() != null);
            Wait.assertTrue(() -> messagePostHandled.get() != null);
            Assertions.assertSame(messagePreHandled.get(), messagePostHandled.get());
            Message received = consumerL.receive(5000L);
            consumerL.close();
            Wait.assertTrue(() -> federationPlugin.beforeCloseConsumerCapture.get() != null);
            Wait.assertTrue(() -> federationPlugin.afterCloseConsumerCapture.get() != null);
            Assertions.assertNotNull((Object)received);
        }
        this.server.stop();
        Wait.assertTrue(() -> federationPlugin.stopped.get());
    }

    @Test
    @Timeout(value=20L)
    public void testPluginCanBlockAddressFederationConsumerCreate() throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationAddressPolicyElement localAddressPolicy = new AMQPFederationAddressPolicyElement();
        localAddressPolicy.setName("test-policy");
        localAddressPolicy.addToIncludes(this.getTestName());
        localAddressPolicy.setAutoDelete(Boolean.valueOf(false));
        localAddressPolicy.setAutoDeleteDelay(Long.valueOf(-1L));
        localAddressPolicy.setAutoDeleteMessageCount(Long.valueOf(-1L));
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addLocalAddressPolicy(localAddressPolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        AMQPTestFederationBrokerPlugin federationPlugin = new AMQPTestFederationBrokerPlugin();
        federationPlugin.shouldCreateConsumerForAddress = a -> false;
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.remoteServer.start();
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)federationPlugin);
        this.server.start();
        Wait.assertTrue(() -> federationPlugin.started.get());
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        ConnectionFactory factoryRemote = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            Topic topic = sessionL.createTopic("test");
            MessageConsumer consumerL = sessionL.createConsumer((Destination)topic);
            connectionL.start();
            connectionR.start();
            Wait.assertTrue(() -> this.server.addressQuery(SimpleString.of((String)"test")).isExists());
            MessageProducer producerR = sessionR.createProducer((Destination)topic);
            TextMessage message = sessionR.createTextMessage("Hello World");
            AtomicReference messagePreHandled = new AtomicReference();
            federationPlugin.beforeMessageHandled = (c, m) -> messagePreHandled.set(m);
            producerR.send((Message)message);
            Assertions.assertNull((Object)consumerL.receiveNoWait());
            Assertions.assertNull(messagePreHandled.get());
            consumerL.close();
        }
        this.server.stop();
        Wait.assertTrue(() -> federationPlugin.stopped.get());
    }

    @Test
    @Timeout(value=20L)
    public void testPluginCanBlockQueueFederationConsumerCreate() throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationQueuePolicyElement localQueuePolicy = new AMQPFederationQueuePolicyElement();
        localQueuePolicy.setName("test-policy");
        localQueuePolicy.addToIncludes("test", "test");
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addLocalQueuePolicy(localQueuePolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        AMQPTestFederationBrokerPlugin federationPlugin = new AMQPTestFederationBrokerPlugin();
        federationPlugin.shouldCreateConsumerForQueue = q -> false;
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.remoteServer.start();
        this.remoteServer.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)federationPlugin);
        this.server.start();
        Wait.assertTrue(() -> federationPlugin.started.get());
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        ConnectionFactory factoryRemote = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            jakarta.jms.Queue queue = sessionL.createQueue("test");
            MessageConsumer consumerL = sessionL.createConsumer((Destination)queue);
            connectionL.start();
            connectionR.start();
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"test")).isExists());
            MessageProducer producerR = sessionR.createProducer((Destination)queue);
            TextMessage message = sessionR.createTextMessage("Hello World");
            AtomicReference messagePreHandled = new AtomicReference();
            federationPlugin.beforeMessageHandled = (c, m) -> messagePreHandled.set(m);
            producerR.send((Message)message);
            Assertions.assertNull((Object)consumerL.receiveNoWait());
            Assertions.assertNull(messagePreHandled.get());
            consumerL.close();
        }
        this.server.stop();
        Wait.assertTrue(() -> federationPlugin.stopped.get());
    }

    @Test
    @Timeout(value=20L)
    public void testPluginCanBlockAddressFederationWhenDemandOnDivertIsAdded() throws Exception {
        logger.info("Test started: {}", (Object)this.getTestName());
        AMQPFederationAddressPolicyElement localAddressPolicy = new AMQPFederationAddressPolicyElement();
        localAddressPolicy.setName("test-policy");
        localAddressPolicy.addToIncludes("source");
        localAddressPolicy.setAutoDelete(Boolean.valueOf(false));
        localAddressPolicy.setAutoDeleteDelay(Long.valueOf(-1L));
        localAddressPolicy.setAutoDeleteMessageCount(Long.valueOf(-1L));
        localAddressPolicy.setEnableDivertBindings(Boolean.valueOf(true));
        AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
        element.setName(this.getTestName());
        element.addLocalAddressPolicy(localAddressPolicy);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
        amqpConnection.setReconnectAttempts(10);
        amqpConnection.addElement((AMQPBrokerConnectionElement)element);
        DivertConfiguration divert = new DivertConfiguration();
        divert.setName("test-divert");
        divert.setAddress("source");
        divert.setForwardingAddress("target");
        divert.setRoutingType(ComponentConfigurationRoutingType.MULTICAST);
        AMQPTestFederationBrokerPlugin federationPlugin = new AMQPTestFederationBrokerPlugin();
        federationPlugin.shouldCreateConsumerForDivert = (d, q) -> false;
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.remoteServer.start();
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)federationPlugin);
        this.server.start();
        this.server.deployDivert(divert);
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"source"), RoutingType.MULTICAST));
        ConnectionFactory factoryLocal = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        ConnectionFactory factoryRemote = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        try (Connection connectionL = factoryLocal.createConnection();
             Connection connectionR = factoryRemote.createConnection();){
            Session sessionL = connectionL.createSession(1);
            Session sessionR = connectionR.createSession(1);
            Topic target = sessionL.createTopic("target");
            Topic source = sessionL.createTopic("source");
            MessageConsumer consumerL = sessionL.createConsumer((Destination)target);
            connectionL.start();
            connectionR.start();
            MessageProducer producerR = sessionR.createProducer((Destination)source);
            TextMessage message = sessionR.createTextMessage("Hello World");
            AtomicReference messagePreHandled = new AtomicReference();
            federationPlugin.beforeMessageHandled = (c, m) -> messagePreHandled.set(m);
            producerR.send((Message)message);
            Assertions.assertNull((Object)consumerL.receiveNoWait());
            Assertions.assertNull(messagePreHandled.get());
        }
        this.server.stop();
        Wait.assertTrue(() -> federationPlugin.stopped.get());
    }

    private class AMQPTestFederationBrokerPlugin
    implements ActiveMQServerAMQPFederationPlugin {
        public final AtomicBoolean started = new AtomicBoolean();
        public final AtomicBoolean stopped = new AtomicBoolean();
        public final AtomicReference<FederationConsumerInfo> beforeCreateConsumerCapture = new AtomicReference();
        public final AtomicReference<FederationConsumer> afterCreateConsumerCapture = new AtomicReference();
        public final AtomicReference<FederationConsumer> beforeCloseConsumerCapture = new AtomicReference();
        public final AtomicReference<FederationConsumer> afterCloseConsumerCapture = new AtomicReference();
        public Consumer<FederationConsumerInfo> beforeCreateConsumer = c -> this.beforeCreateConsumerCapture.set((FederationConsumerInfo)c);
        public Consumer<FederationConsumer> afterCreateConsumer = c -> this.afterCreateConsumerCapture.set((FederationConsumer)c);
        public Consumer<FederationConsumer> beforeCloseConsumer = c -> this.beforeCloseConsumerCapture.set((FederationConsumer)c);
        public Consumer<FederationConsumer> afterCloseConsumer = c -> this.afterCloseConsumerCapture.set((FederationConsumer)c);
        public BiConsumer<FederationConsumer, org.apache.activemq.artemis.api.core.Message> beforeMessageHandled = (c, m) -> {};
        public BiConsumer<FederationConsumer, org.apache.activemq.artemis.api.core.Message> afterMessageHandled = (c, m) -> {};
        public Function<AddressInfo, Boolean> shouldCreateConsumerForAddress = a -> true;
        public Function<Queue, Boolean> shouldCreateConsumerForQueue = q -> true;
        public BiFunction<Divert, Queue, Boolean> shouldCreateConsumerForDivert = (d, q) -> true;

        private AMQPTestFederationBrokerPlugin() {
        }

        public void federationStarted(Federation federation) throws ActiveMQException {
            this.started.set(true);
        }

        public void federationStopped(Federation federation) throws ActiveMQException {
            this.stopped.set(true);
        }

        public void beforeCreateFederationConsumer(FederationConsumerInfo consumerInfo) throws ActiveMQException {
            this.beforeCreateConsumer.accept(consumerInfo);
        }

        public void afterCreateFederationConsumer(FederationConsumer consumer) throws ActiveMQException {
            this.afterCreateConsumer.accept(consumer);
        }

        public void beforeCloseFederationConsumer(FederationConsumer consumer) throws ActiveMQException {
            this.beforeCloseConsumer.accept(consumer);
        }

        public void afterCloseFederationConsumer(FederationConsumer consumer) throws ActiveMQException {
            this.afterCloseConsumer.accept(consumer);
        }

        public void beforeFederationConsumerMessageHandled(FederationConsumer consumer, org.apache.activemq.artemis.api.core.Message message) throws ActiveMQException {
            this.beforeMessageHandled.accept(consumer, message);
        }

        public void afterFederationConsumerMessageHandled(FederationConsumer consumer, org.apache.activemq.artemis.api.core.Message message) throws ActiveMQException {
            this.afterMessageHandled.accept(consumer, message);
        }

        public boolean shouldCreateFederationConsumerForAddress(AddressInfo address) throws ActiveMQException {
            return this.shouldCreateConsumerForAddress.apply(address);
        }

        public boolean shouldCreateFederationConsumerForQueue(Queue queue) throws ActiveMQException {
            return this.shouldCreateConsumerForQueue.apply(queue);
        }

        public boolean shouldCreateFederationConsumerForDivert(Divert divert, Queue queue) throws ActiveMQException {
            return this.shouldCreateConsumerForDivert.apply(divert, queue);
        }
    }
}

