/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AutogroupIdTest
extends ActiveMQTestBase {
    public final SimpleString addressA = SimpleString.of((String)"addressA");
    public final SimpleString queueA = SimpleString.of((String)"queueA");
    public final SimpleString queueB = SimpleString.of((String)"queueB");
    public final SimpleString queueC = SimpleString.of((String)"queueC");
    private final SimpleString groupTestQ = SimpleString.of((String)"testGroupQueue");
    private ActiveMQServer server;
    private ServerLocator locator;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
        this.waitForServerToStart(this.server);
        this.locator = this.createInVMNonHALocator();
    }

    @Test
    public void testGroupIdAutomaticallySet() throws Exception {
        this.locator.setAutoGroup(true);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.groupTestQ).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.groupTestQ);
        CountDownLatch latch = new CountDownLatch(100);
        MyMessageHandler myMessageHandler = new MyMessageHandler(latch);
        MyMessageHandler myMessageHandler2 = new MyMessageHandler(latch);
        ClientConsumer consumer = session.createConsumer(this.groupTestQ);
        consumer.setMessageHandler((MessageHandler)myMessageHandler);
        ClientConsumer consumer2 = session.createConsumer(this.groupTestQ);
        consumer2.setMessageHandler((MessageHandler)myMessageHandler2);
        session.start();
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            producer.send((Message)session.createMessage(false));
        }
        AutogroupIdTest.waitForLatch(latch);
        session.close();
        Assertions.assertEquals((int)100, (int)myMessageHandler.messagesReceived);
        Assertions.assertEquals((int)0, (int)myMessageHandler2.messagesReceived);
    }

    @Test
    public void testGroupIdAutomaticallySetMultipleProducers() throws Exception {
        int i;
        this.locator.setAutoGroup(true);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.groupTestQ).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.groupTestQ);
        ClientProducer producer2 = session.createProducer(this.groupTestQ);
        CountDownLatch latch = new CountDownLatch(200);
        MyMessageHandler myMessageHandler = new MyMessageHandler(latch);
        MyMessageHandler myMessageHandler2 = new MyMessageHandler(latch);
        MyMessageHandler myMessageHandler3 = new MyMessageHandler(latch);
        ClientConsumer consumer = session.createConsumer(this.groupTestQ);
        consumer.setMessageHandler((MessageHandler)myMessageHandler);
        ClientConsumer consumer2 = session.createConsumer(this.groupTestQ);
        consumer2.setMessageHandler((MessageHandler)myMessageHandler2);
        ClientConsumer consumer3 = session.createConsumer(this.groupTestQ);
        consumer3.setMessageHandler((MessageHandler)myMessageHandler3);
        session.start();
        int numMessages = 100;
        for (i = 0; i < 100; ++i) {
            producer.send((Message)session.createMessage(false));
        }
        for (i = 0; i < 100; ++i) {
            producer2.send((Message)session.createMessage(false));
        }
        AutogroupIdTest.waitForLatch(latch);
        session.close();
        Assertions.assertEquals((int)myMessageHandler.messagesReceived, (int)100);
        Assertions.assertEquals((int)myMessageHandler2.messagesReceived, (int)100);
        Assertions.assertEquals((int)myMessageHandler3.messagesReceived, (int)0);
    }

    @Test
    public void testGroupIdAutomaticallyNotSet() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.groupTestQ).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.groupTestQ);
        CountDownLatch latch = new CountDownLatch(100);
        MyMessageHandler myMessageHandler = new MyMessageHandler(latch);
        MyMessageHandler myMessageHandler2 = new MyMessageHandler(latch);
        ClientConsumer consumer = session.createConsumer(this.groupTestQ);
        consumer.setMessageHandler((MessageHandler)myMessageHandler);
        ClientConsumer consumer2 = session.createConsumer(this.groupTestQ);
        consumer2.setMessageHandler((MessageHandler)myMessageHandler2);
        session.start();
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            producer.send((Message)session.createMessage(false));
        }
        AutogroupIdTest.waitForLatch(latch);
        session.close();
        Assertions.assertEquals((int)50, (int)myMessageHandler.messagesReceived);
        Assertions.assertEquals((int)50, (int)myMessageHandler2.messagesReceived);
    }

    private static class MyMessageHandler
    implements MessageHandler {
        int messagesReceived = 0;
        private final CountDownLatch latch;

        private MyMessageHandler(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onMessage(ClientMessage message) {
            ++this.messagesReceived;
            try {
                message.acknowledge();
            }
            catch (ActiveMQException e) {
                e.printStackTrace();
            }
            this.latch.countDown();
        }
    }
}

