/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.cli.commands.tools.journal.CompactJournal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.ReplicatedBackupUtils;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class InfiniteRedeliveryTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    String protocol;
    boolean useCLI;
    TestableServer primaryServer;
    TestableServer backupServer;
    Configuration backupConfig;
    Configuration primaryConfig;

    @Parameters(name="protocol={0}, useCLI={1}")
    public static Collection getParameters() {
        return Arrays.asList({"CORE", true}, {"AMQP", false}, {"OPENWIRE", false});
    }

    public InfiniteRedeliveryTest(String protocol, boolean useCLI) {
        this.protocol = protocol;
        this.useCLI = useCLI;
    }

    protected TestableServer createTestableServer(Configuration config, NodeManager nodeManager) throws Exception {
        boolean isBackup = config.getHAPolicyConfiguration() instanceof ReplicaPolicyConfiguration || config.getHAPolicyConfiguration() instanceof SharedStoreBackupPolicyConfiguration;
        return new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config, nodeManager, isBackup ? 2 : 1));
    }

    protected void createReplicatedConfigs() throws Exception {
        TransportConfiguration primaryConnector = TransportConfigurationUtils.getNettyConnector(true, 0);
        TransportConfiguration backupConnector = TransportConfigurationUtils.getNettyConnector(false, 0);
        TransportConfiguration backupAcceptor = TransportConfigurationUtils.getNettyAcceptor(false, 0);
        this.backupConfig = this.createDefaultConfig(0, true);
        this.primaryConfig = this.createDefaultConfig(0, true);
        this.configureReplicationPair(backupConnector, backupAcceptor, primaryConnector);
        this.backupConfig.setBindingsDirectory(this.getBindingsDir(0, true)).setJournalDirectory(this.getJournalDir(0, true)).setPagingDirectory(this.getPageDir(0, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(0, true)).setSecurityEnabled(false);
        this.backupServer = this.createTestableServer(this.backupConfig, (NodeManager)new InVMNodeManager(true, this.backupConfig.getJournalLocation()));
        this.primaryConfig.clearAcceptorConfigurations().addAcceptorConfiguration(TransportConfigurationUtils.getNettyAcceptor(true, 0));
        this.primaryServer = this.createTestableServer(this.primaryConfig, (NodeManager)new InVMNodeManager(false, this.primaryConfig.getJournalLocation()));
    }

    protected void configureReplicationPair(TransportConfiguration backupConnector, TransportConfiguration backupAcceptor, TransportConfiguration primaryConnector) {
        ReplicatedBackupUtils.configureReplicationPair(this.backupConfig, backupConnector, backupAcceptor, this.primaryConfig, primaryConnector, null);
        ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(-1).setAllowFailBack(true);
        ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setRestartBackup(false);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    protected void startServer(boolean reschedule) throws Exception {
        this.createReplicatedConfigs();
        Configuration configuration = this.primaryServer.getServer().getConfiguration();
        configuration.getAddressSettings().clear();
        if (reschedule) {
            AddressSettings settings = new AddressSettings().setMaxDeliveryAttempts(Integer.MAX_VALUE).setRedeliveryDelay(1L);
            configuration.getAddressSettings().put("#", settings);
        } else {
            AddressSettings settings = new AddressSettings().setMaxDeliveryAttempts(Integer.MAX_VALUE).setRedeliveryDelay(0L);
            configuration.getAddressSettings().put("#", settings);
        }
        this.primaryServer.start();
        this.backupServer.start();
        Wait.waitFor(() -> ((ActiveMQServer)this.primaryServer.getServer()).isReplicaSync());
    }

    @TestTemplate
    public void testInifinteRedeliveryWithScheduling() throws Exception {
        this.testInifinteRedeliveryWithScheduling(true);
    }

    @TestTemplate
    public void testInifinteRedeliveryWithoutScheduling() throws Exception {
        this.testInifinteRedeliveryWithScheduling(false);
    }

    public void testInifinteRedeliveryWithScheduling(boolean reschedule) throws Exception {
        this.startServer(reschedule);
        this.primaryServer.getServer().addAddressInfo(new AddressInfo("test").setAutoCreated(false).addRoutingType(RoutingType.ANYCAST));
        this.primaryServer.getServer().createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setDurable(Boolean.valueOf(true)));
        ConnectionFactory factory = this.protocol.toUpperCase().equals("OPENWIRE") ? CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616?jms.redeliveryPolicy.maximumRedeliveries=100&jms.redeliveryPolicy.redeliveryDelay=0") : CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(true, 0);
        Queue queue = session.createQueue("test");
        Assertions.assertNotNull((Object)queue);
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("hello"));
        session.commit();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        connection.start();
        for (int i = 0; i < 100; ++i) {
            Message message = consumer.receive(10000L);
            Assertions.assertNotNull((Object)message);
            session.rollback();
        }
        connection.close();
        if (!this.useCLI) {
            this.primaryServer.getServer().getStorageManager().getMessageJournal().scheduleCompactAndBlock(5000);
            this.backupServer.getServer().getStorageManager().getMessageJournal().scheduleCompactAndBlock(5000);
        }
        this.primaryServer.stop();
        this.backupServer.stop();
        if (this.useCLI) {
            CompactJournal.compactJournals((Configuration)this.backupServer.getServer().getConfiguration());
            CompactJournal.compactJournals((Configuration)this.primaryServer.getServer().getConfiguration());
        }
        HashMap<Integer, AtomicInteger> counts = this.countJournal(this.primaryServer.getServer().getConfiguration());
        counts.forEach((k, v) -> logger.debug("{}={}", k, v));
        counts.forEach((k, v) -> Assertions.assertTrue((v.intValue() < 20 ? 1 : 0) != 0, (String)("Record type " + k + " has a lot of records:" + v)));
        HashMap<Integer, AtomicInteger> backupCounts = this.countJournal(this.backupServer.getServer().getConfiguration());
        Assertions.assertTrue((backupCounts.size() > 0 ? 1 : 0) != 0);
        backupCounts.forEach((k, v) -> logger.debug("On Backup:{}={}", k, v));
        backupCounts.forEach((k, v) -> Assertions.assertTrue((v.intValue() < 10 ? 1 : 0) != 0, (String)("Backup Record type " + k + " has a lot of records:" + v)));
    }
}

