/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.multiprotocol;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.jms.multiprotocol.MultiprotocolJMSClientTestSupport;
import org.apache.activemq.artemis.utils.DestinationUtil;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSMessageConsumerTest
extends MultiprotocolJMSClientTestSupport {
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=30L)
    public void testDeliveryModeAMQPProducerCoreConsumer() throws Exception {
        Connection connection = this.createConnection();
        Connection connection2 = this.createCoreConnection();
        this.testDeliveryMode(connection, connection2);
    }

    @Test
    @Timeout(value=30L)
    public void testDeliveryModeAMQPProducerAMQPConsumer() throws Exception {
        Connection connection = this.createConnection();
        Connection connection2 = this.createConnection();
        this.testDeliveryMode(connection, connection2);
    }

    @Test
    @Timeout(value=30L)
    public void testDeliveryModeCoreProducerAMQPConsumer() throws Exception {
        Connection connection = this.createCoreConnection();
        Connection connection2 = this.createConnection();
        this.testDeliveryMode(connection, connection2);
    }

    @Test
    @Timeout(value=30L)
    public void testDeliveryModeCoreProducerCoreConsumer() throws Exception {
        Connection connection = this.createCoreConnection();
        Connection connection2 = this.createCoreConnection();
        this.testDeliveryMode(connection, connection2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeliveryMode(Connection connection1, Connection connection2) throws JMSException {
        try {
            Session session1 = connection1.createSession(false, 1);
            Session session2 = connection2.createSession(false, 1);
            jakarta.jms.Queue queue1 = session1.createQueue(this.getQueueName());
            jakarta.jms.Queue queue2 = session2.createQueue(this.getQueueName());
            MessageConsumer consumer2 = session2.createConsumer((Destination)queue2);
            MessageProducer producer = session1.createProducer((Destination)queue1);
            producer.setDeliveryMode(2);
            connection1.start();
            TextMessage message = session1.createTextMessage();
            message.setText("hello");
            producer.send((Message)message);
            Message received = consumer2.receive(100L);
            Assertions.assertNotNull((Object)received, (String)"Should have received a message by now.");
            Assertions.assertTrue((boolean)(received instanceof TextMessage), (String)"Should be an instance of TextMessage");
            Assertions.assertEquals((int)2, (int)received.getJMSDeliveryMode());
        }
        finally {
            connection1.close();
            connection2.close();
        }
    }

    @Test
    @Timeout(value=30L)
    public void testQueueRoutingTypeMismatchCore() throws Exception {
        this.testQueueRoutingTypeMismatch(this.createCoreConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testQueueRoutingTypeMismatchOpenWire() throws Exception {
        this.testQueueRoutingTypeMismatch(this.createOpenWireConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testQueueRoutingTypeMismatchAMQP() throws Exception {
        this.testQueueRoutingTypeMismatch(this.createConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testQueueRoutingTypeMismatch(Connection connection) throws Exception {
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("#")).setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false));
        String name = this.getTopicName();
        this.server.createQueue(QueueConfiguration.of((String)name).setAddress(name).setRoutingType(RoutingType.MULTICAST).setAutoCreateAddress(Boolean.valueOf(true)));
        try {
            Session session = connection.createSession(false, 1);
            session.createConsumer((Destination)session.createQueue(name));
            Assertions.fail((String)"Should have thrown a JMSException!");
        }
        catch (JMSException jMSException) {
        }
        finally {
            connection.close();
        }
    }

    @Test
    @Timeout(value=30L)
    public void testPriorityAMQPProducerCoreConsumer() throws Exception {
        Connection connection = this.createConnection();
        Connection connection2 = this.createCoreConnection();
        this.testPriority(connection, connection2);
    }

    @Test
    @Timeout(value=30L)
    public void testPriorityAMQPProducerAMQPConsumer() throws Exception {
        Connection connection = this.createConnection();
        Connection connection2 = this.createConnection();
        this.testPriority(connection, connection2);
    }

    @Test
    @Timeout(value=30L)
    public void testPriorityModeCoreProducerAMQPConsumer() throws Exception {
        Connection connection = this.createCoreConnection();
        Connection connection2 = this.createConnection();
        this.testPriority(connection, connection2);
    }

    @Test
    @Timeout(value=30L)
    public void testPriorityCoreProducerCoreConsumer() throws Exception {
        Connection connection = this.createCoreConnection();
        Connection connection2 = this.createCoreConnection();
        this.testPriority(connection, connection2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPriority(Connection connection1, Connection connection2) throws JMSException {
        try {
            Session session1 = connection1.createSession(false, 1);
            Session session2 = connection2.createSession(false, 1);
            jakarta.jms.Queue queue1 = session1.createQueue(this.getQueueName());
            jakarta.jms.Queue queue2 = session2.createQueue(this.getQueueName());
            MessageConsumer consumer2 = session2.createConsumer((Destination)queue2);
            MessageProducer producer = session1.createProducer((Destination)queue1);
            producer.setPriority(2);
            connection1.start();
            TextMessage message = session1.createTextMessage();
            message.setText("hello");
            producer.send((Message)message);
            Message received = consumer2.receive(100L);
            Assertions.assertNotNull((Object)received, (String)"Should have received a message by now.");
            Assertions.assertTrue((boolean)(received instanceof TextMessage), (String)"Should be an instance of TextMessage");
            Assertions.assertEquals((int)2, (int)received.getJMSPriority());
        }
        finally {
            connection1.close();
            connection2.close();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testDurableSubscriptionWithConfigurationManagedQueueWithCore() throws Exception {
        this.testDurableSubscriptionWithConfigurationManagedQueue(() -> this.createCoreConnection(false));
    }

    @Test
    @Timeout(value=60L)
    public void testDurableSubscriptionWithConfigurationManagedQueueWithOpenWire() throws Exception {
        this.testDurableSubscriptionWithConfigurationManagedQueue(() -> this.createOpenWireConnection(false));
    }

    @Test
    @Timeout(value=60L)
    public void testDurableSubscriptionWithConfigurationManagedQueueWithAMQP() throws Exception {
        this.testDurableSubscriptionWithConfigurationManagedQueue(() -> JMSMessageConsumerTest.super.createConnection(false));
    }

    private void testDurableSubscriptionWithConfigurationManagedQueue(MultiprotocolJMSClientTestSupport.ConnectionSupplier connectionSupplier) throws Exception {
        String clientId = "bar";
        String subName = "foo";
        String queueName = DestinationUtil.createQueueNameForSubscription((boolean)true, (String)"bar", (String)"foo").toString();
        this.server.stop();
        this.server.getConfiguration().addQueueConfiguration(QueueConfiguration.of((String)queueName).setAddress("myTopic").setFilterString("color = 'BLUE'").setRoutingType(RoutingType.MULTICAST));
        this.server.getConfiguration().setAmqpUseCoreSubscriptionNaming(true);
        this.server.start();
        try (Connection connection = connectionSupplier.createConnection();){
            connection.setClientID("bar");
            Session session = connection.createSession(false, 1);
            Topic destination = session.createTopic("myTopic");
            TopicSubscriber messageConsumer = session.createDurableSubscriber(destination, "foo");
            messageConsumer.close();
            Queue queue = this.server.locateQueue(queueName);
            Assertions.assertNotNull((Object)queue);
            Assertions.assertNotNull((Object)queue.getFilter());
            Assertions.assertEquals((Object)"color = 'BLUE'", (Object)queue.getFilter().getFilterString().toString());
        }
    }

    @Test
    @Timeout(value=30L)
    public void testEmptyMapMessageConversionBetweenOpenWireAndAMQP() throws Exception {
        this.testEmptyMapMessageConversion(this.createOpenWireConnection(), this.createConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testEmptyMapMessageConversionBetweenAMQPAndOpenWire() throws Exception {
        this.testEmptyMapMessageConversion(this.createConnection(), this.createOpenWireConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testEmptyMapMessageConversionBetweenCoreAndAMQP() throws Exception {
        this.testEmptyMapMessageConversion(this.createCoreConnection(), this.createConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testEmptyMapMessageConversionBetweenAMQPAndCore() throws Exception {
        this.testEmptyMapMessageConversion(this.createConnection(), this.createCoreConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testEmptyMapMessageConversionBetweenCoreAndOpenWire() throws Exception {
        this.testEmptyMapMessageConversion(this.createCoreConnection(), this.createOpenWireConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testEmptyMapMessageConversionBetweenOpenWireAndCore() throws Exception {
        this.testEmptyMapMessageConversion(this.createOpenWireConnection(), this.createCoreConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEmptyMapMessageConversion(Connection senderConnection, Connection consumerConnection) throws Exception {
        try {
            Session consumerSession = consumerConnection.createSession(false, 1);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerSession.createQueue(this.getQueueName()));
            Session senderSession = senderConnection.createSession(false, 1);
            MessageProducer producer = senderSession.createProducer((Destination)senderSession.createQueue(this.getQueueName()));
            MapMessage message = senderSession.createMapMessage();
            producer.send((Message)message);
            Message received = consumer.receive(1000L);
            Assertions.assertNotNull((Object)received, (String)"Should have received a message by now.");
            Assertions.assertTrue((boolean)(received instanceof MapMessage), (String)"Should be an instance of MapMessage");
        }
        finally {
            senderConnection.close();
            consumerConnection.close();
        }
    }

    @Test
    @Timeout(value=30L)
    public void testMapMessageConversionBetweenAMQPAndOpenWire() throws Exception {
        this.testMapMessageConversion(this.createConnection(), this.createOpenWireConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testMapMessageConversionBetweenCoreAndAMQP() throws Exception {
        this.testMapMessageConversion(this.createCoreConnection(), this.createConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testMapMessageConversionBetweenAMQPAndCore() throws Exception {
        this.testMapMessageConversion(this.createConnection(), this.createCoreConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testMapMessageConversionBetweenCoreAndOpenWire() throws Exception {
        this.testMapMessageConversion(this.createCoreConnection(), this.createOpenWireConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testMapMessageConversionBetweenOpenWireAndCore() throws Exception {
        this.testMapMessageConversion(this.createOpenWireConnection(), this.createCoreConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMapMessageConversion(Connection senderConnection, Connection consumerConnection) throws Exception {
        boolean BOOLEAN_VALUE = RandomUtil.randomBoolean();
        String BOOLEAN_KEY = "myBoolean";
        byte BYTE_VALUE = RandomUtil.randomByte();
        String BYTE_KEY = "myByte";
        byte[] BYTES_VALUE = RandomUtil.randomBytes();
        String BYTES_KEY = "myBytes";
        char CHAR_VALUE = RandomUtil.randomChar();
        String CHAR_KEY = "myChar";
        double DOUBLE_VALUE = RandomUtil.randomDouble();
        String DOUBLE_KEY = "myDouble";
        float FLOAT_VALUE = RandomUtil.randomFloat();
        String FLOAT_KEY = "myFloat";
        int INT_VALUE = RandomUtil.randomInt();
        String INT_KEY = "myInt";
        long LONG_VALUE = RandomUtil.randomLong();
        String LONG_KEY = "myLong";
        Boolean OBJECT_VALUE = RandomUtil.randomBoolean();
        String OBJECT_KEY = "myObject";
        short SHORT_VALUE = RandomUtil.randomShort();
        String SHORT_KEY = "myShort";
        String STRING_VALUE = RandomUtil.randomString();
        String STRING_KEY = "myString";
        try {
            Session consumerSession = consumerConnection.createSession(false, 1);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerSession.createQueue(this.getQueueName()));
            Session senderSession = senderConnection.createSession(false, 1);
            MessageProducer producer = senderSession.createProducer((Destination)senderSession.createQueue(this.getQueueName()));
            MapMessage message = senderSession.createMapMessage();
            message.setBoolean("myBoolean", BOOLEAN_VALUE);
            message.setByte("myByte", BYTE_VALUE);
            message.setBytes("myBytes", BYTES_VALUE);
            message.setChar("myChar", CHAR_VALUE);
            message.setDouble("myDouble", DOUBLE_VALUE);
            message.setFloat("myFloat", FLOAT_VALUE);
            message.setInt("myInt", INT_VALUE);
            message.setLong("myLong", LONG_VALUE);
            message.setObject("myObject", (Object)OBJECT_VALUE);
            message.setShort("myShort", SHORT_VALUE);
            message.setString("myString", STRING_VALUE);
            producer.send((Message)message);
            Message received = consumer.receive(1000L);
            Assertions.assertNotNull((Object)received, (String)"Should have received a message by now.");
            Assertions.assertTrue((boolean)(received instanceof MapMessage), (String)"Should be an instance of MapMessage");
            MapMessage receivedMapMessage = (MapMessage)received;
            Assertions.assertEquals((Object)BOOLEAN_VALUE, (Object)receivedMapMessage.getBoolean("myBoolean"));
            Assertions.assertEquals((byte)BYTE_VALUE, (byte)receivedMapMessage.getByte("myByte"));
            JMSMessageConsumerTest.assertEqualsByteArrays(BYTES_VALUE, receivedMapMessage.getBytes("myBytes"));
            Assertions.assertEquals((char)CHAR_VALUE, (char)receivedMapMessage.getChar("myChar"));
            Assertions.assertEquals((double)DOUBLE_VALUE, (double)receivedMapMessage.getDouble("myDouble"), (double)0.0);
            Assertions.assertEquals((float)FLOAT_VALUE, (float)receivedMapMessage.getFloat("myFloat"), (float)0.0f);
            Assertions.assertEquals((int)INT_VALUE, (int)receivedMapMessage.getInt("myInt"));
            Assertions.assertEquals((long)LONG_VALUE, (long)receivedMapMessage.getLong("myLong"));
            Assertions.assertTrue((boolean)(receivedMapMessage.getObject("myObject") instanceof Boolean));
            Assertions.assertEquals((Object)OBJECT_VALUE, (Object)receivedMapMessage.getObject("myObject"));
            Assertions.assertEquals((short)SHORT_VALUE, (short)receivedMapMessage.getShort("myShort"));
            Assertions.assertEquals((Object)STRING_VALUE, (Object)receivedMapMessage.getString("myString"));
        }
        finally {
            senderConnection.close();
            consumerConnection.close();
        }
    }

    @Test
    public void testConvertedAndPaging() throws Exception {
        boolean MESSAGE_COUNT = true;
        this.server.createQueue(QueueConfiguration.of((String)this.getQueueName()).setRoutingType(RoutingType.ANYCAST));
        PagingStore store = this.server.getPagingManager().getPageStore(SimpleString.of((String)this.getQueueName()));
        store.startPaging();
        try (Connection senderConnection = this.createConnection();
             Connection consumerConnection = this.createCoreConnection();){
            int i;
            Session consumerSession = consumerConnection.createSession(true, 0);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerSession.createQueue(this.getQueueName()));
            Session senderSession = senderConnection.createSession(true, 0);
            MessageProducer producer = senderSession.createProducer((Destination)senderSession.createQueue(this.getQueueName()));
            for (i = 0; i < 1; ++i) {
                Message message = senderSession.createMessage();
                message.setIntProperty("count", i);
                producer.send(message);
            }
            senderSession.commit();
            for (i = 0; i < 1; ++i) {
                Message received = consumer.receive(1000L);
                Assertions.assertNotNull((Object)received);
            }
            consumerSession.commit();
            consumer.close();
            Assertions.assertEquals((long)0L, (long)this.server.locateQueue(this.getQueueName()).getMessageCount());
            Wait.assertEquals((long)0L, () -> ((PagingStore)store).getAddressSize(), (long)5000L);
            Assertions.assertEquals((long)0L, (long)((AddressControl)this.server.getManagementService().getResource("address." + this.getQueueName())).getAddressSize());
        }
    }
}

