/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MessageListenerRedeliveryTest
extends BasicOpenWireTest {
    private Connection redeliverConnection;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.redeliverConnection = this.createRetryConnection();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        if (this.redeliverConnection != null) {
            this.redeliverConnection.close();
            this.redeliverConnection = null;
        }
        super.tearDown();
    }

    protected RedeliveryPolicy getRedeliveryPolicy() {
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.setInitialRedeliveryDelay(0L);
        redeliveryPolicy.setRedeliveryDelay(1000L);
        redeliveryPolicy.setMaximumRedeliveries(3);
        redeliveryPolicy.setBackOffMultiplier(2.0);
        redeliveryPolicy.setUseExponentialBackOff(true);
        return redeliveryPolicy;
    }

    protected Connection createRetryConnection() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
        factory.setRedeliveryPolicy(this.getRedeliveryPolicy());
        return factory.createConnection();
    }

    @Test
    public void testQueueRollbackConsumerListener() throws Exception {
        this.redeliverConnection.start();
        Session session = this.redeliverConnection.createSession(true, 2);
        String qname = "queue-testQueueRollbackConsumerListener";
        Queue queue = session.createQueue(qname);
        this.makeSureCoreQueueExist(qname);
        MessageProducer producer = this.createProducer(session, (Destination)queue);
        TextMessage message = this.createTextMessage(session);
        producer.send((Message)message);
        session.commit();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        ActiveMQMessageConsumer mc = (ActiveMQMessageConsumer)consumer;
        mc.setRedeliveryPolicy(this.getRedeliveryPolicy());
        TestMessageListener listener = new TestMessageListener(session);
        consumer.setMessageListener((MessageListener)listener);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)2, (int)listener.counter);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)3, (int)listener.counter);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)4, (int)listener.counter);
        producer.send((Message)this.createTextMessage(session));
        session.commit();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)5, (int)listener.counter);
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)5, (int)listener.counter);
        session.close();
    }

    @Test
    public void testQueueRollbackSessionListener() throws Exception {
        this.redeliverConnection.start();
        Session session = this.redeliverConnection.createSession(true, 2);
        String qname = "queue-testQueueRollbackSessionListener";
        Queue queue = session.createQueue(qname);
        this.makeSureCoreQueueExist(qname);
        MessageProducer producer = this.createProducer(session, (Destination)queue);
        TextMessage message = this.createTextMessage(session);
        producer.send((Message)message);
        session.commit();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        ActiveMQMessageConsumer mc = (ActiveMQMessageConsumer)consumer;
        mc.setRedeliveryPolicy(this.getRedeliveryPolicy());
        TestMessageListener listener = new TestMessageListener(session);
        consumer.setMessageListener((MessageListener)listener);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)2, (int)listener.counter);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)3, (int)listener.counter);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)4, (int)listener.counter);
        producer.send((Message)this.createTextMessage(session));
        session.commit();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)5, (int)listener.counter);
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)5, (int)listener.counter);
        session.close();
    }

    @Test
    public void testQueueSessionListenerExceptionRetry() throws Exception {
        int i;
        this.redeliverConnection.start();
        Session session = this.redeliverConnection.createSession(false, 1);
        String qname = "queue-testQueueSessionListenerExceptionRetry";
        Queue queue = session.createQueue(qname);
        this.makeSureCoreQueueExist(qname);
        MessageProducer producer = this.createProducer(session, (Destination)queue);
        TextMessage message = this.createTextMessage(session, "1");
        producer.send((Message)message);
        message = this.createTextMessage(session, "2");
        producer.send((Message)message);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        CountDownLatch gotMessage = new CountDownLatch(2);
        AtomicInteger count = new AtomicInteger(0);
        int maxDeliveries = this.getRedeliveryPolicy().getMaximumRedeliveries();
        ArrayList received = new ArrayList();
        consumer.setMessageListener(message1 -> {
            try {
                received.add(((TextMessage)message1).getText());
            }
            catch (JMSException e) {
                e.printStackTrace();
                Assertions.fail((String)e.toString());
            }
            if (count.incrementAndGet() < maxDeliveries) {
                throw new RuntimeException(this.getName() + " force a redelivery");
            }
            count.set(0);
            gotMessage.countDown();
        });
        Assertions.assertTrue((boolean)gotMessage.await(20L, TimeUnit.SECONDS), (String)"got message before retry expiry");
        for (i = 0; i < maxDeliveries; ++i) {
            Assertions.assertEquals((Object)"1", received.get(i), (String)("got first redelivered: " + i));
        }
        for (i = maxDeliveries; i < maxDeliveries * 2; ++i) {
            Assertions.assertEquals((Object)"2", received.get(i), (String)("got first redelivered: " + i));
        }
        session.close();
    }

    @Test
    public void testQueueSessionListenerExceptionDlq() throws Exception {
        this.redeliverConnection.start();
        Session session = this.redeliverConnection.createSession(false, 1);
        String qname = "queue-testQueueSessionListenerExceptionDlq";
        Queue queue = session.createQueue(qname);
        this.makeSureCoreQueueExist(qname);
        MessageProducer producer = this.createProducer(session, (Destination)queue);
        TextMessage message = this.createTextMessage(session);
        producer.send((Message)message);
        Message[] dlqMessage = new Message[1];
        ActiveMQQueue dlqDestination = new ActiveMQQueue("ActiveMQ.DLQ");
        this.makeSureCoreQueueExist("ActiveMQ.DLQ");
        MessageConsumer dlqConsumer = session.createConsumer((Destination)dlqDestination);
        CountDownLatch gotDlqMessage = new CountDownLatch(1);
        dlqConsumer.setMessageListener(message12 -> {
            dlqMessage[0] = message12;
            gotDlqMessage.countDown();
        });
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        int maxDeliveries = this.getRedeliveryPolicy().getMaximumRedeliveries();
        CountDownLatch gotMessage = new CountDownLatch(maxDeliveries);
        consumer.setMessageListener(message1 -> {
            gotMessage.countDown();
            throw new RuntimeException(this.getName() + " force a redelivery");
        });
        Assertions.assertTrue((boolean)gotMessage.await(20L, TimeUnit.SECONDS), (String)"got message before retry expiry");
        Assertions.assertTrue((boolean)gotDlqMessage.await(20L, TimeUnit.SECONDS), (String)"got dlq message");
        message = dlqMessage[0];
        Assertions.assertNotNull((Object)message, (String)"dlq message captured");
        String cause = message.getStringProperty("dlqDeliveryFailureCause");
        Assertions.assertTrue((boolean)cause.contains("RuntimeException"), (String)"cause 'cause' exception is remembered");
        Assertions.assertTrue((boolean)cause.contains(this.getName()), (String)"is correct exception");
        Assertions.assertTrue((boolean)cause.contains("Throwable"), (String)"cause exception is remembered");
        Assertions.assertTrue((boolean)cause.contains("RedeliveryPolicy"), (String)"cause policy is remembered");
        session.close();
    }

    private TextMessage createTextMessage(Session session, String text) throws JMSException {
        return session.createTextMessage(text);
    }

    private TextMessage createTextMessage(Session session) throws JMSException {
        return session.createTextMessage("Hello");
    }

    private MessageProducer createProducer(Session session, Destination queue) throws JMSException {
        MessageProducer producer = session.createProducer(queue);
        producer.setDeliveryMode(this.getDeliveryMode());
        return producer;
    }

    protected int getDeliveryMode() {
        return 2;
    }

    @Override
    protected String getName() {
        return "testQueueSessionListenerExceptionDlq";
    }

    private class TestMessageListener
    implements MessageListener {
        public int counter;
        private final Session session;

        private TestMessageListener(Session session) {
            this.session = session;
        }

        public void onMessage(Message message) {
            try {
                ++this.counter;
                if (this.counter <= 4) {
                    this.session.rollback();
                } else {
                    message.acknowledge();
                    this.session.commit();
                }
            }
            catch (JMSException e) {
                System.out.println("Error when rolling back transaction");
            }
        }
    }
}

