/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.auth;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.jboss.as.clustering.jgroups.auth.BinaryAuthToken;
import org.jgroups.Message;
import org.jgroups.auth.AuthToken;

public class CipherAuthToken
extends BinaryAuthToken {
    private final Cipher cipher;
    private final byte[] rawSharedSecret;

    public CipherAuthToken() {
        this.cipher = null;
        this.rawSharedSecret = null;
    }

    public CipherAuthToken(Cipher cipher, KeyPair pair, byte[] rawSharedSecret) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        super(CipherAuthToken.encryptedSharedSecret(cipher, pair.getPublic(), rawSharedSecret));
        this.cipher = cipher;
        this.rawSharedSecret = rawSharedSecret;
        this.cipher.init(2, pair.getPrivate());
    }

    private static byte[] encryptedSharedSecret(Cipher cipher, Key key, byte[] data) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        cipher.init(1, key);
        return cipher.doFinal(data);
    }

    @Override
    public synchronized boolean authenticate(AuthToken token, Message message) {
        if (this.getSharedSecret() == null || !(token instanceof CipherAuthToken)) {
            return false;
        }
        try {
            byte[] decrypted = this.cipher.doFinal(((CipherAuthToken)token).getSharedSecret());
            return Arrays.equals(decrypted, this.rawSharedSecret);
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }
}

