/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.crypto.Cipher;
import org.jboss.as.clustering.controller.CommonServiceDescriptor;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.jgroups.auth.CipherAuthToken;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.AuthTokenResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.security.CredentialReferenceWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder;
import org.wildfly.subsystem.service.ServiceDependency;

public class CipherAuthTokenResourceDefinition
extends AuthTokenResourceDefinition<CipherAuthToken> {
    static final PathElement PATH = CipherAuthTokenResourceDefinition.pathElement("cipher");

    CipherAuthTokenResourceDefinition() {
        super(PATH, new ResourceDescriptorTransformer());
    }

    public Map.Entry<Function<String, CipherAuthToken>, Consumer<RequirementServiceBuilder<?>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        String keyStoreName = Attribute.KEY_STORE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final String keyAlias = Attribute.KEY_ALIAS.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final String transformation = Attribute.ALGORITHM.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final ServiceDependency keyStore = ServiceDependency.on((UnaryServiceDescriptor)CommonServiceDescriptor.KEY_STORE, (String)keyStoreName);
        final ServiceDependency keyCredentialSource = ServiceDependency.from((org.wildfly.service.ServiceDependency)CredentialReference.getCredentialSourceDependency((OperationContext)context, (AttributeDefinition)Attribute.KEY_CREDENTIAL.getDefinition(), (ModelNode)model));
        return Map.entry(new Function<String, CipherAuthToken>(){

            @Override
            public CipherAuthToken apply(String authValue) {
                KeyStore store = (KeyStore)keyStore.get();
                try {
                    if (!store.containsAlias(keyAlias)) {
                        throw JGroupsLogger.ROOT_LOGGER.keyEntryNotFound(keyAlias);
                    }
                    if (!store.entryInstanceOf(keyAlias, KeyStore.PrivateKeyEntry.class)) {
                        throw JGroupsLogger.ROOT_LOGGER.unexpectedKeyStoreEntryType(keyAlias, KeyStore.PrivateKeyEntry.class.getSimpleName());
                    }
                    PasswordCredential credential = (PasswordCredential)((CredentialSource)keyCredentialSource.get()).getCredential(PasswordCredential.class);
                    if (credential == null) {
                        throw JGroupsLogger.ROOT_LOGGER.unexpectedCredentialSource();
                    }
                    ClearPassword password = (ClearPassword)credential.getPassword(ClearPassword.class);
                    if (password == null) {
                        throw JGroupsLogger.ROOT_LOGGER.unexpectedCredentialSource();
                    }
                    KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)store.getEntry(keyAlias, new KeyStore.PasswordProtection(password.getPassword()));
                    KeyPair pair = new KeyPair(entry.getCertificate().getPublicKey(), entry.getPrivateKey());
                    Cipher cipher = Cipher.getInstance(transformation);
                    return new CipherAuthToken(cipher, pair, authValue.getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }, keyStore.andThen((Consumer)keyCredentialSource));
    }

    static class ResourceDescriptorTransformer
    implements UnaryOperator<ResourceDescriptor> {
        ResourceDescriptorTransformer() {
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return descriptor.addAttributes(EnumSet.complementOf(EnumSet.of(Attribute.KEY_CREDENTIAL))).addAttribute((org.jboss.as.clustering.controller.Attribute)Attribute.KEY_CREDENTIAL, (OperationStepHandler)new CredentialReferenceWriteAttributeHandler(Attribute.KEY_CREDENTIAL.getDefinition()));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        KEY_CREDENTIAL((AttributeDefinition)CredentialReference.getAttributeBuilder((String)"key-credential-reference", null, (boolean)false, (org.jboss.as.controller.CapabilityReferenceRecorder)CapabilityReferenceRecorder.builder(AuthTokenResourceDefinition.CAPABILITY, (UnaryServiceDescriptor)CommonServiceDescriptor.CREDENTIAL_STORE).build()).build()),
        KEY_ALIAS("key-alias", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setAllowExpression(true);
            }
        }
        ,
        KEY_STORE("key-store", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setCapabilityReference((org.jboss.as.controller.CapabilityReferenceRecorder)CapabilityReferenceRecorder.builder(AuthTokenResourceDefinition.CAPABILITY, (UnaryServiceDescriptor)CommonServiceDescriptor.KEY_STORE).build());
            }
        }
        ,
        ALGORITHM("algorithm", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(true)).setRequired(false)).setDefaultValue(new ModelNode("RSA"));
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        private Attribute(AttributeDefinition definition) {
            this.definition = definition;
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }
}

