/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsat.client;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices11.ServiceRegistry;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.util.PrivilegedMapBuilderFactory;
import com.arjuna.webservices11.util.PrivilegedServiceRegistryFactory;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsaddr.EndpointHelper;
import com.arjuna.webservices11.wsaddr.NativeEndpointReference;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsat.client.WSATClient;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import java.io.IOException;
import org.jboss.ws.api.addressing.MAP;
import org.jboss.ws.api.addressing.MAPBuilder;
import org.jboss.ws.api.addressing.MAPEndpoint;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CoordinatorPortType;
import org.oasis_open.docs.ws_tx.wsat._2006._06.Notification;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class CoordinatorClient {
    private static final CoordinatorClient CLIENT = new CoordinatorClient();
    private String preparedAction = null;
    private String abortedAction = null;
    private String readOnlyAction = null;
    private String committedAction = null;
    private String faultAction = null;
    private MAPEndpoint participant;
    private MAPEndpoint secureParticipant;

    private CoordinatorClient() {
        MAPBuilder builder = PrivilegedMapBuilderFactory.getInstance().getBuilderInstance();
        this.preparedAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Prepared";
        this.abortedAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Aborted";
        this.readOnlyAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/ReadOnly";
        this.committedAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Committed";
        this.faultAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/fault";
        ServiceRegistry serviceRegistry = PrivilegedServiceRegistryFactory.getInstance().getServiceRegistry();
        String participantURIString = serviceRegistry.getServiceURI("ParticipantService", false);
        String secureParticipantURIString = serviceRegistry.getServiceURI("ParticipantService", true);
        this.participant = builder.newEndpoint(participantURIString);
        this.secureParticipant = builder.newEndpoint(secureParticipantURIString);
    }

    public void sendPrepared(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint participant = this.getParticipant(endpoint, map);
        AddressingHelper.installFromFaultTo(map, participant, identifier);
        CoordinatorPortType port = this.getPort(endpoint, map, this.preparedAction);
        Notification prepared = new Notification();
        port.preparedOperation(prepared);
    }

    public void sendAborted(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint participant = this.getParticipant(endpoint, map);
        AddressingHelper.installFaultTo(map, participant, identifier);
        CoordinatorPortType port = this.getPort(endpoint, map, this.abortedAction);
        Notification aborted = new Notification();
        port.abortedOperation(aborted);
    }

    public void sendReadOnly(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint participant = this.getParticipant(endpoint, map);
        AddressingHelper.installFaultTo(map, participant, identifier);
        CoordinatorPortType port = this.getPort(endpoint, map, this.readOnlyAction);
        Notification readOnly = new Notification();
        port.readOnlyOperation(readOnly);
    }

    public void sendCommitted(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint participant = this.getParticipant(endpoint, map);
        AddressingHelper.installFaultTo(map, participant, identifier);
        CoordinatorPortType port = this.getPort(endpoint, map, this.committedAction);
        Notification committed = new Notification();
        port.committedOperation(committed);
    }

    public void sendSoapFault(W3CEndpointReference endpoint, MAP map, SoapFault soapFault, InstanceIdentifier identifier) throws SoapFault, IOException {
        CoordinatorPortType port = this.getPort(endpoint, map, this.faultAction);
        soapFault.setAction(this.faultAction);
        Fault fault = ((SoapFault11)soapFault).toFault();
        port.soapFault(fault);
    }

    MAPEndpoint getParticipant(W3CEndpointReference endpoint, MAP map) {
        String address;
        if (endpoint != null) {
            NativeEndpointReference nativeRef = EndpointHelper.transform(NativeEndpointReference.class, (EndpointReference)endpoint);
            address = nativeRef.getAddress();
        } else {
            address = map.getTo();
        }
        if (address.startsWith("https")) {
            return this.secureParticipant;
        }
        return this.participant;
    }

    public static CoordinatorClient getClient() {
        return CLIENT;
    }

    private CoordinatorPortType getPort(W3CEndpointReference endpoint, MAP map, String action) {
        AddressingHelper.installNoneReplyTo(map);
        if (endpoint != null) {
            return WSATClient.getCoordinatorPort(endpoint, action, map);
        }
        return WSATClient.getCoordinatorPort(action, map);
    }
}

