/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpAnonymousRelayTest
extends AmqpClientTestSupport {
    private static final String AUTO_CREATION_QUEUE_PREFIX = "AmqpAnonymousRelayTest-AutoCreateQueues.";
    private static final String AUTO_CREATION_TOPIC_PREFIX = "AmqpAnonymousRelayTest-AutoCreateTopics.";

    @Override
    protected boolean isAutoCreateQueues() {
        return false;
    }

    @Override
    protected boolean isAutoCreateAddresses() {
        return false;
    }

    @Override
    protected void configureAddressPolicy(ActiveMQServer server) {
        super.configureAddressPolicy(server);
        AddressSettings autoCreateQueueAddressSettings = new AddressSettings();
        autoCreateQueueAddressSettings.setAutoCreateQueues(Boolean.valueOf(true));
        autoCreateQueueAddressSettings.setAutoCreateAddresses(Boolean.valueOf(true));
        autoCreateQueueAddressSettings.setDefaultAddressRoutingType(RoutingType.ANYCAST);
        autoCreateQueueAddressSettings.setDefaultQueueRoutingType(RoutingType.ANYCAST);
        server.getConfiguration().getAddressSettings().put("AmqpAnonymousRelayTest-AutoCreateQueues.#", autoCreateQueueAddressSettings);
        AddressSettings autoCreateTopicAddressSettings = new AddressSettings();
        autoCreateTopicAddressSettings.setAutoCreateQueues(Boolean.valueOf(true));
        autoCreateTopicAddressSettings.setAutoCreateAddresses(Boolean.valueOf(true));
        autoCreateTopicAddressSettings.setDefaultAddressRoutingType(RoutingType.MULTICAST);
        autoCreateTopicAddressSettings.setDefaultQueueRoutingType(RoutingType.MULTICAST);
        server.getConfiguration().getAddressSettings().put("AmqpAnonymousRelayTest-AutoCreateTopics.#", autoCreateTopicAddressSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSendMessageOnAnonymousProducerCausesQueueAutoCreation() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        String queueName = AUTO_CREATION_QUEUE_PREFIX + this.getQueueName();
        try {
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createAnonymousSender();
            AmqpMessage message = new AmqpMessage();
            message.setAddress(queueName);
            message.setText(this.getTestName());
            AddressQueryResult addressQueryResult = this.server.addressQuery(SimpleString.of((String)queueName));
            Assertions.assertFalse((boolean)addressQueryResult.isExists());
            sender.send(message);
            sender.close();
            addressQueryResult = this.server.addressQuery(SimpleString.of((String)queueName));
            Assertions.assertTrue((boolean)addressQueryResult.isExists());
            Assertions.assertTrue((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.ANYCAST));
            Assertions.assertTrue((boolean)addressQueryResult.isAutoCreated());
            AmqpReceiver receiver = session.createReceiver(queueName);
            receiver.flow(1);
            AmqpMessage received = receiver.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received, (String)"Should have read message");
            Assertions.assertEquals((Object)this.getTestName(), (Object)received.getText());
            received.accept();
            receiver.close();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSendMessageOnAnonymousProducerCausesTopicAutoCreation() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        String topicName = AUTO_CREATION_TOPIC_PREFIX + this.getTopicName();
        try {
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createAnonymousSender();
            AmqpMessage message = new AmqpMessage();
            message.setAddress(topicName);
            message.setText("creating-topic-address");
            AddressQueryResult addressQueryResult = this.server.addressQuery(SimpleString.of((String)topicName));
            Assertions.assertFalse((boolean)addressQueryResult.isExists());
            sender.send(message);
            addressQueryResult = this.server.addressQuery(SimpleString.of((String)topicName));
            Assertions.assertTrue((boolean)addressQueryResult.isExists());
            Assertions.assertTrue((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.MULTICAST));
            Assertions.assertTrue((boolean)addressQueryResult.isAutoCreated());
            AmqpReceiver receiver1 = session.createReceiver(topicName);
            AmqpReceiver receiver2 = session.createReceiver(topicName);
            receiver1.flow(1);
            receiver2.flow(1);
            AmqpMessage message2 = new AmqpMessage();
            message2.setAddress(topicName);
            message2.setText(this.getTestName());
            sender.send(message2);
            AmqpMessage received1 = receiver1.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received1, (String)"Should have read message");
            Assertions.assertEquals((Object)this.getTestName(), (Object)received1.getText());
            received1.accept();
            AmqpMessage received2 = receiver2.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received2, (String)"Should have read message");
            Assertions.assertEquals((Object)this.getTestName(), (Object)received2.getText());
            received1.accept();
            receiver1.close();
            receiver2.close();
            sender.close();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSendMessageOnAnonymousProducerWithDestinationTypeAnnotationCausesQueueAutoCreation() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createAnonymousSender();
            AmqpMessage message = new AmqpMessage();
            message.setMessageAnnotation(AMQPMessageSupport.JMS_DEST_TYPE_MSG_ANNOTATION.toString(), (byte)0);
            String queueName = AUTO_CREATION_TOPIC_PREFIX + this.getQueueName();
            message.setAddress(queueName);
            message.setText(this.getTestName());
            AddressQueryResult addressQueryResult = this.server.addressQuery(SimpleString.of((String)queueName));
            Assertions.assertFalse((boolean)addressQueryResult.isExists());
            sender.send(message);
            sender.close();
            addressQueryResult = this.server.addressQuery(SimpleString.of((String)queueName));
            Assertions.assertTrue((boolean)addressQueryResult.isExists());
            Assertions.assertTrue((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.ANYCAST));
            Assertions.assertTrue((boolean)addressQueryResult.isAutoCreated());
            AmqpReceiver receiver = session.createReceiver(queueName);
            receiver.flow(1);
            AmqpMessage received = receiver.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received, (String)"Should have read message");
            Assertions.assertEquals((Object)this.getTestName(), (Object)received.getText());
            received.accept();
            receiver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSendMessageOnAnonymousProducerWithDestinationTypeAnnotationCausesTopicAutoCreation() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createAnonymousSender();
            AmqpMessage message = new AmqpMessage();
            message.setMessageAnnotation(AMQPMessageSupport.JMS_DEST_TYPE_MSG_ANNOTATION.toString(), (byte)1);
            String topicName = AUTO_CREATION_QUEUE_PREFIX + this.getTopicName();
            message.setAddress(topicName);
            message.setText("creating-topic-address");
            AddressQueryResult addressQueryResult = this.server.addressQuery(SimpleString.of((String)topicName));
            Assertions.assertFalse((boolean)addressQueryResult.isExists());
            sender.send(message);
            addressQueryResult = this.server.addressQuery(SimpleString.of((String)topicName));
            Assertions.assertTrue((boolean)addressQueryResult.isExists());
            Assertions.assertTrue((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.MULTICAST));
            Assertions.assertTrue((boolean)addressQueryResult.isAutoCreated());
            AmqpReceiver receiver1 = session.createReceiver(topicName);
            AmqpReceiver receiver2 = session.createReceiver(topicName);
            receiver1.flow(1);
            receiver2.flow(1);
            AmqpMessage message2 = new AmqpMessage();
            message2.setMessageAnnotation(AMQPMessageSupport.JMS_DEST_TYPE_MSG_ANNOTATION.toString(), (byte)1);
            message2.setAddress(topicName);
            message2.setText(this.getTestName());
            sender.send(message2);
            AmqpMessage received1 = receiver1.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received1, (String)"Should have read message");
            Assertions.assertEquals((Object)this.getTestName(), (Object)received1.getText());
            received1.accept();
            AmqpMessage received2 = receiver2.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received2, (String)"Should have read message");
            Assertions.assertEquals((Object)this.getTestName(), (Object)received2.getText());
            received1.accept();
            receiver1.close();
            receiver2.close();
            sender.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSendMessageOnAnonymousRelayLinkUsingMessageTo() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createAnonymousSender();
            AmqpMessage message = new AmqpMessage();
            message.setAddress(this.getQueueName());
            message.setMessageId("msg1");
            message.setText("Test-Message");
            sender.send(message);
            sender.close();
            AmqpReceiver receiver = session.createReceiver(this.getQueueName());
            receiver.flow(1);
            AmqpMessage received = receiver.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received, (String)"Should have read message");
            Assertions.assertEquals((Object)"msg1", (Object)received.getMessageId());
            received.accept();
            receiver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSendMessageFailsOnAnonymousRelayLinkWhenNoToValueSet() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createAnonymousSender();
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("msg1");
            message.setText("Test-Message");
            try {
                sender.send(message);
                Assertions.fail((String)"Should not be able to send, message should be rejected");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                sender.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSendMessageFailsOnAnonymousRelayWhenToFieldHasNonExistingAddress() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createAnonymousSender();
            AmqpMessage message = new AmqpMessage();
            message.setAddress("exampleQueu-not-in-service");
            message.setMessageId("msg1");
            message.setText("Test-Message");
            try {
                sender.send(message);
                Assertions.fail((String)"Should not be able to send, message should be rejected");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                sender.close();
            }
        }
    }
}

