/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQRemoteDisconnectException;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.protocol.amqp.client.AMQPClientConnectionFactory;
import org.apache.activemq.artemis.protocol.amqp.client.ProtonClientConnectionManager;
import org.apache.activemq.artemis.protocol.amqp.client.ProtonClientProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.EventHandler;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASLFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.engine.Connection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpOutboundConnectionTest
extends AmqpClientTestSupport {
    private boolean securityEnabled;

    @Test
    @Timeout(value=60L)
    public void testOutboundConnection() throws Throwable {
        this.runOutboundConnectionTest(false, true);
    }

    @Test
    @Timeout(value=60L)
    public void testOutboundConnectionServerClose() throws Throwable {
        this.runOutboundConnectionTest(false, false);
    }

    @Test
    @Timeout(value=60L)
    public void testOutboundConnectionWithSecurity() throws Throwable {
        this.runOutboundConnectionTest(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOutboundConnectionTest(boolean withSecurity, boolean closeFromClient) throws Exception {
        ActiveMQServer remote;
        try {
            this.securityEnabled = withSecurity;
            remote = this.createServer(5673);
        }
        finally {
            this.securityEnabled = false;
        }
        Wait.assertTrue(() -> ((ActiveMQServer)remote).isActive());
        LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
        config.put("host", "localhost");
        config.put("port", String.valueOf(5673));
        ClientSASLFactory clientSASLFactory = withSecurity ? availableMechanims -> {
            if (availableMechanims != null && Arrays.asList(availableMechanims).contains("PLAIN")) {
                return new PlainSASLMechanism(this.fullUser, this.fullPass);
            }
            return null;
        } : null;
        final AtomicBoolean connectionOpened = new AtomicBoolean();
        EventHandler eventHandler = new EventHandler(){

            public void onRemoteOpen(Connection connection) throws Exception {
                connectionOpened.set(true);
            }
        };
        ProtonClientConnectionManager lifeCycleListener = new ProtonClientConnectionManager(new AMQPClientConnectionFactory(this.server, "myid", Collections.singletonMap(Symbol.getSymbol((String)"myprop"), "propvalue"), 5000), Optional.of(eventHandler), clientSASLFactory);
        ProtonClientProtocolManager protocolManager = new ProtonClientProtocolManager(new ProtonProtocolManagerFactory(), this.server);
        NettyConnector connector = new NettyConnector(config, (BufferHandler)lifeCycleListener, (BaseConnectionLifeCycleListener)lifeCycleListener, (Executor)this.server.getExecutorFactory().getExecutor(), (Executor)this.server.getExecutorFactory().getExecutor(), this.server.getScheduledPool(), (ClientProtocolManager)protocolManager);
        connector.start();
        Object connectionId = connector.createConnection().getID();
        Assertions.assertNotNull((Object)connectionId);
        RemotingConnection remotingConnection = lifeCycleListener.getConnection(connectionId);
        final AtomicReference ex = new AtomicReference();
        AtomicBoolean closed = new AtomicBoolean(false);
        remotingConnection.addCloseListener(() -> closed.set(true));
        remotingConnection.addFailureListener(new FailureListener(){

            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
                ex.set(exception);
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
                ex.set(exception);
            }
        });
        try {
            Wait.assertEquals((int)1, () -> ((ActiveMQServer)remote).getConnectionCount());
            Wait.assertTrue(connectionOpened::get);
            if (closeFromClient) {
                lifeCycleListener.stop();
            } else {
                remote.stop();
            }
            Wait.assertEquals((int)0, () -> ((ActiveMQServer)remote).getConnectionCount());
            Assertions.assertTrue((boolean)remotingConnection.isDestroyed());
            if (!closeFromClient) {
                Assertions.assertTrue((boolean)(ex.get() instanceof ActiveMQRemoteDisconnectException));
            } else {
                Assertions.assertNull(ex.get());
            }
        }
        finally {
            if (closeFromClient) {
                remote.stop();
            } else {
                lifeCycleListener.stop();
            }
        }
    }

    @Override
    protected boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    private static class PlainSASLMechanism
    implements ClientSASL {
        private final byte[] initialResponse;

        PlainSASLMechanism(String username, String password) {
            byte[] usernameBytes = username.getBytes(StandardCharsets.UTF_8);
            byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
            byte[] encoded = new byte[usernameBytes.length + passwordBytes.length + 2];
            System.arraycopy(usernameBytes, 0, encoded, 1, usernameBytes.length);
            System.arraycopy(passwordBytes, 0, encoded, usernameBytes.length + 2, passwordBytes.length);
            this.initialResponse = encoded;
        }

        public String getName() {
            return "PLAIN";
        }

        public byte[] getInitialResponse() {
            return this.initialResponse;
        }

        public byte[] getResponse(byte[] challenge) {
            return new byte[0];
        }
    }
}

