/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.largemessages;

import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpTestSupport;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.ReplicatedBackupUtils;
import org.junit.jupiter.api.BeforeEach;

public abstract class AmqpReplicatedTestSupport
extends AmqpTestSupport {
    protected TestableServer primaryServer;
    protected TestableServer backupServer;
    protected Configuration backupConfig;
    protected Configuration primaryConfig;
    protected NodeManager nodeManager;

    protected abstract TransportConfiguration getAcceptorTransportConfiguration(boolean var1);

    protected abstract TransportConfiguration getConnectorTransportConfiguration(boolean var1);

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.createReplicatedConfigs();
    }

    protected void createReplicatedConfigs() throws Exception {
        TransportConfiguration primaryConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        TransportConfiguration backupAcceptor = this.getAcceptorTransportConfiguration(false);
        this.backupConfig = this.createDefaultInVMConfig();
        this.primaryConfig = this.createDefaultInVMConfig();
        ReplicatedBackupUtils.configureReplicationPair(this.backupConfig, backupConnector, backupAcceptor, this.primaryConfig, primaryConnector, null);
        this.backupConfig.setBindingsDirectory(this.getBindingsDir(0, true)).setJournalDirectory(this.getJournalDir(0, true)).setPagingDirectory(this.getPageDir(0, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(0, true)).setSecurityEnabled(false);
        this.setupHAPolicyConfiguration();
        this.nodeManager = this.createReplicatedBackupNodeManager(this.backupConfig);
        this.backupServer = this.createTestableServer(this.backupConfig);
        this.primaryConfig.clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true));
        this.primaryServer = this.createTestableServer(this.primaryConfig);
    }

    protected NodeManager createReplicatedBackupNodeManager(Configuration backupConfig) {
        return new InVMNodeManager(true, backupConfig.getJournalLocation());
    }

    protected void setupHAPolicyConfiguration() {
        ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(-1).setAllowFailBack(true);
        ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setRestartBackup(false);
    }

    protected TestableServer createTestableServer(Configuration config) throws Exception {
        return this.createTestableServer(config, this.nodeManager);
    }

    protected TestableServer createTestableServer(Configuration config, NodeManager nodeManager) throws Exception {
        boolean isBackup = config.getHAPolicyConfiguration() instanceof ReplicaPolicyConfiguration || config.getHAPolicyConfiguration() instanceof SharedStoreBackupPolicyConfiguration;
        return new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config, nodeManager, isBackup ? 2 : 1));
    }
}

