/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientMessageImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MessageBufferTest
extends ActiveMQTestBase {
    protected ActiveMQServer server;
    protected ClientSession session;
    protected ClientSessionFactory sf;
    protected ServerLocator locator;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultInVMConfig());
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.addClientSession(this.sf.createSession(false, true, true));
    }

    @Test
    public void simpleTest() throws Exception {
        String data = "Simple Text " + UUID.randomUUID().toString();
        String queueName = "simpleQueue";
        String addressName = "simpleAddress";
        this.session.createQueue(QueueConfiguration.of((String)"simpleQueue").setAddress("simpleAddress").setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = this.session.createProducer("simpleAddress");
        ClientMessageImpl message = (ClientMessageImpl)this.session.createMessage(true);
        message.getBodyBuffer().writeString(data);
        for (int i = 0; i < 100; ++i) {
            message.putStringProperty("key", "int" + i);
            message.getBodyBuffer().resetReaderIndex();
            producer.send((Message)message);
            this.session.commit();
            Assertions.assertTrue((message.getBodySize() < 1000 ? 1 : 0) != 0, (String)"Message body growing indefinitely and unexpectedly");
        }
        producer.send((Message)message);
        producer.close();
        ClientConsumer consumer = this.session.createConsumer("simpleQueue");
        this.session.start();
        Assertions.assertNotNull((Object)message);
        message.acknowledge();
        Assertions.assertEquals((Object)data, (Object)message.getBodyBuffer().readString());
    }

    @Test
    public void simpleTestBytes() throws Exception {
        ByteBuf buf = UnpooledByteBufAllocator.DEFAULT.buffer(1500);
        for (int i = 0; i < 1024; ++i) {
            buf.writeByte((int)MessageBufferTest.getSamplebyte(i));
        }
        String queueName = "simpleQueue";
        String addressName = "simpleAddress";
        this.session.createQueue(QueueConfiguration.of((String)"simpleQueue").setAddress("simpleAddress").setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = this.session.createProducer("simpleAddress");
        ClientMessageImpl message = (ClientMessageImpl)this.session.createMessage(true);
        Assertions.assertEquals((int)1024, (int)buf.readableBytes());
        message.getBodyBuffer().writeBytes(buf, 0, buf.readableBytes());
        producer.send((Message)message);
        this.session.commit();
        producer.close();
        ClientConsumer consumer = this.session.createConsumer("simpleQueue");
        this.session.start();
        ClientMessage message2 = consumer.receive(5000L);
        Assertions.assertNotNull((Object)message2);
        Assertions.assertEquals((int)1024, (int)message2.getBodySize());
        ActiveMQBuffer buffer = message2.getDataBuffer();
        Assertions.assertEquals((int)1024, (int)message2.getBodySize());
        ActiveMQBuffer bodyBuffer = message2.getBodyBuffer();
        Assertions.assertEquals((int)1024, (int)message2.getBodySize());
        ActiveMQBuffer result = ActiveMQBuffers.fixedBuffer((int)message2.getBodyBufferSize());
        buffer.readBytes(result);
        Assertions.assertEquals((int)1024, (int)result.readableBytes());
        for (int i = 0; i < 1024; ++i) {
            Assertions.assertEquals((byte)MessageBufferTest.getSamplebyte(i), (byte)result.readByte());
        }
        Assertions.assertNotNull((Object)message2);
        message2.acknowledge();
    }
}

