/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClusterWithBackupTest
extends ClusterTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setupServers();
    }

    protected boolean isNetty() {
        return false;
    }

    @Test
    public void testBasicRoundRobin() throws Throwable {
        this.setupCluster();
        this.startServers(0, 1, 2, 3, 4, 5);
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.setupSessionFactory(5, this.isNetty());
        this.createQueue(3, "queues.testaddress", "queue0", null, false);
        this.createQueue(4, "queues.testaddress", "queue0", null, false);
        this.createQueue(5, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 3, "queue0", null);
        this.addConsumer(1, 4, "queue0", null);
        this.addConsumer(2, 5, "queue0", null);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        this.waitForBindings(4, "queues.testaddress", 1, 1, true);
        this.waitForBindings(5, "queues.testaddress", 1, 1, true);
        this.waitForBindings(3, "queues.testaddress", 2, 2, false);
        this.waitForBindings(4, "queues.testaddress", 2, 2, false);
        this.waitForBindings(5, "queues.testaddress", 2, 2, false);
        this.send(3, "queues.testaddress", 100, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(100, 0, 1, 2);
        this.verifyNotReceive(0, 0, 1, 2);
    }

    protected void setupCluster() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnection("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 3, 4, 5);
        this.setupClusterConnection("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 4, 3, 5);
        this.setupClusterConnection("cluster2", "queues", messageLoadBalancingType, 1, this.isNetty(), 5, 3, 4);
        this.setupClusterConnection("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 0, 4, 5);
        this.setupClusterConnection("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 1, 3, 5);
        this.setupClusterConnection("cluster2", "queues", messageLoadBalancingType, 1, this.isNetty(), 2, 3, 4);
    }

    protected void setupServers() throws Exception {
        this.setupBackupServer(0, 3, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupBackupServer(1, 4, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupBackupServer(2, 5, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupPrimaryServer(3, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupPrimaryServer(4, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupPrimaryServer(5, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
    }
}

