/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.reattach;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQObjectClosedException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionProducerCreditsMessage;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnector;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReattachTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final SimpleString ADDRESS = SimpleString.of((String)"FailoverTestAddress");
    private ActiveMQServer server;
    private ServerLocator locator;

    @Test
    public void testImmediateReattach() throws Exception {
        long retryInterval = 50L;
        double retryMultiplier = 1.0;
        int reconnectAttempts = 10;
        this.locator.setRetryInterval(50L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(10).setConfirmationWindowSize(0x100000);
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS).setDurable(Boolean.valueOf(false)));
        int numIterations = 10;
        for (int j = 0; j < 10; ++j) {
            ClientProducer producer = session.createProducer(ADDRESS);
            int numMessages = 100;
            for (int i = 0; i < 100; ++i) {
                ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
                message.putIntProperty(SimpleString.of((String)"count"), i);
                message.getBodyBuffer().writeString("aardvarks");
                producer.send((Message)message);
            }
            ClientConsumer consumer = session.createConsumer(ADDRESS);
            RemotingConnection conn = ((ClientSessionInternal)session).getConnection();
            conn.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
            session.start();
            for (int i = 0; i < 100; ++i) {
                ClientMessage message = consumer.receive(500L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)"aardvarks", (Object)message.getBodyBuffer().readString());
                Assertions.assertEquals((Object)i, (Object)message.getObjectProperty(SimpleString.of((String)"count")));
                message.acknowledge();
            }
            ClientMessage message = consumer.receiveImmediate();
            Assertions.assertNull((Object)message);
            producer.close();
            consumer.close();
        }
        session.close();
        sf.close();
    }

    @Test
    public void testReattachTransferConnectionOnSession() throws Exception {
        long retryInterval = 50L;
        double retryMultiplier = 1.0;
        int reconnectAttempts = 10;
        this.locator.setRetryInterval(50L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(10).setConfirmationWindowSize(0x100000);
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        Object originalConnectionID = ((ServerSession)this.server.getSessions().toArray()[0]).getConnectionID();
        ((ClientSessionInternal)session).getConnection().fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        session.start();
        Assertions.assertFalse((boolean)Objects.equals(((ServerSession)this.server.getSessions().toArray()[0]).getConnectionID(), originalConnectionID));
        session.close();
        sf.close();
    }

    @Test
    public void testReattachTransferConnectionOnSession2() throws Exception {
        long retryInterval = 50L;
        double retryMultiplier = 1.0;
        int reconnectAttempts = 10;
        this.locator.setRetryInterval(50L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(10).setConfirmationWindowSize(0x100000);
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        ClientSession secondSession = sf.createSession(false, true, true);
        Object originalConnectionID = ((ServerSession)this.server.getSessions().toArray()[0]).getConnectionID();
        RemotingConnection oldConnection = ((ServerSession)this.server.getSessions().toArray()[0]).getRemotingConnection();
        Set originalServerSessions = this.server.getSessions();
        Assertions.assertTrue((boolean)oldConnection.getFailureListeners().containsAll(originalServerSessions));
        ((ClientSessionInternal)session).getConnection().fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        session.start();
        secondSession.start();
        Assertions.assertFalse((boolean)Objects.equals(((ServerSession)this.server.getSessions().toArray()[0]).getConnectionID(), originalConnectionID));
        Assertions.assertTrue((boolean)originalServerSessions.stream().noneMatch(oldConnection.getFailureListeners()::contains));
        RemotingConnection newConnection = ((ServerSession)this.server.getSessions().toArray()[0]).getRemotingConnection();
        Assertions.assertTrue((boolean)newConnection.getFailureListeners().containsAll(originalServerSessions));
        session.close();
        secondSession.close();
        sf.close();
    }

    @Test
    public void testOverflowCredits() throws Exception {
        long retryInterval = 500L;
        double retryMultiplier = 1.0;
        boolean reconnectAttempts = true;
        this.locator.setRetryInterval(500L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(1).setConfirmationWindowSize(0x100000).setProducerWindowSize(1000);
        AtomicInteger count = new AtomicInteger(0);
        Interceptor intercept = (packet, connection) -> {
            if (packet instanceof SessionProducerCreditsMessage) {
                SessionProducerCreditsMessage credit = (SessionProducerCreditsMessage)packet;
                if (count.incrementAndGet() == 2) {
                    connection.fail(new ActiveMQException(ActiveMQExceptionType.UNSUPPORTED_PACKET, "bye"));
                    return false;
                }
            }
            return true;
        };
        this.locator.addIncomingInterceptor(intercept);
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 10;
        for (int i = 0; i < 10; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(SimpleString.of((String)"count"), i);
            message.getBodyBuffer().writeBytes(new byte[5000]);
            producer.send((Message)message);
        }
        session.close();
        sf.close();
    }

    @Test
    public void testDelayedReattach() throws Exception {
        long retryInterval = 50L;
        double retryMultiplier = 1.0;
        int reconnectAttempts = 60;
        this.locator.setRetryInterval(50L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(60).setConfirmationWindowSize(0x100000);
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 1000;
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(SimpleString.of((String)"count"), i);
            message.getBodyBuffer().writeString("aardvarks");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        InVMConnector.failOnCreateConnection = true;
        RemotingConnection conn = ((ClientSessionInternal)session).getConnection();
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            InVMConnector.failOnCreateConnection = false;
        });
        t.start();
        conn.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        session.start();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = consumer.receive(500L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)"aardvarks", (Object)message.getBodyBuffer().readString());
            Assertions.assertEquals((int)i, (int)message.getIntProperty("count"));
            message.acknowledge();
        }
        ClientMessage message = consumer.receiveImmediate();
        Assertions.assertNull((Object)message);
        session.close();
        sf.close();
        t.join();
    }

    @Test
    public void testAsyncFailureWhileReattaching() throws Exception {
        long retryInterval = 50L;
        double retryMultiplier = 1.0;
        int reconnectAttempts = 60;
        long asyncFailDelay = 200L;
        this.locator.setRetryInterval(50L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(60).setConfirmationWindowSize(0x100000);
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        ClientSession session2 = sf.createSession(false, true, true);
        class MyFailureListener
        implements SessionFailureListener {
            volatile boolean failed;

            MyFailureListener() {
            }

            public void connectionFailed(ActiveMQException me, boolean failedOver) {
                this.failed = true;
            }

            public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
                this.connectionFailed(me, failedOver);
            }

            public void beforeReconnect(ActiveMQException exception) {
            }
        }
        MyFailureListener listener = new MyFailureListener();
        session2.addFailureListener((SessionFailureListener)listener);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 1000;
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(SimpleString.of((String)"count"), i);
            message.getBodyBuffer().writeString("aardvarks");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        InVMConnector.numberOfFailures = 10;
        InVMConnector.failOnCreateConnection = true;
        RemotingConnection conn = ((ClientSessionInternal)session).getConnection();
        RemotingConnection conn2 = ((ClientSessionInternal)session2).getConnection();
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            conn2.fail((ActiveMQException)((Object)((Object)((Object)new ActiveMQNotConnectedException("Did not receive pong from server")))));
        });
        t.start();
        conn.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        Assertions.assertTrue((boolean)listener.failed);
        session.start();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = consumer.receive(500L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)"aardvarks", (Object)message.getBodyBuffer().readString());
            Assertions.assertEquals((int)i, (int)message.getIntProperty("count"));
            message.acknowledge();
        }
        ClientMessage message = consumer.receiveImmediate();
        Assertions.assertNull((Object)message);
        session.close();
        session2.close();
        sf.close();
        t.join();
    }

    @Test
    public void testReattachAttemptsFailsToReconnect() throws Exception {
        long retryInterval = 50L;
        double retryMultiplier = 1.0;
        int reconnectAttempts = 3;
        this.locator.setRetryInterval(50L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(3).setConfirmationWindowSize(0x100000);
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 1000;
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(SimpleString.of((String)"count"), i);
            message.getBodyBuffer().writeString("aardvarks");
            producer.send((Message)message);
        }
        session.createConsumer(ADDRESS);
        InVMConnector.failOnCreateConnection = true;
        RemotingConnection conn = ((ClientSessionInternal)session).getConnection();
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            InVMConnector.failOnCreateConnection = false;
        });
        t.start();
        conn.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        try {
            session.start();
            Assertions.fail((String)"Should throw exception");
        }
        catch (ActiveMQObjectClosedException activeMQObjectClosedException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session.close();
        sf.close();
        t.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSessionFailAfterSendSeveralThreads() throws Throwable {
        Timer timer = new Timer();
        ClientSession session = null;
        try {
            long retryInterval = 100L;
            double retryMultiplier = 1.0;
            int reconnectAttempts = 300;
            this.locator.setRetryInterval(100L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(300).setConfirmationWindowSize(0x100000);
            final ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
            session = sf.createSession();
            final RemotingConnection connFailure = ((ClientSessionInternal)session).getConnection();
            int numberOfThreads = 100;
            int numberOfSessionsToCreate = 10;
            final CountDownLatch alignLatch = new CountDownLatch(numberOfThreads);
            final CountDownLatch startFlag = new CountDownLatch(1);
            class CreateSessionThread
            extends Thread {
                Throwable failure;

                CreateSessionThread() {
                }

                @Override
                public void run() {
                    try {
                        alignLatch.countDown();
                        startFlag.await();
                        for (int i = 0; i < 10; ++i) {
                            Thread.yield();
                            ClientSession session = sf.createSession(false, true, true);
                            session.close();
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        this.failure = e;
                    }
                }
            }
            CreateSessionThread[] threads = new CreateSessionThread[numberOfThreads];
            for (int i = 0; i < numberOfThreads; ++i) {
                threads[i] = new CreateSessionThread();
                threads[i].start();
            }
            ReattachTest.waitForLatch(alignLatch);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        connFailure.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
                    }
                    catch (Exception e) {
                        logger.warn("Error on the timer {}", (Throwable)e);
                    }
                }
            }, 10L, 10L);
            startFlag.countDown();
            Throwable failure = null;
            for (CreateSessionThread thread : threads) {
                thread.join();
                if (thread.failure == null) continue;
                System.out.println("Thread " + thread.getName() + " failed - " + thread.failure);
                failure = thread.failure;
            }
            if (failure != null) {
                throw failure;
            }
            sf.close();
        }
        finally {
            timer.cancel();
            if (session != null) {
                session.close();
            }
        }
    }

    @Test
    public void testCreateSessionFailBeforeSendSeveralThreads() throws Throwable {
        long retryInterval = 50L;
        double retryMultiplier = 1.0;
        int reconnectAttempts = 60;
        this.locator.setRetryInterval(50L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(60).setConfirmationWindowSize(0x100000);
        final ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        InVMConnector.failOnCreateConnection = true;
        int numberOfThreads = 100;
        final CountDownLatch alignLatch = new CountDownLatch(numberOfThreads);
        final CountDownLatch startFlag = new CountDownLatch(1);
        class CreateSessionThread
        extends Thread {
            Throwable failure;

            CreateSessionThread() {
            }

            @Override
            public void run() {
                try {
                    alignLatch.countDown();
                    startFlag.await();
                    ClientSession session = sf.createSession(false, true, true);
                    session.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.failure = e;
                }
            }
        }
        CreateSessionThread[] threads = new CreateSessionThread[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            threads[i] = new CreateSessionThread();
            threads[i].start();
        }
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            InVMConnector.failOnCreateConnection = false;
        });
        ReattachTest.waitForLatch(alignLatch);
        t.start();
        startFlag.countDown();
        Throwable failure = null;
        for (CreateSessionThread thread : threads) {
            thread.join();
            if (thread.failure == null) continue;
            System.out.println("Thread " + thread.getName() + " failed - " + thread.failure);
            failure = thread.failure;
        }
        if (failure != null) {
            throw failure;
        }
        sf.close();
        t.join();
    }

    @Test
    public void testCreateQueue() throws Exception {
        long retryInterval = 100L;
        double retryMultiplier = 1.0;
        int reconnectAttempts = 300;
        this.locator.setRetryInterval(100L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(300).setConfirmationWindowSize(0x100000);
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        RemotingConnection conn = ((ClientSessionInternal)session).getConnection();
        InVMConnector.failOnCreateConnection = false;
        conn.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            InVMConnector.failOnCreateConnection = false;
        });
        t.start();
        for (int i = 0; i < 10; ++i) {
            session.createQueue(QueueConfiguration.of((String)("queue" + i)).setAddress("address").setRoutingType(RoutingType.ANYCAST));
        }
        session.close();
        sf.close();
        t.join();
    }

    @Test
    public void testReattachAttemptsSucceedsInReconnecting() throws Exception {
        long retryInterval = 50L;
        double retryMultiplier = 1.0;
        int reconnectAttempts = 10;
        this.locator.setRetryInterval(50L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(10).setConfirmationWindowSize(0x100000);
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 1000;
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(SimpleString.of((String)"count"), i);
            message.getBodyBuffer().writeString("aardvarks");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        InVMConnector.failOnCreateConnection = true;
        InVMConnector.numberOfFailures = 9;
        RemotingConnection conn = ((ClientSessionInternal)session).getConnection();
        conn.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        session.start();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = consumer.receive(500L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)"aardvarks", (Object)message.getBodyBuffer().readString());
            Assertions.assertEquals((int)i, (int)message.getIntProperty("count"));
            message.acknowledge();
        }
        ClientMessage message = consumer.receiveImmediate();
        Assertions.assertNull((Object)message);
        session.close();
        sf.close();
    }

    @Test
    public void testRetryInterval() throws Exception {
        long retryInterval = 500L;
        double retryMultiplier = 1.0;
        int reconnectAttempts = 60;
        this.locator.setRetryInterval(500L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(60).setConfirmationWindowSize(0x100000);
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 1000;
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(SimpleString.of((String)"count"), i);
            message.getBodyBuffer().writeString("aardvarks");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        InVMConnector.failOnCreateConnection = true;
        RemotingConnection conn = ((ClientSessionInternal)session).getConnection();
        long start = System.currentTimeMillis();
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            InVMConnector.failOnCreateConnection = false;
        });
        t.start();
        conn.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        session.start();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = consumer.receive(500L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)"aardvarks", (Object)message.getBodyBuffer().readString());
            Assertions.assertEquals((int)i, (int)message.getIntProperty("count"));
            message.acknowledge();
        }
        ClientMessage message = consumer.receiveImmediate();
        Assertions.assertNull((Object)message);
        long end = System.currentTimeMillis();
        Assertions.assertTrue((end - start >= 500L ? 1 : 0) != 0);
        session.close();
        sf.close();
        t.join();
    }

    @Test
    public void testExponentialBackoff() throws Exception {
        long retryInterval = 50L;
        double retryMultiplier = 2.0;
        int reconnectAttempts = 60;
        this.locator.setRetryInterval(50L).setRetryIntervalMultiplier(2.0).setReconnectAttempts(60).setConfirmationWindowSize(0x100000);
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 1000;
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(SimpleString.of((String)"count"), i);
            message.getBodyBuffer().writeString("aardvarks");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        InVMConnector.failOnCreateConnection = true;
        InVMConnector.numberOfFailures = 3;
        RemotingConnection conn = ((ClientSessionInternal)session).getConnection();
        long start = System.currentTimeMillis();
        conn.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        session.start();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = consumer.receive(500L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)"aardvarks", (Object)message.getBodyBuffer().readString());
            Assertions.assertEquals((Object)i, (Object)message.getObjectProperty(SimpleString.of((String)"count")));
            message.acknowledge();
        }
        ClientMessage message = consumer.receiveImmediate();
        Assertions.assertNull((Object)message);
        long end = System.currentTimeMillis();
        double wait = 350.0;
        Assertions.assertTrue(((double)(end - start) >= wait ? 1 : 0) != 0);
        session.close();
        sf.close();
    }

    @Test
    public void testExponentialBackoffMaxRetryInterval() throws Exception {
        long retryInterval = 50L;
        double retryMultiplier = 2.0;
        int reconnectAttempts = 60;
        long maxRetryInterval = 100L;
        this.locator.setRetryInterval(50L).setRetryIntervalMultiplier(2.0).setReconnectAttempts(60).setMaxRetryInterval(100L).setConfirmationWindowSize(0x100000);
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 1000;
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(SimpleString.of((String)"count"), i);
            message.getBodyBuffer().writeString("aardvarks");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        InVMConnector.failOnCreateConnection = true;
        InVMConnector.numberOfFailures = 3;
        RemotingConnection conn = ((ClientSessionInternal)session).getConnection();
        long start = System.currentTimeMillis();
        conn.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        session.start();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = consumer.receive(500L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)"aardvarks", (Object)message.getBodyBuffer().readString());
            Assertions.assertEquals((int)i, (int)message.getIntProperty("count"));
            message.acknowledge();
        }
        ClientMessage message = consumer.receiveImmediate();
        Assertions.assertNull((Object)message);
        long end = System.currentTimeMillis();
        double wait = 252.0;
        Assertions.assertTrue(((double)(end - start) >= wait ? 1 : 0) != 0);
        Assertions.assertTrue(((double)(end - start) < wait + 500.0 ? 1 : 0) != 0);
        session.close();
        sf.close();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, false);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        InVMConnector.resetFailures();
        super.tearDown();
    }
}

