/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.federation;

import java.util.HashMap;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationUpstreamConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.federation.Federation;
import org.apache.activemq.artemis.core.server.federation.FederationUpstream;
import org.apache.activemq.artemis.tests.integration.federation.FederatedTestBase;
import org.apache.activemq.artemis.tests.integration.federation.FederatedTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FederatedServerLocatorConfigTest
extends FederatedTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected int numberOfServers() {
        return 2;
    }

    @Override
    protected Configuration createDefaultConfig(int serverID, boolean netty) throws Exception {
        ConfigurationImpl configuration = this.createBasicConfig(serverID).setJMXManagementEnabled(false).addAcceptorConfiguration(new TransportConfiguration(INVM_ACCEPTOR_FACTORY, this.generateInVMParams(serverID), "invm"));
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("port", 61616 + serverID);
        configuration.addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params, "netty", new HashMap()));
        return configuration;
    }

    @Test
    public void testFederatedAddressServerLocatorConfigFromUrl() throws Exception {
        String address = this.getName();
        String connectorName = "server1WithUrlParams";
        this.getServer(0).getConfiguration().addConnectorConfiguration(connectorName, "tcp://localhost:61617?ackBatchSize=100&consumerWindowSize=-1");
        FederationConfiguration federationConfiguration0 = FederatedTestUtil.createAddressUpstreamFederationConfiguration("server1WithUrlParams", address, 2);
        for (FederationUpstreamConfiguration upstreamConfiguration : federationConfiguration0.getUpstreamConfigurations()) {
            upstreamConfiguration.getConnectionConfiguration().setHA(false);
        }
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration0);
        this.getServer(0).getFederationManager().deploy();
        Federation fed = this.getServer(0).getFederationManager().get(federationConfiguration0.getName());
        Assertions.assertNotNull((Object)fed);
        FederationUpstream federationUpstream = fed.get(connectorName);
        Assertions.assertFalse((boolean)federationUpstream.getConnection().clientSessionFactory().getServerLocator().getUseTopologyForLoadBalancing());
        Assertions.assertEquals((int)100, (int)federationUpstream.getConnection().clientSessionFactory().getServerLocator().getAckBatchSize());
        Assertions.assertEquals((int)-1, (int)federationUpstream.getConnection().clientSessionFactory().getServerLocator().getConsumerWindowSize());
    }
}

