/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.File;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.JournalImplTestUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public class AIOJournalImplTest
extends JournalImplTestUnit {
    @BeforeAll
    public static void hasAIO() {
        Assumptions.assumeTrue((boolean)AIOSequentialFileFactory.isSupported(), (String)"Test case needs AIO to run");
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        if (!LibaioContext.isLoaded()) {
            Assertions.fail((String)String.format("libAIO is not loaded on %s %s %s", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version")));
        }
    }

    @Override
    protected SequentialFileFactory getFileFactory() throws Exception {
        File file = new File(this.getTestDir());
        AIOJournalImplTest.deleteDirectory(file);
        file.mkdir();
        return new AIOSequentialFileFactory(this.getTestDirfile(), 501760, 1000000, 10, false).setAlignment(512);
    }

    @Override
    protected int getAlignment() {
        return 512;
    }
}

