/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.ArrayList;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JmsClientAckTest
extends BasicOpenWireTest {
    @Test
    public void testAckedMessageAreConsumed() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(1000L);
        Assertions.assertNull((Object)msg);
        session.close();
    }

    @Test
    public void testLastMessageAcked() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        producer.send((Message)session.createTextMessage("Hello2"));
        producer.send((Message)session.createTextMessage("Hello3"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        Assertions.assertNotNull((Object)msg);
        msg = consumer.receive(1000L);
        Assertions.assertNotNull((Object)msg);
        msg = consumer.receive(1000L);
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(1000L);
        Assertions.assertNull((Object)msg);
        session.close();
    }

    @Test
    public void testUnAckedMessageAreNotConsumedOnSessionClose() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        Assertions.assertNotNull((Object)msg);
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(2000L);
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
    }

    @Test
    public void testAckedMessageDeliveringWithPrefetch() throws Exception {
        int i;
        int prefetchSize = 10;
        int messageCount = 50;
        this.connection.getPrefetchPolicy().setAll(10);
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue(this.getQueueName());
        QueueControl queueControl = (QueueControl)this.server.getManagementService().getResource("queue." + this.queueName);
        MessageProducer producer = session.createProducer((Destination)queue);
        for (int i2 = 0; i2 < 50; ++i2) {
            producer.send((Message)session.createTextMessage("MSG" + i2));
        }
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Wait.assertEquals((Long)0L, () -> queueControl.getMessagesAcknowledged(), (long)3000L, (long)100L);
        Wait.assertEquals((int)10, () -> queueControl.getDeliveringCount(), (long)3000L, (long)100L);
        ArrayList<Message> messages = new ArrayList<Message>();
        for (i = 0; i < 10; ++i) {
            Message msg = consumer.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            messages.add(msg);
        }
        Wait.assertEquals((Long)0L, () -> queueControl.getMessagesAcknowledged(), (long)3000L, (long)100L);
        Wait.assertEquals((int)20, () -> queueControl.getDeliveringCount(), (long)3000L, (long)100L);
        for (i = 0; i < 10; ++i) {
            Message msg = (Message)messages.get(i);
            msg.acknowledge();
        }
        Wait.assertEquals((Long)10L, () -> queueControl.getMessagesAcknowledged(), (long)3000L, (long)100L);
        Wait.assertEquals((int)10, () -> queueControl.getDeliveringCount(), (long)3000L, (long)100L);
        for (i = 0; i < 40; ++i) {
            Message msg = consumer.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
        }
        Wait.assertEquals((Long)50L, () -> queueControl.getMessagesAcknowledged(), (long)3000L, (long)100L);
        Wait.assertEquals((int)0, () -> queueControl.getDeliveringCount(), (long)3000L, (long)100L);
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receiveNoWait();
        Assertions.assertNull((Object)msg);
        session.close();
    }

    protected String getQueueName() {
        return this.queueName;
    }
}

