/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigurationTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartWithDuplicateQueues() throws Exception {
        ActiveMQServer server = this.getActiveMQServer("duplicate-queues.xml");
        try {
            server.start();
            Bindings mytopic_1 = server.getPostOffice().getBindingsForAddress(SimpleString.of((String)"mytopic_1"));
            Assertions.assertEquals((int)mytopic_1.getBindings().size(), (int)0);
            Bindings mytopic_2 = server.getPostOffice().getBindingsForAddress(SimpleString.of((String)"mytopic_2"));
            Assertions.assertEquals((int)mytopic_2.getBindings().size(), (int)3);
        }
        finally {
            try {
                server.stop();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueueWithoutAddressName() throws Exception {
        SimpleString QUEUE_NAME = RandomUtil.randomSimpleString();
        ActiveMQServer server = this.createServer(false, this.createDefaultInVMConfig());
        try {
            server.getConfiguration().addQueueConfiguration(new CoreQueueConfiguration().setName(QUEUE_NAME.toString()));
            server.start();
            Assertions.assertTrue((server.getAddressInfo(QUEUE_NAME) != null ? (byte)1 : 0) != 0);
        }
        finally {
            try {
                server.stop();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropertiesConfigReload() throws Exception {
        File propsFile = new File(this.getTestDirfile(), "some.props");
        propsFile.createNewFile();
        ConfigurationImpl.InsertionOrderedProperties config = new ConfigurationImpl.InsertionOrderedProperties();
        config.put((Object)"configurationFileRefreshPeriod", (Object)"500");
        config.put((Object)"addressConfigurations.mytopic_3.routingTypes", (Object)"MULTICAST");
        config.put((Object)"addressConfigurations.mytopic_3.queueConfigs.\"queue.A3\".address", (Object)"mytopic_3");
        config.put((Object)"addressConfigurations.mytopic_3.queueConfigs.\"queue.A3\".routingType", (Object)"MULTICAST");
        config.put((Object)"addressConfigurations.mytopic_3.queueConfigs.\"queue.B3\".address", (Object)"mytopic_3");
        config.put((Object)"addressConfigurations.mytopic_3.queueConfigs.\"queue.B3\".routingType", (Object)"MULTICAST");
        config.put((Object)"status", (Object)"{\"generation\": \"1\"}");
        try (FileOutputStream outStream = new FileOutputStream(propsFile);){
            config.store((OutputStream)outStream, null);
        }
        Assertions.assertTrue((boolean)propsFile.exists());
        ActiveMQServer server = this.getActiveMQServer("duplicate-queues.xml");
        server.setProperties(propsFile.getAbsolutePath());
        try {
            server.start();
            Bindings mytopic_1 = server.getPostOffice().getBindingsForAddress(SimpleString.of((String)"mytopic_1"));
            Assertions.assertEquals((int)mytopic_1.getBindings().size(), (int)0);
            Bindings mytopic_2 = server.getPostOffice().getBindingsForAddress(SimpleString.of((String)"mytopic_2"));
            Assertions.assertEquals((int)mytopic_2.getBindings().size(), (int)3);
            Bindings mytopic_3 = server.getPostOffice().getBindingsForAddress(SimpleString.of((String)"mytopic_3"));
            Assertions.assertEquals((int)mytopic_3.getBindings().size(), (int)2);
            config.put((Object)"addressConfigurations.mytopic_3.queueConfigs.\"queue.C3\".address", (Object)"mytopic_3");
            config.put((Object)"status", (Object)"{\"generation\": \"2\"}");
            try (FileOutputStream outStream = new FileOutputStream(propsFile);){
                config.store((OutputStream)outStream, null);
            }
            Wait.assertTrue(() -> {
                Bindings mytopic_31 = server.getPostOffice().getBindingsForAddress(SimpleString.of((String)"mytopic_3"));
                return mytopic_31.getBindings().size() == 3;
            });
            Assertions.assertTrue((boolean)server.getActiveMQServerControl().getStatus().contains("2"));
            Assertions.assertTrue((boolean)server.getActiveMQServerControl().getStatus().contains("version"));
            Assertions.assertTrue((boolean)server.getActiveMQServerControl().getStatus().contains("uptime"));
        }
        finally {
            try {
                server.stop();
            }
            catch (Exception exception) {}
        }
    }

    protected ActiveMQServer getActiveMQServer(String brokerConfig) throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileJMSConfiguration fileConfiguration = new FileJMSConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(brokerConfig);
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.addDeployable((Deployable)fileConfiguration);
        deploymentManager.readConfiguration();
        ActiveMQJAASSecurityManager sm = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), new SecurityConfiguration());
        return this.addServer((ActiveMQServer)new ActiveMQServerImpl((Configuration)fc, (ActiveMQSecurityManager)sm));
    }
}

