/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.lang.invoke.MethodHandles;
import java.util.ConcurrentModificationException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.LastValueQueue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LVQTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ActiveMQServer server;
    private ClientSession clientSession;
    private ClientSession clientSessionTxReceives;
    private ClientSession clientSessionTxSends;
    private final SimpleString address = SimpleString.of((String)"LVQTestAddress");
    private final SimpleString qName1 = SimpleString.of((String)"LVQTestQ1");

    @Test
    public void testSimple() throws Exception {
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName1);
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        SimpleString rh = SimpleString.of((String)"SMID1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        producer.send((Message)m1);
        producer.send((Message)m2);
        this.clientSession.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
    }

    @Test
    public void testSimpleExclusive() throws Exception {
        ServerLocator locator = this.createNettyNonHALocator().setConsumerWindowSize(0);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession clientSession = this.addClientSession(sf.createSession(false, true, true));
        String EXCLUSIVE_QUEUE = "exclusiveQueue";
        clientSession.createQueue(QueueConfiguration.of((String)"exclusiveQueue").setExclusive(Boolean.valueOf(true)).setLastValue(Boolean.valueOf(true)));
        ClientProducer producer = clientSession.createProducer("exclusiveQueue");
        ClientConsumer consumer = clientSession.createConsumer("exclusiveQueue");
        clientSession.start();
        ClientMessage m1 = this.createTextMessage(clientSession, "m1");
        SimpleString rh = SimpleString.of((String)"SMID1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m2 = this.createTextMessage(clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        producer.send((Message)m1);
        producer.send((Message)m2);
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
    }

    @Test
    public void testSimpleRestart() throws Exception {
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        SimpleString rh = SimpleString.of((String)"SMID1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        producer.send((Message)m1);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        producer.send((Message)m2);
        Wait.assertEquals((long)1L, () -> this.server.locateQueue(this.qName1).getMessageCount());
        this.clientSession.close();
        this.server.stop();
        this.server.start();
        Assertions.assertEquals((long)1L, (long)this.server.locateQueue(this.qName1).getMessageCount());
        ServerLocator locator = this.createNettyNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        this.clientSession = this.addClientSession(sf.createSession(false, true, true));
        producer = this.clientSession.createProducer(this.address);
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        m3.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        producer.send((Message)m3);
        Wait.assertEquals((long)1L, () -> this.server.locateQueue(this.qName1).getMessageCount());
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName1);
        this.clientSession.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)"m3", (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testMultipleMessages() throws Exception {
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName1);
        SimpleString messageId1 = SimpleString.of((String)"SMID1");
        SimpleString messageId2 = SimpleString.of((String)"SMID2");
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId1);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId2);
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        m3.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId1);
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        m4.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId2);
        producer.send((Message)m1);
        producer.send((Message)m2);
        producer.send((Message)m3);
        producer.send((Message)m4);
        this.clientSession.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
    }

    @Test
    public void testMultipleMessagesWithoutLastValue() throws Exception {
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientMessage m1 = this.createTextMessage(this.clientSession, "message1");
        ClientMessage m2 = this.createTextMessage(this.clientSession, "message2");
        producer.send((Message)m1);
        producer.send((Message)m2);
        Wait.assertEquals((Long)2L, () -> this.server.locateQueue(this.qName1).getMessageCount(), (long)2000L, (long)100L);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName1);
        this.clientSession.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)"message1", (Object)m.getBodyBuffer().readString());
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)"message2", (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testMultipleRollback() throws Exception {
        AddressSettings qs = new AddressSettings();
        qs.setDefaultLastValueQueue(true);
        qs.setRedeliveryDelay(1L);
        this.server.getAddressSettingsRepository().addMatch(this.address.toString(), (Object)qs);
        ClientProducer producer = this.clientSessionTxReceives.createProducer(this.address);
        ClientConsumer consumer = this.clientSessionTxReceives.createConsumer(this.qName1);
        SimpleString messageId1 = SimpleString.of((String)"SMID1");
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId1);
        producer.send((Message)m1);
        this.clientSessionTxReceives.start();
        for (int i = 0; i < 10; ++i) {
            logger.debug("#Deliver {}", (Object)i);
            ClientMessage m = consumer.receive(5000L);
            Assertions.assertNotNull((Object)m);
            m.acknowledge();
            this.clientSessionTxReceives.rollback();
        }
        m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId1);
        producer.send((Message)m1);
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        Assertions.assertNull((Object)consumer.receiveImmediate());
        this.clientSessionTxReceives.commit();
    }

    @Test
    public void testFirstMessageReceivedButAckedAfter() throws Exception {
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName1);
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        SimpleString rh = SimpleString.of((String)"SMID1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        producer.send((Message)m1);
        this.clientSession.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        producer.send((Message)m2);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
    }

    @Test
    public void testFirstMessageReceivedAndCancelled() throws Exception {
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName1);
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        SimpleString rh = SimpleString.of((String)"SMID1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        producer.send((Message)m1);
        this.clientSession.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        producer.send((Message)m2);
        consumer.close();
        consumer = this.clientSession.createConsumer(this.qName1);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = consumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testManyMessagesReceivedAndCancelled() throws Exception {
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName1);
        SimpleString rh = SimpleString.of((String)"SMID1");
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        m3.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        m4.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m5 = this.createTextMessage(this.clientSession, "m5");
        m5.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m6 = this.createTextMessage(this.clientSession, "m6");
        m6.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        this.clientSession.start();
        producer.send((Message)m1);
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        producer.send((Message)m2);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        producer.send((Message)m3);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        producer.send((Message)m4);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        producer.send((Message)m5);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m5");
        producer.send((Message)m6);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m6");
        consumer.close();
        consumer = this.clientSession.createConsumer(this.qName1);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m6");
        m = consumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testSimpleInTx() throws Exception {
        ClientProducer producer = this.clientSessionTxReceives.createProducer(this.address);
        ClientConsumer consumer = this.clientSessionTxReceives.createConsumer(this.qName1);
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        SimpleString rh = SimpleString.of((String)"SMID1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        producer.send((Message)m1);
        producer.send((Message)m2);
        this.clientSessionTxReceives.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
    }

    @Test
    public void testMultipleMessagesInTx() throws Exception {
        ClientProducer producer = this.clientSessionTxReceives.createProducer(this.address);
        SimpleString messageId1 = SimpleString.of((String)"SMID1");
        SimpleString messageId2 = SimpleString.of((String)"SMID2");
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId1);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId2);
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        m3.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId1);
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        m4.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId2);
        producer.send((Message)m1);
        producer.send((Message)m2);
        producer.send((Message)m3);
        producer.send((Message)m4);
        ClientConsumer consumer = this.clientSessionTxReceives.createConsumer(this.qName1);
        this.clientSessionTxReceives.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        this.clientSessionTxReceives.commit();
        m = consumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testMultipleMessagesInTxRollback() throws Exception {
        ClientProducer producer = this.clientSessionTxReceives.createProducer(this.address);
        ClientConsumer consumer = this.clientSessionTxReceives.createConsumer(this.qName1);
        SimpleString messageId1 = SimpleString.of((String)"SMID1");
        SimpleString messageId2 = SimpleString.of((String)"SMID2");
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId1);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId2);
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        m3.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId1);
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        m4.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId2);
        producer.send((Message)m1);
        producer.send((Message)m2);
        this.clientSessionTxReceives.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        producer.send((Message)m3);
        producer.send((Message)m4);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        this.clientSessionTxReceives.rollback();
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
    }

    @Test
    public void testSingleTXRollback() throws Exception {
        ClientProducer producer = this.clientSessionTxReceives.createProducer(this.address);
        ClientConsumer consumer = this.clientSessionTxReceives.createConsumer(this.qName1);
        SimpleString messageId1 = SimpleString.of((String)"SMID1");
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId1);
        producer.send((Message)m1);
        this.clientSessionTxReceives.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        this.clientSessionTxReceives.rollback();
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        Assertions.assertNull((Object)consumer.receiveImmediate());
    }

    @Test
    public void testMultipleMessagesInTxSend() throws Exception {
        ClientProducer producer = this.clientSessionTxSends.createProducer(this.address);
        ClientConsumer consumer = this.clientSessionTxSends.createConsumer(this.qName1);
        this.clientSessionTxSends.start();
        SimpleString rh = SimpleString.of((String)"SMID1");
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        m3.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        m4.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m5 = this.createTextMessage(this.clientSession, "m5");
        m5.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m6 = this.createTextMessage(this.clientSession, "m6");
        m6.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        producer.send((Message)m1);
        producer.send((Message)m2);
        producer.send((Message)m3);
        producer.send((Message)m4);
        producer.send((Message)m5);
        producer.send((Message)m6);
        this.clientSessionTxSends.commit();
        for (int i = 1; i < 6; ++i) {
            ClientMessage m = consumer.receive(1000L);
            Assertions.assertNotNull((Object)m);
            m.acknowledge();
            Assertions.assertEquals((Object)("m" + i), (Object)m.getBodyBuffer().readString());
        }
        consumer.close();
        consumer = this.clientSessionTxSends.createConsumer(this.qName1);
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)"m6", (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testMultipleMessagesPersistedCorrectly() throws Exception {
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName1);
        SimpleString rh = SimpleString.of((String)"SMID1");
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m1.setDurable(true);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m2.setDurable(true);
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        m3.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m3.setDurable(true);
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        m4.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m4.setDurable(true);
        ClientMessage m5 = this.createTextMessage(this.clientSession, "m5");
        m5.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m5.setDurable(true);
        ClientMessage m6 = this.createTextMessage(this.clientSession, "m6");
        m6.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m6.setDurable(true);
        producer.send((Message)m1);
        producer.send((Message)m2);
        producer.send((Message)m3);
        producer.send((Message)m4);
        producer.send((Message)m5);
        producer.send((Message)m6);
        this.clientSession.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m6");
        m = consumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testMultipleMessagesPersistedCorrectlyInTx() throws Exception {
        ClientProducer producer = this.clientSessionTxSends.createProducer(this.address);
        SimpleString rh = SimpleString.of((String)"SMID1");
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m1.setDurable(true);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m2.setDurable(true);
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        m3.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m3.setDurable(true);
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        m4.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m4.setDurable(true);
        ClientMessage m5 = this.createTextMessage(this.clientSession, "m5");
        m5.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m5.setDurable(true);
        ClientMessage m6 = this.createTextMessage(this.clientSession, "m6");
        m6.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m6.setDurable(true);
        producer.send((Message)m1);
        producer.send((Message)m2);
        producer.send((Message)m3);
        producer.send((Message)m4);
        producer.send((Message)m5);
        producer.send((Message)m6);
        this.clientSessionTxSends.commit();
        this.clientSessionTxSends.start();
        ClientConsumer consumer = this.clientSessionTxSends.createConsumer(this.qName1);
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m6");
        m = consumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    public void testMultipleAcksPersistedCorrectly() throws Exception {
        Queue queue = this.server.locateQueue(this.qName1);
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName1);
        SimpleString rh = SimpleString.of((String)"SMID1");
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m1.setDurable(true);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m2.setDurable(true);
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        m3.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m3.setDurable(true);
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        m4.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m4.setDurable(true);
        ClientMessage m5 = this.createTextMessage(this.clientSession, "m5");
        m5.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m5.setDurable(true);
        ClientMessage m6 = this.createTextMessage(this.clientSession, "m6");
        m6.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m6.setDurable(true);
        this.clientSession.start();
        producer.send((Message)m1);
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        producer.send((Message)m2);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        producer.send((Message)m3);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        producer.send((Message)m4);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        producer.send((Message)m5);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m5");
        producer.send((Message)m6);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m6");
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
    }

    @Test
    public void testRemoveMessageThroughManagement() throws Exception {
        Queue queue = this.server.locateQueue(this.qName1);
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName1);
        SimpleString rh = SimpleString.of((String)"SMID1");
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m1.setDurable(true);
        producer.send((Message)m1);
        queue.deleteAllReferences();
        producer.send((Message)m1);
        this.clientSession.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
    }

    @Test
    public void testScheduledMessages() throws Exception {
        long DELAY_TIME = 10L;
        int MESSAGE_COUNT = 5;
        Queue queue = this.server.locateQueue(this.qName1);
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName1);
        SimpleString rh = SimpleString.of((String)"SMID1");
        long timeSent = 0L;
        for (int i = 0; i < 5; ++i) {
            ClientMessage m = this.createTextMessage(this.clientSession, "m" + i);
            m.setDurable(true);
            m.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
            timeSent = System.currentTimeMillis();
            m.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, timeSent + (long)i * 10L);
            producer.send((Message)m);
        }
        Wait.waitFor(() -> queue.getScheduledCount() == 0);
        Wait.assertEquals((long)5L, () -> ((Queue)queue).getMessagesAdded());
        this.clientSession.start();
        ClientMessage m = consumer.receive(5000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
    }

    @Test
    public void testMultipleAcksPersistedCorrectly2() throws Exception {
        Queue queue = this.server.locateQueue(this.qName1);
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName1);
        SimpleString rh = SimpleString.of((String)"SMID1");
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m1.setDurable(true);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m2.setDurable(true);
        this.clientSession.start();
        producer.send((Message)m1);
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        producer.send((Message)m2);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
    }

    @Test
    public void testMultipleAcksPersistedCorrectlyInTx() throws Exception {
        ClientProducer producer = this.clientSessionTxReceives.createProducer(this.address);
        ClientConsumer consumer = this.clientSessionTxReceives.createConsumer(this.qName1);
        SimpleString rh = SimpleString.of((String)"SMID1");
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m1.setDurable(true);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m2.setDurable(true);
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        m3.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m3.setDurable(true);
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        m4.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m4.setDurable(true);
        ClientMessage m5 = this.createTextMessage(this.clientSession, "m5");
        m5.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m5.setDurable(true);
        ClientMessage m6 = this.createTextMessage(this.clientSession, "m6");
        m6.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m6.setDurable(true);
        this.clientSessionTxReceives.start();
        producer.send((Message)m1);
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        producer.send((Message)m2);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        producer.send((Message)m3);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        producer.send((Message)m4);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        producer.send((Message)m5);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m5");
        producer.send((Message)m6);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m6");
        this.clientSessionTxReceives.commit();
    }

    @Test
    public void testLargeMessage() throws Exception {
        ClientProducer producer = this.clientSessionTxReceives.createProducer(this.address);
        SimpleString rh = SimpleString.of((String)"SMID1");
        for (int i = 0; i < 50; ++i) {
            ClientMessage message = this.clientSession.createMessage(true);
            message.setBodyInputStream(LVQTest.createFakeLargeStream(307200L));
            message.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
            producer.send((Message)message);
            this.clientSession.commit();
        }
        ClientConsumer consumer = this.clientSessionTxReceives.createConsumer(this.qName1);
        this.clientSessionTxReceives.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertNull((Object)consumer.receiveImmediate());
        this.clientSessionTxReceives.commit();
    }

    @Test
    public void testSizeInReplace() throws Exception {
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        SimpleString rh = SimpleString.of((String)"SMID1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        ClientMessage m2 = this.clientSession.createMessage(true);
        m2.setBodyInputStream(LVQTest.createFakeLargeStream(10240L));
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        Queue queue = this.server.locateQueue(this.qName1);
        producer.send((Message)m1);
        Wait.assertEquals((long)123L, () -> queue.getPersistentSize());
        producer.send((Message)m2);
        Wait.assertTrue(() -> queue.getPersistentSize() > 10240L);
        Assertions.assertEquals((long)queue.getDeliveringSize(), (long)0L);
    }

    @Test
    public void testDeleteReference() throws Exception {
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        SimpleString rh = SimpleString.of((String)"SMID1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m1.setBodyInputStream(LVQTest.createFakeLargeStream(2048L));
        ClientMessage m2 = this.clientSession.createMessage(true);
        m2.setBodyInputStream(LVQTest.createFakeLargeStream(10240L));
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        Queue queue = this.server.locateQueue(this.qName1);
        producer.send((Message)m1);
        LinkedListIterator browserIterator = queue.browserIterator();
        Wait.assertTrue(() -> browserIterator.hasNext(), (long)10000L, (long)2L);
        long messageId = ((MessageReference)browserIterator.next()).getMessage().getMessageID();
        browserIterator.close();
        queue.deleteReference(messageId);
        Wait.assertEquals((Long)0L, () -> queue.getDeliveringSize(), (long)10000L, (long)2L);
        Assertions.assertEquals((long)queue.getPersistentSize(), (long)0L);
        Assertions.assertTrue((boolean)((LastValueQueue)queue).getLastValueKeys().isEmpty());
        producer.send((Message)m2);
        Wait.assertTrue(() -> queue.getPersistentSize() > 10240L, (long)10000L, (long)2L);
        Assertions.assertEquals((long)queue.getDeliveringSize(), (long)0L);
    }

    @Test
    public void testChangeReferencePriority() throws Exception {
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        SimpleString rh = SimpleString.of((String)"SMID1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        Queue queue = this.server.locateQueue(this.qName1);
        producer.send((Message)m1);
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        LinkedListIterator browserIterator = queue.browserIterator();
        Assertions.assertTrue((boolean)browserIterator.hasNext());
        long messageId = ((MessageReference)browserIterator.next()).getMessage().getMessageID();
        browserIterator.close();
        long oldSize = queue.getPersistentSize();
        Assertions.assertTrue((boolean)queue.changeReferencePriority(messageId, (byte)1));
        Wait.assertEquals((Long)oldSize, () -> queue.getPersistentSize(), (long)10000L, (long)2L);
        Assertions.assertEquals((long)queue.getDeliveringSize(), (long)0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrency() throws Exception {
        AtomicBoolean cme = new AtomicBoolean(false);
        AtomicBoolean hash = new AtomicBoolean(true);
        Queue lvq = this.server.locateQueue(this.qName1);
        Thread hashCodeThread = new Thread(() -> {
            while (hash.get()) {
                try {
                    int n = lvq.hashCode();
                }
                catch (ConcurrentModificationException e) {
                    cme.set(true);
                    return;
                }
            }
        });
        hashCodeThread.start();
        AtomicBoolean consume = new AtomicBoolean(true);
        ClientConsumer consumer = this.clientSessionTxReceives.createConsumer(this.qName1);
        this.clientSessionTxReceives.start();
        Thread consumerThread = new Thread(() -> {
            while (consume.get()) {
                try {
                    ClientMessage m = consumer.receive();
                    m.acknowledge();
                    this.clientSessionTxReceives.commit();
                }
                catch (ActiveMQException e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
        consumerThread.start();
        ClientProducer producer = this.clientSessionTxSends.createProducer(this.address);
        SimpleString lastValue = RandomUtil.randomSimpleString();
        AtomicBoolean produce = new AtomicBoolean(true);
        Thread producerThread = new Thread(() -> {
            int i = 0;
            while (!cme.get() && produce.get()) {
                ClientMessage m = this.createTextMessage(this.clientSession, "m" + i, false);
                m.putStringProperty(Message.HDR_LAST_VALUE_NAME, lastValue);
                try {
                    producer.send((Message)m);
                    this.clientSessionTxSends.commit();
                }
                catch (ActiveMQException e) {
                    e.printStackTrace();
                    return;
                }
                ++i;
            }
        });
        producerThread.start();
        producerThread.join(5000L);
        try {
            Assertions.assertFalse((boolean)cme.get());
        }
        finally {
            produce.set(false);
            producerThread.join();
            consume.set(false);
            consumerThread.join();
            hash.set(false);
            hashCodeThread.join();
        }
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultNettyConfig(), (boolean)true));
        this.server.start();
        this.server.getAddressSettingsRepository().addMatch(this.address.toString(), (Object)new AddressSettings().setDefaultLastValueQueue(true));
        ServerLocator locator = this.createNettyNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        this.clientSession = this.addClientSession(sf.createSession(false, true, true));
        this.clientSessionTxReceives = this.addClientSession(sf.createSession(false, true, false));
        this.clientSessionTxSends = this.addClientSession(sf.createSession(false, false, true));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName1).setAddress(this.address));
    }
}

