/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.xa;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAStartMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class XaTimeoutTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, AddressSettings> addressSettings = new HashMap<String, AddressSettings>();
    private ActiveMQServer server;
    private ClientSession clientSession;
    private ClientProducer clientProducer;
    private ClientConsumer clientConsumer;
    private ClientSessionFactory sessionFactory;
    private Configuration configuration;
    private final SimpleString atestq = SimpleString.of((String)"atestq");
    private ServerLocator locator;
    private StoreConfiguration.StoreType storeType;

    public XaTimeoutTest(StoreConfiguration.StoreType storeType) {
        this.storeType = storeType;
    }

    @Parameters(name="storeType={0}")
    public static Collection<Object[]> data() {
        Object[][] params = new Object[][]{{StoreConfiguration.StoreType.FILE}, {StoreConfiguration.StoreType.DATABASE}};
        return Arrays.asList(params);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.addressSettings.clear();
        this.configuration = this.storeType == StoreConfiguration.StoreType.DATABASE ? this.createDefaultJDBCConfig(true) : this.createBasicConfig();
        this.configuration.setTransactionTimeoutScanPeriod(500L).addAcceptorConfiguration(new TransportConfiguration(ActiveMQTestBase.INVM_ACCEPTOR_FACTORY));
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.configuration, (boolean)false));
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sessionFactory = this.createSessionFactory(this.locator);
        this.clientSession = this.sessionFactory.createSession(true, false, false);
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)this.atestq));
        this.clientProducer = this.clientSession.createProducer(this.atestq);
        this.clientConsumer = this.clientSession.createConsumer(this.atestq);
    }

    @TestTemplate
    public void testSimpleTimeoutOnSendOnCommit() throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        this.clientSession.setTransactionTimeout(1);
        this.clientSession.start((Xid)xid, 0);
        this.clientProducer.send((Message)m1);
        this.clientProducer.send((Message)m2);
        this.clientProducer.send((Message)m3);
        this.clientProducer.send((Message)m4);
        this.clientSession.end((Xid)xid, 0x4000000);
        CountDownLatch latch = new CountDownLatch(1);
        this.server.getResourceManager().getTransaction((Xid)xid).addOperation((TransactionOperation)new RollbackCompleteOperation(latch));
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        try {
            this.clientSession.commit((Xid)xid, true);
        }
        catch (XAException e) {
            Assertions.assertTrue((e.errorCode == -4 ? (byte)1 : 0) != 0);
        }
        this.clientSession.start();
        ClientMessage m = this.clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @TestTemplate
    public void testSimpleTimeoutOnReceive() throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        ClientSession clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientProducer clientProducer2 = clientSession2.createProducer(this.atestq);
        clientProducer2.send((Message)m1);
        clientProducer2.send((Message)m2);
        clientProducer2.send((Message)m3);
        clientProducer2.send((Message)m4);
        clientSession2.close();
        this.clientSession.setTransactionTimeout(2);
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.start();
        ClientMessage m = this.clientConsumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = this.clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = this.clientConsumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = this.clientConsumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        this.clientSession.end((Xid)xid, 0x4000000);
        CountDownLatch latch = new CountDownLatch(1);
        this.server.getResourceManager().getTransaction((Xid)xid).addOperation((TransactionOperation)new RollbackCompleteOperation(latch));
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        try {
            this.clientSession.commit((Xid)xid, true);
        }
        catch (XAException e) {
            Assertions.assertTrue((e.errorCode == -4 ? (byte)1 : 0) != 0);
        }
        this.clientSession.setTransactionTimeout(0);
        this.clientConsumer.close();
        clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientConsumer consumer = clientSession2.createConsumer(this.atestq);
        clientSession2.start();
        m = consumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = consumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = consumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = consumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        clientSession2.close();
    }

    @TestTemplate
    public void testSimpleTimeoutOnSendAndReceive() throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        ClientMessage m5 = this.createTextMessage(this.clientSession, "m5");
        ClientMessage m6 = this.createTextMessage(this.clientSession, "m6");
        ClientMessage m7 = this.createTextMessage(this.clientSession, "m7");
        ClientMessage m8 = this.createTextMessage(this.clientSession, "m8");
        ClientSession clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientProducer clientProducer2 = clientSession2.createProducer(this.atestq);
        clientProducer2.send((Message)m1);
        clientProducer2.send((Message)m2);
        clientProducer2.send((Message)m3);
        clientProducer2.send((Message)m4);
        clientSession2.close();
        this.clientSession.setTransactionTimeout(2);
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.start();
        this.clientProducer.send((Message)m5);
        this.clientProducer.send((Message)m6);
        this.clientProducer.send((Message)m7);
        this.clientProducer.send((Message)m8);
        ClientMessage m = this.clientConsumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = this.clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = this.clientConsumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = this.clientConsumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        this.clientSession.end((Xid)xid, 0x4000000);
        CountDownLatch latch = new CountDownLatch(1);
        this.server.getResourceManager().getTransaction((Xid)xid).addOperation((TransactionOperation)new RollbackCompleteOperation(latch));
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        try {
            this.clientSession.commit((Xid)xid, true);
        }
        catch (XAException e) {
            Assertions.assertTrue((e.errorCode == -4 ? (byte)1 : 0) != 0);
        }
        this.clientSession.setTransactionTimeout(0);
        this.clientConsumer.close();
        clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientConsumer consumer = clientSession2.createConsumer(this.atestq);
        clientSession2.start();
        m = consumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = consumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = consumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = consumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        m = consumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        clientSession2.close();
    }

    @TestTemplate
    public void testPreparedTransactionNotTimedOut() throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        ClientMessage m5 = this.createTextMessage(this.clientSession, "m5");
        ClientMessage m6 = this.createTextMessage(this.clientSession, "m6");
        ClientMessage m7 = this.createTextMessage(this.clientSession, "m7");
        ClientMessage m8 = this.createTextMessage(this.clientSession, "m8");
        ClientSession clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientProducer clientProducer2 = clientSession2.createProducer(this.atestq);
        clientProducer2.send((Message)m1);
        clientProducer2.send((Message)m2);
        clientProducer2.send((Message)m3);
        clientProducer2.send((Message)m4);
        clientSession2.close();
        this.clientSession.setTransactionTimeout(2);
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.start();
        this.clientProducer.send((Message)m5);
        this.clientProducer.send((Message)m6);
        this.clientProducer.send((Message)m7);
        this.clientProducer.send((Message)m8);
        ClientMessage m = this.clientConsumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = this.clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = this.clientConsumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = this.clientConsumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        CountDownLatch latch = new CountDownLatch(1);
        this.server.getResourceManager().getTransaction((Xid)xid).addOperation((TransactionOperation)new RollbackCompleteOperation(latch));
        Assertions.assertFalse((boolean)latch.await(2600L, TimeUnit.MILLISECONDS));
        this.clientSession.commit((Xid)xid, false);
        this.clientSession.setTransactionTimeout(0);
        this.clientConsumer.close();
        clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientConsumer consumer = clientSession2.createConsumer(this.atestq);
        clientSession2.start();
        m = consumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m5");
        m = consumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m6");
        m = consumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m7");
        m = consumer.receive(500L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m8");
        m = consumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        clientSession2.close();
    }

    @TestTemplate
    public void testTimeoutOnConsumerResend() throws Exception {
        int i;
        int numberOfMessages = 100;
        String outQueue = "outQueue";
        ClientSession simpleTXSession = this.sessionFactory.createTransactedSession();
        ClientProducer producerTX = simpleTXSession.createProducer(this.atestq);
        for (int i2 = 0; i2 < numberOfMessages; ++i2) {
            ClientMessage m = this.createTextMessage(this.clientSession, "m-" + i2);
            m.putIntProperty("msg", i2);
            producerTX.send((Message)m);
        }
        simpleTXSession.commit();
        simpleTXSession.createQueue(QueueConfiguration.of((String)outQueue));
        simpleTXSession.close();
        ClientSession outProducerSession = this.sessionFactory.createSession(true, false, false);
        ClientProducer outProducer = outProducerSession.createProducer(outQueue);
        AtomicInteger errors = new AtomicInteger(0);
        AtomicInteger msgCount = new AtomicInteger(0);
        CountDownLatch latchReceives = new CountDownLatch(numberOfMessages + 1);
        outProducerSession.setTransactionTimeout(2);
        this.clientSession.setTransactionTimeout(2);
        MessageHandler handler = message -> {
            block12: {
                try {
                    latchReceives.countDown();
                    XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
                    XidImpl xidOut = new XidImpl("xa2".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
                    this.clientSession.start((Xid)xid, 0);
                    outProducerSession.start((Xid)xidOut, 0);
                    message.acknowledge();
                    int msgInt = message.getIntProperty("msg");
                    ClientMessage msgOut = this.createTextMessage(outProducerSession, "outMsg=" + msgInt);
                    msgOut.putIntProperty("msg", msgInt);
                    outProducer.send((Message)msgOut);
                    boolean rollback = false;
                    if (msgCount.getAndIncrement() == 0) {
                        rollback = true;
                        logger.debug("Forcing first message to time out");
                        Thread.sleep(5000L);
                    }
                    try {
                        this.clientSession.end((Xid)xid, 0x4000000);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        outProducerSession.end((Xid)xidOut, 0x4000000);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (rollback) {
                        try {
                            this.clientSession.rollback((Xid)xid);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.clientSession.rollback();
                        }
                        try {
                            outProducerSession.rollback((Xid)xidOut);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            outProducerSession.rollback();
                        }
                        break block12;
                    }
                    this.clientSession.prepare((Xid)xid);
                    outProducerSession.prepare((Xid)xidOut);
                    this.clientSession.commit((Xid)xid, false);
                    outProducerSession.commit((Xid)xidOut, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            }
        };
        this.clientConsumer.setMessageHandler(handler);
        this.clientSession.start();
        Assertions.assertTrue((boolean)latchReceives.await(20L, TimeUnit.SECONDS));
        this.clientConsumer.close();
        this.clientConsumer = this.clientSession.createConsumer(this.atestq);
        Assertions.assertNull((Object)this.clientConsumer.receiveImmediate());
        this.clientConsumer.close();
        this.clientConsumer = this.clientSession.createConsumer(outQueue);
        HashSet<Integer> msgsIds = new HashSet<Integer>();
        for (i = 0; i < numberOfMessages; ++i) {
            ClientMessage msg = this.clientConsumer.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
            msgsIds.add(msg.getIntProperty("msg"));
        }
        Assertions.assertNull((Object)this.clientConsumer.receiveImmediate());
        for (i = 0; i < numberOfMessages; ++i) {
            Assertions.assertTrue((boolean)msgsIds.contains(i));
        }
        outProducerSession.close();
    }

    @TestTemplate
    public void testChangeXID() throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        XidImpl xid2 = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.start((Xid)xid2, 0);
    }

    @TestTemplate
    public void testChangingTimeoutGetsPickedUp() throws Exception {
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        this.clientSession.start((Xid)xid, 0);
        this.clientProducer.send((Message)m1);
        this.clientProducer.send((Message)m2);
        this.clientProducer.send((Message)m3);
        this.clientProducer.send((Message)m4);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.commit((Xid)xid, true);
        this.clientSession.setTransactionTimeout(1);
        this.clientSession.start((Xid)xid, 0);
        CountDownLatch latch = new CountDownLatch(1);
        this.server.getResourceManager().getTransaction((Xid)xid).addOperation((TransactionOperation)new RollbackCompleteOperation(latch));
        this.clientProducer.send((Message)m1);
        this.clientProducer.send((Message)m2);
        this.clientProducer.send((Message)m3);
        this.clientProducer.send((Message)m4);
        this.clientSession.end((Xid)xid, 0x4000000);
        Assertions.assertTrue((boolean)latch.await(2600L, TimeUnit.MILLISECONDS));
        try {
            this.clientSession.commit((Xid)xid, true);
        }
        catch (XAException e) {
            Assertions.assertTrue((e.errorCode == -4 ? (byte)1 : 0) != 0);
        }
        this.clientSession.start();
        ClientMessage m = this.clientConsumer.receiveImmediate();
        Assertions.assertNotNull((Object)m);
        m = this.clientConsumer.receiveImmediate();
        Assertions.assertNotNull((Object)m);
        m = this.clientConsumer.receiveImmediate();
        Assertions.assertNotNull((Object)m);
        m = this.clientConsumer.receiveImmediate();
        Assertions.assertNotNull((Object)m);
        m = this.clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @TestTemplate
    public void testMultipleTransactionsTimedOut() throws Exception {
        int i;
        int i1;
        int i2;
        XidImpl[] xids = new XidImpl[100];
        for (int i3 = 0; i3 < xids.length; ++i3) {
            xids[i3] = new XidImpl(("xa" + i3).getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        }
        ClientSession[] clientSessions = new ClientSession[xids.length];
        for (int i4 = 0; i4 < clientSessions.length; ++i4) {
            clientSessions[i4] = this.sessionFactory.createSession(true, false, false);
            clientSessions[i4].setTransactionTimeout(i4 < 50 ? 2 : 5000);
        }
        ClientProducer[] clientProducers = new ClientProducer[xids.length];
        for (int i5 = 0; i5 < clientProducers.length; ++i5) {
            clientProducers[i5] = clientSessions[i5].createProducer(this.atestq);
        }
        ClientMessage[] messages = new ClientMessage[xids.length];
        for (i2 = 0; i2 < messages.length; ++i2) {
            messages[i2] = this.createTextMessage(this.clientSession, "m" + i2);
        }
        for (i2 = 0; i2 < clientSessions.length; ++i2) {
            clientSessions[i2].start((Xid)xids[i2], 0);
        }
        for (i2 = 0; i2 < clientProducers.length; ++i2) {
            clientProducers[i2].send((Message)messages[i2]);
        }
        for (i2 = 0; i2 < clientSessions.length; ++i2) {
            clientSessions[i2].end((Xid)xids[i2], 0x4000000);
        }
        CountDownLatch[] latches = new CountDownLatch[xids.length];
        for (i1 = 0; i1 < latches.length; ++i1) {
            latches[i1] = new CountDownLatch(1);
            this.server.getResourceManager().getTransaction((Xid)xids[i1]).addOperation((TransactionOperation)new RollbackCompleteOperation(latches[i1]));
        }
        for (i1 = 0; i1 < latches.length / 2; ++i1) {
            Assertions.assertTrue((boolean)latches[i1].await(5L, TimeUnit.SECONDS));
        }
        for (i = 0; i < clientSessions.length / 2; ++i) {
            try {
                clientSessions[i].commit((Xid)xids[i], true);
                continue;
            }
            catch (XAException e) {
                Assertions.assertTrue((e.errorCode == -4 ? (byte)1 : 0) != 0);
            }
        }
        for (i = 50; i < clientSessions.length; ++i) {
            clientSessions[i].commit((Xid)xids[i], true);
        }
        for (ClientSession session : clientSessions) {
            session.close();
        }
        this.clientSession.start();
        for (int i6 = 0; i6 < clientSessions.length / 2; ++i6) {
            ClientMessage m = this.clientConsumer.receiveImmediate();
            Assertions.assertNotNull((Object)m);
        }
        ClientMessage m = this.clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @TestTemplate
    public void testTimeoutOnXACall() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        class SomeInterceptor
        implements Interceptor {
            SomeInterceptor() {
            }

            public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
                if (packet instanceof SessionXAStartMessage) {
                    try {
                        latch.await(1L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
        }
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new SomeInterceptor());
        ServerLocator locatorTimeout = this.createInVMNonHALocator().setCallTimeout(300L).setReconnectAttempts(-1);
        ClientSessionFactory factoryTimeout = locatorTimeout.createSessionFactory();
        ClientSession sessionTimeout = factoryTimeout.createSession(true, false, false);
        XidImpl xid = this.newXID();
        boolean expectedException = false;
        try {
            sessionTimeout.start((Xid)xid, 0);
        }
        catch (Exception e) {
            expectedException = true;
            e.printStackTrace();
        }
        Assertions.assertTrue((boolean)expectedException);
        latch.countDown();
        sessionTimeout.setTransactionTimeout(30);
        sessionTimeout.close();
        factoryTimeout.close();
        locatorTimeout.close();
    }

    final class RollbackCompleteOperation
    extends TransactionOperationAbstract {
        final CountDownLatch latch;

        RollbackCompleteOperation(CountDownLatch latch) {
            this.latch = latch;
        }

        public void afterRollback(Transaction tx) {
            this.latch.countDown();
        }
    }
}

