/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.remoting.server.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.server.impl.RemotingServiceImpl;
import org.apache.activemq.artemis.core.server.ServiceRegistry;
import org.apache.activemq.artemis.core.server.impl.ServiceRegistryImpl;
import org.apache.activemq.artemis.tests.unit.core.remoting.server.impl.fake.FakeInterceptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RemotingServiceImplTest {
    private ServiceRegistry serviceRegistry;
    private RemotingServiceImpl remotingService;
    private Configuration configuration;

    @BeforeEach
    public void setUp() throws Exception {
        this.serviceRegistry = new ServiceRegistryImpl();
        this.configuration = new ConfigurationImpl();
        this.configuration.setAcceptorConfigurations(new HashSet());
        this.remotingService = new RemotingServiceImpl(null, this.configuration, null, null, null, null, null, this.serviceRegistry);
    }

    @Test
    public void testPropagatingInterceptors() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.serviceRegistry.addIncomingInterceptor((BaseInterceptor)new FakeInterceptor());
        }
        this.remotingService = new RemotingServiceImpl(null, this.configuration, null, null, null, null, null, this.serviceRegistry);
        Assertions.assertTrue((this.remotingService.getIncomingInterceptors().size() == 5 ? (byte)1 : 0) != 0);
        Assertions.assertTrue((boolean)(this.remotingService.getIncomingInterceptors().get(0) instanceof FakeInterceptor));
        Assertions.assertTrue((this.remotingService.getIncomingInterceptors().get(0) != this.remotingService.getIncomingInterceptors().get(1) ? (byte)1 : 0) != 0);
    }

    @Test
    public void testSetInterceptorsAddsBothInterceptorsFromConfigAndServiceRegistry() throws Exception {
        Method method = RemotingServiceImpl.class.getDeclaredMethod("setInterceptors", Configuration.class);
        Field incomingInterceptors = RemotingServiceImpl.class.getDeclaredField("incomingInterceptors");
        Field outgoingInterceptors = RemotingServiceImpl.class.getDeclaredField("outgoingInterceptors");
        method.setAccessible(true);
        incomingInterceptors.setAccessible(true);
        outgoingInterceptors.setAccessible(true);
        this.serviceRegistry.addIncomingInterceptor((BaseInterceptor)new FakeInterceptor());
        this.serviceRegistry.addOutgoingInterceptor((BaseInterceptor)new FakeInterceptor());
        ArrayList<String> interceptorClassNames = new ArrayList<String>();
        interceptorClassNames.add(FakeInterceptor.class.getCanonicalName());
        this.configuration.setIncomingInterceptorClassNames(interceptorClassNames);
        this.configuration.setOutgoingInterceptorClassNames(interceptorClassNames);
        method.invoke((Object)this.remotingService, this.configuration);
        Assertions.assertTrue((((List)incomingInterceptors.get(this.remotingService)).size() == 2 ? (byte)1 : 0) != 0);
        Assertions.assertTrue((((List)outgoingInterceptors.get(this.remotingService)).size() == 2 ? (byte)1 : 0) != 0);
        Assertions.assertTrue((boolean)((List)incomingInterceptors.get(this.remotingService)).contains(this.serviceRegistry.getIncomingInterceptors(null).get(0)));
        Assertions.assertTrue((boolean)((List)outgoingInterceptors.get(this.remotingService)).contains(this.serviceRegistry.getOutgoingInterceptors(null).get(0)));
    }

    @Test
    public void testInterceptorsAreAddedOnCreationOfServiceRegistry() throws Exception {
        Field incomingInterceptors = RemotingServiceImpl.class.getDeclaredField("incomingInterceptors");
        Field outgoingInterceptors = RemotingServiceImpl.class.getDeclaredField("outgoingInterceptors");
        incomingInterceptors.setAccessible(true);
        outgoingInterceptors.setAccessible(true);
        this.serviceRegistry.addIncomingInterceptor((BaseInterceptor)new FakeInterceptor());
        this.serviceRegistry.addOutgoingInterceptor((BaseInterceptor)new FakeInterceptor());
        ArrayList<String> interceptorClassNames = new ArrayList<String>();
        interceptorClassNames.add(FakeInterceptor.class.getCanonicalName());
        this.configuration.setIncomingInterceptorClassNames(interceptorClassNames);
        this.configuration.setOutgoingInterceptorClassNames(interceptorClassNames);
        this.remotingService = new RemotingServiceImpl(null, this.configuration, null, null, null, null, null, this.serviceRegistry);
        Assertions.assertTrue((((List)incomingInterceptors.get(this.remotingService)).size() == 2 ? (byte)1 : 0) != 0);
        Assertions.assertTrue((((List)outgoingInterceptors.get(this.remotingService)).size() == 2 ? (byte)1 : 0) != 0);
        Assertions.assertTrue((boolean)((List)incomingInterceptors.get(this.remotingService)).contains(this.serviceRegistry.getIncomingInterceptors(null).get(0)));
        Assertions.assertTrue((boolean)((List)outgoingInterceptors.get(this.remotingService)).contains(this.serviceRegistry.getOutgoingInterceptors(null).get(0)));
    }
}

