/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.util;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import org.apache.activemq.artemis.tests.extensions.SpawnedVMCheckExtension;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomUtilDistributionTest {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @RegisterExtension
    public SpawnedVMCheckExtension check = new SpawnedVMCheckExtension();

    public static void main(String[] arg) {
        long start = Long.parseLong(arg[0]);
        try {
            Thread.sleep((start - System.currentTimeMillis()) / 2L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (System.currentTimeMillis() < start) {
            Thread.yield();
        }
        int value = RandomUtil.randomInterval((int)0, (int)255);
        System.exit(value);
    }

    @Test
    public void testDistribution() throws Exception {
        int numberOfStarts = 50;
        int iterations = 1;
        int value = 0;
        for (int i = 0; i < iterations; ++i) {
            int v = this.internalDistributionTest(numberOfStarts);
            value += v;
        }
        int minimumExpected = (int)((double)(iterations * numberOfStarts) * 0.8);
        logger.debug("values = {}, minimum expected = {}", (Object)value, (Object)minimumExpected);
        Assertions.assertTrue((value >= minimumExpected ? (byte)1 : 0) != 0, (String)("The Random distribution is pretty bad. Many tries have returned duplicated randoms. Number of different values=" + value + ", minimum expected = " + minimumExpected));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int internalDistributionTest(int numberOfTries) throws Exception {
        long timeStart = System.currentTimeMillis() + 5000L;
        Process[] process = new Process[numberOfTries];
        int[] value = new int[numberOfTries];
        try {
            for (int i = 0; i < numberOfTries; ++i) {
                process[i] = SpawnedVMSupport.spawnVM((String)RandomUtilDistributionTest.class.getName(), (boolean)true, (String[])new String[]{"" + timeStart});
            }
            HashSet<Integer> valueSet = new HashSet<Integer>();
            for (int i = 0; i < numberOfTries; ++i) {
                value[i] = process[i].waitFor();
                Assertions.assertTrue((value[i] >= 0 ? (byte)1 : 0) != 0);
                valueSet.add(process[i].exitValue());
            }
            logger.debug("Generated {} randoms out of {} tries", (Object)valueSet.size(), (Object)numberOfTries);
            int n = valueSet.size();
            return n;
        }
        finally {
            for (Process p : process) {
                if (p == null) continue;
                p.destroy();
            }
        }
    }
}

