/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.lang.invoke.MethodHandles;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestParameters {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private static String propertyName(String testName, String property) {
        if (testName == null) {
            return "TEST_" + property;
        }
        return "TEST_" + testName + "_" + property;
    }

    public static int testProperty(String testName, String property, int defaultValue) {
        try {
            return Integer.parseInt(TestParameters.testProperty(testName, property, Integer.toString(defaultValue)));
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
            return defaultValue;
        }
    }

    public static int intMandatoryProperty(String testName, String property) {
        try {
            return Integer.parseInt(TestParameters.mandatoryProperty(testName, property));
        }
        catch (Throwable e) {
            Assertions.fail((String)e.getMessage());
            return -1;
        }
    }

    public static String testProperty(String testName, String property, String defaultValue) {
        String value = System.getenv(property = TestParameters.propertyName(testName, property));
        if (value == null) {
            value = System.getProperty(property);
        }
        if (value == null) {
            logger.debug("System property '{}' not defined, using default: {}", (Object)property, (Object)defaultValue);
            value = defaultValue;
        }
        logger.info("{}={}", (Object)property, (Object)value);
        return value;
    }

    public static String mandatoryProperty(String testName, String property) {
        String value = System.getenv(property = TestParameters.propertyName(testName, property));
        if (value == null) {
            value = System.getProperty(property);
        }
        if (value == null) {
            Assertions.fail((String)("mandatory System property '" + property + "' not defined"));
        }
        logger.info("{}={}", (Object)property, (Object)value);
        return value;
    }
}

