/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.client;

import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.jboss.as.clustering.infinispan.client.ManagedRemoteCache;
import org.jboss.as.clustering.infinispan.dataconversion.MediaTypeFactory;
import org.jboss.as.clustering.infinispan.marshalling.UserMarshallerFactory;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.infinispan.client.RemoteCache;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ManagedRemoteCacheContainer
implements RemoteCacheContainer {
    private final RemoteCacheManager container;
    private final OperationsFactory factory;
    private final String name;
    private final ModuleLoader loader;
    private final Registrar<String> registrar;

    public ManagedRemoteCacheContainer(RemoteCacheManager container, String name, ModuleLoader loader, Registrar<String> registrar) {
        this.container = container;
        this.name = name;
        this.loader = loader;
        this.registrar = registrar;
        this.factory = new OperationsFactory(container.getChannelFactory(), null, container.getConfiguration());
    }

    public String getName() {
        return this.name;
    }

    public RemoteCacheManagerAdmin administration() {
        return this.container.administration();
    }

    public CompletionStage<Boolean> isAvailable() {
        return this.factory.newFaultTolerantPingOperation().execute().thenApply(PingResponse::isSuccess);
    }

    public <K, V> RemoteCache<K, V> getCache() {
        return this.getCache("");
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName) {
        org.infinispan.client.hotrod.RemoteCache cache = this.container.getCache(cacheName);
        if (cache == null) {
            return null;
        }
        Marshaller defaultMarshaller = this.container.getMarshaller();
        DataFormat.Builder builder = DataFormat.builder().from(cache.getDataFormat()).keyType(defaultMarshaller.mediaType()).keyMarshaller(defaultMarshaller).valueType(defaultMarshaller.mediaType()).valueMarshaller(defaultMarshaller);
        if ("___protobuf_metadata".equals(cacheName)) {
            builder.keyType(MediaType.TEXT_PLAIN);
            builder.valueType(MediaType.TEXT_PLAIN);
        } else if (defaultMarshaller.mediaType().equals((Object)MediaType.APPLICATION_PROTOSTREAM)) {
            final SerializationContext context = ((ProtoStreamMarshaller)defaultMarshaller).getSerializationContext();
            WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Object>(){

                @Override
                public Void run() {
                    for (SerializationContextInitializer initializer : ServiceLoader.load(SerializationContextInitializer.class, Thread.currentThread().getContextClassLoader())) {
                        initializer.registerSchema(context);
                        initializer.registerMarshallers(context);
                    }
                    return null;
                }
            });
        } else {
            boolean overrideValueMarshaller;
            ClassLoader loader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            Map.Entry<MediaType, MediaType> types = MediaTypeFactory.INSTANCE.apply(loader);
            boolean overrideKeyMarshaller = !types.getKey().equals((Object)MediaType.APPLICATION_OBJECT);
            boolean bl = overrideValueMarshaller = !types.getValue().equals((Object)MediaType.APPLICATION_OBJECT);
            if (overrideKeyMarshaller || overrideValueMarshaller) {
                Marshaller marshaller = UserMarshallerFactory.forMediaType(defaultMarshaller.mediaType()).createUserMarshaller(this.loader, List.of(loader));
                if (overrideKeyMarshaller) {
                    builder.keyType(marshaller.mediaType());
                    builder.keyMarshaller(marshaller);
                }
                if (overrideValueMarshaller) {
                    builder.valueType(marshaller.mediaType());
                    builder.valueMarshaller(marshaller);
                }
            }
        }
        return new ManagedRemoteCache(this, this.container, cache.withDataFormat(builder.build()), this.registrar);
    }

    public Configuration getConfiguration() {
        return this.container.getConfiguration();
    }

    public boolean isStarted() {
        return this.container.isStarted();
    }

    public String getCurrentClusterName() {
        return this.container.getCurrentClusterName();
    }

    public boolean switchToCluster(String clusterName) {
        return this.container.switchToCluster(clusterName);
    }

    public boolean switchToDefaultCluster() {
        return this.container.switchToDefaultCluster();
    }

    public Marshaller getMarshaller() {
        return this.container.getMarshaller();
    }

    public boolean isTransactional(String cacheName) {
        return this.container.isTransactional(cacheName);
    }

    public Set<String> getCacheNames() {
        return this.container.getCacheNames();
    }

    public void start() {
    }

    public void stop() {
    }

    public String[] getServers() {
        return this.container.getServers();
    }

    public int getActiveConnectionCount() {
        return this.container.getActiveConnectionCount();
    }

    public int getConnectionCount() {
        return this.container.getConnectionCount();
    }

    public int getIdleConnectionCount() {
        return this.container.getIdleConnectionCount();
    }

    public long getRetries() {
        return this.container.getRetries();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RemoteCacheContainer)) {
            return false;
        }
        RemoteCacheContainer container = (RemoteCacheContainer)object;
        return this.name.equals(container.getName());
    }

    public String toString() {
        return this.name;
    }
}

