/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.interceptor.InterceptorBinding;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.util.InterceptorBindingSet;
import org.jboss.weld.util.collections.Multimap;
import org.jboss.weld.util.collections.SetMultimap;

public class Interceptors {
    private Interceptors() {
    }

    public static Set<Annotation> filterInterceptorBindings(BeanManagerImpl beanManager, Collection<Annotation> annotations) {
        InterceptorBindingSet interceptorBindings = new InterceptorBindingSet(beanManager);
        for (Annotation annotation : annotations) {
            if (!beanManager.isInterceptorBinding(annotation.annotationType())) continue;
            interceptorBindings.add(annotation);
        }
        return interceptorBindings;
    }

    public static Set<Annotation> flattenInterceptorBindings(EnhancedAnnotatedType<?> clazz, BeanManagerImpl beanManager, Collection<Annotation> annotations, boolean addTopLevelInterceptorBindings, boolean addInheritedInterceptorBindings) {
        InterceptorBindingSet flattenInterceptorBindings = new InterceptorBindingSet(beanManager);
        MetaAnnotationStore metaAnnotationStore = (MetaAnnotationStore)beanManager.getServices().get(MetaAnnotationStore.class);
        if (addTopLevelInterceptorBindings) {
            Interceptors.addInterceptorBindings(clazz, annotations, flattenInterceptorBindings, metaAnnotationStore);
        }
        if (addInheritedInterceptorBindings) {
            for (Annotation annotation : annotations) {
                Interceptors.addInheritedInterceptorBindings(clazz, annotation.annotationType(), metaAnnotationStore, flattenInterceptorBindings);
            }
        }
        return flattenInterceptorBindings;
    }

    private static void addInheritedInterceptorBindings(EnhancedAnnotatedType<?> clazz, Class<? extends Annotation> bindingType, MetaAnnotationStore metaAnnotationStore, Set<Annotation> flattenInterceptorBindings) {
        Set<Annotation> metaBindings = metaAnnotationStore.getInterceptorBindingModel(bindingType).getInheritedInterceptionBindingTypes();
        Interceptors.addInterceptorBindings(clazz, metaBindings, flattenInterceptorBindings, metaAnnotationStore);
        for (Annotation metaBinding : metaBindings) {
            Interceptors.addInheritedInterceptorBindings(clazz, metaBinding.annotationType(), metaAnnotationStore, flattenInterceptorBindings);
        }
    }

    private static void addInterceptorBindings(EnhancedAnnotatedType<?> clazz, Collection<Annotation> interceptorBindings, Set<Annotation> flattenInterceptorBindings, MetaAnnotationStore metaAnnotationStore) {
        for (Annotation annotation : interceptorBindings) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotation.annotationType().isAnnotationPresent(Repeatable.class)) {
                for (Annotation binding : flattenInterceptorBindings) {
                    if (!binding.annotationType().equals(annotationType) || metaAnnotationStore.getInterceptorBindingModel(annotationType).isEqual(annotation, binding, false)) continue;
                    if (clazz != null) {
                        throw new DefinitionException(BeanLogger.LOG.conflictingInterceptorBindings(clazz));
                    }
                    throw BeanManagerLogger.LOG.duplicateInterceptorBinding(annotation);
                }
            }
            flattenInterceptorBindings.add(annotation);
        }
    }

    public static Multimap<Class<? extends Annotation>, Annotation> mergeBeanInterceptorBindings(BeanManagerImpl beanManager, EnhancedAnnotatedType<?> clazz, Collection<Class<? extends Annotation>> stereotypes) {
        Set<Annotation> rawBindings = clazz.getMetaAnnotations(InterceptorBinding.class);
        Set<Annotation> classBindingAnnotations = Interceptors.flattenInterceptorBindings(clazz, beanManager, Interceptors.filterInterceptorBindings(beanManager, rawBindings), true, false);
        HashSet<Annotation> inheritedBindingAnnotations = new HashSet<Annotation>();
        inheritedBindingAnnotations.addAll(Interceptors.flattenInterceptorBindings(clazz, beanManager, Interceptors.filterInterceptorBindings(beanManager, rawBindings), false, true));
        for (Class<? extends Annotation> annotation : stereotypes) {
            inheritedBindingAnnotations.addAll(Interceptors.flattenInterceptorBindings(clazz, beanManager, Interceptors.filterInterceptorBindings(beanManager, beanManager.getStereotypeDefinition(annotation)), true, true));
        }
        try {
            return Interceptors.mergeBeanInterceptorBindings(beanManager, clazz, classBindingAnnotations, inheritedBindingAnnotations);
        }
        catch (DeploymentException e) {
            throw new DefinitionException(BeanLogger.LOG.conflictingInterceptorBindings(clazz.getJavaClass()));
        }
    }

    public static Multimap<Class<? extends Annotation>, Annotation> mergeBeanInterceptorBindings(BeanManagerImpl beanManager, AnnotatedType<?> clazz, Collection<Annotation> classBindingAnnotations, Collection<Annotation> inheritedBindingAnnotations) {
        Class<? extends Annotation> annotationType;
        SetMultimap<Class<? extends Annotation>, Annotation> mergedBeanBindings = SetMultimap.newSetMultimap();
        SetMultimap acceptedInheritedBindings = SetMultimap.newSetMultimap();
        MetaAnnotationStore metaAnnotationStore = (MetaAnnotationStore)beanManager.getServices().get(MetaAnnotationStore.class);
        for (Annotation binding : classBindingAnnotations) {
            annotationType = binding.annotationType();
            if (!annotationType.isAnnotationPresent(Repeatable.class)) {
                for (Annotation mergedBinding : (Set)mergedBeanBindings.get((Object)annotationType)) {
                    if (metaAnnotationStore.getInterceptorBindingModel(annotationType).isEqual(binding, mergedBinding, false)) continue;
                    throw new DeploymentException(BeanLogger.LOG.conflictingInterceptorBindings(clazz.getJavaClass()));
                }
            }
            mergedBeanBindings.put(binding.annotationType(), (Object)binding);
        }
        for (Annotation binding : inheritedBindingAnnotations) {
            annotationType = binding.annotationType();
            if (!mergedBeanBindings.containsKey(annotationType) || annotationType.isAnnotationPresent(Repeatable.class)) {
                mergedBeanBindings.put(annotationType, (Object)binding);
                acceptedInheritedBindings.put(annotationType, binding);
                continue;
            }
            Set inheritedBindings = (Set)acceptedInheritedBindings.get(annotationType);
            for (Annotation inheritedBinding : inheritedBindings) {
                if (metaAnnotationStore.getInterceptorBindingModel(annotationType).isEqual(binding, inheritedBinding, false)) continue;
                throw new DeploymentException(BeanLogger.LOG.conflictingInterceptorBindings(clazz.getJavaClass()));
            }
        }
        return mergedBeanBindings;
    }
}

