/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.jts.subordinate;

import com.arjuna.ats.internal.jta.transaction.jts.AtomicTransaction;
import com.arjuna.ats.internal.jta.transaction.jts.subordinate.SubordinateAtomicTransaction;
import com.arjuna.ats.internal.jta.utils.jtaxLogger;
import com.arjuna.ats.jta.exceptions.InactiveTransactionException;
import com.arjuna.ats.jta.exceptions.InvalidTerminationStateException;
import com.arjuna.ats.jta.exceptions.UnexpectedConditionException;
import jakarta.transaction.HeuristicCommitException;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import org.omg.CosTransactions.NoTransaction;

public class TransactionImple
extends com.arjuna.ats.internal.jta.transaction.jts.TransactionImple {
    public TransactionImple(AtomicTransaction imported) {
        super(imported);
        TransactionImple.putTransaction(this);
    }

    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException, IllegalStateException {
        throw new InvalidTerminationStateException();
    }

    @Override
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        throw new InvalidTerminationStateException();
    }

    public int doPrepare() {
        try {
            SubordinateAtomicTransaction subAct = (SubordinateAtomicTransaction)this._theTransaction;
            if (!this.endSuspendedRMs()) {
                try {
                    this._theTransaction.rollbackOnly();
                }
                catch (NoTransaction noTransaction) {
                    // empty catch block
                }
            }
            int res = subAct.doPrepare();
            switch (res) {
                case 1: 
                case 2: {
                    TransactionImple.removeTransaction(this);
                }
            }
            return res;
        }
        catch (ClassCastException ex) {
            return 11;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doCommit() throws IllegalStateException, HeuristicMixedException, HeuristicRollbackException, HeuristicCommitException, SystemException {
        try {
            SubordinateAtomicTransaction subAct = (SubordinateAtomicTransaction)this._theTransaction;
            int res = subAct.doCommit();
            switch (res) {
                case 12: {
                    throw new HeuristicCommitException();
                }
                case 7: {
                    return true;
                }
                case 6: {
                    boolean bl = false;
                    return bl;
                }
                case 2: 
                case 4: 
                case 11: {
                    throw new HeuristicRollbackException();
                }
                case 13: 
                case 14: {
                    throw new HeuristicMixedException();
                }
                case 9: {
                    throw new IllegalStateException();
                }
                default: {
                    throw new HeuristicMixedException();
                }
            }
        }
        catch (ClassCastException ex) {
            jtaxLogger.i18NLogger.warn_jtax_transaction_jts_ex(ex);
            UnexpectedConditionException unexpectedConditionException = new UnexpectedConditionException(ex.toString());
            unexpectedConditionException.initCause(ex);
            throw unexpectedConditionException;
        }
        finally {
            TransactionImple.removeTransaction(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doRollback() throws IllegalStateException, HeuristicMixedException, HeuristicCommitException, HeuristicRollbackException, SystemException {
        try {
            SubordinateAtomicTransaction subAct = (SubordinateAtomicTransaction)this._theTransaction;
            if (!this.endSuspendedRMs()) {
                jtaxLogger.i18NLogger.warn_jtax_transaction_jts_endsuspendfailed1();
            }
            int res = subAct.doRollback();
            switch (res) {
                case 2: 
                case 4: {
                    return;
                }
                case 11: {
                    throw new HeuristicRollbackException();
                }
                case 6: 
                case 7: 
                case 12: {
                    throw new HeuristicCommitException();
                }
                case 13: 
                case 14: {
                    throw new HeuristicMixedException();
                }
                default: {
                    throw new HeuristicMixedException();
                }
            }
        }
        catch (ClassCastException ex) {
            jtaxLogger.i18NLogger.warn_jtax_transaction_jts_ex(ex);
            UnexpectedConditionException unexpectedConditionException = new UnexpectedConditionException(ex.toString());
            unexpectedConditionException.initCause(ex);
            throw unexpectedConditionException;
        }
        finally {
            TransactionImple.removeTransaction(this);
        }
    }

    public void doOnePhaseCommit() throws IllegalStateException, RollbackException, HeuristicMixedException, SystemException {
        try {
            SubordinateAtomicTransaction subAct = (SubordinateAtomicTransaction)this._theTransaction;
            if (!this.endSuspendedRMs()) {
                try {
                    this._theTransaction.rollbackOnly();
                }
                catch (NoTransaction noTransaction) {
                    // empty catch block
                }
            }
            int status = subAct.doOnePhaseCommit();
            TransactionImple.removeTransaction(this);
            switch (status) {
                case 6: 
                case 7: 
                case 12: {
                    break;
                }
                case 2: 
                case 4: {
                    throw new RollbackException();
                }
                default: {
                    throw new HeuristicMixedException();
                }
                case 9: {
                    throw new InvalidTerminationStateException();
                }
            }
        }
        catch (ClassCastException ex) {
            jtaxLogger.i18NLogger.warn_jtax_transaction_jts_ex(ex);
            throw new IllegalStateException(ex);
        }
    }

    public void doForget() throws IllegalStateException {
        try {
            SubordinateAtomicTransaction subAct = (SubordinateAtomicTransaction)this._theTransaction;
            subAct.doForget();
        }
        catch (ClassCastException ex) {
            jtaxLogger.i18NLogger.warn_jtax_transaction_jts_ex(ex);
            throw new IllegalStateException(ex);
        }
    }

    public boolean doBeforeCompletion() throws SystemException {
        try {
            SubordinateAtomicTransaction subAct = (SubordinateAtomicTransaction)this._theTransaction;
            return subAct.doBeforeCompletion();
        }
        catch (Exception ex) {
            jtaxLogger.i18NLogger.warn_jtax_transaction_jts_ex(ex);
            UnexpectedConditionException unexpectedConditionException = new UnexpectedConditionException(ex.toString());
            unexpectedConditionException.initCause(ex);
            throw unexpectedConditionException;
        }
    }

    @Override
    public String toString() {
        if (this._theTransaction == null) {
            return "TransactionImple < jts-subordinate, NoTransaction >";
        }
        return "TransactionImple < jts-subordinate, " + this._theTransaction.get_uid() + " >";
    }

    @Override
    protected void commitAndDisassociate() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException, IllegalStateException {
        throw new InactiveTransactionException();
    }

    @Override
    protected void rollbackAndDisassociate() throws IllegalStateException, SecurityException, SystemException {
        throw new InactiveTransactionException();
    }
}

