/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.requestcontroller;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.as.server.suspend.ServerResumeContext;
import org.jboss.as.server.suspend.ServerSuspendContext;
import org.jboss.as.server.suspend.SuspendableActivity;
import org.jboss.as.server.suspend.SuspendableActivityRegistry;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.ControlPointTask;
import org.wildfly.extension.requestcontroller.RequestControllerRootDefinition;
import org.wildfly.extension.requestcontroller.RequestControllerState;
import org.wildfly.extension.requestcontroller.RunResult;
import org.wildfly.extension.requestcontroller.logging.RequestControllerLogger;

public class RequestController
implements Service<RequestController>,
SuspendableActivity {
    static final ServiceName SERVICE_NAME = RequestControllerRootDefinition.REQUEST_CONTROLLER_CAPABILITY.getCapabilityServiceName();
    private static final AtomicIntegerFieldUpdater<RequestController> activeRequestCountUpdater = AtomicIntegerFieldUpdater.newUpdater(RequestController.class, "activeRequestCount");
    private static final AtomicReferenceFieldUpdater<RequestController, CompletableFuture> suspendUpdater = AtomicReferenceFieldUpdater.newUpdater(RequestController.class, CompletableFuture.class, "suspend");
    private volatile int maxRequestCount = -1;
    private volatile int activeRequestCount = 0;
    private volatile boolean paused = false;
    private final Map<ControlPointIdentifier, ControlPoint> entryPoints = new HashMap<ControlPointIdentifier, ControlPoint>();
    private volatile CompletableFuture<Void> suspend = null;
    private final boolean trackIndividualControlPoints;
    private final Supplier<SuspendableActivityRegistry> registry;
    private Timer timer;
    private final Deque<QueuedTask> taskQueue = new LinkedBlockingDeque<QueuedTask>();

    public RequestController(boolean trackIndividualControlPoints, Supplier<SuspendableActivityRegistry> registry) {
        this.trackIndividualControlPoints = trackIndividualControlPoints;
        this.registry = registry;
    }

    public CompletionStage<Void> suspend(ServerSuspendContext context) {
        this.paused = true;
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        suspendUpdater.set(this, result);
        if (activeRequestCountUpdater.get(this) == 0 && suspendUpdater.compareAndSet(this, result, null)) {
            result.complete(null);
        }
        return result;
    }

    public CompletionStage<Void> resume(ServerResumeContext context) {
        this.paused = false;
        CompletableFuture suspend = suspendUpdater.get(this);
        if (suspend != null) {
            suspendUpdater.compareAndSet(this, suspend, null);
            suspend.cancel(false);
        }
        while (!(this.taskQueue.isEmpty() || this.activeRequestCount >= this.maxRequestCount && this.maxRequestCount >= 0)) {
            this.runQueuedTask(false);
        }
        return SuspendableActivity.COMPLETED;
    }

    private synchronized CompletionStage<Void> pause(Predicate<ControlPoint> filter) {
        List controlPoints = this.entryPoints.values().stream().filter(filter).collect(Collectors.toUnmodifiableList());
        if (controlPoints.isEmpty()) {
            return SuspendableActivity.COMPLETED;
        }
        final AtomicInteger count = new AtomicInteger(controlPoints.size());
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        for (ControlPoint controlPoint : controlPoints) {
            controlPoint.pause().whenComplete(new BiConsumer<Void, Throwable>(){

                @Override
                public void accept(Void ignore, Throwable exception) {
                    if (exception != null) {
                        result.completeExceptionally(exception);
                    } else if (count.decrementAndGet() == 0) {
                        result.complete(null);
                    }
                }
            });
        }
        return result;
    }

    public CompletionStage<Void> pauseDeployment(String deployment) {
        return this.pause(new DeploymentFilter(deployment));
    }

    @Deprecated(forRemoval=true, since="26.0.0")
    public void pauseDeployment(String deployment, ServerActivityCallback listener) {
        this.pauseDeployment(deployment).whenComplete((ignore, exception) -> listener.done());
    }

    private synchronized void resume(Predicate<ControlPoint> filter) {
        this.entryPoints.values().stream().filter(filter).forEach(ControlPoint::resume);
    }

    public void resumeDeployment(String deployment) {
        this.resume(new DeploymentFilter(deployment));
    }

    public CompletionStage<Void> pauseControlPoint(String entryPoint) {
        return this.pause(new EntryPointFilter(entryPoint));
    }

    @Deprecated(forRemoval=true)
    public void pauseControlPoint(String entryPoint, ServerActivityCallback listener) {
        this.pauseControlPoint(entryPoint).whenComplete((ignore, exception) -> listener.done());
    }

    public void resumeControlPoint(String entryPoint) {
        this.resume(new EntryPointFilter(entryPoint));
    }

    public synchronized RequestControllerState getState() {
        ArrayList<RequestControllerState.EntryPointState> eps = new ArrayList<RequestControllerState.EntryPointState>();
        for (ControlPoint controlPoint : this.entryPoints.values()) {
            eps.add(new RequestControllerState.EntryPointState(controlPoint.getDeployment(), controlPoint.getEntryPoint(), controlPoint.isPaused(), controlPoint.getActiveRequestCount()));
        }
        return new RequestControllerState(this.paused, this.activeRequestCount, this.maxRequestCount, eps);
    }

    RunResult beginRequest(boolean force) {
        int maxRequests = this.maxRequestCount;
        int active = activeRequestCountUpdater.get(this);
        boolean success = false;
        while (!(maxRequests > 0 && active >= maxRequests || this.paused && !force)) {
            if (activeRequestCountUpdater.compareAndSet(this, active, active + 1)) {
                success = true;
                break;
            }
            active = activeRequestCountUpdater.get(this);
        }
        if (success) {
            if (!force && this.paused) {
                this.requestComplete();
                return RunResult.REJECTED;
            }
            return RunResult.RUN;
        }
        return RunResult.REJECTED;
    }

    void requestComplete() {
        this.runQueuedTask(true);
    }

    private void decrementRequestCount() {
        CompletableFuture suspend;
        int result = activeRequestCountUpdater.decrementAndGet(this);
        if (this.paused && this.paused && result == 0 && (suspend = suspendUpdater.get(this)) != null && suspendUpdater.compareAndSet(this, suspend, null)) {
            suspend.complete(null);
        }
    }

    public synchronized ControlPoint getControlPoint(String deploymentName, String entryPointName) {
        ControlPointIdentifier id = new ControlPointIdentifier(deploymentName, entryPointName);
        ControlPoint ep = this.entryPoints.get(id);
        if (ep == null) {
            ep = new ControlPoint(this, deploymentName, entryPointName, this.trackIndividualControlPoints);
            this.entryPoints.put(id, ep);
        }
        ep.increaseReferenceCount();
        return ep;
    }

    public synchronized void removeControlPoint(ControlPoint controlPoint) {
        if (controlPoint.decreaseReferenceCount() == 0) {
            ControlPointIdentifier id = new ControlPointIdentifier(controlPoint.getDeployment(), controlPoint.getEntryPoint());
            this.entryPoints.remove(id);
        }
    }

    public int getMaxRequestCount() {
        return this.maxRequestCount;
    }

    public void setMaxRequestCount(int maxRequestCount) {
        this.maxRequestCount = maxRequestCount;
        while (!this.taskQueue.isEmpty() && (this.activeRequestCount < maxRequestCount || maxRequestCount < 0) && this.runQueuedTask(false)) {
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void start(StartContext startContext) throws StartException {
        this.registry.get().registerActivity((SuspendableActivity)this);
        this.timer = new Timer();
    }

    public void stop(StopContext stopContext) {
        this.registry.get().registerActivity((SuspendableActivity)this);
        this.timer.cancel();
        this.timer = null;
        while (!this.taskQueue.isEmpty()) {
            QueuedTask t = this.taskQueue.poll();
            if (t == null) continue;
            t.run();
        }
    }

    public RequestController getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public int getActiveRequestCount() {
        return this.activeRequestCount;
    }

    void queueTask(ControlPoint controlPoint, Runnable task, Executor taskExecutor, long timeout, Runnable timeoutTask, boolean rejectOnSuspend, boolean forceRun) {
        if (this.paused && rejectOnSuspend && !forceRun) {
            taskExecutor.execute(timeoutTask);
            return;
        }
        QueuedTask queuedTask = new QueuedTask(taskExecutor, task, timeoutTask, controlPoint, forceRun);
        this.taskQueue.add(queuedTask);
        this.runQueuedTask(false);
        if (queuedTask.isQueued() && timeout > 0L) {
            this.timer.schedule((TimerTask)queuedTask, timeout);
        }
    }

    private boolean runQueuedTask(boolean hasPermit) {
        if (!hasPermit && this.beginRequest(this.paused) == RunResult.REJECTED) {
            return false;
        }
        QueuedTask task = null;
        task = !this.paused ? this.taskQueue.poll() : this.findForcedTask();
        if (task != null) {
            if (!task.runRequest()) {
                this.decrementRequestCount();
            }
            return true;
        }
        this.decrementRequestCount();
        return false;
    }

    private QueuedTask findForcedTask() {
        QueuedTask task;
        QueuedTask forcedTask = null;
        ArrayList<QueuedTask> storage = new ArrayList<QueuedTask>();
        while (forcedTask == null && (task = this.taskQueue.poll()) != null) {
            if (task.forceRun) {
                forcedTask = task;
                continue;
            }
            storage.add(task);
        }
        this.taskQueue.addAll(storage);
        return forcedTask;
    }

    private static class EntryPointFilter
    implements Predicate<ControlPoint> {
        private final String entryPoint;

        EntryPointFilter(String entryPoint) {
            this.entryPoint = entryPoint;
        }

        @Override
        public boolean test(ControlPoint controlPoint) {
            return controlPoint.getEntryPoint().equals(this.entryPoint);
        }
    }

    private static class DeploymentFilter
    implements Predicate<ControlPoint> {
        private final String deployment;

        DeploymentFilter(String deployment) {
            this.deployment = deployment;
        }

        @Override
        public boolean test(ControlPoint controlPoint) {
            return controlPoint.getDeployment().equals(this.deployment);
        }
    }

    private static final class QueuedTask
    extends TimerTask {
        private final Executor executor;
        private final Runnable task;
        private final Runnable cancelTask;
        private final ControlPoint controlPoint;
        private final boolean forceRun;
        private final AtomicInteger state = new AtomicInteger(0);

        private QueuedTask(Executor executor, Runnable task, Runnable cancelTask, ControlPoint controlPoint, boolean forceRun) {
            this.executor = executor;
            this.task = task;
            this.cancelTask = cancelTask;
            this.controlPoint = controlPoint;
            this.forceRun = forceRun;
        }

        @Override
        public void run() {
            if (this.state.compareAndSet(0, 2) && this.cancelTask != null) {
                try {
                    this.executor.execute(this.cancelTask);
                }
                catch (Exception e) {
                    RequestControllerLogger.ROOT_LOGGER.failedToCancelTask(this.cancelTask, e);
                }
            }
        }

        public boolean runRequest() {
            if (this.state.compareAndSet(0, 1)) {
                this.cancel();
                this.executor.execute(new ControlPointTask(this.task, this.controlPoint));
                return true;
            }
            return false;
        }

        boolean isQueued() {
            return this.state.get() == 0;
        }
    }

    private static final class ControlPointIdentifier {
        private final String deployment;
        private final String name;

        private ControlPointIdentifier(String deployment, String name) {
            this.deployment = deployment;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ControlPointIdentifier that = (ControlPointIdentifier)o;
            if (this.deployment != null ? !this.deployment.equals(that.deployment) : that.deployment != null) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.deployment != null ? this.deployment.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public String toString() {
            return super.toString();
        }
    }
}

