/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.ActiveMQBroker;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicDefinition;

public class JMSTopicReadAttributeHandler
extends AbstractRuntimeOnlyHandler {
    public static final JMSTopicReadAttributeHandler INSTANCE = new JMSTopicReadAttributeHandler();
    private ParametersValidator validator = new ParametersValidator();

    private JMSTopicReadAttributeHandler() {
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
    }

    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (ActiveMQActivationService.ignoreOperationIfServerNotActive(context, operation)) {
            return;
        }
        this.validator.validate(operation);
        String attributeName = operation.require("name").asString();
        String topicName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController service = context.getServiceRegistry(false).getService(serviceName);
        ActiveMQBroker broker = (ActiveMQBroker)ActiveMQBroker.class.cast(service.getValue());
        AddressControl control = (AddressControl)AddressControl.class.cast(broker.getResource("address.jms.topic." + topicName));
        if (control == null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(address);
        }
        if (CommonAttributes.MESSAGE_COUNT.getName().equals(attributeName)) {
            try {
                context.getResult().set(control.getMessageCount());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (CommonAttributes.DELIVERING_COUNT.getName().equals(attributeName)) {
            context.getResult().set(this.getDeliveringCount(control, broker));
        } else if (CommonAttributes.MESSAGES_ADDED.getName().equals(attributeName)) {
            context.getResult().set(this.getMessagesAdded(control, broker));
        } else if (JMSTopicDefinition.DURABLE_MESSAGE_COUNT.getName().equals(attributeName)) {
            context.getResult().set(this.getDurableMessageCount(control, broker));
        } else if (JMSTopicDefinition.NON_DURABLE_MESSAGE_COUNT.getName().equals(attributeName)) {
            context.getResult().set(this.getNonDurableMessageCount(control, broker));
        } else if (JMSTopicDefinition.SUBSCRIPTION_COUNT.getName().equals(attributeName)) {
            context.getResult().set(this.getSubscriptionCount(control, broker));
        } else if (JMSTopicDefinition.DURABLE_SUBSCRIPTION_COUNT.getName().equals(attributeName)) {
            context.getResult().set(this.getDurableSubscriptionCount(control, broker));
        } else if (JMSTopicDefinition.NON_DURABLE_SUBSCRIPTION_COUNT.getName().equals(attributeName)) {
            context.getResult().set(this.getNonDurableSubscriptionCount(control, broker));
        } else if (JMSTopicDefinition.TOPIC_ADDRESS.getName().equals(attributeName)) {
            context.getResult().set(control.getAddress());
        } else if (CommonAttributes.TEMPORARY.getName().equals(attributeName)) {
            context.getResult().set(false);
        } else if (CommonAttributes.PAUSED.getName().equals(attributeName)) {
            context.getResult().set(control.isPaused());
        } else {
            throw MessagingLogger.ROOT_LOGGER.unsupportedAttribute(attributeName);
        }
    }

    private int getDeliveringCount(AddressControl addressControl, ActiveMQBroker broker) {
        List<QueueControl> queues = JMSTopicReadAttributeHandler.getQueues(DurabilityType.ALL, addressControl, broker);
        int count = 0;
        for (QueueControl queue : queues) {
            count += queue.getDeliveringCount();
        }
        return count;
    }

    private long getMessagesAdded(AddressControl addressControl, ActiveMQBroker broker) {
        List<QueueControl> queues = JMSTopicReadAttributeHandler.getQueues(DurabilityType.ALL, addressControl, broker);
        long count = 0L;
        for (QueueControl queue : queues) {
            count += queue.getMessagesAdded();
        }
        return count;
    }

    private int getDurableMessageCount(AddressControl addressControl, ActiveMQBroker broker) {
        return this.getMessageCount(DurabilityType.DURABLE, addressControl, broker);
    }

    private int getNonDurableMessageCount(AddressControl addressControl, ActiveMQBroker broker) {
        return this.getMessageCount(DurabilityType.NON_DURABLE, addressControl, broker);
    }

    private int getMessageCount(DurabilityType durability, AddressControl addressControl, ActiveMQBroker broker) {
        List<QueueControl> queues = JMSTopicReadAttributeHandler.getQueues(durability, addressControl, broker);
        int count = 0;
        for (QueueControl queue : queues) {
            count = (int)((long)count + queue.getMessageCount());
        }
        return count;
    }

    public int getSubscriptionCount(AddressControl addressControl, ActiveMQBroker broker) {
        return JMSTopicReadAttributeHandler.getQueues(DurabilityType.ALL, addressControl, broker).size();
    }

    public int getDurableSubscriptionCount(AddressControl addressControl, ActiveMQBroker broker) {
        return JMSTopicReadAttributeHandler.getQueues(DurabilityType.DURABLE, addressControl, broker).size();
    }

    public int getNonDurableSubscriptionCount(AddressControl addressControl, ActiveMQBroker broker) {
        return JMSTopicReadAttributeHandler.getQueues(DurabilityType.NON_DURABLE, addressControl, broker).size();
    }

    public static List<QueueControl> getQueues(DurabilityType durability, AddressControl addressControl, ActiveMQBroker broker) {
        try {
            String[] queues;
            ArrayList<QueueControl> matchingQueues = new ArrayList<QueueControl>();
            for (String queue : queues = addressControl.getQueueNames()) {
                QueueControl coreQueueControl = (QueueControl)broker.getResource("queue." + queue);
                if (coreQueueControl == null || coreQueueControl.getName().equals(addressControl.getAddress()) || durability != DurabilityType.ALL && (durability != DurabilityType.DURABLE || !coreQueueControl.isDurable()) && (durability != DurabilityType.NON_DURABLE || coreQueueControl.isDurable())) continue;
                matchingQueues.add(coreQueueControl);
            }
            return matchingQueues;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static enum DurabilityType {
        ALL,
        DURABLE,
        NON_DURABLE;

    }
}

