/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.Locality;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.ejb.cache.timer.TimerFactory;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataFactory;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataKey;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerMetaDataKey;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.TimeoutMetaData;
import org.wildfly.clustering.ejb.timer.Timer;
import org.wildfly.clustering.ejb.timer.TimerManager;
import org.wildfly.clustering.ejb.timer.TimerMetaData;
import org.wildfly.clustering.ejb.timer.TimerRegistry;
import org.wildfly.clustering.server.infinispan.scheduler.AbstractCacheEntryScheduler;
import org.wildfly.clustering.server.local.scheduler.LocalScheduler;
import org.wildfly.clustering.server.local.scheduler.LocalSchedulerConfiguration;
import org.wildfly.clustering.server.local.scheduler.ScheduledEntries;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.security.manager.WildFlySecurityManager;

public class TimerScheduler<I, V>
extends AbstractCacheEntryScheduler<I, TimerMetaDataKey<I>, V, TimeoutMetaData> {
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory(TimerScheduler.class, WildFlySecurityManager.getClassLoaderPrivileged(TimerScheduler.class));
    private final TimerFactory<I, V> factory;

    public TimerScheduler(String name, TimerFactory<I, V> factory, TimerManager<I> manager, Supplier<Locality> locality, Duration closeTimeout, TimerRegistry<I> registry) {
        this(name, factory, manager, new AtomicReference<Scheduler<I, TimeoutMetaData>>(), locality, closeTimeout, registry, ScheduledEntries.sorted(), Executors.newSingleThreadExecutor(THREAD_FACTORY));
    }

    private TimerScheduler(String name, TimerFactory<I, V> factory, TimerManager<I> manager, AtomicReference<Scheduler<I, TimeoutMetaData>> reference, Supplier<Locality> locality, Duration closeTimeout, TimerRegistry<I> registry, ScheduledEntries<I, Instant> entries, ExecutorService executor) {
        this(name, entries, new InvokeTask<I, V>(factory, manager, reference::getPlain, locality, entries, registry, executor), closeTimeout, registry, executor, factory);
        reference.setPlain((Scheduler<I, TimeoutMetaData>)this);
    }

    private TimerScheduler(final String name, final ScheduledEntries<I, Instant> entries, final Predicate<I> invokeTask, final Duration closeTimeout, TimerRegistry<I> registry, ExecutorService executor, TimerFactory<I, V> factory) {
        this(new LocalSchedulerConfiguration<I>(){

            public String getName() {
                return name;
            }

            public ScheduledEntries<I, Instant> getScheduledEntries() {
                return entries;
            }

            public Predicate<I> getTask() {
                return invokeTask;
            }

            public ThreadFactory getThreadFactory() {
                return THREAD_FACTORY;
            }

            public Duration getCloseTimeout() {
                return closeTimeout;
            }
        }, registry, executor, factory);
    }

    private TimerScheduler(LocalSchedulerConfiguration<I> schedulerConfig, final TimerRegistry<I> registry, final ExecutorService executor, TimerFactory<I, V> factory) {
        this((Scheduler<I, Instant>)new LocalScheduler<I>(schedulerConfig){

            public void schedule(I id, Instant instant) {
                super.schedule(id, instant);
                registry.register(id);
            }

            public void cancel(I id) {
                registry.unregister(id);
                super.cancel(id);
            }

            public void close() {
                super.close();
                executor.shutdown();
            }
        }, factory);
    }

    private TimerScheduler(Scheduler<I, Instant> scheduler, TimerFactory<I, V> factory) {
        super(scheduler.map(TimeoutMetaData::getNextTimeout));
        this.factory = factory;
    }

    public void schedule(I id) {
        Object value = this.factory.getMetaDataFactory().findValue(id);
        if (value != null) {
            this.schedule(Map.entry(new InfinispanTimerMetaDataKey<I>(id), value));
        }
    }

    public void schedule(Map.Entry<TimerMetaDataKey<I>, V> entry) {
        this.scheduleValue(entry.getKey().getId(), entry.getValue());
    }

    private void scheduleValue(I id, V value) {
        this.schedule(id, this.factory.getMetaDataFactory().createImmutableTimerMetaData(value));
    }

    private static class InvokeTask<I, V>
    implements Predicate<I> {
        private final TimerFactory<I, V> factory;
        private final TimerManager<I> manager;
        private final Supplier<Locality> locality;
        private final ScheduledEntries<I, Instant> entries;
        private final TimerRegistry<I> registry;
        private final ExecutorService executor;
        private final Supplier<Scheduler<I, TimeoutMetaData>> scheduler;

        InvokeTask(TimerFactory<I, V> factory, TimerManager<I> manager, Supplier<Scheduler<I, TimeoutMetaData>> scheduler, Supplier<Locality> locality, ScheduledEntries<I, Instant> entries, TimerRegistry<I> registry, ExecutorService executor) {
            this.factory = factory;
            this.manager = manager;
            this.scheduler = scheduler;
            this.locality = locality;
            this.entries = entries;
            this.registry = registry;
            this.executor = executor;
        }

        @Override
        public boolean test(final I id) {
            final TimerFactory<I, V> factory = this.factory;
            final TimerManager<I> manager = this.manager;
            final Supplier<Locality> locality = this.locality;
            final ScheduledEntries<I, Instant> entries = this.entries;
            final TimerRegistry<I> registry = this.registry;
            final Scheduler<I, TimeoutMetaData> scheduler = this.scheduler.get();
            final InfinispanTimerMetaDataKey<I> key = new InfinispanTimerMetaDataKey<I>(id);
            if (!locality.get().isLocal(key)) {
                InfinispanEjbLogger.ROOT_LOGGER.debugf("Skipping timeout processing of non-local timer %s", id);
                return true;
            }
            Callable<Boolean> task = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    InfinispanEjbLogger.ROOT_LOGGER.debugf("Initiating timeout for timer %s", id);
                    TimerMetaDataFactory metaDataFactory = factory.getMetaDataFactory();
                    Batch batch = (Batch)manager.getBatchFactory().get();
                    try {
                        Boolean bl;
                        Object value = metaDataFactory.findValue(id);
                        if (value == null) {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("Timer not found %s", id);
                            Boolean bl2 = true;
                            return bl2;
                        }
                        TimerMetaData metaData = metaDataFactory.createTimerMetaData(id, value);
                        Optional currentTimeoutReference = metaData.getNextTimeout();
                        if (currentTimeoutReference.isEmpty()) {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("Unexpected timeout event triggered for %s", id);
                            Boolean bl3 = false;
                            return bl3;
                        }
                        Instant now = Instant.now();
                        Instant currentTimeout = (Instant)currentTimeoutReference.get();
                        if (currentTimeout.isAfter(now)) {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("Timeout for timer %s initiated prematurely @ %s", id, currentTimeout);
                            Boolean bl4 = false;
                            return bl4;
                        }
                        Optional originalLastTimeout = metaData.getLastTimeout();
                        metaData.setLastTimeout(currentTimeout);
                        Optional nextTimeout = metaData.getNextTimeout();
                        if (nextTimeout.orElse(now).isBefore(now)) {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("Skipping notification of missed timeout for timer %s @ %s", id, currentTimeout);
                        } else {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("Triggering timeout for timer %s @ %s", id, currentTimeout);
                            Timer timer = factory.createTimer(id, (ImmutableTimerMetaData)metaData, manager, scheduler);
                            try {
                                timer.invoke();
                            }
                            catch (ExecutionException e) {
                                InfinispanEjbLogger.ROOT_LOGGER.error(e.getLocalizedMessage(), e);
                            }
                            catch (RejectedExecutionException e) {
                                InfinispanEjbLogger.ROOT_LOGGER.debugf("EJB component is suspended - could not invoke timeout for timer %s", id);
                                metaData.setLastTimeout((Instant)originalLastTimeout.orElse(null));
                                batch.discard();
                                Boolean bl5 = false;
                                if (batch != null) {
                                    batch.close();
                                }
                                return bl5;
                            }
                            if (timer.isCanceled()) {
                                InfinispanEjbLogger.ROOT_LOGGER.debugf("Timeout callback canceled timer %s", id);
                                Boolean bl6 = true;
                                return bl6;
                            }
                        }
                        if (nextTimeout.isEmpty()) {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("Timer %s has expired", id);
                            registry.unregister(id);
                            factory.getMetaDataFactory().remove(id);
                            bl = true;
                            return bl;
                        }
                        if (!((Locality)locality.get()).isLocal((Object)key)) {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("Timer %s is no longer local", id);
                            bl = true;
                            return bl;
                        }
                        InfinispanEjbLogger.ROOT_LOGGER.debugf("Rescheduling timer %s for next timeout %s", id, nextTimeout.get());
                        entries.add(id, (Object)((Instant)nextTimeout.get()));
                        bl = false;
                        return bl;
                    }
                    catch (Error | RuntimeException e) {
                        batch.discard();
                        throw e;
                    }
                    finally {
                        if (batch != null) {
                            try {
                                batch.close();
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2;
                                throwable2.addSuppressed(throwable);
                            }
                        }
                    }
                }
            };
            try {
                Future<Boolean> result = this.executor.submit(task);
                return result.get();
            }
            catch (RejectedExecutionException e) {
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            catch (ExecutionException e) {
                InfinispanEjbLogger.ROOT_LOGGER.info(e.getLocalizedMessage(), e);
                return false;
            }
        }
    }
}

