/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.metamodel.mapping.DiscriminatorConverter;
import org.hibernate.metamodel.mapping.DiscriminatorType;
import org.hibernate.metamodel.mapping.EmbeddableDiscriminatorMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.AbstractDiscriminatorMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;

public class ExplicitColumnDiscriminatorMappingImpl
extends AbstractDiscriminatorMapping
implements EmbeddableDiscriminatorMapping {
    private final String name;
    private final String tableExpression;
    private final String columnName;
    private final String columnFormula;
    private final boolean isPhysical;
    private final boolean isUpdateable;
    private final String columnDefinition;
    private final String customReadExpression;
    private final Long length;
    private final Integer precision;
    private final Integer scale;

    public ExplicitColumnDiscriminatorMappingImpl(ManagedMappingType mappingType, String name, String tableExpression, String columnExpression, boolean isFormula, boolean isPhysical, boolean isUpdateable, String columnDefinition, String customReadExpression, Long length, Integer precision, Integer scale, DiscriminatorType<?> discriminatorType) {
        super(mappingType, discriminatorType, discriminatorType.getUnderlyingJdbcMapping());
        this.name = name;
        this.tableExpression = tableExpression;
        this.isPhysical = isPhysical;
        this.columnDefinition = columnDefinition;
        this.customReadExpression = customReadExpression;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        if (isFormula) {
            this.columnName = null;
            this.columnFormula = columnExpression;
            this.isUpdateable = false;
        } else {
            this.columnName = columnExpression;
            this.columnFormula = null;
            this.isUpdateable = isUpdateable;
        }
    }

    @Override
    public DiscriminatorType getMappedType() {
        return (DiscriminatorType)super.getMappedType();
    }

    @Override
    public DiscriminatorConverter<?, ?> getValueConverter() {
        return this.getMappedType().getValueConverter();
    }

    @Override
    public Expression resolveSqlExpression(NavigablePath navigablePath, JdbcMapping jdbcMappingToUse, TableGroup tableGroup, SqlAstCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(navigablePath, this.tableExpression);
        return expressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableGroup.getPrimaryTableReference(), this.getSelectionExpression(), jdbcMappingToUse), processingState -> new ColumnReference(tableReference, (SelectableMapping)this));
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public String getSelectableName() {
        return this.name;
    }

    @Override
    public String getSelectionExpression() {
        return this.columnName == null ? this.columnFormula : this.columnName;
    }

    @Override
    public String getCustomReadExpression() {
        return this.customReadExpression;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public Integer getTemporalPrecision() {
        return null;
    }

    @Override
    public boolean isFormula() {
        return this.columnFormula != null;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isInsertable() {
        return this.isPhysical;
    }

    @Override
    public boolean isUpdateable() {
        return this.isUpdateable;
    }

    @Override
    public boolean isPartitioned() {
        return false;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public boolean hasPhysicalColumn() {
        return this.isPhysical;
    }
}

