/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.addressing;

import java.util.HashSet;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AddressConfigTest
extends ActiveMQTestBase {
    protected ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Configuration configuration = this.createDefaultInVMConfig();
        this.server = this.createServer(true, configuration);
        this.server.start();
    }

    @Test
    public void persistAddressConfigTest() throws Exception {
        this.server.createQueue(QueueConfiguration.of((String)"myQueue").setAddress("myAddress"));
        this.server.stop();
        this.server.start();
        AddressInfo addressInfo = this.server.getAddressInfo(SimpleString.of((String)"myAddress"));
        Assertions.assertNotNull((Object)addressInfo);
        HashSet<RoutingType> routingTypeSet = new HashSet<RoutingType>();
        routingTypeSet.add(RoutingType.MULTICAST);
        Assertions.assertEquals(routingTypeSet, (Object)addressInfo.getRoutingTypes());
        Assertions.assertFalse((boolean)addressInfo.isPaused());
        addressInfo.setPostOffice(this.server.getPostOffice());
        addressInfo.setStorageManager(this.server.getStorageManager());
        addressInfo.pause(true);
        Assertions.assertTrue((boolean)addressInfo.isPaused());
        long id = addressInfo.getId();
        this.server.stop();
        this.server.start();
        addressInfo = this.server.getAddressInfo(SimpleString.of((String)"myAddress"));
        Assertions.assertNotNull((Object)addressInfo);
        routingTypeSet = new HashSet();
        routingTypeSet.add(RoutingType.MULTICAST);
        Assertions.assertEquals(routingTypeSet, (Object)addressInfo.getRoutingTypes());
        Assertions.assertEquals((long)id, (long)addressInfo.getId());
        Assertions.assertTrue((boolean)addressInfo.isPaused());
        addressInfo.setPostOffice(this.server.getPostOffice());
        addressInfo.setStorageManager(this.server.getStorageManager());
        addressInfo.resume();
    }
}

