/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpNoLocalFilter;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpDescribedTypePayloadTest
extends JMSClientTestSupport {
    @Test
    @Timeout(value=60L)
    public void testSendMessageWithDescribedTypeInBody() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setDescribedType(new AmqpNoLocalFilter());
        sender.send(message);
        sender.close();
        Queue queue = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        Assertions.assertNotNull((Object)received.getDescribedType());
        receiver.close();
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSendMessageWithDescribedTypeInBodyReceiveOverOpenWire() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setDescribedType(new AmqpNoLocalFilter());
        sender.send(message);
        sender.close();
        connection.close();
        Queue queue = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.getBrokerOpenWireConnectionURI());
        try (Connection jmsConnection = factory.createConnection();){
            Session jmsSession = jmsConnection.createSession(false, 1);
            jakarta.jms.Queue destination = jmsSession.createQueue(this.getName());
            MessageConsumer jmsConsumer = jmsSession.createConsumer((Destination)destination);
            jmsConnection.start();
            Message received = jmsConsumer.receive(5000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof BytesMessage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testDescribedTypeMessageRoundTrips() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setDescribedType(new AmqpNoLocalFilter());
        sender.send(message);
        sender.close();
        Queue queue = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        JmsConnectionFactory factory = new JmsConnectionFactory(this.getBrokerQpidJMSConnectionURI());
        try (Connection jmsConnection = factory.createConnection();){
            Session jmsSession = jmsConnection.createSession(false, 1);
            jakarta.jms.Queue destination = jmsSession.createQueue(this.getName());
            MessageConsumer jmsConsumer = jmsSession.createConsumer((Destination)destination);
            jmsConnection.start();
            Message received = jmsConsumer.receive(5000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertTrue((boolean)(received instanceof ObjectMessage));
            MessageProducer jmsProducer = jmsSession.createProducer((Destination)destination);
            jmsProducer.send(received);
        }
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage returned = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)returned);
        Assertions.assertNotNull((Object)returned.getDescribedType());
        receiver.close();
        connection.close();
    }
}

