/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class JMSConnectionTest
extends JMSClientTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testConnection() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
            session.createConsumer((Destination)queue);
            Queue queueView = this.getProxyToQueue(this.getQueueName());
            Wait.assertEquals((int)1, () -> ((ActiveMQServer)this.server).getConnectionCount());
            Wait.assertEquals((long)1L, () -> ((ActiveMQServer)this.server).getTotalConsumerCount());
            Assertions.assertEquals((int)1, (int)queueView.getConsumerCount());
            connection.close();
            Wait.assertEquals((int)0, () -> ((ActiveMQServer)this.server).getConnectionCount());
            Wait.assertEquals((long)0L, () -> ((ActiveMQServer)this.server).getTotalConsumerCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testClientIDsAreExclusive() throws Exception {
        Connection testConn1 = this.createConnection(false);
        Connection testConn2 = this.createConnection(false);
        try {
            testConn1.setClientID("client-id1");
            try {
                testConn1.setClientID("client-id2");
                Assertions.fail((String)"didn't get expected exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                testConn2.setClientID("client-id1");
                Assertions.fail((String)"didn't get expected exception");
            }
            catch (InvalidClientIDException invalidClientIDException) {
                // empty catch block
            }
        }
        finally {
            testConn1.close();
            testConn2.close();
        }
        try {
            testConn1 = this.createConnection(false);
            testConn2 = this.createConnection(false);
            testConn1.setClientID("client-id1");
            testConn2.setClientID("client-id2");
        }
        finally {
            testConn1.close();
            testConn2.close();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testParallelConnections() throws Exception {
        int numThreads = 40;
        ExecutorService executorService = Executors.newFixedThreadPool(40);
        for (int i = 0; i < 40; ++i) {
            executorService.execute(() -> {
                try {
                    Connection connection = this.createConnection(this.fullPass, this.fullUser);
                    connection.start();
                    connection.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            });
        }
        executorService.shutdown();
        Assertions.assertTrue((boolean)executorService.awaitTermination(30L, TimeUnit.SECONDS), (String)"executor done on time");
    }
}

