/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.clientcrash;

import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.SpawnedTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.BeforeEach;

public abstract class ClientTestBase
extends SpawnedTestBase {
    protected ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultNettyConfig();
        this.server = this.createServer(false, config);
        this.server.start();
    }

    protected void assertActiveConnections(int expectedActiveConnections) throws Exception {
        this.assertActiveConnections(expectedActiveConnections, 0L);
    }

    protected void assertActiveConnections(int expectedActiveConnections, long timeout) throws Exception {
        Wait.assertEquals((int)expectedActiveConnections, () -> ((ActiveMQServerControlImpl)this.server.getActiveMQServerControl()).getConnectionCount(), (long)timeout);
    }

    protected void assertActiveSession(int expectedActiveSession) throws Exception {
        this.assertActiveSession(expectedActiveSession, 0L);
    }

    protected void assertActiveSession(int expectedActiveSession, long timeout) throws Exception {
        Wait.assertEquals((int)expectedActiveSession, () -> this.server.getSessions().size(), (long)timeout);
    }
}

