/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQDuplicateIdException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQObjectClosedException;
import org.apache.activemq.artemis.api.core.ActiveMQTransactionOutcomeUnknownException;
import org.apache.activemq.artemis.api.core.ActiveMQTransactionRolledBackException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQSessionContext;
import org.apache.activemq.artemis.core.protocol.core.impl.ChannelImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.RemotingConnectionImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ActiveMQExceptionMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.BackupManager;
import org.apache.activemq.artemis.core.server.cluster.ClusterController;
import org.apache.activemq.artemis.core.server.cluster.ha.BackupPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicaPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicatedPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicationBackupPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicationPrimaryPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreBackupPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStorePrimaryPolicy;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.files.FileMoveManager;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.cluster.failover.DelayInterceptor;
import org.apache.activemq.artemis.tests.integration.cluster.failover.DelayInterceptor2;
import org.apache.activemq.artemis.tests.integration.cluster.failover.DelayInterceptor3;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.CountDownSessionFailureListener;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverTest
extends FailoverTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final int NUM_MESSAGES = 100;
    protected ServerLocator locator;
    protected ClientSessionFactoryInternal sf;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.getServerLocator();
    }

    protected ClientSession createSession(ClientSessionFactory sf1, boolean autoCommitSends, boolean autoCommitAcks, int ackBatchSize) throws Exception {
        return this.addClientSession(sf1.createSession(autoCommitSends, autoCommitAcks, ackBatchSize));
    }

    protected ClientSession createSession(ClientSessionFactory sf1, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.addClientSession(sf1.createSession(autoCommitSends, autoCommitAcks));
    }

    protected ClientSession createSession(ClientSessionFactory sf1) throws Exception {
        return this.addClientSession(sf1.createSession());
    }

    protected ClientSession createSession(ClientSessionFactory sf1, boolean xa, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.addClientSession(sf1.createSession(xa, autoCommitSends, autoCommitAcks));
    }

    @Test
    @Timeout(value=120L)
    public void testTimeoutOnFailover() throws Exception {
        this.locator.setCallTimeout(1000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setAckBatchSize(0).setReconnectAttempts(300).setRetryInterval(10L);
        if (this.nodeManager instanceof InVMNodeManager) {
            ((InVMNodeManager)this.nodeManager).failoverPause = 500L;
        }
        ClientSessionFactoryInternal sf1 = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = this.createSession((ClientSessionFactory)sf1, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        CountDownLatch latch = new CountDownLatch(10);
        CountDownLatch latchFailed = new CountDownLatch(1);
        Runnable r = () -> {
            for (int i = 0; i < 500; ++i) {
                ClientMessage message = session.createMessage(true);
                message.putIntProperty("counter", i);
                try {
                    producer.send((Message)message);
                    if (i >= 10) continue;
                    latch.countDown();
                    if (latch.getCount() != 0L) continue;
                    latchFailed.await(10L, TimeUnit.SECONDS);
                    continue;
                }
                catch (Exception e) {
                    try {
                        if (producer.isClosed()) continue;
                        producer.send((Message)message);
                        continue;
                    }
                    catch (ActiveMQException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS), (String)"latch released");
        this.crash(session);
        latchFailed.countDown();
        t.join(30000L);
        if (t.isAlive()) {
            t.interrupt();
            Assertions.fail((String)"Thread still alive");
        }
        Assertions.assertTrue((boolean)this.backupServer.getServer().waitForActivation(5L, TimeUnit.SECONDS));
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        for (int i = 0; i < 500; ++i) {
            ClientMessage m = consumer.receive(1000L);
            Assertions.assertNotNull((Object)m, (String)("message #=" + i));
        }
    }

    @Test
    @Timeout(value=120L)
    public void testTimeoutOnFailoverConsume() throws Exception {
        this.locator.setCallTimeout(1000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setAckBatchSize(0).setBlockOnAcknowledge(true).setReconnectAttempts(-1).setRetryInterval(10L).setAckBatchSize(0);
        if (this.nodeManager instanceof InVMNodeManager) {
            ((InVMNodeManager)this.nodeManager).failoverPause = 2000L;
        }
        ClientSessionFactoryInternal sf1 = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = this.createSession((ClientSessionFactory)sf1, true, false);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        for (int i = 0; i < 500; ++i) {
            ClientMessage message2 = session.createMessage(true);
            message2.putIntProperty("counter", i);
            producer.send((Message)message2);
        }
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch endLatch = new CountDownLatch(1);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        HashMap received = new HashMap();
        consumer.setMessageHandler(message -> {
            Integer counter = message.getIntProperty("counter");
            received.put(counter, message);
            try {
                logger.debug("acking message = id = {}, counter = {}", (Object)message.getMessageID(), (Object)message.getIntProperty("counter"));
                message.acknowledge();
                session.commit();
            }
            catch (ActiveMQException e) {
                try {
                    session.rollback();
                }
                catch (Exception e2) {
                    e.printStackTrace();
                }
                e.printStackTrace();
                return;
            }
            logger.debug("Acked counter = {}", (Object)counter);
            if (counter.equals(10)) {
                latch.countDown();
            }
            if (received.size() == 100) {
                endLatch.countDown();
            }
        });
        latch.await(10L, TimeUnit.SECONDS);
        logger.debug("crashing session");
        this.crash(session);
        Assertions.assertTrue((boolean)endLatch.await(60L, TimeUnit.SECONDS));
        session.close();
    }

    @Test
    @Timeout(value=120L)
    public void testTimeoutOnFailoverConsumeBlocked() throws Exception {
        this.locator.setCallTimeout(1000L).setBlockOnNonDurableSend(true).setConsumerWindowSize(0).setBlockOnDurableSend(true).setAckBatchSize(0).setBlockOnAcknowledge(true).setReconnectAttempts(-1).setAckBatchSize(0).setRetryInterval(10L);
        if (this.nodeManager instanceof InVMNodeManager) {
            ((InVMNodeManager)this.nodeManager).failoverPause = 200L;
        }
        ClientSessionFactoryInternal sf1 = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = this.createSession((ClientSessionFactory)sf1, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        for (int i = 0; i < 500; ++i) {
            ClientMessage message = session.createMessage(true);
            message.putIntProperty("counter", i);
            message.putBooleanProperty("end", i == 499);
            producer.send((Message)message);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch endLatch = new CountDownLatch(1);
        final ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        final HashMap received = new HashMap();
        Thread t = new Thread(){

            @Override
            public void run() {
                ClientMessage message = null;
                try {
                    while ((message = this.getMessage()) != null) {
                        Integer counter = message.getIntProperty("counter");
                        received.put(counter, message);
                        try {
                            logger.debug("acking message = id = {}, counter = {}", (Object)message.getMessageID(), (Object)message.getIntProperty("counter"));
                            message.acknowledge();
                        }
                        catch (ActiveMQException e) {
                            e.printStackTrace();
                            continue;
                        }
                        logger.debug("Acked counter = {}", (Object)counter);
                        if (counter.equals(10)) {
                            latch.countDown();
                        }
                        if (received.size() == 500) {
                            endLatch.countDown();
                        }
                        if (!message.getBooleanProperty("end").booleanValue()) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    Assertions.fail((String)("failing due to exception " + e));
                }
            }

            private ClientMessage getMessage() {
                while (true) {
                    try {
                        ClientMessage msg = consumer.receive(20000L);
                        if (msg == null) {
                            logger.debug("Returning null message on consuming");
                        }
                        return msg;
                    }
                    catch (ActiveMQObjectClosedException oce) {
                        throw new RuntimeException(oce);
                    }
                    catch (ActiveMQException ignored) {
                        ignored.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        t.start();
        latch.await(10L, TimeUnit.SECONDS);
        logger.debug("crashing session");
        this.crash(session);
        endLatch.await(60L, TimeUnit.SECONDS);
        t.join();
        Assertions.assertTrue((received.size() == 500 ? 1 : 0) != 0, (String)("received only " + received.size()));
        session.close();
    }

    @Test
    @Timeout(value=120L)
    public void testTimeoutOnFailoverTransactionCommit() throws Exception {
        this.locator.setCallTimeout(1000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setAckBatchSize(0).setReconnectAttempts(300).setRetryInterval(10L);
        if (this.nodeManager instanceof InVMNodeManager) {
            ((InVMNodeManager)this.nodeManager).failoverPause = 2000L;
        }
        ClientSessionFactoryInternal sf1 = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = this.createSession((ClientSessionFactory)sf1, true, false, false);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        final CountDownLatch connectionFailed = new CountDownLatch(1);
        session.addFailureListener(new SessionFailureListener(){

            public void beforeReconnect(ActiveMQException exception) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
                connectionFailed.countDown();
            }
        });
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session.start((Xid)xid, 0);
        for (int i = 0; i < 500; ++i) {
            ClientMessage message = session.createMessage(true);
            message.putIntProperty("counter", i);
            producer.send((Message)message);
        }
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        this.crash(true, session);
        try {
            session.commit((Xid)xid, false);
        }
        catch (XAException e) {
            Assertions.assertTrue((boolean)connectionFailed.await(10L, TimeUnit.SECONDS));
            session.commit((Xid)xid, false);
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        for (int i = 0; i < 500; ++i) {
            ClientMessage m = consumer.receive(1000L);
            Assertions.assertNotNull((Object)m);
            Assertions.assertEquals((int)i, (int)m.getIntProperty("counter"));
        }
    }

    @Test
    @Timeout(value=120L)
    public void testTimeoutOnFailoverTransactionCommitTimeoutCommunication() throws Exception {
        this.locator.setCallTimeout(1000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setAckBatchSize(0).setReconnectAttempts(300).setRetryInterval(50L);
        if (this.nodeManager instanceof InVMNodeManager) {
            ((InVMNodeManager)this.nodeManager).failoverPause = 2000L;
        }
        ClientSessionFactoryInternal sf1 = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = this.createSession((ClientSessionFactory)sf1, false, false, false);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        final CountDownLatch connectionFailed = new CountDownLatch(1);
        session.addFailureListener(new SessionFailureListener(){

            public void beforeReconnect(ActiveMQException exception) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
                connectionFailed.countDown();
            }
        });
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        for (int i = 0; i < 500; ++i) {
            ClientMessage message = session.createMessage(true);
            message.putIntProperty("counter", i);
            producer.send((Message)message);
        }
        session.commit();
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage m = null;
        for (int i = 0; i < 500; ++i) {
            m = consumer.receive(1000L);
            Assertions.assertNotNull((Object)m);
            Assertions.assertEquals((int)i, (int)m.getIntProperty("counter"));
        }
        m.acknowledge();
        this.crash(false, session);
        try {
            session.commit();
            Assertions.fail((String)"Exception expected");
        }
        catch (Exception expected) {
            expected.printStackTrace();
        }
        Thread.sleep(1000L);
        m = null;
        for (int i = 0; i < 500; ++i) {
            m = consumer.receive(1000L);
            Assertions.assertNotNull((Object)m);
            Assertions.assertEquals((int)i, (int)m.getIntProperty("counter"));
        }
        m.acknowledge();
        session.commit();
    }

    @Test
    @Timeout(value=120L)
    public void testTimeoutOnFailoverTransactionRollback() throws Exception {
        this.locator.setCallTimeout(2000L).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setAckBatchSize(0).setReconnectAttempts(300).setRetryInterval(10L);
        if (this.nodeManager instanceof InVMNodeManager) {
            ((InVMNodeManager)this.nodeManager).failoverPause = 1000L;
        }
        ClientSessionFactoryInternal sf1 = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session = this.createSession((ClientSessionFactory)sf1, true, false, false);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session.start((Xid)xid, 0);
        for (int i = 0; i < 500; ++i) {
            ClientMessage message = session.createMessage(true);
            message.putIntProperty("counter", i);
            producer.send((Message)message);
        }
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        this.crash(true, session);
        try {
            session.rollback((Xid)xid);
        }
        catch (XAException e) {
            try {
                session.rollback((Xid)xid);
            }
            catch (Exception ignored) {
                logger.trace(ignored.getMessage(), (Throwable)ignored);
            }
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage m = consumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Test
    @Timeout(value=120L)
    public void testNonTransactedWithZeroConsumerWindowSize() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setAckBatchSize(0).setReconnectAttempts(300).setRetryInterval(10L);
        this.createClientSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = session.createMessage(true);
            this.setBody(i, message2);
            message2.putIntProperty("counter", i);
            producer.send((Message)message2);
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        CountDownLatch latch = new CountDownLatch(100);
        consumer.setMessageHandler(message -> latch.countDown());
        session.start();
        this.crash(session);
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
    }

    protected void createClientSessionFactory() throws Exception {
        this.sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
    }

    @Test
    @Timeout(value=120L)
    public void testNonTransacted() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        this.crash(session);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        this.receiveDurableMessages(consumer);
        session.close();
        this.sf.close();
        Assertions.assertEquals((int)0, (int)this.sf.numSessions());
        Assertions.assertEquals((int)0, (int)this.sf.numConnections());
    }

    @Test
    @Timeout(value=60L)
    public void testFailBothRestartPrimary() throws Exception {
        ServerLocatorInternal locator = this.getServerLocator();
        locator.setReconnectAttempts(-1).setRetryInterval(10L);
        this.sf = (ClientSessionFactoryInternal)locator.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        this.crash(session);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        this.receiveDurableMessages(consumer);
        this.backupServer.getServer().fail(true);
        this.decrementActivationSequenceForForceRestartOf(this.primaryServer);
        this.primaryServer.start();
        consumer.close();
        producer.close();
        producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        this.sf.close();
        Assertions.assertEquals((int)0, (int)this.sf.numSessions());
        Assertions.assertEquals((int)0, (int)this.sf.numConnections());
    }

    @Test
    public void testFailPrimaryTooSoon() throws Exception {
        ServerLocatorInternal locator = this.getServerLocator();
        locator.setReconnectAttempts(-1);
        locator.setRetryInterval(10L);
        this.sf = (ClientSessionFactoryInternal)locator.createSessionFactory();
        this.waitForBackupConfig(this.sf);
        TransportConfiguration initialPrimary = this.getFieldFromSF(this.sf, "currentConnectorConfig");
        TransportConfiguration initialBackup = this.getFieldFromSF(this.sf, "backupConnectorConfig");
        logger.debug("initprimary: {}", (Object)initialPrimary);
        logger.debug("initback: {}", (Object)initialBackup);
        TransportConfiguration last = this.getFieldFromSF(this.sf, "connectorConfig");
        TransportConfiguration current = this.getFieldFromSF(this.sf, "currentConnectorConfig");
        logger.debug("now last: {}", (Object)last);
        logger.debug("now current: {}", (Object)current);
        Assertions.assertTrue((boolean)current.equals((Object)initialPrimary));
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        this.crash(new ClientSession[0]);
        this.createSession((ClientSessionFactory)this.sf, true, true).close();
        last = this.getFieldFromSF(this.sf, "connectorConfig");
        current = this.getFieldFromSF(this.sf, "currentConnectorConfig");
        logger.debug("now after primary crashed last: {}", (Object)last);
        logger.debug("now current: {}", (Object)current);
        Assertions.assertTrue((boolean)current.equals((Object)initialBackup));
        this.beforeRestart(this.primaryServer);
        this.adaptPrimaryConfigForReplicatedFailBack(this.primaryServer);
        this.primaryServer.getServer().start();
        Assertions.assertTrue((boolean)this.primaryServer.getServer().waitForActivation(40L, TimeUnit.SECONDS), (String)"primary initialized...");
        Wait.assertTrue(() -> ((TestableServer)this.backupServer).isStarted());
        this.primaryServer.getServer().waitForActivation(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.backupServer.isStarted());
        this.createSession((ClientSessionFactory)this.sf, true, true).close();
        last = this.getFieldFromSF(this.sf, "connectorConfig");
        current = this.getFieldFromSF(this.sf, "currentConnectorConfig");
        logger.debug("now after primary back again last: {}", (Object)last);
        logger.debug("now current: {}", (Object)current);
        Assertions.assertTrue((boolean)current.isSameParams(initialPrimary));
        this.setSFFieldValue(this.sf, "backupConnectorConfig", null);
        this.crash(new ClientSession[0]);
        this.beforeRestart(this.backupServer);
        this.createSession((ClientSessionFactory)this.sf, true, true).close();
        this.sf.close();
        Assertions.assertEquals((int)0, (int)this.sf.numSessions());
        Assertions.assertEquals((int)0, (int)this.sf.numConnections());
    }

    protected void waitForBackupConfig(ClientSessionFactoryInternal sf) throws NoSuchFieldException, IllegalAccessException, InterruptedException {
        TransportConfiguration initialBackup = this.getFieldFromSF(sf, "backupConnectorConfig");
        for (int cnt = 50; initialBackup == null && cnt > 0; --cnt) {
            Thread.sleep(200L);
            initialBackup = this.getFieldFromSF(sf, "backupConnectorConfig");
        }
    }

    protected void setSFFieldValue(ClientSessionFactoryInternal sf, String tcName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field tcField = ClientSessionFactoryImpl.class.getDeclaredField(tcName);
        tcField.setAccessible(true);
        tcField.set(sf, value);
    }

    protected TransportConfiguration getFieldFromSF(ClientSessionFactoryInternal sf, String tcName) throws NoSuchFieldException, IllegalAccessException {
        Field tcField = ClientSessionFactoryImpl.class.getDeclaredField(tcName);
        tcField.setAccessible(true);
        return (TransportConfiguration)tcField.get(sf);
    }

    @Test
    @Timeout(value=120L)
    public void testFailBack() throws Exception {
        boolean doFailBack = true;
        HAPolicy haPolicy = this.backupServer.getServer().getHAPolicy();
        if (haPolicy instanceof ReplicaPolicy) {
            ((ReplicaPolicy)haPolicy).setMaxSavedReplicatedJournalsSize(1);
        }
        this.simpleFailover(haPolicy instanceof ReplicaPolicy || haPolicy instanceof ReplicationBackupPolicy, doFailBack);
    }

    @Test
    @Timeout(value=120L)
    public void testFailBackPrimaryRestartsBackupIsGone() throws Exception {
        boolean replication;
        this.createSessionFactory();
        ClientSession session = this.createSessionAndQueue();
        ClientProducer producer = this.addClientProducer(session.createProducer(FailoverTestBase.ADDRESS));
        this.sendMessages(session, producer, 100);
        producer.close();
        session.commit();
        SimpleString primaryId = this.primaryServer.getServer().getNodeID();
        this.crash(session);
        session.start();
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(FailoverTestBase.ADDRESS));
        this.receiveMessages(consumer);
        this.assertNoMoreMessages(consumer);
        consumer.close();
        session.commit();
        Assertions.assertEquals((Object)primaryId, (Object)this.backupServer.getServer().getNodeID(), (String)"backup must be running with the same nodeID");
        this.sf.close();
        this.backupServer.crash(new ClientSession[0]);
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)this.backupServer.isStarted(), (String)"backup is not running");
        boolean isBackup = this.primaryServer.getServer().getHAPolicy() instanceof BackupPolicy || this.primaryServer.getServer().getHAPolicy() instanceof ReplicationBackupPolicy;
        Assertions.assertFalse((boolean)isBackup, (String)"must NOT be a backup");
        this.adaptPrimaryConfigForReplicatedFailBack(this.primaryServer);
        this.beforeRestart(this.primaryServer);
        this.decrementActivationSequenceForForceRestartOf(this.primaryServer);
        this.primaryServer.start();
        Assertions.assertTrue((boolean)this.primaryServer.getServer().waitForActivation(15L, TimeUnit.SECONDS), (String)"primary initialized...");
        this.sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, false, false);
        session2.start();
        ClientConsumer consumer2 = session2.createConsumer(FailoverTestBase.ADDRESS);
        boolean bl = replication = this.primaryServer.getServer().getHAPolicy() instanceof ReplicatedPolicy || this.primaryServer.getServer().getHAPolicy() instanceof ReplicationPrimaryPolicy;
        if (replication) {
            this.receiveMessages(consumer2, 0, 100, true);
        }
        this.assertNoMoreMessages(consumer2);
        session2.commit();
    }

    @Test
    @Timeout(value=120L)
    public void testSimpleFailover() throws Exception {
        HAPolicy haPolicy = this.backupServer.getServer().getHAPolicy();
        this.simpleFailover(haPolicy instanceof ReplicaPolicy || haPolicy instanceof ReplicationBackupPolicy, false);
    }

    @Test
    @Timeout(value=120L)
    public void testWithoutUsingTheBackup() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSessionAndQueue();
        ClientProducer producer = this.addClientProducer(session.createProducer(FailoverTestBase.ADDRESS));
        this.sendMessages(session, producer, 100);
        producer.close();
        session.commit();
        this.backupServer.stop();
        this.backupServer.start();
        FailoverTest.waitForRemoteBackupSynchronization(this.backupServer.getServer());
        session.start();
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(FailoverTestBase.ADDRESS));
        this.receiveMessages(consumer);
        this.assertNoMoreMessages(consumer);
        consumer.close();
        session.commit();
        session.start();
        producer = this.addClientProducer(session.createProducer(FailoverTestBase.ADDRESS));
        this.sendMessages(session, producer, 100);
        producer.close();
        session.commit();
        this.backupServer.stop();
        this.beforeRestart(this.backupServer);
        this.backupServer.start();
        FailoverTest.waitForRemoteBackupSynchronization(this.backupServer.getServer());
        this.backupServer.stop();
        this.primaryServer.stop();
        this.beforeRestart(this.primaryServer);
        this.primaryServer.start();
        this.primaryServer.getServer().waitForActivation(10L, TimeUnit.SECONDS);
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, false, false);
        session2.start();
        ClientConsumer consumer2 = session2.createConsumer(FailoverTestBase.ADDRESS);
        this.receiveMessages(consumer2, 0, 100, true);
        this.assertNoMoreMessages(consumer2);
        session2.commit();
    }

    private void simpleFailover(boolean isReplicated, boolean doFailBack) throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSessionAndQueue();
        ClientProducer producer = this.addClientProducer(session.createProducer(FailoverTestBase.ADDRESS));
        this.sendMessages(session, producer, 100);
        producer.close();
        session.commit();
        SimpleString primaryId = this.primaryServer.getServer().getNodeID();
        this.crash(session);
        session.start();
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(FailoverTestBase.ADDRESS));
        this.receiveMessages(consumer);
        this.assertNoMoreMessages(consumer);
        consumer.close();
        producer = this.addClientProducer(session.createProducer(FailoverTestBase.ADDRESS));
        this.sendMessages(session, producer, 100);
        producer.close();
        session.commit();
        Assertions.assertEquals((Object)primaryId, (Object)this.backupServer.getServer().getNodeID(), (String)"backup must be running with the same nodeID");
        if (doFailBack) {
            Assertions.assertFalse((boolean)this.primaryServer.getServer().getHAPolicy().isBackup(), (String)"must NOT be a backup");
            this.adaptPrimaryConfigForReplicatedFailBack(this.primaryServer);
            this.beforeRestart(this.primaryServer);
            this.primaryServer.start();
            Assertions.assertTrue((boolean)this.primaryServer.getServer().waitForActivation(40L, TimeUnit.SECONDS), (String)"primary initialized...");
            if (isReplicated) {
                Wait.assertTrue(() -> this.backupServer.getServer().getHAPolicy().isBackup());
                Wait.assertTrue(() -> ((TestableServer)this.backupServer).isStarted());
                Wait.assertTrue(() -> ((ActiveMQServer)this.backupServer.getServer()).isReplicaSync());
            } else {
                Wait.assertTrue(() -> ((TestableServer)this.backupServer).isStarted());
                this.backupServer.getServer().waitForActivation(5L, TimeUnit.SECONDS);
                Assertions.assertTrue((boolean)this.backupServer.isStarted());
            }
            if (isReplicated) {
                FileMoveManager moveManager = new FileMoveManager(this.backupServer.getServer().getConfiguration().getJournalLocation(), 0, new String[0]);
                Wait.assertTrue(() -> moveManager.getNumberOfFolders() <= 2);
            }
        } else {
            this.backupServer.stop();
            this.beforeRestart(this.backupServer);
            this.backupServer.start();
            Assertions.assertTrue((boolean)this.backupServer.getServer().waitForActivation(10L, TimeUnit.SECONDS));
        }
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, false, false);
        session2.start();
        ClientConsumer consumer2 = session2.createConsumer(FailoverTestBase.ADDRESS);
        this.receiveMessages(consumer2, 0, 100, true);
        this.assertNoMoreMessages(consumer2);
        session2.commit();
    }

    private void assertNoMoreMessages(ClientConsumer consumer) throws ActiveMQException {
        ClientMessage msg = consumer.receiveImmediate();
        Assertions.assertNull((Object)msg, (String)("there should be no more messages to receive! " + msg));
    }

    protected void createSessionFactory() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
    }

    @Test
    @Timeout(value=120L)
    public void testConsumeTransacted() throws Exception {
        ClientMessage message;
        this.createSessionFactory();
        ClientSession session = this.createSessionAndQueue();
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        int numMessages = 10;
        this.sendMessages(session, producer, 10);
        session.commit();
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        for (int i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message, (String)("Just crashed? " + (i == 6) + " " + i));
            message.acknowledge();
            if (i != 5) continue;
            this.crash(session);
        }
        try {
            session.commit();
            Assertions.fail((String)"session must have rolled back on failover");
        }
        catch (ActiveMQTransactionRolledBackException i) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        consumer.close();
        consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        for (int i = 0; i < 10; ++i) {
            message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message, (String)("Expecting message #" + i));
            message.acknowledge();
        }
        session.commit();
        session.close();
    }

    protected ClientSession createSessionAndQueue() throws Exception {
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, false, false);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        return session;
    }

    @Test
    @Timeout(value=120L)
    public void testFailoverOnInitialConnection() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        this.crash(new ClientSession[0]);
        ClientSession session = this.createSession((ClientSessionFactory)this.sf);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessages(session, producer, 100);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        this.receiveMessages(consumer);
        session.close();
    }

    @Test
    @Timeout(value=120L)
    public void testTransactedMessagesSentSoRollback() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSessionAndQueue();
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        this.crash(session);
        Assertions.assertTrue((boolean)session.isRollbackOnly());
        try {
            session.commit();
            Assertions.fail((String)"Should throw exception");
        }
        catch (ActiveMQTransactionRolledBackException activeMQTransactionRolledBackException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage message = consumer.receiveImmediate();
        Assertions.assertNull((Object)message, (String)("message should be null! Was: " + message));
        session.close();
    }

    @Test
    @Timeout(value=120L)
    public void testTransactedMessagesSentSoRollbackAndContinueWork() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSessionAndQueue();
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        this.crash(session);
        Assertions.assertTrue((boolean)session.isRollbackOnly());
        try {
            session.commit();
            Assertions.fail((String)"Should throw exception");
        }
        catch (ActiveMQTransactionRolledBackException activeMQTransactionRolledBackException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        ClientMessage message = session.createMessage(false);
        int counter = RandomUtil.randomInt();
        message.putIntProperty("counter", counter);
        producer.send((Message)message);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        message = consumer.receive(1000L);
        Assertions.assertNotNull((Object)message, (String)"expecting a message");
        Assertions.assertEquals((int)counter, (int)message.getIntProperty("counter"));
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testTransactedMessagesNotSentSoNoRollback() throws Exception {
        try {
            this.createSessionFactory();
            ClientSession session = this.createSessionAndQueue();
            ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
            this.sendMessagesSomeDurable(session, producer);
            session.commit();
            this.crash(session);
            Assertions.assertFalse((boolean)session.isRollbackOnly());
            session.commit();
            ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
            session.start();
            this.receiveDurableMessages(consumer);
            Assertions.assertNull((Object)consumer.receiveImmediate());
            session.commit();
            session.close();
        }
        finally {
            try {
                this.primaryServer.getServer().stop();
            }
            catch (Throwable throwable) {}
            try {
                this.backupServer.getServer().stop();
            }
            catch (Throwable throwable) {}
        }
    }

    @Test
    @Timeout(value=120L)
    public void testTransactedMessagesWithConsumerStartedBeforeFailover() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSessionAndQueue();
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        session.commit();
        Assertions.assertFalse((boolean)session.isRollbackOnly());
        this.crash(session);
        session.commit();
        session.close();
        session = this.createSession((ClientSessionFactory)this.sf, false, false);
        consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        this.receiveDurableMessages(consumer);
        Assertions.assertNull((Object)consumer.receiveImmediate());
        session.commit();
    }

    @Test
    @Timeout(value=120L)
    public void testTransactedMessagesConsumedSoRollback() throws Exception {
        this.createSessionFactory();
        ClientSession session1 = this.createSessionAndQueue();
        ClientProducer producer = session1.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session1, producer);
        session1.commit();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, false, false);
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        this.receiveMessages(consumer);
        this.crash(session2);
        Assertions.assertTrue((boolean)session2.isRollbackOnly());
        try {
            session2.commit();
            Assertions.fail((String)"Should throw exception");
        }
        catch (ActiveMQTransactionRolledBackException activeMQTransactionRolledBackException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    @Test
    @Timeout(value=120L)
    public void testTransactedMessagesNotConsumedSoNoRollback() throws Exception {
        this.createSessionFactory();
        ClientSession session1 = this.createSessionAndQueue();
        ClientProducer producer = session1.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessages(session1, producer, 100);
        session1.commit();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, false, false);
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        this.receiveMessages(consumer, 0, 50, true);
        session2.commit();
        consumer.close();
        this.crash(session2);
        Assertions.assertFalse((boolean)session2.isRollbackOnly());
        consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        for (int i = 50; i < 100; ++i) {
            ClientMessage message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message, (String)("expecting message " + i));
            this.assertMessageBody(i, message);
            Assertions.assertEquals((int)i, (int)message.getIntProperty("counter"));
            message.acknowledge();
        }
        session2.commit();
        Assertions.assertNull((Object)consumer.receiveImmediate());
    }

    @Test
    @Timeout(value=120L)
    public void testXAMessagesSentSoRollbackOnEnd() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        session.start((Xid)xid, 0);
        this.sendMessagesSomeDurable(session, producer);
        this.crash(session);
        try {
            session.end((Xid)xid, 0x4000000);
            Assertions.fail((String)"Should throw exception");
        }
        catch (XAException e) {
            Assertions.assertEquals((int)-7, (int)e.errorCode);
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage message = consumer.receiveImmediate();
        Assertions.assertNull((Object)message);
    }

    @Test
    @Timeout(value=120L)
    public void testXAMessagesSentSoRollbackOnEnd2() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        session.start((Xid)xid, 0);
        this.crash(session);
        producer.send((Message)this.createMessage(session, 1, true));
        try {
            session.end((Xid)xid, 0x4000000);
            Assertions.fail((String)"Should throw exception");
        }
        catch (XAException xAException) {
            // empty catch block
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage message = consumer.receiveImmediate();
        Assertions.assertNull((Object)message);
    }

    @Test
    @Timeout(value=120L)
    public void testXAMessagesSentSoRollbackOnPrepare() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        session.start((Xid)xid, 0);
        this.sendMessagesSomeDurable(session, producer);
        session.end((Xid)xid, 0x4000000);
        this.crash(session);
        try {
            session.prepare((Xid)xid);
            Assertions.fail((String)"Should throw exception");
        }
        catch (XAException e) {
            Assertions.assertEquals((int)-7, (int)e.errorCode);
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage message = consumer.receiveImmediate();
        Assertions.assertNull((Object)message);
        producer.close();
        consumer.close();
    }

    @Test
    @Timeout(value=120L)
    public void testXAMessagesSentSoRollbackOnCommit() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        session.start((Xid)xid, 0);
        this.sendMessagesSomeDurable(session, producer);
        session.end((Xid)xid, 0x4000000);
        this.crash(session);
        try {
            session.commit((Xid)xid, false);
            Assertions.fail((String)"Should throw exception");
        }
        catch (XAException e) {
            Assertions.assertEquals((int)-4, (int)e.errorCode);
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage message = consumer.receiveImmediate();
        Assertions.assertNull((Object)message);
    }

    @Test
    @Timeout(value=120L)
    public void testXAMessagesNotSentSoNoRollbackOnCommit() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        session.start((Xid)xid, 0);
        this.sendMessagesSomeDurable(session, producer);
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        session.commit((Xid)xid, false);
        this.crash(session);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        XidImpl xid2 = new XidImpl("tfytftyf".getBytes(), 54654, "iohiuohiuhgiu".getBytes());
        session.start((Xid)xid2, 0);
        this.receiveDurableMessages(consumer);
        session.end((Xid)xid2, 0x4000000);
        session.prepare((Xid)xid2);
        session.commit((Xid)xid2, false);
    }

    @Test
    @Timeout(value=120L)
    public void testXAMessagesConsumedSoRollbackOnEnd() throws Exception {
        this.createSessionFactory();
        ClientSession session1 = this.createSessionAndQueue();
        ClientProducer producer = session1.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session1, producer);
        session1.commit();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session2.start((Xid)xid, 0);
        this.receiveMessages(consumer);
        this.crash(session2);
        try {
            session2.end((Xid)xid, 0x4000000);
            Assertions.fail((String)"Should throw exception");
        }
        catch (XAException e) {
            Assertions.assertEquals((int)-7, (int)e.errorCode);
        }
    }

    @Test
    @Timeout(value=120L)
    public void testXAMessagesConsumedSoRollbackOnEnd2() throws Exception {
        this.createSessionFactory();
        ClientSession session1 = this.createSessionAndQueue();
        ClientProducer producer = session1.createProducer(FailoverTestBase.ADDRESS);
        for (int i = 0; i < 100; ++i) {
            producer.send((Message)this.createMessage(session1, i, true));
        }
        session1.commit();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session2.start((Xid)xid, 0);
        this.crash(session2);
        this.receiveMessages(consumer);
        try {
            session2.end((Xid)xid, 0x4000000);
            Assertions.fail((String)"Should throw exception");
        }
        catch (XAException xAException) {
            // empty catch block
        }
        this.receiveMessages(consumer);
    }

    @Test
    @Timeout(value=120L)
    public void testXAMessagesConsumedSoRollbackOnPrepare() throws Exception {
        this.createSessionFactory();
        ClientSession session1 = this.createSessionAndQueue();
        ClientProducer producer = session1.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session1, producer);
        session1.commit();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session2.start((Xid)xid, 0);
        this.receiveMessages(consumer);
        session2.end((Xid)xid, 0x4000000);
        this.crash(session2);
        try {
            session2.prepare((Xid)xid);
            Assertions.fail((String)"Should throw exception");
        }
        catch (XAException e) {
            Assertions.assertEquals((int)-7, (int)e.errorCode);
        }
    }

    @Test
    @Timeout(value=120L)
    public void testXAMessagesConsumedSoRollbackOnCommit() throws Exception {
        this.createSessionFactory();
        ClientSession session1 = this.createSessionAndQueue();
        ClientProducer producer = session1.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session1, producer);
        session1.commit();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, true, false, false);
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        XidImpl xid = new XidImpl("uhuhuhu".getBytes(), 126512, "auhsduashd".getBytes());
        session2.start((Xid)xid, 0);
        this.receiveMessages(consumer);
        session2.end((Xid)xid, 0x4000000);
        this.crash(session2);
        try {
            session2.commit((Xid)xid, false);
            Assertions.fail((String)"Should throw exception");
        }
        catch (XAException e) {
            Assertions.assertEquals((int)-4, (int)e.errorCode);
        }
        session1.close();
        session2.close();
    }

    @Test
    @Timeout(value=120L)
    public void testCreateNewFactoryAfterFailover() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        this.crash(true, session);
        session.close();
        long timeout = System.currentTimeMillis() + 5000L;
        while (timeout > System.currentTimeMillis()) {
            try {
                this.createClientSessionFactory();
                break;
            }
            catch (Exception e) {
                Thread.sleep(100L);
            }
        }
        session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
    }

    @Test
    @Timeout(value=120L)
    public void testFailoverMultipleSessionsWithConsumers() throws Exception {
        this.createSessionFactory();
        int numSessions = 5;
        int numConsumersPerSession = 5;
        HashMap sessionConsumerMap = new HashMap();
        for (int i = 0; i < 5; ++i) {
            ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
            ArrayList<ClientConsumer> consumers = new ArrayList<ClientConsumer>();
            for (int j = 0; j < 5; ++j) {
                SimpleString queueName = SimpleString.of((String)("queue" + i + "-" + j));
                session.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(FailoverTestBase.ADDRESS));
                ClientConsumer consumer = session.createConsumer(queueName);
                consumers.add(consumer);
            }
            sessionConsumerMap.put(session, consumers);
        }
        ClientSession sendSession = this.createSession((ClientSessionFactory)this.sf, true, true);
        ClientProducer producer = sendSession.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessages(sendSession, producer, 100);
        Set sessionSet = sessionConsumerMap.keySet();
        ClientSession[] sessions = new ClientSession[sessionSet.size()];
        sessionSet.toArray(sessions);
        this.crash(sessions);
        for (ClientSession session : sessionConsumerMap.keySet()) {
            session.start();
        }
        for (List consumerList : sessionConsumerMap.values()) {
            for (ClientConsumer consumer : consumerList) {
                this.receiveMessages(consumer);
            }
        }
    }

    @Test
    @Timeout(value=120L)
    public void testFailWithBrowser() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS, true);
        session.start();
        this.receiveMessages(consumer, 0, 100, false);
        this.crash(session);
        this.receiveDurableMessages(consumer);
    }

    protected void sendMessagesSomeDurable(ClientSession session, ClientProducer producer) throws Exception {
        for (int i = 0; i < 100; ++i) {
            producer.send((Message)this.createMessage(session, i, this.isDurable(i)));
        }
    }

    @Test
    @Timeout(value=120L)
    public void testFailThenReceiveMoreMessagesAfterFailover() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message);
            this.assertMessageBody(i, message);
            Assertions.assertEquals((int)i, (int)message.getIntProperty("counter"));
        }
        this.crash(session);
        this.receiveDurableMessages(consumer);
    }

    protected void receiveDurableMessages(ClientConsumer consumer) throws ActiveMQException {
        ClientMessage repeatMessage = null;
        for (int i = 0; i < 100; ++i) {
            int msgInternalCounter;
            ClientMessage message;
            if (repeatMessage != null) {
                message = repeatMessage;
                repeatMessage = null;
            } else {
                message = consumer.receive(50L);
            }
            if (message != null && (msgInternalCounter = message.getIntProperty("counter").intValue()) == i + 1) {
                Assertions.assertFalse((boolean)this.isDurable(i), (String)("a message on counter=" + i + " was expected"));
                repeatMessage = message;
                continue;
            }
            if (this.isDurable(i)) {
                Assertions.assertNotNull((Object)message);
            }
            if (message == null) continue;
            this.assertMessageBody(i, message);
            Assertions.assertEquals((int)i, (int)message.getIntProperty("counter"));
            message.acknowledge();
        }
    }

    private boolean isDurable(int i) {
        return i % 2 == 0;
    }

    @Test
    @Timeout(value=120L)
    public void testFailThenReceiveMoreMessagesAfterFailover2() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true, 0);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessagesSomeDurable(session, producer);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        this.receiveMessages(consumer);
        this.crash(session);
        for (int i = 100; i < 200; ++i) {
            producer.send((Message)this.createMessage(session, i, this.isDurable(i)));
        }
        this.receiveMessages(consumer, 100, 200, true);
    }

    protected void receiveMessages(ClientConsumer consumer) throws ActiveMQException {
        this.receiveMessages(consumer, 0, 100, true);
    }

    @Test
    @Timeout(value=120L)
    public void testSimpleSendAfterFailoverDurableTemporary() throws Exception {
        this.doSimpleSendAfterFailover(true, true);
    }

    @Test
    @Timeout(value=120L)
    public void testSimpleSendAfterFailoverNonDurableTemporary() throws Exception {
        this.doSimpleSendAfterFailover(false, true);
    }

    @Test
    @Timeout(value=120L)
    public void testSimpleSendAfterFailoverDurableNonTemporary() throws Exception {
        this.doSimpleSendAfterFailover(true, false);
    }

    @Test
    @Timeout(value=120L)
    public void testSimpleSendAfterFailoverNonDurableNonTemporary() throws Exception {
        this.doSimpleSendAfterFailover(false, false);
    }

    private void doSimpleSendAfterFailover(boolean durable, boolean temporary) throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true, 0);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS).setDurable(Boolean.valueOf(durable && !temporary)).setTemporary(Boolean.valueOf(temporary)));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        this.crash(session);
        this.sendMessagesSomeDurable(session, producer);
        this.receiveMessages(consumer);
    }

    @Test
    @Timeout(value=120L)
    public void testMultipleSessionFailover() throws Exception {
        String address = "TEST";
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        ClientSession session1 = this.createSession((ClientSessionFactory)this.sf, true, true, 0);
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, true, true, 0);
        this.backupServer.addInterceptor(new Interceptor(){
            private int index = 0;

            public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
                if (packet.getType() == 30) {
                    ++this.index;
                    if (this.index == 2 || this.index == 3) {
                        Channel sessionChannel = ((RemotingConnectionImpl)connection).getChannel(ChannelImpl.CHANNEL_ID.SESSION.id, -1);
                        sessionChannel.send((Packet)new ActiveMQExceptionMessage((ActiveMQException)new ActiveMQInternalErrorException()));
                        return false;
                    }
                }
                return true;
            }
        });
        session1.start();
        session2.start();
        this.crash(session1, session2);
        session1.createQueue(QueueConfiguration.of((String)"TEST").setAddress("TEST"));
        ClientProducer clientProducer = session1.createProducer("TEST");
        clientProducer.send((Message)session1.createMessage(false));
        ClientConsumer clientConsumer = session2.createConsumer("TEST");
        ClientMessage message = clientConsumer.receive(3000L);
        Assertions.assertNotNull((Object)message);
    }

    @Test
    @Timeout(value=120L)
    public void testChannelStateDuringFailover() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        int reconnectFailures = 3;
        AtomicInteger reconnectRetries = new AtomicInteger(0);
        AtomicBoolean channelLockedDuringFailover = new AtomicBoolean(true);
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true, 0);
        this.backupServer.addInterceptor((packet, connection) -> {
            if (packet.getType() == 30) {
                if (reconnectRetries.getAndIncrement() < 3) {
                    Channel sessionChannel = ((RemotingConnectionImpl)connection).getChannel(ChannelImpl.CHANNEL_ID.SESSION.id, -1);
                    sessionChannel.send((Packet)new ActiveMQExceptionMessage((ActiveMQException)new ActiveMQInternalErrorException()));
                    return false;
                }
                ActiveMQSessionContext sessionContext = (ActiveMQSessionContext)((ClientSessionInternal)session).getSessionContext();
                channelLockedDuringFailover.compareAndSet(true, sessionContext.getSessionChannel().isLocked());
            }
            return true;
        });
        session.start();
        this.crash(session);
        Assertions.assertTrue((boolean)channelLockedDuringFailover.get());
        Assertions.assertEquals((int)4, (int)reconnectRetries.get());
    }

    @Test
    @Timeout(value=120L)
    public void testForceBlockingReturn() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.createClientSessionFactory();
        DelayInterceptor interceptor = new DelayInterceptor();
        this.primaryServer.getServer().getRemotingService().addIncomingInterceptor((BaseInterceptor)interceptor);
        final ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true, 0);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        final ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        class Sender
        extends Thread {
            volatile ActiveMQException e;

            Sender() {
            }

            @Override
            public void run() {
                ClientMessage message = session.createMessage(true);
                message.getBodyBuffer().writeString("message");
                try {
                    producer.send((Message)message);
                }
                catch (ActiveMQException e1) {
                    this.e = e1;
                }
            }
        }
        Sender sender = new Sender();
        sender.start();
        Assertions.assertTrue((boolean)interceptor.await());
        this.crash(session);
        sender.join();
        Assertions.assertNotNull((Object)((Object)sender.e));
        Assertions.assertNotNull((Object)sender.e.getCause());
        Assertions.assertEquals((Object)sender.e.getType(), (Object)ActiveMQExceptionType.UNBLOCKED);
        Assertions.assertEquals((Object)((ActiveMQException)sender.e.getCause()).getType(), (Object)ActiveMQExceptionType.DISCONNECTED);
        session.close();
    }

    @Test
    @Timeout(value=120L)
    public void testCommitOccurredUnblockedAndResendNoDuplicates() throws Exception {
        ClientMessage message;
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(300).setRetryInterval(100L).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        final ClientSession session = this.createSession((ClientSessionFactory)this.sf, false, false);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        String txID = "my-tx-id";
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = session.createMessage(true);
            if (i == 0) {
                message2.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, SimpleString.of((String)txID));
            }
            this.setBody(i, message2);
            message2.putIntProperty("counter", i);
            producer.send((Message)message2);
        }
        class Committer
        extends Thread {
            DelayInterceptor2 interceptor = new DelayInterceptor2();
            volatile boolean failed = true;

            Committer() {
            }

            @Override
            public void run() {
                try {
                    FailoverTest.this.sf.getServerLocator().addIncomingInterceptor((Interceptor)this.interceptor);
                    session.commit();
                }
                catch (ActiveMQTransactionRolledBackException trbe) {
                    FailoverTest.this.sf.getServerLocator().removeIncomingInterceptor((Interceptor)this.interceptor);
                    try {
                        session.commit();
                        this.failed = false;
                    }
                    catch (ActiveMQException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                catch (ActiveMQTransactionOutcomeUnknownException toue) {
                    FailoverTest.this.sf.getServerLocator().removeIncomingInterceptor((Interceptor)this.interceptor);
                    try {
                        session.commit();
                        this.failed = false;
                    }
                    catch (ActiveMQException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                catch (ActiveMQException activeMQException) {
                    // empty catch block
                }
            }
        }
        Committer committer = new Committer();
        committer.start();
        Assertions.assertTrue((boolean)committer.interceptor.await());
        this.crash(session);
        committer.join();
        Assertions.assertFalse((boolean)committer.failed, (String)"second attempt succeed?");
        session.close();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, false, false);
        producer = session2.createProducer(FailoverTestBase.ADDRESS);
        for (int i = 0; i < 100; ++i) {
            message = session2.createMessage(true);
            if (i == 0) {
                message.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, SimpleString.of((String)txID));
            }
            this.setBody(i, message);
            message.putIntProperty("counter", i);
            producer.send((Message)message);
        }
        try {
            session2.commit();
            Assertions.fail((String)"expecting DUPLICATE_ID_REJECTED exception");
        }
        catch (ActiveMQDuplicateIdException i) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        this.receiveMessages(consumer);
        message = consumer.receiveImmediate();
        Assertions.assertNull((Object)message);
    }

    @Test
    @Timeout(value=120L)
    public void testCommitDidNotOccurUnblockedAndResend() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        final ClientSession session = this.createSession((ClientSessionFactory)this.sf, false, false);
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessages(session, producer, 100);
        class Committer
        extends Thread {
            volatile boolean failed = true;

            Committer() {
            }

            @Override
            public void run() {
                DelayInterceptor3 interceptor = new DelayInterceptor3();
                try {
                    FailoverTest.this.primaryServer.addInterceptor(interceptor);
                    session.commit();
                }
                catch (ActiveMQTransactionRolledBackException trbe) {
                    FailoverTest.this.primaryServer.removeInterceptor(interceptor);
                    try {
                        session.commit();
                        this.failed = false;
                    }
                    catch (ActiveMQException activeMQException) {}
                }
                catch (ActiveMQTransactionOutcomeUnknownException toue) {
                    FailoverTest.this.primaryServer.removeInterceptor(interceptor);
                    try {
                        session.commit();
                        this.failed = false;
                    }
                    catch (ActiveMQException activeMQException) {}
                }
                catch (ActiveMQException activeMQException) {
                    // empty catch block
                }
            }
        }
        Committer committer = new Committer();
        committer.start();
        this.crash(session);
        committer.join();
        Assertions.assertFalse((boolean)committer.failed, (String)"commiter failed should be false");
        session.close();
        ClientSession session2 = this.createSession((ClientSessionFactory)this.sf, false, false);
        producer = session2.createProducer(FailoverTestBase.ADDRESS);
        this.sendMessages(session2, producer, 100);
        session2.commit();
        ClientConsumer consumer = session2.createConsumer(FailoverTestBase.ADDRESS);
        session2.start();
        this.receiveMessages(consumer);
        ClientMessage message = consumer.receiveImmediate();
        Assertions.assertNull((Object)message, (String)"expecting null message");
    }

    @Test
    @Timeout(value=120L)
    public void testBackupServerNotRemoved() throws Exception {
        if (!(this.backupServer.getServer().getHAPolicy() instanceof SharedStoreBackupPolicy)) {
            return;
        }
        this.createSessionFactory();
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        CountDownSessionFailureListener listener = new CountDownSessionFailureListener(session);
        session.addFailureListener((SessionFailureListener)listener);
        this.backupServer.stop();
        this.primaryServer.crash(new ClientSession[0]);
        this.beforeRestart(this.backupServer);
        this.backupServer.start();
        Assertions.assertTrue((boolean)listener.getLatch().await(5L, TimeUnit.SECONDS), (String)"session failure listener");
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        ClientMessage message = session.createMessage(true);
        this.setBody(0, message);
        producer.send((Message)message);
    }

    @Test
    @Timeout(value=120L)
    public void testPrimaryAndBackupPrimaryComesBack() throws Exception {
        this.createSessionFactory();
        CountDownLatch latch = new CountDownLatch(1);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        session.addFailureListener((SessionFailureListener)new CountDownSessionFailureListener(latch, session));
        this.backupServer.stop();
        this.primaryServer.crash(new ClientSession[0]);
        this.beforeRestart(this.primaryServer);
        this.beforeRestart(this.primaryServer);
        this.primaryServer.start();
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        ClientMessage message = session.createMessage(true);
        this.setBody(0, message);
        producer.send((Message)message);
    }

    @Test
    @Timeout(value=120L)
    public void testPrimaryAndBackupPrimaryComesBackNewFactory() throws Exception {
        this.createSessionFactory();
        CountDownLatch latch = new CountDownLatch(1);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        session.addFailureListener((SessionFailureListener)new CountDownSessionFailureListener(latch, session));
        this.backupServer.stop();
        this.primaryServer.crash(new ClientSession[0]);
        this.beforeRestart(this.primaryServer);
        this.primaryServer.start();
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        ClientMessage message = session.createMessage(true);
        this.setBody(0, message);
        producer.send((Message)message);
        session.close();
        this.sf.close();
        this.createClientSessionFactory();
        session = this.createSession((ClientSessionFactory)this.sf);
        ClientConsumer cc = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage cm = cc.receive(5000L);
        Assertions.assertNotNull((Object)cm);
        Assertions.assertEquals((Object)"message0", (Object)cm.getBodyBuffer().readString());
    }

    @Test
    @Timeout(value=120L)
    public void testPrimaryAndBackupBackupComesBackNewFactory() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        CountDownSessionFailureListener listener = new CountDownSessionFailureListener(session);
        session.addFailureListener((SessionFailureListener)listener);
        this.backupServer.stop();
        this.primaryServer.crash(new ClientSession[0]);
        this.beforeRestart(this.backupServer);
        if (!this.backupServer.getServer().getHAPolicy().isSharedStore()) {
            this.backupServer.getServer().setHAPolicy((HAPolicy)new SharedStorePrimaryPolicy());
        }
        this.backupServer.start();
        Assertions.assertTrue((boolean)listener.getLatch().await(5L, TimeUnit.SECONDS), (String)"session failure listener");
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        ClientMessage message = session.createMessage(true);
        this.setBody(0, message);
        producer.send((Message)message);
        session.close();
        this.sf.close();
        this.createClientSessionFactory();
        session = this.createSession((ClientSessionFactory)this.sf);
        ClientConsumer cc = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        ClientMessage cm = cc.receive(5000L);
        Assertions.assertNotNull((Object)cm);
        Assertions.assertEquals((Object)"message0", (Object)cm.getBodyBuffer().readString());
    }

    @Test
    @Timeout(value=120L)
    public void testBackupConnections() throws Exception {
        Assumptions.assumeTrue((boolean)this.backupServer.getServer().getHAPolicy().isBackup());
        this.createSessionFactory();
        CountDownLatch latch = new CountDownLatch(1);
        this.sf.addFailoverListener(eventType -> {
            if (eventType == FailoverEventType.FAILOVER_COMPLETED) {
                latch.countDown();
            }
        });
        BackupManager backupManager = ((ActiveMQServerImpl)this.backupServer.getServer()).getBackupManager();
        ClusterController backupClusterController = this.backupServer.getServer().getClusterManager().getClusterController();
        ClusterConnectionImpl backupClusterConnection = (ClusterConnectionImpl)this.backupServer.getServer().getClusterManager().getClusterConnections().stream().findFirst().get();
        for (BackupManager.BackupConnector backupConnector : backupManager.getBackupConnectors()) {
            for (ClientSessionFactoryInternal factory : ((ServerLocatorImpl)backupConnector.getBackupServerLocator()).getFactories()) {
                Assertions.assertNotNull((Object)factory.getConnection());
            }
        }
        for (ClientSessionFactoryInternal factory : ((ServerLocatorImpl)backupClusterController.getDefaultLocator()).getFactories()) {
            Assertions.assertNotNull((Object)factory.getConnection());
        }
        Assertions.assertNull((Object)backupClusterConnection.getServerLocator());
        Assertions.assertNotNull((Object)this.sf.getConnection());
        this.crash(new ClientSession[0]);
        latch.await();
        for (BackupManager.BackupConnector backupConnector : backupManager.getBackupConnectors()) {
            Assertions.assertNull((Object)backupConnector.getBackupServerLocator());
        }
        for (ClientSessionFactoryInternal factory : ((ServerLocatorImpl)this.backupServer.getServer().getClusterManager().getClusterController().getDefaultLocator()).getFactories()) {
            Assertions.assertNull((Object)factory.getConnection());
        }
        for (ClientSessionFactoryInternal factory : ((ServerLocatorImpl)backupClusterConnection.getServerLocator()).getFactories()) {
            Assertions.assertNull((Object)factory.getConnection());
        }
        Assertions.assertNotNull((Object)this.sf.getConnection());
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean primary) {
        return TransportConfigurationUtils.getInVMAcceptor(primary);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean primary) {
        return TransportConfigurationUtils.getInVMConnector(primary);
    }

    protected void beforeRestart(TestableServer primaryServer1) {
    }

    protected void decrementActivationSequenceForForceRestartOf(TestableServer primaryServer) throws Exception {
    }

    protected ClientSession sendAndConsume(ClientSessionFactory sf1, boolean createQueue) throws Exception {
        ClientSession session = this.createSession(sf1, false, true, true);
        if (createQueue) {
            session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS).setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(SimpleString.of((String)"count"), i);
            message.getBodyBuffer().writeString("aardvarks");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive();
            Assertions.assertEquals((Object)"aardvarks", (Object)message2.getBodyBuffer().readString());
            Assertions.assertEquals((Object)i, (Object)message2.getObjectProperty(SimpleString.of((String)"count")));
            message2.acknowledge();
        }
        ClientMessage message3 = consumer.receiveImmediate();
        Assertions.assertNull((Object)message3);
        return session;
    }
}

