/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.File;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AddressSettingsInfo;
import org.apache.activemq.artemis.cli.commands.tools.PrintData;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DuplicateRecordIdTest
extends ActiveMQTestBase {
    protected ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultInVMConfig().addAddressSetting("#", new AddressSettings().setDeadLetterAddress(SimpleString.of((String)"dlq")).setExpiryAddress(SimpleString.of((String)"dlq")).setSlowConsumerPolicy(SlowConsumerPolicy.NOTIFY).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK)));
        this.server.getConfiguration().setPersistenceEnabled(true);
    }

    @Test
    public void testDuplicateRecordId() throws Exception {
        for (int i = 0; i < 3; ++i) {
            this.server.start();
            ActiveMQServerControlImpl serverControl = this.server.getActiveMQServerControl();
            serverControl.removeAddressSettings("q");
            AddressSettingsInfo defaultSettings = AddressSettingsInfo.fromJSON((String)serverControl.getAddressSettingsAsJSON("#"));
            AddressSettings settings = new AddressSettings();
            settings.setExpiryAddress(SimpleString.of((String)defaultSettings.getExpiryAddress())).setExpiryDelay(Long.valueOf(defaultSettings.getExpiryDelay())).setMaxDeliveryAttempts(1).setMaxSizeBytes(defaultSettings.getMaxSizeBytes()).setPageSizeBytes(defaultSettings.getPageSizeBytes()).setPageCacheMaxSize(defaultSettings.getPageCacheMaxSize()).setRedeliveryDelay(defaultSettings.getRedeliveryDelay()).setMaxExpiryDelay(Long.valueOf(defaultSettings.getMaxRedeliveryDelay())).setRedistributionDelay(defaultSettings.getRedistributionDelay()).setSendToDLAOnNoRoute(defaultSettings.isSendToDLAOnNoRoute()).setAddressFullMessagePolicy(AddressFullMessagePolicy.valueOf((String)defaultSettings.getAddressFullMessagePolicy())).setSlowConsumerThreshold(defaultSettings.getSlowConsumerThreshold()).setSlowConsumerCheckPeriod(defaultSettings.getSlowConsumerCheckPeriod()).setSlowConsumerPolicy(SlowConsumerPolicy.valueOf((String)defaultSettings.getSlowConsumerPolicy()));
            serverControl.addAddressSettings("q", settings.toJSON());
            this.server.stop();
            PrintData.printData((File)this.server.getConfiguration().getBindingsLocation().getAbsoluteFile(), (File)this.server.getConfiguration().getJournalLocation().getAbsoluteFile(), (File)this.server.getConfiguration().getPagingLocation().getAbsoluteFile());
        }
    }
}

