/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.XAConnection;
import jakarta.jms.XAConnectionFactory;
import jakarta.jms.XASession;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.TabularDataSupport;
import javax.transaction.xa.Xid;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.DayCounterInfo;
import org.apache.activemq.artemis.api.core.management.MessageCounterInfo;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.api.core.management.ResourceNames;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.management.impl.view.ConsumerField;
import org.apache.activemq.artemis.core.messagecounter.impl.MessageCounterManagerImpl;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerTestAccessor;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.QueueImplTestAccessor;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.jms.server.management.JMSUtil;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.Base64;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class QueueControlTest
extends ManagementTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String NULL_DATE = DateFormat.getDateTimeInstance(3, 2).format(new Date(0L));
    private ActiveMQServer server;
    private ClientSession session;
    private ServerLocator locator;
    private final boolean durable;

    @Parameters(name="durable={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({true}, {false});
    }

    public QueueControlTest(boolean durable) {
        this.durable = durable;
    }

    @TestTemplate
    public void testMoveMessagesInPagingMode() throws Exception {
        int TOTAL_MESSAGES = 10000;
        String DLA = "DLA";
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, false);
        SimpleString queueAddr = SimpleString.of((String)"testQueue");
        session.createQueue(QueueConfiguration.of((SimpleString)queueAddr).setDurable(Boolean.valueOf(this.durable)));
        SimpleString dlq = SimpleString.of((String)"DLA");
        session.createQueue(QueueConfiguration.of((SimpleString)dlq));
        AddressSettings addressSettings = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(16384L).setDeadLetterAddress(dlq);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.sendMessageBatch(10000, session, queueAddr);
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(queueAddr);
        Assertions.assertTrue((boolean)this.waitForMessages(queue, 10000, 5000L));
        PagingStore queuePagingStore = queue.getPagingStore();
        Assertions.assertTrue((queuePagingStore != null && queuePagingStore.isPaging() ? (byte)1 : 0) != 0);
        String queueControlResourceName = "queue.testQueue";
        Object resource = this.server.getManagementService().getResource(queueControlResourceName);
        QueueControl queueControl = (QueueControl)resource;
        Assertions.assertEquals((long)queueControl.getMessageCount(), (long)10000L);
        int count = queueControl.moveMessages(500, "", "DLA", false, 500);
        Assertions.assertEquals((int)500, (int)count);
        try {
            queueControl.moveMessages(1000, "", "testQueue", false, 9000);
            Assertions.fail((String)"messages cannot be moved on to the queue itself");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        count = queueControl.moveMessages(1000, "", "DLA", false, 9000);
        Assertions.assertEquals((int)9000, (int)count);
        count = queueControl.moveMessages(100, "", "DLA", false, 1000);
        Assertions.assertEquals((int)500, (int)count);
        count = queueControl.moveMessages(100, "", "DLA", false, 1000);
        Assertions.assertEquals((int)0, (int)count);
    }

    @TestTemplate
    public void testGetPreparedTransactionMessageCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        for (int i = 0; i < 10; ++i) {
            producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(true));
        }
        producer.close();
        ClientSession xaSession = this.locator.createSessionFactory().createXASession();
        ClientConsumer consumer = xaSession.createConsumer(queue);
        XidImpl xid = this.newXID();
        xaSession.start((Xid)xid, 0);
        xaSession.start();
        for (int i = 0; i < 10; ++i) {
            ClientMessage receive = consumer.receive();
            receive.acknowledge();
        }
        xaSession.end((Xid)xid, 0x4000000);
        xaSession.prepare((Xid)xid);
        QueueControl queueControl = this.createManagementControl(address, queue);
        int count = queueControl.getPreparedTransactionMessageCount();
        Assertions.assertEquals((int)10, (int)count);
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGetPreparedTransactionMessageCountDifferentQueues() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString address2 = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString queue2 = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue2).setAddress(address2).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientProducer producer2 = this.session.createProducer(address2);
        for (int i = 0; i < 10; ++i) {
            producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(true));
            producer2.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(true));
        }
        producer.close();
        producer2.close();
        ClientSession xaSession = this.locator.createSessionFactory().createXASession();
        ClientConsumer consumer = xaSession.createConsumer(queue);
        ClientConsumer consumer2 = xaSession.createConsumer(queue2);
        XidImpl xid = this.newXID();
        xaSession.start((Xid)xid, 0);
        xaSession.start();
        for (int i = 0; i < 10; ++i) {
            ClientMessage receive = consumer.receive();
            receive.acknowledge();
            receive = consumer2.receive();
            receive.acknowledge();
        }
        xaSession.end((Xid)xid, 0x4000000);
        xaSession.prepare((Xid)xid);
        QueueControl queueControl = this.createManagementControl(address, queue);
        int count = queueControl.getPreparedTransactionMessageCount();
        Assertions.assertEquals((int)10, (int)count);
        consumer.close();
        consumer2.close();
        this.session.deleteQueue(queue);
        this.session.deleteQueue(queue2);
    }

    @TestTemplate
    public void testGetPreparedTransactionMessageCountNoTX() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        int count = queueControl.getPreparedTransactionMessageCount();
        Assertions.assertEquals((int)0, (int)count);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testAttributes() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString filter = SimpleString.of((String)"color = 'blue'");
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setFilterString(filter).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((Object)queue.toString(), (Object)queueControl.getName());
        Assertions.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assertions.assertEquals((Object)filter.toString(), (Object)queueControl.getFilter());
        Assertions.assertEquals((Object)this.durable, (Object)queueControl.isDurable());
        Assertions.assertFalse((boolean)queueControl.isTemporary());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testRegisterInternalQueues() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        this.server.createQueue(QueueConfiguration.of((SimpleString)queue).setDurable(Boolean.valueOf(this.durable)).setInternal(Boolean.valueOf(true)));
        QueueControl queueControl = this.createManagementControl(queue, queue);
        Assertions.assertNotNull((Object)queueControl);
        Assertions.assertTrue((boolean)this.server.locateQueue(queue).isInternalQueue());
        Assertions.assertEquals((Object)queue.toString(), (Object)queueControl.getName());
        Assertions.assertEquals((Object)this.durable, (Object)queueControl.isDurable());
        queueControl.pause();
        Assertions.assertTrue((boolean)queueControl.isPaused());
        queueControl.resume();
        Assertions.assertFalse((boolean)queueControl.isPaused());
    }

    @TestTemplate
    public void testAutoDeleteAttribute() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertFalse((boolean)queueControl.isAutoDelete());
        this.session.deleteQueue(queue);
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setAutoDelete(Boolean.valueOf(true)));
        queueControl = this.createManagementControl(address, queue);
        Assertions.assertTrue((boolean)queueControl.isAutoDelete());
        this.session.deleteQueue(queue);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)new AddressSettings().setAutoDeleteQueues(Boolean.valueOf(true)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setAutoCreated(Boolean.valueOf(true)));
        queueControl = this.createManagementControl(address, queue);
        Assertions.assertTrue((boolean)queueControl.isAutoDelete());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGroupAttributes() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(address, RoutingType.MULTICAST, queue);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertFalse((boolean)queueControl.isGroupRebalance());
        Assertions.assertEquals((int)-1, (int)queueControl.getGroupBuckets());
        Assertions.assertNull((Object)queueControl.getGroupFirstKey());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testRetroactiveResourceAttribute() throws Exception {
        SimpleString baseAddress = RandomUtil.randomSimpleString();
        String internalNamingPrefix = this.server.getInternalNamingPrefix();
        String delimiter = this.server.getConfiguration().getWildcardConfiguration().getDelimiterString();
        SimpleString address = ResourceNames.getRetroactiveResourceAddressName((String)internalNamingPrefix, (String)delimiter, (SimpleString)baseAddress);
        SimpleString multicastQueue = ResourceNames.getRetroactiveResourceQueueName((String)internalNamingPrefix, (String)delimiter, (SimpleString)baseAddress, (RoutingType)RoutingType.MULTICAST);
        SimpleString anycastQueue = ResourceNames.getRetroactiveResourceQueueName((String)internalNamingPrefix, (String)delimiter, (SimpleString)baseAddress, (RoutingType)RoutingType.ANYCAST);
        this.session.createQueue(QueueConfiguration.of((SimpleString)multicastQueue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)anycastQueue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, multicastQueue);
        Assertions.assertTrue((boolean)queueControl.isRetroactiveResource());
        queueControl = this.createManagementControl(address, anycastQueue);
        Assertions.assertTrue((boolean)queueControl.isRetroactiveResource());
        this.session.deleteQueue(multicastQueue);
        this.session.deleteQueue(anycastQueue);
    }

    @TestTemplate
    public void testGetNullFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((Object)queue.toString(), (Object)queueControl.getName());
        Assertions.assertNull((Object)queueControl.getFilter());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGetDeadLetterAddress() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString deadLetterAddress = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertNull((Object)queueControl.getDeadLetterAddress());
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)new AddressSettings().setDeadLetterAddress(deadLetterAddress));
        Assertions.assertEquals((Object)deadLetterAddress.toString(), (Object)queueControl.getDeadLetterAddress());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testSetDeadLetterAddress() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        String deadLetterAddress = RandomUtil.randomString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        AddressSettings addressSettings = new AddressSettings().setDeadLetterAddress(SimpleString.of((String)deadLetterAddress));
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        Assertions.assertEquals((Object)deadLetterAddress, (Object)queueControl.getDeadLetterAddress());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGetExpiryAddress() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString expiryAddress = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertNull((Object)queueControl.getExpiryAddress());
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)new AddressSettings().setExpiryAddress(expiryAddress));
        Assertions.assertEquals((Object)expiryAddress.toString(), (Object)queueControl.getExpiryAddress());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testSetExpiryAddress() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        String expiryAddress = RandomUtil.randomString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(SimpleString.of((String)expiryAddress));
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        Assertions.assertEquals((Object)expiryAddress, (Object)queueControl.getExpiryAddress());
        org.apache.activemq.artemis.core.server.Queue serverqueue = this.server.locateQueue(queue);
        Assertions.assertEquals((Object)expiryAddress, (Object)serverqueue.getExpiryAddress().toString());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGetConsumerCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((int)0, (int)queueControl.getConsumerCount());
        ClientConsumer consumer = this.session.createConsumer(queue);
        Wait.assertEquals((int)1, () -> queueControl.getConsumerCount());
        consumer.close();
        Wait.assertEquals((int)0, () -> queueControl.getConsumerCount());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGetConsumerJSON() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Wait.assertEquals((int)0, () -> queueControl.getConsumerCount());
        ClientConsumer consumer = this.session.createConsumer(queue);
        Wait.assertEquals((int)1, () -> queueControl.getConsumerCount());
        JsonArray obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
        Assertions.assertEquals((int)1, (int)obj.size());
        Assertions.assertEquals((int)0, (int)((JsonValue)obj.get(0)).asJsonObject().getInt(ConsumerField.LAST_DELIVERED_TIME.getName()));
        Assertions.assertEquals((int)0, (int)((JsonValue)obj.get(0)).asJsonObject().getInt(ConsumerField.LAST_ACKNOWLEDGED_TIME.getName()));
        consumer.close();
        Assertions.assertEquals((int)0, (int)queueControl.getConsumerCount());
        obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
        Assertions.assertEquals((int)0, (int)obj.size());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGetConsumerWithMessagesJSON() throws Exception {
        long currentTime = System.currentTimeMillis();
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        for (int i = 0; i < 10; ++i) {
            producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(true));
        }
        Wait.assertEquals((int)0, () -> queueControl.getConsumerCount());
        ClientConsumer consumer = this.session.createConsumer(queue);
        Wait.assertEquals((int)1, () -> queueControl.getConsumerCount());
        this.session.start();
        ClientMessage clientMessage = null;
        int size = 0;
        for (int i = 0; i < 5; ++i) {
            clientMessage = consumer.receiveImmediate();
            size += clientMessage.getEncodeSize();
        }
        JsonArray obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
        Assertions.assertEquals((int)1, (int)obj.size());
        Wait.assertEquals((int)5, () -> ((JsonValue)JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON()).get(0)).asJsonObject().getInt(ConsumerField.MESSAGES_IN_TRANSIT.getName()));
        obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
        JsonObject jsonObject = ((JsonValue)obj.get(0)).asJsonObject();
        Assertions.assertEquals((int)5, (int)jsonObject.getInt(ConsumerField.MESSAGES_IN_TRANSIT.getName()));
        Assertions.assertEquals((int)size, (int)jsonObject.getInt(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()));
        Assertions.assertEquals((int)5, (int)jsonObject.getInt(ConsumerField.MESSAGES_DELIVERED.getName()));
        Assertions.assertEquals((int)size, (int)jsonObject.getInt(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()));
        Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()));
        long lastDelivered = jsonObject.getJsonNumber(ConsumerField.LAST_DELIVERED_TIME.getName()).longValue();
        Assertions.assertTrue((lastDelivered > currentTime ? (byte)1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.LAST_ACKNOWLEDGED_TIME.getName()));
        clientMessage.acknowledge();
        this.session.commit();
        Wait.assertEquals((int)5, () -> ((JsonValue)JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON()).get(0)).asJsonObject().getInt(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()));
        obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
        jsonObject = ((JsonValue)obj.get(0)).asJsonObject();
        Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_IN_TRANSIT.getName()));
        long lastAcked = jsonObject.getJsonNumber(ConsumerField.LAST_ACKNOWLEDGED_TIME.getName()).longValue();
        Assertions.assertTrue((lastAcked >= lastDelivered ? (byte)1 : 0) != 0, (String)("lastAcked = " + lastAcked + " lastDelivered = " + lastDelivered));
        currentTime = System.currentTimeMillis();
        Assertions.assertTrue((currentTime >= lastAcked ? (byte)1 : 0) != 0, (String)("currentTime = " + currentTime + " lastAcked = " + lastAcked));
        consumer.close();
        Assertions.assertEquals((int)0, (int)queueControl.getConsumerCount());
        obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
        Assertions.assertEquals((int)0, (int)obj.size());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGetConsumerMessageCountsAutoAckCore() throws Exception {
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory factory = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        factory.setConsumerWindowSize(1);
        this.testGetConsumerMessageCountsAutoAck((ConnectionFactory)factory, false);
    }

    @TestTemplate
    public void testGetConsumerMessageCountsAutoAckAMQP() throws Exception {
        this.testGetConsumerMessageCountsAutoAck((ConnectionFactory)new JmsConnectionFactory("amqp://localhost:61616"), false);
    }

    @TestTemplate
    public void testGetConsumerMessageCountsAutoAckOpenWire() throws Exception {
        this.testGetConsumerMessageCountsAutoAck((ConnectionFactory)new ActiveMQConnectionFactory("tcp://localhost:61616"), false);
    }

    @TestTemplate
    public void testGetConsumerMessageCountsAutoAckCoreIndividualAck() throws Exception {
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory factory = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        this.testGetConsumerMessageCountsAutoAck((ConnectionFactory)factory, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetConsumerMessageCountsAutoAck(ConnectionFactory factory, boolean usePriority) throws Exception {
        SimpleString queueName = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(queueName).setDurable(Boolean.valueOf(this.durable)).setRoutingType(RoutingType.ANYCAST));
        QueueControl queueControl = this.createManagementControl(queueName, queueName, RoutingType.ANYCAST);
        try (Connection connection = factory.createConnection();){
            Message message;
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(queueName.toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            for (int i = 0; i < 100; ++i) {
                message = session.createMessage();
                if (usePriority) {
                    producer.send(message, 2, 1, 0L);
                    continue;
                }
                producer.send(message);
            }
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            message = null;
            for (int i = 0; i < 100; ++i) {
                message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message, (String)("message " + i + " not received"));
            }
            JsonArray obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
            Assertions.assertEquals((int)1, (int)obj.size());
            Wait.assertEquals((int)0, () -> ((JsonValue)JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON()).get(0)).asJsonObject().getInt(ConsumerField.MESSAGES_IN_TRANSIT.getName()));
            Wait.assertEquals((int)0, () -> ((JsonValue)JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON()).get(0)).asJsonObject().getInt(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()));
            obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
            JsonObject jsonObject = ((JsonValue)obj.get(0)).asJsonObject();
            Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_IN_TRANSIT.getName()));
            Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()));
            Assertions.assertEquals((int)100, (int)jsonObject.getInt(ConsumerField.MESSAGES_DELIVERED.getName()));
            Assertions.assertTrue((jsonObject.getInt(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()) > 0 ? (byte)1 : 0) != 0);
            Assertions.assertEquals((int)100, (int)jsonObject.getInt(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()));
            Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()));
            consumer.close();
        }
    }

    @TestTemplate
    public void testGetConsumerMessageCountsClientAckCore() throws Exception {
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory factory = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        factory.setConsumerWindowSize(1);
        this.testGetConsumerMessageCountsClientAck((ConnectionFactory)factory, false);
    }

    @TestTemplate
    public void testGetConsumerMessageCountsClientAckAMQP() throws Exception {
        this.testGetConsumerMessageCountsClientAck((ConnectionFactory)new JmsConnectionFactory("amqp://localhost:61616"), false);
    }

    @TestTemplate
    public void testGetConsumerMessageCountsClientAckOpenWire() throws Exception {
        this.testGetConsumerMessageCountsClientAck((ConnectionFactory)new ActiveMQConnectionFactory("tcp://localhost:61616"), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetConsumerMessageCountsClientAck(ConnectionFactory factory, boolean usePriority) throws Exception {
        SimpleString queueName = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(queueName).setDurable(Boolean.valueOf(this.durable)).setRoutingType(RoutingType.ANYCAST));
        QueueControl queueControl = this.createManagementControl(queueName, queueName, RoutingType.ANYCAST);
        try (Connection connection = factory.createConnection();){
            Message message;
            Session session = connection.createSession(false, 2);
            Queue queue = session.createQueue(queueName.toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            for (int i = 0; i < 100; ++i) {
                message = session.createMessage();
                if (usePriority) {
                    producer.send(message, 2, 1, 0L);
                    continue;
                }
                producer.send(message);
            }
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            message = null;
            for (int i = 0; i < 100; ++i) {
                message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message, (String)("message " + i + " not received"));
                message.acknowledge();
            }
            JsonArray obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
            Assertions.assertEquals((int)1, (int)obj.size());
            Wait.assertEquals((int)0, () -> ((JsonValue)JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON()).get(0)).asJsonObject().getInt(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()));
            Wait.assertEquals((int)0, () -> ((JsonValue)JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON()).get(0)).asJsonObject().getInt(ConsumerField.MESSAGES_IN_TRANSIT.getName()));
            Wait.assertEquals((int)0, () -> ((JsonValue)JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON()).get(0)).asJsonObject().getInt(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()));
            obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
            JsonObject jsonObject = ((JsonValue)obj.get(0)).asJsonObject();
            Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_IN_TRANSIT.getName()));
            Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()));
            Assertions.assertEquals((int)100, (int)jsonObject.getInt(ConsumerField.MESSAGES_DELIVERED.getName()));
            Assertions.assertTrue((jsonObject.getInt(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()) > 0 ? (byte)1 : 0) != 0);
            Assertions.assertEquals((int)100, (int)jsonObject.getInt(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()));
            Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()));
            consumer.close();
        }
    }

    @TestTemplate
    public void testGetConsumerMessageCountsTransactedCore() throws Exception {
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory factory = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        factory.setConsumerWindowSize(1);
        this.testGetConsumerMessageCountsTransacted((ConnectionFactory)factory, false);
    }

    @TestTemplate
    public void testGetConsumerMessageCountsTransactedAMQP() throws Exception {
        this.testGetConsumerMessageCountsTransacted((ConnectionFactory)new JmsConnectionFactory("amqp://localhost:61616"), false);
    }

    @TestTemplate
    public void testGetConsumerMessageCountsTransactedOpenWire() throws Exception {
        this.testGetConsumerMessageCountsTransacted((ConnectionFactory)new ActiveMQConnectionFactory("tcp://localhost:61616"), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetConsumerMessageCountsTransacted(ConnectionFactory factory, boolean usePriority) throws Exception {
        SimpleString queueName = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(queueName).setDurable(Boolean.valueOf(this.durable)).setRoutingType(RoutingType.ANYCAST));
        QueueControl queueControl = this.createManagementControl(queueName, queueName, RoutingType.ANYCAST);
        try (Connection connection = factory.createConnection();){
            Message message;
            Session session = connection.createSession(true, 0);
            Queue queue = session.createQueue(queueName.toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            for (int i = 0; i < 100; ++i) {
                message = session.createMessage();
                if (usePriority) {
                    producer.send(message, 2, 1, 0L);
                    continue;
                }
                producer.send(message);
            }
            session.commit();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            message = null;
            for (int i = 0; i < 100; ++i) {
                message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message, (String)("message " + i + " not received"));
            }
            session.commit();
            JsonArray obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
            Assertions.assertEquals((int)1, (int)obj.size());
            Wait.assertEquals((int)0, () -> ((JsonValue)JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON()).get(0)).asJsonObject().getInt(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()));
            obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
            JsonObject jsonObject = ((JsonValue)obj.get(0)).asJsonObject();
            Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_IN_TRANSIT.getName()));
            Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()));
            Assertions.assertEquals((int)100, (int)jsonObject.getInt(ConsumerField.MESSAGES_DELIVERED.getName()));
            Assertions.assertTrue((jsonObject.getInt(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()) > 0 ? (byte)1 : 0) != 0);
            Assertions.assertEquals((int)100, (int)jsonObject.getInt(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()));
            Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()));
            consumer.close();
        }
    }

    @TestTemplate
    public void testGetConsumerMessageCountsTransactedXACore() throws Exception {
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory factory = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        factory.setConsumerWindowSize(1);
        this.testGetConsumerMessageCountsTransactedXA((XAConnectionFactory)factory, false);
    }

    @TestTemplate
    public void testGetConsumerMessageCountsTransactedXAOpenWire() throws Exception {
        this.testGetConsumerMessageCountsTransactedXA((XAConnectionFactory)new ActiveMQXAConnectionFactory("tcp://localhost:61616"), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetConsumerMessageCountsTransactedXA(XAConnectionFactory factory, boolean usePriority) throws Exception {
        SimpleString queueName = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(queueName).setDurable(Boolean.valueOf(this.durable)).setRoutingType(RoutingType.ANYCAST));
        QueueControl queueControl = this.createManagementControl(queueName, queueName, RoutingType.ANYCAST);
        try (XAConnection connection = factory.createXAConnection();){
            Message message;
            XASession session = connection.createXASession();
            XidImpl xid = this.newXID();
            Queue queue = session.createQueue(queueName.toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            session.getXAResource().start((Xid)xid, 0);
            for (int i = 0; i < 100; ++i) {
                message = session.createMessage();
                if (usePriority) {
                    producer.send(message, 2, 1, 0L);
                    continue;
                }
                producer.send(message);
            }
            session.getXAResource().end((Xid)xid, 0x4000000);
            session.getXAResource().commit((Xid)xid, true);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            xid = this.newXID();
            message = null;
            session.getXAResource().start((Xid)xid, 0);
            for (int i = 0; i < 100; ++i) {
                message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message, (String)("message " + i + " not received"));
            }
            session.getXAResource().end((Xid)xid, 0x4000000);
            JsonArray obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
            Assertions.assertEquals((int)1, (int)obj.size());
            Wait.assertEquals((int)100, () -> ((JsonValue)JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON()).get(0)).asJsonObject().getInt(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()));
            obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
            JsonObject jsonObject = ((JsonValue)obj.get(0)).asJsonObject();
            Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_IN_TRANSIT.getName()));
            Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()));
            Assertions.assertEquals((int)100, (int)jsonObject.getInt(ConsumerField.MESSAGES_DELIVERED.getName()));
            Assertions.assertTrue((jsonObject.getInt(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()) > 0 ? (byte)1 : 0) != 0);
            Assertions.assertEquals((int)100, (int)jsonObject.getInt(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()));
            Assertions.assertEquals((int)100, (int)jsonObject.getInt(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()));
            session.getXAResource().commit((Xid)xid, true);
            obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
            Assertions.assertEquals((int)1, (int)obj.size());
            Wait.assertEquals((int)0, () -> ((JsonValue)JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON()).get(0)).asJsonObject().getInt(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()));
            obj = JsonUtil.readJsonArray((String)queueControl.listConsumersAsJSON());
            jsonObject = ((JsonValue)obj.get(0)).asJsonObject();
            Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_IN_TRANSIT.getName()));
            Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()));
            Assertions.assertEquals((int)100, (int)jsonObject.getInt(ConsumerField.MESSAGES_DELIVERED.getName()));
            Assertions.assertTrue((jsonObject.getInt(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()) > 0 ? (byte)1 : 0) != 0);
            Assertions.assertEquals((int)100, (int)jsonObject.getInt(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()));
            Assertions.assertEquals((int)0, (int)jsonObject.getInt(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()));
            consumer.close();
        }
    }

    @TestTemplate
    public void testGetMessageCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        QueueControlTest.consumeMessages(1, this.session, queue);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGetFirstMessage() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        Assertions.assertEquals((Object)"[{}]", (Object)queueControl.getFirstMessageAsJSON());
        long beforeSend = System.currentTimeMillis();
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false).putStringProperty("x", "valueX").putStringProperty("y", "valueY"));
        Wait.assertEquals((long)1L, () -> ((QueueControl)queueControl).getMessageCount());
        long firstMessageTimestamp = queueControl.getFirstMessageTimestamp();
        Assertions.assertTrue((beforeSend <= firstMessageTimestamp ? (byte)1 : 0) != 0);
        Assertions.assertTrue((firstMessageTimestamp <= System.currentTimeMillis() ? (byte)1 : 0) != 0);
        long firstMessageAge = queueControl.getFirstMessageAge();
        Assertions.assertTrue((firstMessageAge <= System.currentTimeMillis() - firstMessageTimestamp ? (byte)1 : 0) != 0);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testPeekFirstMessage() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        Assertions.assertEquals((Object)"null", (Object)queueControl.peekFirstMessageAsJSON());
        String fooValue = RandomUtil.randomString();
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false).putStringProperty("foo", fooValue));
        Wait.assertEquals((long)1L, () -> ((QueueControl)queueControl).getMessageCount());
        JsonObject messageAsJson = JsonUtil.readJsonObject((String)queueControl.peekFirstMessageAsJSON());
        Assertions.assertEquals((Object)fooValue, (Object)messageAsJson.getString("foo"));
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testPeekFirstScheduledMessage() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        Assertions.assertEquals((Object)"null", (Object)queueControl.peekFirstScheduledMessageAsJSON());
        long timestampBeforeSend = System.currentTimeMillis();
        ClientProducer producer = this.addClientProducer(this.session.createProducer(address));
        ClientMessage message = this.session.createMessage(this.durable).putStringProperty("x", "valueX").putStringProperty("y", "valueY").putBooleanProperty("durable", this.durable).putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_SCHEDULED_DELIVERY_TIME, timestampBeforeSend + 5000L);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        QueueControlTest.consumeMessages(0, this.session, queue);
        this.assertScheduledMetrics(queueControl, 1L, this.durable);
        long timestampAfterSend = System.currentTimeMillis();
        JsonObject messageAsJson = JsonUtil.readJsonObject((String)queueControl.peekFirstScheduledMessageAsJSON());
        Assertions.assertEquals((Object)"valueX", (Object)messageAsJson.getString("x"));
        Assertions.assertEquals((Object)"valueY", (Object)messageAsJson.getString("y"));
        Assertions.assertEquals((Object)this.durable, (Object)messageAsJson.getBoolean("durable"));
        long messageTimestamp = messageAsJson.getJsonNumber("timestamp").longValue();
        Assertions.assertTrue((messageTimestamp >= timestampBeforeSend ? (byte)1 : 0) != 0);
        Assertions.assertTrue((messageTimestamp <= timestampAfterSend ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)"[{}]", (Object)queueControl.getFirstMessageAsJSON());
        queueControl.deliverScheduledMessage((long)messageAsJson.getInt("messageID"));
        queueControl.flushExecutor();
        this.assertScheduledMetrics(queueControl, 0L, this.durable);
        QueueControlTest.consumeMessages(1, this.session, queue);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testMessageAttributeLimits() throws Exception {
        CompositeData[] browseResult;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        AddressSettings addressSettings = new AddressSettings().setManagementMessageAttributeSizeLimit(100);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        byte[] twoKBytes = new byte[2048];
        for (int i = 0; i < 2048; ++i) {
            twoKBytes[i] = 42;
        }
        String twoKString = new String(twoKBytes);
        ClientMessage clientMessage = this.session.createMessage(false);
        clientMessage.putStringProperty("y", "valueY");
        clientMessage.putStringProperty("bigString", twoKString);
        clientMessage.putBytesProperty("bigBytes", twoKBytes);
        clientMessage.putObjectProperty("bigObject", (Object)twoKString);
        clientMessage.getBodyBuffer().writeBytes(twoKBytes);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientMessage);
        Wait.assertEquals((long)1L, () -> this.getMessageCount(queueControl));
        Assertions.assertTrue((this.server.getPagingManager().getPageStore(address).getAddressSize() > 2048L ? (byte)1 : 0) != 0);
        Map[] messages = queueControl.listMessages("");
        Assertions.assertEquals((int)1, (int)messages.length);
        for (String key : messages[0].keySet()) {
            Object value = messages[0].get(key);
            System.err.println(key + " " + value);
            Assertions.assertTrue((value.toString().length() <= 150 ? (byte)1 : 0) != 0);
            if (!(value instanceof byte[])) continue;
            Assertions.assertTrue((((byte[])value).length <= 150 ? (byte)1 : 0) != 0);
        }
        String all = queueControl.listMessagesAsJSON("");
        Assertions.assertTrue((all.length() < 1024 ? (byte)1 : 0) != 0);
        String first = queueControl.getFirstMessageAsJSON();
        Assertions.assertTrue((first.length() < 1024 ? (byte)1 : 0) != 0);
        for (CompositeData compositeData : browseResult = queueControl.browse(1, 100)) {
            for (String key : compositeData.getCompositeType().keySet()) {
                Object value = compositeData.get(key);
                System.err.println(key + ", " + value);
                if (value == null) continue;
                if (key.equals("StringProperties")) {
                    Assertions.assertTrue((value.toString().length() <= 3000 ? (byte)1 : 0) != 0, (String)(value.toString().length() + " truncated? " + key));
                } else {
                    Assertions.assertTrue((value.toString().length() <= 512 ? (byte)1 : 0) != 0, (String)(value.toString().length() + " truncated? " + key));
                }
                if (!(value instanceof byte[])) continue;
                Assertions.assertTrue((((byte[])value).length <= 150 ? (byte)1 : 0) != 0, (String)("truncated? " + key));
            }
        }
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testBytesMessageBodyWithoutLimits() throws Exception {
        int BYTE_COUNT = 2048;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        AddressSettings addressSettings = new AddressSettings().setManagementMessageAttributeSizeLimit(-1);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        byte[] randomBytes = RandomUtil.randomBytes((int)2048);
        ClientMessage clientMessage = this.session.createMessage(false);
        clientMessage.getBodyBuffer().writeBytes(randomBytes);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientMessage);
        Wait.assertEquals((long)1L, () -> this.getMessageCount(queueControl));
        CompositeData[] browseResult = queueControl.browse(1, 1);
        boolean tested = false;
        for (CompositeData compositeData : browseResult) {
            for (String key : compositeData.getCompositeType().keySet()) {
                Object value = compositeData.get(key);
                if (value == null || !(value instanceof byte[])) continue;
                QueueControlTest.assertEqualsByteArrays(randomBytes, (byte[])value);
                tested = true;
            }
        }
        Assertions.assertTrue((boolean)tested, (String)"Nothing tested!");
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testTextMessageAttributeLimits() throws Exception {
        CompositeData[] browseResult;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        AddressSettings addressSettings = new AddressSettings().setManagementMessageAttributeSizeLimit(10);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        String twentyBytes = new String(new char[20]).replace("\u0000", "#");
        ClientMessage clientMessage = this.session.createMessage((byte)3, this.durable);
        clientMessage.getBodyBuffer().writeNullableSimpleString(SimpleString.of((String)twentyBytes));
        clientMessage.putStringProperty("x", twentyBytes);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)clientMessage);
        Wait.assertEquals((long)1L, () -> this.getMessageCount(queueControl));
        Map[] messages = queueControl.listMessages("");
        Assertions.assertEquals((int)1, (int)messages.length);
        Assertions.assertTrue((boolean)((String)messages[0].get("x")).contains("more"), (String)"truncated? ");
        for (CompositeData compositeData : browseResult = queueControl.browse(1, 100)) {
            for (String key : new String[]{"text", "PropertiesText", "StringProperties"}) {
                Assertions.assertTrue((boolean)compositeData.get(key).toString().contains("more"), (String)("truncated? : " + key));
            }
        }
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGetMessagesAdded() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)this.getMessagesAdded(queueControl));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        Wait.assertEquals((long)1L, () -> this.getMessagesAdded(queueControl));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        Wait.assertEquals((long)2L, () -> this.getMessagesAdded(queueControl));
        QueueControlTest.consumeMessages(2, this.session, queue);
        Assertions.assertEquals((long)2L, (long)this.getMessagesAdded(queueControl));
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGetMessagesAcknowledged() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false));
        QueueControlTest.consumeMessages(1, this.session, queue);
        Wait.assertEquals((long)1L, () -> queueControl.getMessagesAcknowledged());
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false));
        QueueControlTest.consumeMessages(1, this.session, queue);
        Wait.assertEquals((long)2L, () -> queueControl.getMessagesAcknowledged());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGetMessagesAcknowledgedOnXARollback() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        ClientSessionFactory xaFactory = this.createSessionFactory(this.locator);
        ClientSession xaSession = this.addClientSession(xaFactory.createSession(true, false, false));
        xaSession.start();
        ClientConsumer consumer = xaSession.createConsumer(queue);
        int tries = 10;
        for (int i = 0; i < tries; ++i) {
            XidImpl xid = this.newXID();
            xaSession.start((Xid)xid, 0);
            ClientMessage message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message);
            message.acknowledge();
            Assertions.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
            xaSession.end((Xid)xid, 0x4000000);
            Assertions.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
            xaSession.prepare((Xid)xid);
            Assertions.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
            if (i + 1 == tries) {
                xaSession.commit((Xid)xid, false);
                continue;
            }
            xaSession.rollback((Xid)xid);
        }
        Wait.assertEquals((long)1L, () -> ((QueueControl)queueControl).getMessagesAcknowledged());
        Wait.assertEquals((long)10L, () -> ((QueueControl)queueControl).getAcknowledgeAttempts());
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGetMessagesAcknowledgedOnRegularRollback() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        ClientSessionFactory xaFactory = this.createSessionFactory(this.locator);
        ClientSession txSession = this.addClientSession(xaFactory.createSession(false, false, false));
        txSession.start();
        ClientConsumer consumer = txSession.createConsumer(queue);
        int tries = 10;
        for (int i = 0; i < tries; ++i) {
            ClientMessage message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message);
            message.acknowledge();
            Assertions.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
            if (i + 1 == tries) {
                txSession.commit();
                continue;
            }
            txSession.rollback();
        }
        Wait.assertEquals((long)1L, () -> ((QueueControl)queueControl).getMessagesAcknowledged());
        Wait.assertEquals((long)10L, () -> ((QueueControl)queueControl).getAcknowledgeAttempts());
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGetScheduledCount() throws Exception {
        long delay = 500L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)queueControl.getScheduledCount());
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        message.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_SCHEDULED_DELIVERY_TIME, System.currentTimeMillis() + delay);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        long timeout = System.currentTimeMillis() + 5000L;
        while (timeout > System.currentTimeMillis() && queueControl.getScheduledCount() != 1L) {
            Thread.sleep(100L);
        }
        this.assertScheduledMetrics(queueControl, 1L, this.durable);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        QueueControlTest.consumeMessages(0, this.session, queue);
        Thread.sleep(delay * 2L);
        Assertions.assertEquals((long)0L, (long)queueControl.getScheduledCount());
        QueueControlTest.consumeMessages(1, this.session, queue);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        this.assertScheduledMetrics(queueControl, 0L, this.durable);
        this.session.deleteQueue(queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testListDeliveringMessagesWithRASession() throws Exception {
        ServerLocator locator1 = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setConsumerWindowSize(10240).setAckBatchSize(0);
        ClientSessionFactory sf = locator1.createSessionFactory();
        ClientSession transSession = sf.createSession(false, true, false);
        ClientConsumer consumer = null;
        SimpleString queue = null;
        int numMsg = 10;
        try {
            transSession.addMetaData("resource-adapter", "inbound");
            transSession.addMetaData("jms-session", "");
            SimpleString address = RandomUtil.randomSimpleString();
            queue = RandomUtil.randomSimpleString();
            transSession.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
            QueueControl queueControl = this.createManagementControl(address, queue);
            ClientProducer producer = transSession.createProducer(address);
            for (int i = 0; i < numMsg; ++i) {
                ClientMessage message2 = transSession.createMessage(this.durable);
                message2.putIntProperty(SimpleString.of((String)"seqno"), i);
                producer.send((org.apache.activemq.artemis.api.core.Message)message2);
            }
            consumer = transSession.createConsumer(queue);
            transSession.start();
            CountDownLatch latch1 = new CountDownLatch(1);
            CountDownLatch latch2 = new CountDownLatch(1);
            CountDownLatch latch3 = new CountDownLatch(10);
            consumer.setMessageHandler(message -> {
                try {
                    message.acknowledge();
                }
                catch (ActiveMQException e1) {
                    e1.printStackTrace();
                }
                latch1.countDown();
                try {
                    latch2.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                latch3.countDown();
            });
            latch1.await(10L, TimeUnit.SECONDS);
            int n = 0;
            for (int i = 0; i < 5; ++i) {
                Thread.sleep(1000L);
                String jsonStr = queueControl.listDeliveringMessagesAsJSON();
                n = QueueControlTest.countOccurrencesOf(jsonStr, "seqno");
                if (n == numMsg) break;
            }
            Assertions.assertEquals((int)numMsg, (int)n);
            latch2.countDown();
            latch3.await(10L, TimeUnit.SECONDS);
            transSession.commit();
        }
        catch (Throwable throwable) {
            consumer.close();
            transSession.deleteQueue(queue);
            transSession.close();
            locator1.close();
            throw throwable;
        }
        consumer.close();
        transSession.deleteQueue(queue);
        transSession.close();
        locator1.close();
    }

    @TestTemplate
    public void testListDeliveringMessages() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        int intValue = RandomUtil.randomInt();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        org.apache.activemq.artemis.core.server.Queue srvqueue = this.server.locateQueue(queue);
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        message.putIntProperty(SimpleString.of((String)"key"), intValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        ClientConsumer consumer = this.session.createConsumer(queue);
        this.session.start();
        ClientMessage msgRec = consumer.receive(5000L);
        Assertions.assertNotNull((Object)msgRec);
        Assertions.assertEquals((int)msgRec.getIntProperty("key"), (int)intValue);
        ClientSessionFactory sf2 = this.createSessionFactory(this.locator);
        ClientSession session2 = sf2.createSession(false, true, false);
        ClientConsumer consumer2 = session2.createConsumer(queue);
        session2.start();
        ClientMessage msgRec2 = consumer2.receive(5000L);
        Assertions.assertNotNull((Object)msgRec2);
        Assertions.assertEquals((int)2, (int)srvqueue.getDeliveringCount());
        Assertions.assertEquals((int)2, (int)srvqueue.getConsumerCount());
        Map deliveringMap = queueControl.listDeliveringMessages();
        Assertions.assertEquals((int)2, (int)deliveringMap.size());
        consumer.close();
        consumer2.close();
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testListDeliveringMessagesOnClosedConsumer() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        int intValue = RandomUtil.randomInt();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        org.apache.activemq.artemis.core.server.Queue srvqueue = this.server.locateQueue(queue);
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        message.putIntProperty(SimpleString.of((String)"key"), intValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        ClientConsumer consumer = this.session.createConsumer(queue);
        this.session.start();
        ClientMessage msgRec = consumer.receive(5000L);
        Assertions.assertNotNull((Object)msgRec);
        Assertions.assertEquals((int)msgRec.getIntProperty("key"), (int)intValue);
        Assertions.assertEquals((int)1, (int)srvqueue.getDeliveringCount());
        Assertions.assertEquals((int)1, (int)queueControl.listDeliveringMessages().size());
        msgRec.acknowledge();
        consumer.close();
        Assertions.assertEquals((int)1, (int)srvqueue.getDeliveringCount());
        Map deliveringMap = queueControl.listDeliveringMessages();
        Assertions.assertEquals((int)1, (int)deliveringMap.size());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testListScheduledMessages() throws Exception {
        long delay = 2000L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        int intValue = RandomUtil.randomInt();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        message.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_SCHEDULED_DELIVERY_TIME, System.currentTimeMillis() + delay);
        message.putIntProperty(SimpleString.of((String)"key"), intValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        Map[] messages = queueControl.listScheduledMessages();
        Assertions.assertEquals((int)1, (int)messages.length);
        this.assertScheduledMetrics(queueControl, 1L, this.durable);
        Assertions.assertEquals((int)intValue, (int)Integer.parseInt(messages[0].get("key").toString()));
        Thread.sleep(delay + 500L);
        messages = queueControl.listScheduledMessages();
        Assertions.assertEquals((int)0, (int)messages.length);
        QueueControlTest.consumeMessages(2, this.session, queue);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testListScheduledMessagesAsJSON() throws Exception {
        long delay = 2000L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        int intValue = RandomUtil.randomInt();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(false);
        message.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_SCHEDULED_DELIVERY_TIME, System.currentTimeMillis() + delay);
        message.putIntProperty(SimpleString.of((String)"key"), intValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        String jsonString = queueControl.listScheduledMessagesAsJSON();
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)1, (int)array.size());
        int i = Integer.parseInt(((JsonValue)array.getJsonObject(0).get((Object)"key")).toString().replaceAll("\"", ""));
        Assertions.assertEquals((int)intValue, (int)i);
        Thread.sleep(delay + 500L);
        jsonString = queueControl.listScheduledMessagesAsJSON();
        Assertions.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)0, (int)array.size());
        QueueControlTest.consumeMessages(2, this.session, queue);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGetDeliveringCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((int)0, (int)queueControl.getDeliveringCount());
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage message = consumer.receive(500L);
        Assertions.assertNotNull((Object)message);
        this.assertDeliveringMetrics(queueControl, 1L, this.durable);
        message.acknowledge();
        this.session.commit();
        this.assertDeliveringMetrics(queueControl, 0L, this.durable);
        consumer.close();
        this.session.deleteQueue(queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testMessagesAddedAndMessagesAcknowledged() throws Exception {
        int THREAD_COUNT = 5;
        int MSG_COUNT = 1000;
        CountDownLatch producerCountDown = new CountDownLatch(5);
        CountDownLatch consumerCountDown = new CountDownLatch(5);
        ExecutorService producerExecutor = Executors.newFixedThreadPool(5);
        ExecutorService consumerExecutor = Executors.newFixedThreadPool(5);
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        try {
            int i;
            this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
            for (i = 0; i < 5; ++i) {
                producerExecutor.submit(() -> {
                    try (ClientSessionFactory sf = this.locator.createSessionFactory();
                         ClientSession session = sf.createSession(false, true, false);
                         ClientProducer producer = session.createProducer(address);){
                        for (int j = 0; j < 1000; ++j) {
                            producer.send((org.apache.activemq.artemis.api.core.Message)session.createMessage(false));
                            Thread.sleep(5L);
                        }
                        producerCountDown.countDown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            for (i = 0; i < 5; ++i) {
                consumerExecutor.submit(() -> {
                    try (ClientSessionFactory sf = this.locator.createSessionFactory();
                         ClientSession session = sf.createSession(false, true, false);
                         ClientConsumer consumer = session.createConsumer(queue);){
                        session.start();
                        for (int j = 0; j < 1000; ++j) {
                            ClientMessage message = consumer.receive(500L);
                            Assertions.assertNotNull((Object)message);
                            message.acknowledge();
                        }
                        session.commit();
                        consumerCountDown.countDown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            producerCountDown.await(30L, TimeUnit.SECONDS);
            consumerCountDown.await(30L, TimeUnit.SECONDS);
            QueueControl queueControl = this.createManagementControl(address, queue, RoutingType.MULTICAST);
            Thread.sleep(200L);
            Assertions.assertEquals((long)0L, (long)queueControl.getMessageCount());
            Assertions.assertEquals((int)0, (int)queueControl.getConsumerCount());
            Assertions.assertEquals((int)0, (int)queueControl.getDeliveringCount());
            Assertions.assertEquals((long)5000L, (long)queueControl.getMessagesAdded());
            Assertions.assertEquals((long)5000L, (long)queueControl.getMessagesAcknowledged());
            this.session.deleteQueue(queue);
        }
        finally {
            this.shutdownExecutor(producerExecutor);
            this.shutdownExecutor(consumerExecutor);
        }
    }

    private void shutdownExecutor(ExecutorService executor) {
        try {
            executor.shutdown();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            executor.shutdownNow();
        }
    }

    @TestTemplate
    public void testListMessagesAsJSONWithNullFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        int intValue = RandomUtil.randomInt();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        message.putIntProperty(SimpleString.of((String)"key"), intValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        String jsonString = queueControl.listMessagesAsJSON(null);
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)1, (int)array.size());
        long l = Long.parseLong(((JsonValue)array.getJsonObject(0).get((Object)"key")).toString().replaceAll("\"", ""));
        Assertions.assertEquals((long)intValue, (long)l);
        QueueControlTest.consumeMessages(1, this.session, queue);
        jsonString = queueControl.listMessagesAsJSON(null);
        Assertions.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)0, (int)array.size());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testListMessagesWithFilter() throws Exception {
        SimpleString key = SimpleString.of((String)"key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        String filter = key + " =" + matchingValue;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(this.durable);
        matchingMessage.putLongProperty(key, matchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)matchingMessage);
        ClientMessage unmatchingMessage = this.session.createMessage(this.durable);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)unmatchingMessage);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        Map[] messages = queueControl.listMessages(filter);
        Assertions.assertEquals((int)1, (int)messages.length);
        Assertions.assertEquals((long)matchingValue, (long)Long.parseLong(messages[0].get("key").toString()));
        QueueControlTest.consumeMessages(2, this.session, queue);
        messages = queueControl.listMessages(filter);
        Assertions.assertEquals((int)0, (int)messages.length);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testListMessagesWithNullFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable).putBytesProperty("bytes", new byte[]{37}));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        Wait.assertEquals((int)2, () -> queueControl.listMessages(null).length);
        QueueControlTest.consumeMessages(2, this.session, queue);
        Wait.assertEquals((int)0, () -> queueControl.listMessages(null).length);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testListMessagesWithEmptyFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        Wait.assertEquals((int)2, () -> queueControl.listMessages("").length);
        QueueControlTest.consumeMessages(2, this.session, queue);
        Wait.assertEquals((int)0, () -> queueControl.listMessages("").length);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testListMessagesAsJSONWithFilter() throws Exception {
        SimpleString key = SimpleString.of((String)"key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        String filter = key + " =" + matchingValue;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(this.durable);
        matchingMessage.putLongProperty(key, matchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)matchingMessage);
        ClientMessage unmatchingMessage = this.session.createMessage(this.durable);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)unmatchingMessage);
        String jsonString = queueControl.listMessagesAsJSON(filter);
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)1, (int)array.size());
        long l = Long.parseLong(((JsonValue)array.getJsonObject(0).get((Object)"key")).toString().replaceAll("\"", ""));
        Assertions.assertEquals((long)matchingValue, (long)l);
        QueueControlTest.consumeMessages(2, this.session, queue);
        jsonString = queueControl.listMessagesAsJSON(filter);
        Assertions.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)0, (int)array.size());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testRetryMessage() throws Exception {
        SimpleString dla = SimpleString.of((String)"DLA");
        SimpleString qName = SimpleString.of((String)"q1");
        SimpleString adName = SimpleString.of((String)"ad1");
        SimpleString dlq = SimpleString.of((String)"DLQ1");
        String sampleText = "Put me on DLQ";
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla);
        this.server.getAddressSettingsRepository().addMatch(adName.toString(), (Object)addressSettings);
        this.session.createQueue(QueueConfiguration.of((SimpleString)dlq).setAddress(dla).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)qName).setAddress(adName).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(adName);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.createTextMessage(this.session, "Put me on DLQ"));
        this.session.start();
        ClientConsumer clientConsumer = this.session.createConsumer(qName);
        ClientMessage clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assertions.assertNotNull((Object)clientMessage);
        Assertions.assertEquals((Object)clientMessage.getBodyBuffer().readString(), (Object)"Put me on DLQ");
        this.session.rollback();
        clientMessage = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)clientMessage);
        QueueControl queueControl = this.createManagementControl(dla, dlq);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        long messageID = this.getFirstMessageId(queueControl);
        Assertions.assertTrue((boolean)queueControl.retryMessage(messageID));
        Assertions.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assertions.assertNotNull((Object)clientMessage);
        Assertions.assertEquals((Object)"Put me on DLQ", (Object)clientMessage.getBodyBuffer().readString());
        clientConsumer.close();
    }

    @TestTemplate
    public void testRetryMessageWithAutoCreatedResources() throws Exception {
        SimpleString dla = SimpleString.of((String)"DLA");
        SimpleString qName = SimpleString.of((String)"q1");
        SimpleString adName = SimpleString.of((String)"ad1");
        String sampleText = "Put me on DLQ";
        AddressSettings addressSettings = (AddressSettings)this.server.getAddressSettingsRepository().getMatch(adName.toString());
        SimpleString dlq = addressSettings.getDeadLetterQueuePrefix().concat(adName).concat(addressSettings.getDeadLetterQueueSuffix());
        this.server.getAddressSettingsRepository().addMatch(adName.toString(), (Object)new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla).setAutoCreateDeadLetterResources(true));
        this.session.createQueue(QueueConfiguration.of((SimpleString)qName).setAddress(adName).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(adName);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.createTextMessage(this.session, "Put me on DLQ"));
        this.session.start();
        ClientConsumer clientConsumer = this.session.createConsumer(qName);
        ClientMessage clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assertions.assertNotNull((Object)clientMessage);
        Assertions.assertEquals((Object)clientMessage.getBodyBuffer().readString(), (Object)"Put me on DLQ");
        this.session.rollback();
        clientMessage = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)clientMessage);
        QueueControl queueControl = this.createManagementControl(dla, dlq);
        this.assertMessageMetrics(queueControl, 1L, true);
        long messageID = this.getFirstMessageId(queueControl);
        Assertions.assertTrue((boolean)queueControl.retryMessage(messageID));
        Assertions.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assertions.assertNotNull((Object)clientMessage);
        Assertions.assertEquals((Object)"Put me on DLQ", (Object)clientMessage.getBodyBuffer().readString());
        clientConsumer.close();
    }

    @TestTemplate
    public void testRetryMessageWithoutDLQ() throws Exception {
        SimpleString qName = SimpleString.of((String)"q1");
        SimpleString qName2 = SimpleString.of((String)"q2");
        SimpleString adName = SimpleString.of((String)"ad1");
        SimpleString adName2 = SimpleString.of((String)"ad2");
        String sampleText = "Put me on DLQ";
        this.session.createQueue(QueueConfiguration.of((SimpleString)qName).setAddress(adName).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)qName2).setAddress(adName2).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(adName);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.createTextMessage(this.session, "Put me on DLQ"));
        ClientMessage m = this.createTextMessage(this.session, "Put me on DLQ");
        m.putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIGINAL_ADDRESS, adName2);
        m.putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIGINAL_QUEUE, qName2);
        producer.send((org.apache.activemq.artemis.api.core.Message)m);
        this.session.start();
        QueueControl queueControl = this.createManagementControl(adName, qName);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        QueueControl queueControl2 = this.createManagementControl(adName2, qName2);
        this.assertMessageMetrics(queueControl2, 0L, this.durable);
        queueControl.retryMessages();
        Wait.assertTrue(() -> this.getMessageCount(queueControl) == 1L, (long)2000L, (long)100L);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        Wait.assertTrue(() -> this.getMessageCount(queueControl2) == 1L, (long)2000L, (long)100L);
        this.assertMessageMetrics(queueControl2, 1L, this.durable);
        ClientConsumer clientConsumer = this.session.createConsumer(qName);
        ClientMessage clientMessage = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        Assertions.assertEquals((Object)"Put me on DLQ", (Object)clientMessage.getBodyBuffer().readString());
        clientConsumer = this.session.createConsumer(qName2);
        clientMessage = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        Assertions.assertEquals((Object)"Put me on DLQ", (Object)clientMessage.getBodyBuffer().readString());
        clientConsumer.close();
    }

    @TestTemplate
    public void testRetryDivertedMessage() throws Exception {
        SimpleString dla = SimpleString.of((String)"DLA");
        SimpleString dlq = SimpleString.of((String)"DLQ");
        SimpleString forwardingQueue = SimpleString.of((String)"forwardingQueue");
        SimpleString forwardingAddress = SimpleString.of((String)"forwardingAddress");
        SimpleString myTopic = SimpleString.of((String)"myTopic");
        String sampleText = "Put me on DLQ";
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla);
        this.server.getAddressSettingsRepository().addMatch(forwardingAddress.toString(), (Object)addressSettings);
        this.session.createQueue(QueueConfiguration.of((SimpleString)dlq).setAddress(dla).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)forwardingQueue).setAddress(forwardingAddress).setDurable(Boolean.valueOf(this.durable)));
        this.session.createAddress(myTopic, RoutingType.MULTICAST, false);
        DivertConfiguration divert = new DivertConfiguration().setName("local-divert").setRoutingName("some-name").setAddress(myTopic.toString()).setForwardingAddress(forwardingAddress.toString()).setExclusive(false);
        this.server.deployDivert(divert);
        ClientProducer producer = this.session.createProducer(myTopic);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.createTextMessage(this.session, "Put me on DLQ"));
        this.session.start();
        ClientConsumer clientConsumer = this.session.createConsumer(forwardingQueue);
        ClientMessage clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assertions.assertNotNull((Object)clientMessage);
        Assertions.assertEquals((Object)clientMessage.getBodyBuffer().readString(), (Object)"Put me on DLQ");
        this.session.rollback();
        clientMessage = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)clientMessage);
        QueueControl queueControl = this.createManagementControl(dla, dlq, RoutingType.MULTICAST);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        long messageID = this.getFirstMessageId(queueControl);
        Assertions.assertTrue((boolean)queueControl.retryMessage(messageID));
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        clientMessage = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        Assertions.assertEquals((Object)"Put me on DLQ", (Object)clientMessage.getBodyBuffer().readString());
        clientConsumer.close();
    }

    @TestTemplate
    public void testRetryMultipleMessages() throws Exception {
        SimpleString dla = SimpleString.of((String)"DLA");
        SimpleString qName = SimpleString.of((String)"q1");
        SimpleString adName = SimpleString.of((String)"ad1");
        SimpleString dlq = SimpleString.of((String)"DLQ1");
        String sampleText = "Put me on DLQ";
        int numMessagesToTest = 10;
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla);
        this.server.getAddressSettingsRepository().addMatch(adName.toString(), (Object)addressSettings);
        this.session.createQueue(QueueConfiguration.of((SimpleString)dlq).setAddress(dla).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)qName).setAddress(adName).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(adName);
        for (int i = 0; i < 10; ++i) {
            producer.send((org.apache.activemq.artemis.api.core.Message)this.createTextMessage(this.session, "Put me on DLQ"));
        }
        this.session.start();
        LocalQueueBinding binding = (LocalQueueBinding)this.server.getPostOffice().getBinding(qName);
        org.apache.activemq.artemis.core.server.Queue q = binding.getQueue();
        LocalQueueBinding binding2 = (LocalQueueBinding)this.server.getPostOffice().getBinding(dlq);
        org.apache.activemq.artemis.core.server.Queue q2 = binding2.getQueue();
        Assertions.assertTrue((QueueImplTestAccessor.getQueueMemorySize(q) > 0L ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)QueueImplTestAccessor.getQueueMemorySize(q2));
        ClientConsumer clientConsumer = this.session.createConsumer(qName);
        for (int i = 0; i < 10; ++i) {
            ClientMessage clientMessage = clientConsumer.receive(500L);
            clientMessage.acknowledge();
            Assertions.assertNotNull((Object)clientMessage);
            Assertions.assertEquals((Object)clientMessage.getBodyBuffer().readString(), (Object)"Put me on DLQ");
            this.session.rollback();
        }
        Assertions.assertNull((Object)clientConsumer.receiveImmediate());
        Assertions.assertEquals((long)0L, (long)QueueImplTestAccessor.getQueueMemorySize(q));
        Assertions.assertTrue((QueueImplTestAccessor.getQueueMemorySize(q2) > 0L ? (byte)1 : 0) != 0);
        QueueControl dlqQueueControl = this.createManagementControl(dla, dlq);
        this.assertMessageMetrics(dlqQueueControl, 10L, this.durable);
        Assertions.assertEquals((int)10, (int)dlqQueueControl.retryMessages());
        this.assertMessageMetrics(dlqQueueControl, 0L, this.durable);
        Assertions.assertTrue((QueueImplTestAccessor.getQueueMemorySize(q) > 0L ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)QueueImplTestAccessor.getQueueMemorySize(q2));
        for (int i = 0; i < 10; ++i) {
            ClientMessage clientMessage = clientConsumer.receive(500L);
            clientMessage.acknowledge();
            Assertions.assertNotNull((Object)clientMessage);
            Assertions.assertEquals((Object)clientMessage.getBodyBuffer().readString(), (Object)"Put me on DLQ");
        }
        clientConsumer.close();
        Assertions.assertEquals((long)0L, (long)QueueImplTestAccessor.getQueueMemorySize(q));
        Assertions.assertEquals((long)0L, (long)QueueImplTestAccessor.getQueueMemorySize(q2));
    }

    @TestTemplate
    public void testSendToDLAIncludesPagedMessages() throws Exception {
        SimpleString dla = SimpleString.of((String)"DLA");
        SimpleString qName = SimpleString.of((String)"q1");
        SimpleString adName = SimpleString.of((String)"ad1");
        SimpleString dlq = SimpleString.of((String)"DLQ1");
        String sampleText = "Put me on DLQ";
        int messageCount = 10;
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla).setMaxSizeBytes(200L);
        this.server.getAddressSettingsRepository().addMatch(adName.toString(), (Object)addressSettings);
        this.server.getAddressSettingsRepository().addMatch(dla.toString(), (Object)addressSettings);
        this.session.createQueue(QueueConfiguration.of((SimpleString)dlq).setAddress(dla).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)qName).setAddress(adName).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(adName);
        for (int i = 0; i < 10; ++i) {
            producer.send((org.apache.activemq.artemis.api.core.Message)this.createTextMessage(this.session, "Put me on DLQ"));
        }
        Wait.assertTrue(() -> ((PagingStore)this.server.locateQueue(qName).getPagingStore()).isPaging());
        QueueControl queueControl = this.createManagementControl(adName, qName);
        Assertions.assertEquals((int)10, (int)queueControl.sendMessagesToDeadLetterAddress(null));
        Assertions.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        queueControl = this.createManagementControl(dla, dlq);
        Assertions.assertEquals((long)10L, (long)this.getMessageCount(queueControl));
        queueControl.removeAllMessages();
    }

    @TestTemplate
    public void testSendMessageToDLAIncludesPagedMessage() throws Exception {
        SimpleString dla = SimpleString.of((String)"DLA");
        SimpleString qName = SimpleString.of((String)"q1");
        SimpleString adName = SimpleString.of((String)"ad1");
        SimpleString dlq = SimpleString.of((String)"DLQ1");
        String sampleText = "Message Content";
        int messageCount = 10;
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla).setMaxSizeBytes(200L);
        this.server.getAddressSettingsRepository().addMatch(adName.toString(), (Object)addressSettings);
        this.server.getAddressSettingsRepository().addMatch(dla.toString(), (Object)addressSettings);
        this.session.createQueue(QueueConfiguration.of((SimpleString)dlq).setAddress(dla).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)qName).setAddress(adName).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(adName);
        for (int i = 0; i < 10; ++i) {
            producer.send((org.apache.activemq.artemis.api.core.Message)this.createTextMessage(this.session, "Message Content"));
        }
        Wait.assertTrue(() -> ((PagingStore)this.server.locateQueue(qName).getPagingStore()).isPaging());
        producer.send((org.apache.activemq.artemis.api.core.Message)this.createTextMessage(this.session, "Message Content").putStringProperty("myID", "unique"));
        QueueControl queueControl = this.createManagementControl(adName, qName);
        Map[] messages = queueControl.listMessages(null);
        long messageID = (Long)messages[10].get("messageID");
        Assertions.assertTrue((boolean)queueControl.sendMessageToDeadLetterAddress(messageID));
        queueControl.removeAllMessages();
        queueControl = this.createManagementControl(dla, dlq);
        messages = queueControl.listMessages(null);
        Assertions.assertEquals((int)1, (int)messages.length);
        Assertions.assertEquals((Object)"unique", (Object)((String)messages[0].get("myID")));
        queueControl.removeAllMessages();
    }

    @TestTemplate
    public void testMoveMessages() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString otherAddress = RandomUtil.randomSimpleString();
        SimpleString otherQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)otherQueue).setAddress(otherAddress).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        SimpleString key = RandomUtil.randomSimpleString();
        long value = RandomUtil.randomLong();
        message.putLongProperty(key, value);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        LocalQueueBinding binding = (LocalQueueBinding)this.server.getPostOffice().getBinding(queue);
        org.apache.activemq.artemis.core.server.Queue q = binding.getQueue();
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        Assertions.assertTrue((QueueImplTestAccessor.getQueueMemorySize(q) > 0L ? (byte)1 : 0) != 0);
        int movedMessagesCount = queueControl.moveMessages(null, otherQueue.toString());
        Assertions.assertEquals((int)1, (int)movedMessagesCount);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        Assertions.assertEquals((long)0L, (long)QueueImplTestAccessor.getQueueMemorySize(q));
        QueueControlTest.consumeMessages(0, this.session, queue);
        ClientConsumer otherConsumer = this.session.createConsumer(otherQueue);
        ClientMessage m = otherConsumer.receive(500L);
        Assertions.assertEquals((Object)value, (Object)m.getObjectProperty(key));
        m.acknowledge();
        this.session.deleteQueue(queue);
        otherConsumer.close();
        this.session.deleteQueue(otherQueue);
    }

    @TestTemplate
    public void testMoveMessages2() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queueA = SimpleString.of((String)"A");
        SimpleString queueB = SimpleString.of((String)"B");
        SimpleString queueC = SimpleString.of((String)"C");
        this.server.createQueue(QueueConfiguration.of((SimpleString)queueA).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.server.createQueue(QueueConfiguration.of((SimpleString)queueB).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.server.createQueue(QueueConfiguration.of((SimpleString)queueC).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControlA = this.createManagementControl(address, queueA);
        QueueControl queueControlB = this.createManagementControl(address, queueB);
        QueueControl queueControlC = this.createManagementControl(address, queueC);
        queueControlA.sendMessage(new HashMap(), 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword");
        queueControlA.sendMessage(new HashMap(), 4, Base64.encodeBytes((byte[])"theBody2".getBytes()), true, "myUser", "myPassword");
        Wait.assertEquals((long)2L, () -> this.getMessageCount(queueControlA));
        Wait.assertEquals((long)0L, () -> this.getMessageCount(queueControlB));
        Wait.assertEquals((long)0L, () -> this.getMessageCount(queueControlC));
        queueControlA.moveMessages(null, queueB.toString());
        Thread.sleep(500L);
        Wait.assertEquals((long)0L, () -> this.getMessageCount(queueControlA));
        Wait.assertEquals((long)2L, () -> this.getMessageCount(queueControlB));
        queueControlA.sendMessage(new HashMap(), 4, Base64.encodeBytes((byte[])"theBody3".getBytes()), true, "myUser", "myPassword");
        Wait.assertEquals((long)1L, () -> this.getMessageCount(queueControlA));
        queueControlA.moveMessages(null, queueC.toString());
        Wait.assertEquals((long)1L, () -> this.getMessageCount(queueControlC));
        Wait.assertEquals((long)0L, () -> this.getMessageCount(queueControlA));
        queueControlB.moveMessages(null, queueA.toString());
        Wait.assertEquals((long)2L, () -> this.getMessageCount(queueControlA));
        Wait.assertEquals((long)0L, () -> this.getMessageCount(queueControlB));
        queueControlC.moveMessages(null, queueA.toString());
        Wait.assertEquals((long)3L, () -> this.getMessageCount(queueControlA));
        Wait.assertEquals((long)0L, () -> this.getMessageCount(queueControlC));
        ClientConsumer consumer = this.session.createConsumer(queueA);
        ClientMessage m1 = consumer.receive(500L);
        ClientMessage m2 = consumer.receive(500L);
        ClientMessage m3 = consumer.receive(500L);
        m1.acknowledge();
        m2.acknowledge();
        m3.acknowledge();
        consumer.close();
        this.session.deleteQueue(queueA);
        this.session.deleteQueue(queueB);
        this.session.deleteQueue(queueC);
    }

    @TestTemplate
    public void testMoveMessagesToUnknownQueue() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString unknownQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        SimpleString key = RandomUtil.randomSimpleString();
        long value = RandomUtil.randomLong();
        message.putLongProperty(key, value);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        try {
            queueControl.moveMessages(null, unknownQueue.toString());
            Assertions.fail((String)"operation must fail if the other queue does not exist");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertEquals((long)1L, (long)this.getMessageCount(queueControl));
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        QueueControlTest.consumeMessages(1, this.session, queue);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testMoveMessagesWithFilter() throws Exception {
        SimpleString key = SimpleString.of((String)"key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString otherAddress = RandomUtil.randomSimpleString();
        SimpleString otherQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)otherQueue).setAddress(otherAddress).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(this.durable);
        matchingMessage.putLongProperty(key, matchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)matchingMessage);
        ClientMessage unmatchingMessage = this.session.createMessage(this.durable);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)unmatchingMessage);
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        int movedMatchedMessagesCount = queueControl.moveMessages(key + " =" + matchingValue, otherQueue.toString());
        Assertions.assertEquals((int)1, (int)movedMatchedMessagesCount);
        Assertions.assertEquals((long)1L, (long)this.getMessageCount(queueControl));
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage m = consumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)unmatchingValue, (Object)m.getObjectProperty(key));
        ClientConsumer otherConsumer = this.session.createConsumer(otherQueue);
        m = otherConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)matchingValue, (Object)m.getObjectProperty(key));
        m.acknowledge();
        consumer.close();
        this.session.deleteQueue(queue);
        otherConsumer.close();
        this.session.deleteQueue(otherQueue);
    }

    @TestTemplate
    public void testMoveMessagesWithMessageCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString otherAddress = RandomUtil.randomSimpleString();
        SimpleString otherQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)otherQueue).setAddress(otherAddress).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        for (int i = 0; i < 10; ++i) {
            ClientMessage message = this.session.createMessage(this.durable);
            SimpleString key = RandomUtil.randomSimpleString();
            long value = RandomUtil.randomLong();
            message.putLongProperty(key, value);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        LocalQueueBinding binding = (LocalQueueBinding)this.server.getPostOffice().getBinding(queue);
        Wait.assertEquals((long)10L, () -> binding.getQueue().getMessageCount());
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)10L, (long)queueControl.getMessageCount());
        int movedMessagesCount = queueControl.moveMessages(500, null, otherQueue.toString(), false, 5);
        Assertions.assertEquals((int)5, (int)movedMessagesCount);
        Assertions.assertEquals((long)5L, (long)queueControl.getMessageCount());
        QueueControlTest.consumeMessages(5, this.session, queue);
        QueueControlTest.consumeMessages(5, this.session, otherQueue);
        this.session.deleteQueue(queue);
        this.session.deleteQueue(otherQueue);
    }

    @TestTemplate
    public void testMoveMessage() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString otherAddress = RandomUtil.randomSimpleString();
        SimpleString otherQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)otherQueue).setAddress(otherAddress).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        QueueControl otherQueueControl = this.createManagementControl(otherAddress, otherQueue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        this.assertMessageMetrics(otherQueueControl, 0L, this.durable);
        Map[] messages = queueControl.listMessages(null);
        Assertions.assertEquals((int)2, (int)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        boolean moved = queueControl.moveMessage(messageID, otherQueue.toString());
        Assertions.assertTrue((boolean)moved);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        this.assertMessageMetrics(otherQueueControl, 1L, this.durable);
        QueueControlTest.consumeMessages(1, this.session, queue);
        QueueControlTest.consumeMessages(1, this.session, otherQueue);
        this.session.deleteQueue(queue);
        this.session.deleteQueue(otherQueue);
    }

    @TestTemplate
    public void testMoveMessageToFQQN() throws Exception {
        SimpleString address = SimpleString.of((String)"ErrorQueue");
        SimpleString queue = SimpleString.of((String)"ErrorQueue");
        SimpleString otherAddress = SimpleString.of((String)"parent.addr.1");
        SimpleString otherQueue1 = SimpleString.of((String)"child.queue.1");
        SimpleString otherQueue2 = SimpleString.of((String)"child.queue.2");
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)otherQueue1).setAddress(otherAddress).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)otherQueue2).setAddress(otherAddress).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue, RoutingType.ANYCAST);
        QueueControl otherQueue1Control = this.createManagementControl(otherAddress, otherQueue1);
        QueueControl otherQueue2Control = this.createManagementControl(otherAddress, otherQueue2);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        this.assertMessageMetrics(otherQueue1Control, 0L, this.durable);
        this.assertMessageMetrics(otherQueue2Control, 0L, this.durable);
        Map[] messages = queueControl.listMessages(null);
        Assertions.assertEquals((int)2, (int)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        boolean moved = queueControl.moveMessage(messageID, otherQueue1.toString());
        Assertions.assertTrue((boolean)moved);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        this.assertMessageMetrics(otherQueue1Control, 1L, this.durable);
        this.assertMessageMetrics(otherQueue2Control, 0L, this.durable);
        QueueControlTest.consumeMessages(1, this.session, queue);
        QueueControlTest.consumeMessages(1, this.session, otherQueue1);
        this.session.deleteQueue(queue);
        this.session.deleteQueue(otherQueue1);
        this.session.deleteQueue(otherQueue2);
    }

    @TestTemplate
    public void testMoveMessageToUnknownQueue() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString unknownQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        Map[] messages = queueControl.listMessages(null);
        Assertions.assertEquals((int)1, (int)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        try {
            queueControl.moveMessage(messageID, unknownQueue.toString());
            Assertions.fail((String)"operation must fail if the other queue does not exist");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertEquals((long)1L, (long)this.getMessageCount(queueControl));
        QueueControlTest.consumeMessages(1, this.session, queue);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testCopiedMessageProperties() throws Exception {
        String testAddress = "testAddress";
        SimpleString queue = SimpleString.of((String)"queue");
        int COUNT = 5;
        for (int i = 0; i < 5; ++i) {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queue.concat(Integer.toString(i))).setAddress("testAddress" + i).setRoutingType(RoutingType.ANYCAST));
        }
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        session.start();
        ClientProducer producer = session.createProducer(SimpleString.of((String)"testAddress0"));
        ClientMessage message = session.createMessage(this.durable);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        producer.close();
        for (int i = 0; i < 4; ++i) {
            QueueControl queueControl = this.createManagementControl(SimpleString.of((String)("testAddress" + i)), queue.concat(Integer.toString(i)), RoutingType.ANYCAST);
            QueueControl otherQueueControl = this.createManagementControl(SimpleString.of((String)("testAddress" + (i + 1))), queue.concat(Integer.toString(i + 1)), RoutingType.ANYCAST);
            this.assertMessageMetrics(queueControl, 1L, this.durable);
            this.assertMessageMetrics(otherQueueControl, 0L, this.durable);
            int moved = queueControl.moveMessages(null, queue.concat(Integer.toString(i + 1)).toString());
            Assertions.assertEquals((int)1, (int)moved);
            this.assertMessageMetrics(queueControl, 0L, this.durable);
            this.assertMessageMetrics(otherQueueControl, 1L, this.durable);
        }
        ClientConsumer consumer1 = session.createConsumer(queue.concat(Integer.toString(4)));
        message = consumer1.receive(1000L);
        Assertions.assertNotNull((Object)message);
        message.acknowledge();
        System.out.println(message);
        Assertions.assertEquals((Object)"testAddress4", (Object)message.getAddress());
        Assertions.assertEquals((Object)"testAddress3", (Object)message.getStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIGINAL_ADDRESS));
    }

    @TestTemplate
    public void testRemoveMessages() throws Exception {
        SimpleString key = SimpleString.of((String)"key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(this.durable);
        matchingMessage.putLongProperty(key, matchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)matchingMessage);
        ClientMessage unmatchingMessage = this.session.createMessage(this.durable);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)unmatchingMessage);
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        int removedMatchedMessagesCount = queueControl.removeMessages(key + " =" + matchingValue);
        Assertions.assertEquals((int)1, (int)removedMatchedMessagesCount);
        Assertions.assertEquals((long)1L, (long)this.getMessageCount(queueControl));
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage m = consumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)unmatchingValue, (Object)m.getObjectProperty(key));
        m.acknowledge();
        m = consumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testRemoveMessagesWithLimit() throws Exception {
        SimpleString key = SimpleString.of((String)"key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(this.durable);
        matchingMessage.putLongProperty(key, matchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)matchingMessage);
        ClientMessage unmatchingMessage = this.session.createMessage(this.durable);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)unmatchingMessage);
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        int removedMatchedMessagesCount = queueControl.removeMessages(5, key + " =" + matchingValue);
        Assertions.assertEquals((int)1, (int)removedMatchedMessagesCount);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage m = consumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)unmatchingValue, (Object)m.getObjectProperty(key));
        m.acknowledge();
        m = consumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testRemoveMessagesWithNullFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        int removedMatchedMessagesCount = queueControl.removeMessages(null);
        Assertions.assertEquals((int)2, (int)removedMatchedMessagesCount);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testRemoveAllMessages() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        int removedMatchedMessagesCount = queueControl.removeAllMessages();
        Assertions.assertEquals((int)2, (int)removedMatchedMessagesCount);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testRemoveAllWithPagingMode() throws Exception {
        int MESSAGE_SIZE = 3072;
        PagingManagerTestAccessor.resetMaxSize(this.server.getPagingManager(), 10240L, 0L);
        this.clearDataRecreateServerDirs();
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queueName = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        org.apache.activemq.artemis.core.server.Queue queue = this.server.locateQueue(queueName);
        Assertions.assertFalse((boolean)queue.getPageSubscription().isPaging());
        ClientProducer producer = this.session.createProducer(address);
        byte[] body = new byte[3072];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 3072; ++j) {
            bb.put(QueueControlTest.getSamplebyte(j));
        }
        int numberOfMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        Assertions.assertTrue((boolean)queue.getPageSubscription().isPaging());
        QueueControl queueControl = this.createManagementControl(address, queueName);
        this.assertMessageMetrics(queueControl, 100L, this.durable);
        int removedMatchedMessagesCount = queueControl.removeAllMessages();
        Assertions.assertEquals((int)100, (int)removedMatchedMessagesCount);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        Assertions.assertEquals((long)0L, (long)QueueImplTestAccessor.getQueueMemorySize(queue));
        this.session.deleteQueue(queueName);
    }

    @TestTemplate
    public void testRemoveMessagesWithEmptyFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        int removedMatchedMessagesCount = queueControl.removeMessages("");
        Assertions.assertEquals((int)2, (int)removedMatchedMessagesCount);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testRemoveMessage() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        Map[] messages = queueControl.listMessages(null);
        Assertions.assertEquals((int)2, (int)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        boolean deleted = queueControl.removeMessage(messageID);
        Assertions.assertTrue((boolean)deleted);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        QueueControlTest.consumeMessages(1, this.session, queue);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testRemoveScheduledMessage() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        long timeout = System.currentTimeMillis() + 5000L;
        ClientMessage m1 = this.session.createMessage(this.durable);
        m1.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_SCHEDULED_DELIVERY_TIME, timeout);
        producer.send((org.apache.activemq.artemis.api.core.Message)m1);
        ClientMessage m2 = this.session.createMessage(this.durable);
        m2.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_SCHEDULED_DELIVERY_TIME, timeout);
        producer.send((org.apache.activemq.artemis.api.core.Message)m2);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)2L, (long)queueControl.getScheduledCount());
        Map[] messages = queueControl.listScheduledMessages();
        Assertions.assertEquals((int)2, (int)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        boolean deleted = queueControl.removeMessage(messageID);
        Assertions.assertTrue((boolean)deleted);
        this.assertScheduledMetrics(queueControl, 1L, this.durable);
        while (timeout > System.currentTimeMillis() && queueControl.getScheduledCount() == 1L) {
            Thread.sleep(100L);
        }
        QueueControlTest.consumeMessages(1, this.session, queue);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testRemoveScheduledMessageRestart() throws Exception {
        Assumptions.assumeTrue((boolean)this.durable);
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        long timeout = System.currentTimeMillis() + 5000L;
        ClientMessage m1 = this.session.createMessage(this.durable);
        m1.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_SCHEDULED_DELIVERY_TIME, timeout);
        producer.send((org.apache.activemq.artemis.api.core.Message)m1);
        ClientMessage m2 = this.session.createMessage(this.durable);
        m2.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_SCHEDULED_DELIVERY_TIME, timeout);
        producer.send((org.apache.activemq.artemis.api.core.Message)m2);
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertScheduledMetrics(queueControl, 2L, this.durable);
        Map[] messages = queueControl.listScheduledMessages();
        Assertions.assertEquals((int)2, (int)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        boolean deleted = queueControl.removeMessage(messageID);
        Assertions.assertTrue((boolean)deleted);
        this.assertScheduledMetrics(queueControl, 1L, this.durable);
        this.locator.close();
        this.server.stop();
        this.server.start();
        this.assertScheduledMetrics(queueControl, 1L, this.durable);
    }

    @TestTemplate
    public void testRemoveMessage2() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = this.session.createMessage(this.durable);
            msg.putIntProperty("count", i);
            producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        }
        ClientConsumer cons = this.session.createConsumer(queue);
        this.session.start();
        LinkedList<ClientMessage> msgs = new LinkedList<ClientMessage>();
        for (int i = 0; i < 50; ++i) {
            ClientMessage msg = cons.receive(1000L);
            msgs.add(msg);
        }
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 100L, this.durable);
        Map[] messages = queueControl.listMessages(null);
        Assertions.assertEquals((int)50, (int)messages.length);
        int i = Integer.parseInt(messages[0].get("count").toString());
        Assertions.assertEquals((int)50, (int)i);
        long messageID = (Long)messages[0].get("messageID");
        boolean deleted = queueControl.removeMessage(messageID);
        Assertions.assertTrue((boolean)deleted);
        this.assertMessageMetrics(queueControl, 99L, this.durable);
        cons.close();
        QueueControlTest.consumeMessages(99, this.session, queue);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testCountDeliveringMessageCountWithFilter() throws Exception {
        SimpleString key = SimpleString.of((String)"key");
        long matchingValue = RandomUtil.randomPositiveLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(false);
        matchingMessage.putLongProperty(key, matchingValue);
        ClientMessage unmatchingMessage = this.session.createMessage(false);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)matchingMessage);
        producer.send((org.apache.activemq.artemis.api.core.Message)unmatchingMessage);
        producer.send((org.apache.activemq.artemis.api.core.Message)matchingMessage);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)queueControl.countDeliveringMessages(null));
        Assertions.assertEquals((long)0L, (long)queueControl.countDeliveringMessages(key + " =" + matchingValue));
        Assertions.assertEquals((long)0L, (long)queueControl.countDeliveringMessages(key + " =" + unmatchingValue));
        ClientConsumer consumer = this.session.createConsumer(queue, null, 0x100000, 1, false);
        ClientMessage message = consumer.receive(500L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((long)3L, (long)queueControl.countDeliveringMessages(null));
        Assertions.assertEquals((long)2L, (long)queueControl.countDeliveringMessages(key + " =" + matchingValue));
        Assertions.assertEquals((long)1L, (long)queueControl.countDeliveringMessages(key + " =" + unmatchingValue));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testCountDeliveringMessageCountNoFilter() throws Exception {
        SimpleString key = SimpleString.of((String)"key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(false);
        matchingMessage.putLongProperty(key, matchingValue);
        ClientMessage unmatchingMessage = this.session.createMessage(false);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)matchingMessage);
        producer.send((org.apache.activemq.artemis.api.core.Message)unmatchingMessage);
        producer.send((org.apache.activemq.artemis.api.core.Message)matchingMessage);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)queueControl.countDeliveringMessages(null));
        ClientConsumer consumer = this.session.createConsumer(queue, null, 0x100000, 1, false);
        ClientMessage message = consumer.receive(500L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((long)3L, (long)queueControl.countDeliveringMessages(null));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testCountDeliveringMessageCountNoGroupNoFilter() throws Exception {
        SimpleString key = SimpleString.of((String)"key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(false);
        matchingMessage.putLongProperty(key, matchingValue);
        ClientMessage unmatchingMessage = this.session.createMessage(false);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)matchingMessage);
        producer.send((org.apache.activemq.artemis.api.core.Message)unmatchingMessage);
        producer.send((org.apache.activemq.artemis.api.core.Message)matchingMessage);
        this.session.commit();
        QueueControl queueControl = this.createManagementControl(address, queue);
        String result = queueControl.countDeliveringMessages(null, null);
        JsonObject jsonObject = JsonUtil.readJsonObject((String)result);
        Assertions.assertEquals((int)0, (int)jsonObject.getInt("null"));
        ClientConsumer consumer = this.session.createConsumer(queue, null, 0x100000, 1, false);
        ClientMessage message = consumer.receive(500L);
        Assertions.assertNotNull((Object)message);
        result = queueControl.countDeliveringMessages(null, null);
        jsonObject = JsonUtil.readJsonObject((String)result);
        Assertions.assertEquals((int)3, (int)jsonObject.getInt("null"));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testCountDeliveringMessageCountGroupNoFilter() throws Exception {
        String key = new String("key_group");
        String valueGroup1 = "group_1";
        String valueGroup2 = "group_2";
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message1 = this.session.createMessage(false);
        message1.putStringProperty(key, valueGroup1);
        ClientMessage message2 = this.session.createMessage(false);
        message2.putStringProperty(key, valueGroup2);
        producer.send((org.apache.activemq.artemis.api.core.Message)message1);
        producer.send((org.apache.activemq.artemis.api.core.Message)message2);
        producer.send((org.apache.activemq.artemis.api.core.Message)message1);
        QueueControl queueControl = this.createManagementControl(address, queue);
        String result = queueControl.countDeliveringMessages(null, key);
        JsonObject jsonObject = JsonUtil.readJsonObject((String)result);
        Assertions.assertTrue((boolean)jsonObject.isEmpty());
        ClientConsumer consumer = this.session.createConsumer(queue, null, 0x100000, 1, false);
        ClientMessage message = consumer.receive(500L);
        Assertions.assertNotNull((Object)message);
        result = queueControl.countDeliveringMessages(null, key);
        jsonObject = JsonUtil.readJsonObject((String)result);
        Assertions.assertEquals((int)2, (int)jsonObject.getInt(valueGroup1));
        Assertions.assertEquals((int)1, (int)jsonObject.getInt(valueGroup2));
        Assertions.assertFalse((boolean)jsonObject.containsKey(null));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testCountDeliveringMessageCountGroupFilter() throws Exception {
        String key = new String("key_group");
        long valueGroup1 = RandomUtil.randomLong();
        long valueGroup2 = valueGroup1 + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message1 = this.session.createMessage(false);
        message1.putLongProperty(key, valueGroup1);
        ClientMessage message2 = this.session.createMessage(false);
        message2.putLongProperty(key, valueGroup2);
        producer.send((org.apache.activemq.artemis.api.core.Message)message1);
        producer.send((org.apache.activemq.artemis.api.core.Message)message2);
        producer.send((org.apache.activemq.artemis.api.core.Message)message1);
        this.session.commit();
        QueueControl queueControl = this.createManagementControl(address, queue);
        String result = queueControl.countDeliveringMessages(key + " =" + valueGroup1, key);
        JsonObject jsonObject = JsonUtil.readJsonObject((String)result);
        Assertions.assertTrue((boolean)jsonObject.isEmpty());
        ClientConsumer consumer = this.session.createConsumer(queue, null, 0x100000, 1, false);
        ClientMessage message = consumer.receive(500L);
        Assertions.assertNotNull((Object)message);
        result = queueControl.countDeliveringMessages(key + " =" + valueGroup1, key);
        jsonObject = JsonUtil.readJsonObject((String)result);
        Assertions.assertEquals((int)2, (int)jsonObject.getInt(String.valueOf(valueGroup1)));
        Assertions.assertFalse((boolean)jsonObject.containsKey((Object)String.valueOf(valueGroup2)));
        Assertions.assertFalse((boolean)jsonObject.containsKey(null));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testCountMessagesWithFilter() throws Exception {
        SimpleString key = SimpleString.of((String)"key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(this.durable);
        matchingMessage.putLongProperty(key, matchingValue);
        ClientMessage unmatchingMessage = this.session.createMessage(this.durable);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)matchingMessage);
        producer.send((org.apache.activemq.artemis.api.core.Message)unmatchingMessage);
        producer.send((org.apache.activemq.artemis.api.core.Message)matchingMessage);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)3L, (long)this.getMessageCount(queueControl));
        this.assertMessageMetrics(queueControl, 3L, this.durable);
        Assertions.assertEquals((long)2L, (long)queueControl.countMessages(key + " =" + matchingValue));
        Assertions.assertEquals((long)1L, (long)queueControl.countMessages(key + " =" + unmatchingValue));
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testCountMessagesWithInvalidFilter() throws Exception {
        ClientMessage msg;
        int i;
        SimpleString key = SimpleString.of((String)"key");
        String matchingValue = "MATCH";
        String nonMatchingValue = "DIFFERENT";
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        for (i = 0; i < 100; ++i) {
            msg = this.session.createMessage(this.durable);
            msg.putStringProperty(key, SimpleString.of((String)matchingValue));
            producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        }
        for (i = 0; i < 10; ++i) {
            msg = this.session.createMessage(this.durable);
            msg.putStringProperty(key, SimpleString.of((String)nonMatchingValue));
            producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        }
        this.session.commit();
        ClientConsumer consumer = this.session.createConsumer(queue, SimpleString.of((String)"nonExistentProperty like '%Temp/88'"));
        this.session.start();
        Assertions.assertNull((Object)consumer.receiveImmediate());
        QueueControl queueControl = this.createManagementControl(address, queue);
        this.assertMessageMetrics(queueControl, 110L, this.durable);
        Assertions.assertEquals((long)0L, (long)queueControl.countMessages("nonExistentProperty like '%Temp/88'"));
        Assertions.assertEquals((long)100L, (long)queueControl.countMessages(key + "='" + matchingValue + "'"));
        Assertions.assertEquals((long)10L, (long)queueControl.countMessages(key + " = '" + nonMatchingValue + "'"));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testCountMessagesPropertyExist() throws Exception {
        ClientMessage msg;
        int i;
        String key = new String("key_group");
        String valueGroup1 = "group_1";
        String valueGroup2 = "group_2";
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        for (i = 0; i < 100; ++i) {
            msg = this.session.createMessage(false);
            if (i % 3 == 0) {
                msg.putStringProperty(key, valueGroup1);
            } else {
                msg.putStringProperty(key, valueGroup2);
            }
            producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        }
        for (i = 0; i < 20; ++i) {
            msg = this.session.createMessage(false);
            producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        }
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)120L, (long)this.getMessageCount(queueControl));
        String result = queueControl.countMessages(null, key);
        JsonObject jsonObject = JsonUtil.readJsonObject((String)result);
        Assertions.assertEquals((int)34, (int)jsonObject.getInt(valueGroup1));
        Assertions.assertEquals((int)66, (int)jsonObject.getInt(valueGroup2));
        Assertions.assertEquals((int)20, (int)jsonObject.getInt("null"));
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testCountMessagesPropertyWithNullFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = this.session.createMessage(false);
            msg.putStringProperty(RandomUtil.randomString(), RandomUtil.randomString());
            producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        }
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)100L, (long)this.getMessageCount(queueControl));
        String result = queueControl.countMessages(null, null);
        JsonObject jsonObject = JsonUtil.readJsonObject((String)result);
        Assertions.assertEquals((int)100, (int)jsonObject.getInt("null"));
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testExpireMessagesWithFilter() throws Exception {
        SimpleString key = SimpleString.of((String)"key");
        long matchingValue = RandomUtil.randomLong();
        long unmatchingValue = matchingValue + 1L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage matchingMessage = this.session.createMessage(this.durable);
        matchingMessage.putLongProperty(key, matchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)matchingMessage);
        ClientMessage unmatchingMessage = this.session.createMessage(this.durable);
        unmatchingMessage.putLongProperty(key, unmatchingValue);
        producer.send((org.apache.activemq.artemis.api.core.Message)unmatchingMessage);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)2L, (long)this.getMessageCount(queueControl));
        int expiredMessagesCount = queueControl.expireMessages(key + " =" + matchingValue);
        Assertions.assertEquals((int)1, (int)expiredMessagesCount);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage m = consumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)unmatchingValue, (Object)m.getObjectProperty(key));
        m.acknowledge();
        m = consumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        consumer.close();
        this.session.deleteQueue(queue);
        this.session.close();
    }

    @TestTemplate
    public void testExpireMessage() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString expiryAddress = RandomUtil.randomSimpleString();
        SimpleString expiryQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)expiryQueue).setAddress(expiryAddress).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        QueueControl expiryQueueControl = this.createManagementControl(expiryAddress, expiryQueue);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        this.assertMessageMetrics(expiryQueueControl, 0L, this.durable);
        Map[] messages = queueControl.listMessages(null);
        Assertions.assertEquals((int)1, (int)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(expiryAddress);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        boolean expired = queueControl.expireMessage(messageID);
        Assertions.assertTrue((boolean)expired);
        Thread.sleep(200L);
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        this.assertMessageMetrics(expiryQueueControl, 1L, this.durable);
        QueueControlTest.consumeMessages(0, this.session, queue);
        QueueControlTest.consumeMessages(1, this.session, expiryQueue);
        this.session.deleteQueue(queue);
        this.session.deleteQueue(expiryQueue);
        this.session.close();
    }

    @TestTemplate
    public void testSendMessageToDeadLetterAddress() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString deadLetterAddress = RandomUtil.randomSimpleString();
        SimpleString deadLetterQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        this.session.createQueue(QueueConfiguration.of((SimpleString)deadLetterQueue).setAddress(deadLetterAddress).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        QueueControl queueControl = this.createManagementControl(address, queue);
        QueueControl deadLetterQueueControl = this.createManagementControl(deadLetterAddress, deadLetterQueue);
        this.assertMessageMetrics(queueControl, 2L, this.durable);
        Map[] messages = queueControl.listMessages(null);
        Assertions.assertEquals((int)2, (int)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        AddressSettings addressSettings = new AddressSettings().setDeadLetterAddress(deadLetterAddress);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        Assertions.assertEquals((long)0L, (long)this.getMessageCount(deadLetterQueueControl));
        boolean movedToDeadLetterAddress = queueControl.sendMessageToDeadLetterAddress(messageID);
        Assertions.assertTrue((boolean)movedToDeadLetterAddress);
        this.assertMessageMetrics(queueControl, 1L, this.durable);
        Thread.sleep(200L);
        this.assertMessageMetrics(deadLetterQueueControl, 1L, this.durable);
        QueueControlTest.consumeMessages(1, this.session, queue);
        QueueControlTest.consumeMessages(1, this.session, deadLetterQueue);
        this.session.deleteQueue(queue);
        this.session.deleteQueue(deadLetterQueue);
    }

    @TestTemplate
    public void testChangeMessagePriority() throws Exception {
        byte originalPriority = 1;
        byte newPriority = 8;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        message.setPriority(originalPriority);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Wait.assertEquals((long)1L, () -> this.getMessageCount(queueControl));
        Map[] messages = queueControl.listMessages(null);
        Assertions.assertEquals((int)1, (int)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        boolean priorityChanged = queueControl.changeMessagePriority(messageID, (int)newPriority);
        Assertions.assertTrue((boolean)priorityChanged);
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage m = consumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((byte)newPriority, (byte)m.getPriority());
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testChangeMessagePriorityWithInvalidValue() throws Exception {
        byte invalidPriority = 23;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        QueueControl queueControl = this.createManagementControl(address, queue);
        Wait.assertEquals((long)1L, () -> this.getMessageCount(queueControl));
        Map[] messages = queueControl.listMessages(null);
        Assertions.assertEquals((int)1, (int)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        try {
            queueControl.changeMessagePriority(messageID, (int)invalidPriority);
            Assertions.fail((String)"operation fails when priority value is < 0 or > 9");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage m = consumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertTrue((invalidPriority != m.getPriority() ? (byte)1 : 0) != 0);
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testListMessageCounter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ActiveMQServerControl serverControl = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        serverControl.enableMessageCounters();
        serverControl.setMessageCounterSamplePeriod(99999L);
        String jsonString = queueControl.listMessageCounter();
        MessageCounterInfo info = MessageCounterInfo.fromJSON((String)jsonString);
        Assertions.assertEquals((int)0, (int)info.getDepth());
        Assertions.assertEquals((long)0L, (long)info.getCount());
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        Wait.assertTrue(() -> this.server.locateQueue(queue).getMessageCount() == 1L);
        ((MessageCounterManagerImpl)this.server.getManagementService().getMessageCounterManager()).getMessageCounter(queue.toString()).onTimer();
        Thread.sleep(50L);
        jsonString = queueControl.listMessageCounter();
        info = MessageCounterInfo.fromJSON((String)jsonString);
        Assertions.assertEquals((int)1, (int)info.getDepth());
        Assertions.assertEquals((int)1, (int)info.getDepthDelta());
        Assertions.assertEquals((long)1L, (long)info.getCount());
        Assertions.assertEquals((long)1L, (long)info.getCountDelta());
        Assertions.assertEquals((Object)info.getUpdateTimestamp(), (Object)info.getLastAddTimestamp());
        Assertions.assertEquals((Object)NULL_DATE, (Object)info.getLastAckTimestamp());
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        Wait.assertTrue(() -> this.server.locateQueue(queue).getMessageCount() == 2L);
        ((MessageCounterManagerImpl)this.server.getManagementService().getMessageCounterManager()).getMessageCounter(queue.toString()).onTimer();
        Thread.sleep(50L);
        jsonString = queueControl.listMessageCounter();
        info = MessageCounterInfo.fromJSON((String)jsonString);
        Assertions.assertEquals((int)2, (int)info.getDepth());
        Assertions.assertEquals((int)1, (int)info.getDepthDelta());
        Assertions.assertEquals((long)2L, (long)info.getCount());
        Assertions.assertEquals((long)1L, (long)info.getCountDelta());
        Assertions.assertEquals((Object)info.getUpdateTimestamp(), (Object)info.getLastAddTimestamp());
        Assertions.assertEquals((Object)NULL_DATE, (Object)info.getLastAckTimestamp());
        QueueControlTest.consumeMessages(2, this.session, queue);
        ((MessageCounterManagerImpl)this.server.getManagementService().getMessageCounterManager()).getMessageCounter(queue.toString()).onTimer();
        Thread.sleep(50L);
        jsonString = queueControl.listMessageCounter();
        info = MessageCounterInfo.fromJSON((String)jsonString);
        Assertions.assertEquals((int)0, (int)info.getDepth());
        Assertions.assertEquals((int)-2, (int)info.getDepthDelta());
        Assertions.assertEquals((long)2L, (long)info.getCount());
        Assertions.assertEquals((long)0L, (long)info.getCountDelta());
        Assertions.assertEquals((Object)info.getUpdateTimestamp(), (Object)info.getLastAckTimestamp());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testResetMessageCounter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ActiveMQServerControl serverControl = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        serverControl.enableMessageCounters();
        serverControl.setMessageCounterSamplePeriod(1000L);
        String jsonString = queueControl.listMessageCounter();
        MessageCounterInfo info = MessageCounterInfo.fromJSON((String)jsonString);
        Assertions.assertEquals((int)0, (int)info.getDepth());
        Assertions.assertEquals((long)0L, (long)info.getCount());
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        Thread.sleep(2000L);
        jsonString = queueControl.listMessageCounter();
        info = MessageCounterInfo.fromJSON((String)jsonString);
        Assertions.assertEquals((int)1, (int)info.getDepth());
        Assertions.assertEquals((int)1, (int)info.getDepthDelta());
        Assertions.assertEquals((long)1L, (long)info.getCount());
        Assertions.assertEquals((long)1L, (long)info.getCountDelta());
        QueueControlTest.consumeMessages(1, this.session, queue);
        Thread.sleep(2000L);
        jsonString = queueControl.listMessageCounter();
        info = MessageCounterInfo.fromJSON((String)jsonString);
        Assertions.assertEquals((int)0, (int)info.getDepth());
        Assertions.assertEquals((int)-1, (int)info.getDepthDelta());
        Assertions.assertEquals((long)1L, (long)info.getCount());
        Assertions.assertEquals((long)0L, (long)info.getCountDelta());
        queueControl.resetMessageCounter();
        Thread.sleep(2000L);
        jsonString = queueControl.listMessageCounter();
        info = MessageCounterInfo.fromJSON((String)jsonString);
        Assertions.assertEquals((int)0, (int)info.getDepth());
        Assertions.assertEquals((int)0, (int)info.getDepthDelta());
        Assertions.assertEquals((long)0L, (long)info.getCount());
        Assertions.assertEquals((long)0L, (long)info.getCountDelta());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testListMessageCounterAsHTML() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        String history = queueControl.listMessageCounterAsHTML();
        Assertions.assertNotNull((Object)history);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testListMessageCounterHistory() throws Exception {
        long counterPeriod = 1000L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ActiveMQServerControl serverControl = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        serverControl.enableMessageCounters();
        serverControl.setMessageCounterSamplePeriod(counterPeriod);
        String jsonString = queueControl.listMessageCounterHistory();
        DayCounterInfo[] infos = DayCounterInfo.fromJSON((String)jsonString);
        Assertions.assertEquals((int)1, (int)infos.length);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testListMessageCounterHistoryAsHTML() throws Exception {
        long counterPeriod = 1000L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ActiveMQServerControl serverControl = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        serverControl.enableMessageCounters();
        serverControl.setMessageCounterSamplePeriod(counterPeriod);
        String history = queueControl.listMessageCounterHistoryAsHTML();
        Assertions.assertNotNull((Object)history);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testMoveMessagesBack() throws Exception {
        this.server.createQueue(QueueConfiguration.of((String)"q1").setRoutingType(RoutingType.MULTICAST).setDurable(Boolean.valueOf(this.durable)));
        this.server.createQueue(QueueConfiguration.of((String)"q2").setRoutingType(RoutingType.MULTICAST).setDurable(Boolean.valueOf(this.durable)));
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(true, true);
        ClientProducer prod1 = session.createProducer("q1");
        for (int i = 0; i < 10; ++i) {
            ClientMessage msg = session.createMessage(this.durable);
            msg.putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_DUPLICATE_DETECTION_ID, SimpleString.of((String)("dupl-" + i)));
            prod1.send((org.apache.activemq.artemis.api.core.Message)msg);
        }
        session.commit();
        ClientConsumer consumer = session.createConsumer("q1", true);
        session.start();
        Assertions.assertNotNull((Object)consumer.receive(5000L));
        consumer.close();
        QueueControl q1Control = ManagementControlHelper.createQueueControl(SimpleString.of((String)"q1"), SimpleString.of((String)"q1"), this.mbeanServer);
        QueueControl q2Control = ManagementControlHelper.createQueueControl(SimpleString.of((String)"q2"), SimpleString.of((String)"q2"), this.mbeanServer);
        Assertions.assertEquals((int)10, (int)q1Control.moveMessages(null, "q2"));
        consumer = session.createConsumer("q2", true);
        Assertions.assertNotNull((Object)consumer.receive(500L));
        consumer.close();
        q2Control.moveMessages(null, "q1", false);
        session.start();
        consumer = session.createConsumer("q1");
        for (int i = 0; i < 10; ++i) {
            ClientMessage msg = consumer.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
        }
        consumer.close();
        session.deleteQueue("q1");
        session.deleteQueue("q2");
        session.close();
        locator.close();
    }

    @TestTemplate
    public void testMoveMessagesBack2() throws Exception {
        ClientMessage msg;
        int i;
        this.server.createQueue(QueueConfiguration.of((String)"q1").setRoutingType(RoutingType.MULTICAST).setDurable(Boolean.valueOf(this.durable)));
        this.server.createQueue(QueueConfiguration.of((String)"q2").setRoutingType(RoutingType.MULTICAST).setDurable(Boolean.valueOf(this.durable)));
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(true, true);
        ClientProducer prod1 = session.createProducer("q1");
        int NUMBER_OF_MSGS = 10;
        for (int i2 = 0; i2 < NUMBER_OF_MSGS; ++i2) {
            ClientMessage msg2 = session.createMessage(this.durable);
            msg2.putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_DUPLICATE_DETECTION_ID, SimpleString.of((String)("dupl-" + i2)));
            prod1.send((org.apache.activemq.artemis.api.core.Message)msg2);
        }
        session.commit();
        ClientConsumer consumer = session.createConsumer("q1", true);
        session.start();
        Assertions.assertNotNull((Object)consumer.receive(5000L));
        consumer.close();
        QueueControl q1Control = ManagementControlHelper.createQueueControl(SimpleString.of((String)"q1"), SimpleString.of((String)"q1"), this.mbeanServer);
        QueueControl q2Control = ManagementControlHelper.createQueueControl(SimpleString.of((String)"q2"), SimpleString.of((String)"q2"), this.mbeanServer);
        Assertions.assertEquals((int)NUMBER_OF_MSGS, (int)q1Control.moveMessages(null, "q2"));
        long[] messageIDs = new long[NUMBER_OF_MSGS];
        consumer = session.createConsumer("q2", true);
        for (i = 0; i < NUMBER_OF_MSGS; ++i) {
            msg = consumer.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            messageIDs[i] = msg.getMessageID();
        }
        Assertions.assertNull((Object)consumer.receiveImmediate());
        consumer.close();
        for (i = 0; i < NUMBER_OF_MSGS; ++i) {
            q2Control.moveMessage(messageIDs[i], "q1");
        }
        session.start();
        consumer = session.createConsumer("q1");
        for (i = 0; i < NUMBER_OF_MSGS; ++i) {
            msg = consumer.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
        }
        consumer.close();
        session.deleteQueue("q1");
        session.deleteQueue("q2");
        session.close();
    }

    @TestTemplate
    public void testPauseAndResume() {
        long counterPeriod = 1000L;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        try {
            this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
            QueueControl queueControl = this.createManagementControl(address, queue);
            ActiveMQServerControl serverControl = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
            serverControl.enableMessageCounters();
            serverControl.setMessageCounterSamplePeriod(counterPeriod);
            Assertions.assertFalse((boolean)queueControl.isPaused());
            queueControl.pause();
            Assertions.assertTrue((boolean)queueControl.isPaused());
            queueControl.resume();
            Assertions.assertFalse((boolean)queueControl.isPaused());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @TestTemplate
    public void testResetMessagesAdded() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)this.getMessagesAdded(queueControl));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        Wait.assertEquals((long)1L, () -> this.getMessagesAdded(queueControl));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        Wait.assertEquals((long)2L, () -> this.getMessagesAdded(queueControl));
        QueueControlTest.consumeMessages(2, this.session, queue);
        Wait.assertEquals((long)2L, () -> this.getMessagesAdded(queueControl));
        queueControl.resetMessagesAdded();
        Wait.assertEquals((long)0L, () -> this.getMessagesAdded(queueControl));
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testResetMessagesAcknowledged() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
        ClientProducer producer = this.session.createProducer(address);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        QueueControlTest.consumeMessages(1, this.session, queue);
        Assertions.assertEquals((long)1L, (long)queueControl.getMessagesAcknowledged());
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(this.durable));
        QueueControlTest.consumeMessages(1, this.session, queue);
        Assertions.assertEquals((long)2L, (long)queueControl.getMessagesAcknowledged());
        queueControl.resetMessagesAcknowledged();
        Assertions.assertEquals((long)0L, (long)queueControl.getMessagesAcknowledged());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testResetMessagesExpired() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)queueControl.getMessagesExpired());
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        Wait.assertEquals((int)1, () -> queueControl.listMessages(null).length);
        Map[] messages = queueControl.listMessages(null);
        long messageID = (Long)messages[0].get("messageID");
        queueControl.expireMessage(messageID);
        Assertions.assertEquals((long)1L, (long)queueControl.getMessagesExpired());
        message = this.session.createMessage(this.durable);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        org.apache.activemq.artemis.core.server.Queue serverqueue = this.server.locateQueue(queue);
        Wait.assertEquals((long)1L, () -> ((org.apache.activemq.artemis.core.server.Queue)serverqueue).getMessageCount());
        messages = queueControl.listMessages(null);
        Assertions.assertEquals((int)1, (int)messages.length);
        messageID = (Long)messages[0].get("messageID");
        queueControl.expireMessage(messageID);
        Assertions.assertEquals((long)2L, (long)queueControl.getMessagesExpired());
        queueControl.resetMessagesExpired();
        Assertions.assertEquals((long)0L, (long)queueControl.getMessagesExpired());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testResetMessagesKilled() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)queueControl.getMessagesExpired());
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        Wait.assertEquals((long)1L, () -> ((QueueControl)queueControl).getMessageCount());
        Map[] messages = queueControl.listMessages(null);
        Assertions.assertEquals((int)1, (int)messages.length);
        long messageID = (Long)messages[0].get("messageID");
        queueControl.sendMessageToDeadLetterAddress(messageID);
        Assertions.assertEquals((long)1L, (long)queueControl.getMessagesKilled());
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        message = this.session.createMessage(false);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        ClientConsumer consumer = this.session.createConsumer(queue);
        for (int i = 0; i < ((AddressSettings)this.server.getAddressSettingsRepository().getMatch(queue.toString())).getMaxDeliveryAttempts(); ++i) {
            message = consumer.receive(500L);
            Assertions.assertNotNull((Object)message);
            message.acknowledge();
            this.session.rollback();
        }
        consumer.close();
        Assertions.assertEquals((long)2L, (long)queueControl.getMessagesKilled());
        queueControl.resetMessagesKilled();
        Assertions.assertEquals((long)0L, (long)queueControl.getMessagesKilled());
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testCreateQueueNotification() throws Exception {
        JMSUtil.JMXListener listener = new JMSUtil.JMXListener();
        this.mbeanServer.addNotificationListener(ObjectNameBuilder.DEFAULT.getActiveMQServerObjectName(), listener, null, null);
        SimpleString testQueueName = SimpleString.of((String)"newQueue");
        String testQueueName2 = "newQueue2";
        this.server.createQueue(QueueConfiguration.of((SimpleString)testQueueName).setDurable(Boolean.valueOf(this.durable)));
        Notification notif = listener.getNotification();
        Assertions.assertEquals((Object)CoreNotificationType.BINDING_ADDED.toString(), (Object)notif.getType());
        this.server.destroyQueue(testQueueName);
        notif = listener.getNotification();
        Assertions.assertEquals((Object)CoreNotificationType.BINDING_REMOVED.toString(), (Object)notif.getType());
        ActiveMQServerControl control = ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
        control.createQueue(QueueConfiguration.of((String)testQueueName2).setRoutingType(RoutingType.MULTICAST).toJSON());
        notif = listener.getNotification();
        Assertions.assertEquals((Object)CoreNotificationType.BINDING_ADDED.toString(), (Object)notif.getType());
        control.destroyQueue(testQueueName2);
        notif = listener.getNotification();
        Assertions.assertEquals((Object)CoreNotificationType.BINDING_REMOVED.toString(), (Object)notif.getType());
    }

    @TestTemplate
    public void testSendMessage() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        queueControl.sendMessage(new HashMap(), 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword");
        queueControl.sendMessage(null, 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword");
        Wait.assertEquals((long)2L, () -> this.getMessageCount(queueControl));
        CompositeData[] browse = queueControl.browse(null);
        Assertions.assertEquals((int)2, (int)browse.length);
        byte[] body = (byte[])browse[0].get("BodyPreview");
        Assertions.assertNotNull((Object)body);
        Assertions.assertEquals((Object)new String(body), (Object)"theBody");
        body = (byte[])browse[1].get("BodyPreview");
        Assertions.assertNotNull((Object)body);
        Assertions.assertEquals((Object)new String(body), (Object)"theBody");
    }

    @TestTemplate
    public void testSendMessageWithAMQP() throws Exception {
        TextMessage message;
        MessageProducer producer;
        Session session;
        SimpleString address = SimpleString.of((String)"address_testSendMessageWithAMQP");
        SimpleString queue = SimpleString.of((String)"queue_testSendMessageWithAMQP");
        this.server.addAddressInfo(new AddressInfo(address).setAutoCreated(false).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)).setRoutingType(RoutingType.ANYCAST));
        Wait.assertTrue(() -> this.server.locateQueue(queue) != null && this.server.getAddressInfo(address) != null);
        QueueControl queueControl = this.createManagementControl(address, queue, RoutingType.ANYCAST);
        ConnectionFactory factory = CFUtil.createConnectionFactory("amqp", "tcp://localhost:61616");
        try (Connection connection = factory.createConnection("myUser", "myPassword");){
            session = connection.createSession(false, 1);
            producer = session.createProducer((Destination)session.createQueue(address.toString()));
            producer.setDeliveryMode(2);
            message = session.createTextMessage("theAMQPBody");
            message.setStringProperty("protocolUsed", "amqp");
            producer.send((Message)message);
        }
        factory = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        connection = factory.createConnection("myUser", "myPassword");
        try {
            session = connection.createSession(false, 1);
            producer = session.createProducer((Destination)session.createQueue(address.toString()));
            producer.setDeliveryMode(2);
            message = session.createTextMessage("theCoreBody");
            message.setStringProperty("protocolUsed", "core");
            producer.send((Message)message);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        Wait.assertEquals((Long)2L, () -> this.getMessageCount(queueControl), (long)2000L, (long)100L);
        CompositeData[] browse = queueControl.browse(null);
        Assertions.assertEquals((int)2, (int)browse.length);
        String userID = (String)browse[0].get("userID");
        Assertions.assertTrue((boolean)userID.startsWith("ID:"));
        Assertions.assertFalse((boolean)userID.startsWith("ID:ID:"));
        String body = (String)browse[0].get("text");
        Assertions.assertNotNull((Object)body);
        Assertions.assertEquals((Object)"theAMQPBody", (Object)body);
        userID = (String)browse[1].get("userID");
        Assertions.assertTrue((boolean)userID.startsWith("ID:"));
        Assertions.assertFalse((boolean)userID.startsWith("ID:ID:"));
        body = (String)browse[1].get("text");
        Assertions.assertNotNull((Object)body);
        Assertions.assertEquals((Object)"theCoreBody", (Object)body);
    }

    @TestTemplate
    public void testSendMessageWithAMQPLarge() throws Exception {
        TextMessage message;
        MessageProducer producer;
        Session session;
        SimpleString address = SimpleString.of((String)"address_testSendMessageWithAMQP");
        SimpleString queue = SimpleString.of((String)"queue_testSendMessageWithAMQP");
        this.server.addAddressInfo(new AddressInfo(address).setAutoCreated(false).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)).setRoutingType(RoutingType.ANYCAST));
        Wait.assertTrue(() -> this.server.locateQueue(queue) != null && this.server.getAddressInfo(address) != null);
        QueueControl queueControl = this.createManagementControl(address, queue, RoutingType.ANYCAST);
        StringBuffer bufferLarge = new StringBuffer();
        for (int i = 0; i < 102400; ++i) {
            bufferLarge.append("*-");
        }
        ConnectionFactory factory = CFUtil.createConnectionFactory("amqp", "tcp://localhost:61616");
        try (Connection connection = factory.createConnection("myUser", "myPassword");){
            session = connection.createSession(false, 1);
            producer = session.createProducer((Destination)session.createQueue(address.toString()));
            producer.setDeliveryMode(2);
            message = session.createTextMessage(bufferLarge.toString());
            message.setStringProperty("protocolUsed", "amqp");
            producer.send((Message)message);
        }
        factory = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        connection = factory.createConnection("myUser", "myPassword");
        try {
            session = connection.createSession(false, 1);
            producer = session.createProducer((Destination)session.createQueue(address.toString()));
            producer.setDeliveryMode(2);
            message = session.createTextMessage(bufferLarge.toString());
            message.setStringProperty("protocolUsed", "core");
            producer.send((Message)message);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        Wait.assertEquals((Long)2L, () -> this.getMessageCount(queueControl), (long)2000L, (long)100L);
        CompositeData[] browse = queueControl.browse(null);
        Assertions.assertEquals((int)2, (int)browse.length);
        String body = (String)browse[0].get("text");
        Assertions.assertNotNull((Object)body);
        body = (String)browse[1].get("text");
        Assertions.assertNotNull((Object)body);
    }

    @TestTemplate
    public void testSendMessageWithMessageId() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        queueControl.sendMessage(new HashMap(), 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword");
        queueControl.sendMessage(null, 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword", true);
        Wait.assertEquals((long)2L, () -> this.getMessageCount(queueControl));
        CompositeData[] browse = queueControl.browse(null);
        Assertions.assertEquals((int)2, (int)browse.length);
        byte[] body = (byte[])browse[0].get("BodyPreview");
        String messageID = (String)browse[0].get("userID");
        Assertions.assertEquals((int)0, (int)messageID.length());
        Assertions.assertNotNull((Object)body);
        Assertions.assertEquals((Object)new String(body), (Object)"theBody");
        body = (byte[])browse[1].get("BodyPreview");
        messageID = (String)browse[1].get("userID");
        Assertions.assertTrue((messageID.length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertNotNull((Object)body);
        Assertions.assertEquals((Object)new String(body), (Object)"theBody");
    }

    @TestTemplate
    public void testSendMessageToQueueWithFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)).setFilterString("foo = 'foo'"));
        QueueControl queueControl = this.createManagementControl(address, queue);
        queueControl.sendMessage(new HashMap(), 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword");
        queueControl.sendMessage(Map.of("foo", "foo"), 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword");
        Wait.assertEquals((long)1L, () -> this.getMessageCount(queueControl));
    }

    @TestTemplate
    public void testSendMessageWithProperties() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("myProp1", "myValue1");
        headers.put("myProp2", "myValue2");
        queueControl.sendMessage(headers, 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword");
        queueControl.sendMessage(null, 4, Base64.encodeBytes((byte[])"theBody".getBytes()), true, "myUser", "myPassword");
        Wait.assertEquals((long)2L, () -> this.getMessageCount(queueControl));
        CompositeData[] browse = queueControl.browse(null);
        Assertions.assertEquals((int)2, (int)browse.length);
        byte[] body = (byte[])browse[0].get("BodyPreview");
        for (Object prop : ((TabularDataSupport)browse[0].get("StringProperties")).values()) {
            CompositeDataSupport cds = (CompositeDataSupport)prop;
            Assertions.assertTrue((boolean)headers.containsKey(cds.get("key")));
            Assertions.assertTrue((boolean)headers.containsValue(cds.get("value")));
        }
        Assertions.assertNotNull((Object)body);
        Assertions.assertEquals((Object)new String(body), (Object)"theBody");
        body = (byte[])browse[1].get("BodyPreview");
        Assertions.assertNotNull((Object)body);
        Assertions.assertEquals((Object)new String(body), (Object)"theBody");
    }

    @TestTemplate
    public void testBrowseLimitOnListBrowseAndFilteredCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        AddressSettings addressSettings = new AddressSettings().setManagementBrowsePageSize(5);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        for (int i = 0; i < 10; ++i) {
            producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(true));
        }
        producer.close();
        QueueControl queueControl = this.createManagementControl(address, queue);
        Wait.assertEquals((long)10L, () -> ((QueueControl)queueControl).getMessageCount());
        Assertions.assertEquals((int)5, (int)queueControl.browse().length);
        Assertions.assertEquals((int)5, (int)queueControl.listMessages("").length);
        JsonArray array = JsonUtil.readJsonArray((String)queueControl.listMessagesAsJSON(""));
        Assertions.assertEquals((int)5, (int)array.size());
        Assertions.assertEquals((long)5L, (long)queueControl.countMessages("AMQSize > 0"));
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testBrowseWithNullPropertyValue() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage m = this.session.createMessage(true);
        m.putStringProperty(RandomUtil.randomString(), null);
        producer.send((org.apache.activemq.artemis.api.core.Message)m);
        producer.close();
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((int)1, (int)queueControl.browse().length);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testBrowseWithNullPropertyValueWithAMQP() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)).setRoutingType(RoutingType.ANYCAST));
        JmsConnectionFactory cf = new JmsConnectionFactory("amqp://localhost:61616");
        Connection c = cf.createConnection();
        Session s = c.createSession();
        MessageProducer p = s.createProducer((Destination)s.createQueue(address.toString()));
        Message m = s.createMessage();
        m.setStringProperty("foo", null);
        p.send(m);
        c.close();
        QueueControl queueControl = this.createManagementControl(address, queue, RoutingType.ANYCAST);
        Assertions.assertEquals((int)1, (int)queueControl.browse().length);
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testResetGroups() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        ClientConsumer consumer = this.session.createConsumer(queue);
        Assertions.assertEquals((int)1, (int)queueControl.getConsumerCount());
        consumer.setMessageHandler(message -> logger.debug("{}", (Object)message));
        this.session.start();
        ClientProducer producer = this.session.createProducer(address);
        producer.send(this.session.createMessage(this.durable).putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_GROUP_ID, "group1"));
        producer.send(this.session.createMessage(this.durable).putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_GROUP_ID, "group2"));
        producer.send(this.session.createMessage(this.durable).putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_GROUP_ID, "group3"));
        Wait.assertEquals((int)3, () -> this.getGroupCount(queueControl));
        queueControl.resetGroup("group1");
        Wait.assertEquals((int)2, () -> this.getGroupCount(queueControl));
        producer.send(this.session.createMessage(this.durable).putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_GROUP_ID, "group1"));
        Wait.assertEquals((int)3, () -> this.getGroupCount(queueControl));
        queueControl.resetAllGroups();
        Wait.assertEquals((int)0, () -> this.getGroupCount(queueControl));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testGetScheduledCountOnRemove() throws Exception {
        long delay = Integer.MAX_VALUE;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(this.durable)));
        QueueControl queueControl = this.createManagementControl(address, queue);
        Assertions.assertEquals((long)0L, (long)queueControl.getScheduledCount());
        LocalQueueBinding binding = (LocalQueueBinding)this.server.getPostOffice().getBinding(queue);
        org.apache.activemq.artemis.core.server.Queue q = binding.getQueue();
        Assertions.assertEquals((long)0L, (long)QueueImplTestAccessor.getQueueMemorySize(q));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(this.durable);
        message.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_SCHEDULED_DELIVERY_TIME, System.currentTimeMillis() + delay);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        queueControl.removeAllMessages();
        Assertions.assertEquals((long)0L, (long)queueControl.getMessageCount());
        Assertions.assertEquals((long)0L, (long)QueueImplTestAccessor.getQueueMemorySize(q));
        this.session.deleteQueue(queue);
    }

    @TestTemplate
    public void testRetryMessageWithAutoCreatedResourcesAndOrigRoutingType() throws Exception {
        SimpleString dla = SimpleString.of((String)"DLA");
        SimpleString qName = SimpleString.of((String)"q1");
        SimpleString adName = SimpleString.of((String)"ad1");
        String sampleText = "Put me on DLQ";
        AddressSettings addressSettings = (AddressSettings)this.server.getAddressSettingsRepository().getMatch(adName.toString());
        SimpleString dlq = addressSettings.getDeadLetterQueuePrefix().concat(adName).concat(addressSettings.getDeadLetterQueueSuffix());
        this.server.getAddressSettingsRepository().addMatch(adName.toString(), (Object)new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla).setAutoCreateDeadLetterResources(true));
        this.session.createQueue(QueueConfiguration.of((SimpleString)qName).setAddress(adName).setDurable(Boolean.valueOf(this.durable)).setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = this.session.createProducer(adName);
        ClientMessage m = this.createTextMessage(this.session, "Put me on DLQ");
        m.putByteProperty(org.apache.activemq.artemis.api.core.Message.HDR_ORIG_ROUTING_TYPE, (byte)1);
        producer.send((org.apache.activemq.artemis.api.core.Message)m);
        this.session.start();
        ClientConsumer clientConsumer = this.session.createConsumer(qName);
        ClientMessage clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assertions.assertNotNull((Object)clientMessage);
        Assertions.assertEquals((Object)clientMessage.getBodyBuffer().readString(), (Object)"Put me on DLQ");
        this.session.rollback();
        clientMessage = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)clientMessage);
        QueueControl queueControl = this.createManagementControl(dla, dlq);
        this.assertMessageMetrics(queueControl, 1L, true);
        long messageID = this.getFirstMessageId(queueControl);
        Assertions.assertTrue((boolean)queueControl.retryMessage(messageID));
        Assertions.assertEquals((long)0L, (long)this.getMessageCount(queueControl));
        this.assertMessageMetrics(queueControl, 0L, this.durable);
        clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assertions.assertTrue((clientMessage.getRoutingType() == RoutingType.ANYCAST ? (byte)1 : 0) != 0);
        Assertions.assertNotNull((Object)clientMessage);
        Assertions.assertEquals((Object)"Put me on DLQ", (Object)clientMessage.getBodyBuffer().readString());
        clientConsumer.close();
    }

    @TestTemplate
    public void testRetryMessageReturnedWhenNoOrigQueue() throws Exception {
        SimpleString dla = SimpleString.of((String)"DLA");
        SimpleString qName = SimpleString.of((String)"q1");
        SimpleString adName = SimpleString.of((String)"ad1");
        String sampleText = "Put me on DLQ";
        AddressSettings addressSettings = (AddressSettings)this.server.getAddressSettingsRepository().getMatch(adName.toString());
        SimpleString dlq = addressSettings.getDeadLetterQueuePrefix().concat(adName).concat(addressSettings.getDeadLetterQueueSuffix());
        this.server.getAddressSettingsRepository().addMatch(adName.toString(), (Object)new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla).setAutoCreateDeadLetterResources(true));
        this.session.createQueue(QueueConfiguration.of((SimpleString)qName).setAddress(adName).setDurable(Boolean.valueOf(this.durable)));
        ClientProducer producer = this.session.createProducer(adName);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.createTextMessage(this.session, "Put me on DLQ"));
        this.session.start();
        ClientConsumer clientConsumer = this.session.createConsumer(qName);
        ClientMessage clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assertions.assertNotNull((Object)clientMessage);
        Assertions.assertEquals((Object)clientMessage.getBodyBuffer().readString(), (Object)"Put me on DLQ");
        this.session.rollback();
        clientMessage = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)clientMessage);
        clientConsumer.close();
        QueueControl queueControl = this.createManagementControl(dla, dlq);
        this.assertMessageMetrics(queueControl, 1L, true);
        long messageID = this.getFirstMessageId(queueControl);
        this.session.deleteQueue(qName);
        queueControl.retryMessage(messageID);
        Thread.sleep(100L);
        Assertions.assertEquals((long)1L, (long)this.getMessageCount(queueControl));
        clientConsumer = this.session.createConsumer(dlq);
        clientMessage = clientConsumer.receive(500L);
        clientMessage.acknowledge();
        Assertions.assertNotNull((Object)clientMessage);
        Assertions.assertEquals((Object)"Put me on DLQ", (Object)clientMessage.getBodyBuffer().readString());
        clientConsumer.close();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Configuration conf = this.createDefaultConfig(true).setJMXManagementEnabled(true);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf, (MBeanServer)this.mbeanServer, (boolean)true));
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setConsumerWindowSize(0);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        this.session = sf.createSession(false, true, false);
        this.session.start();
    }

    protected long getFirstMessageId(QueueControl queueControl) throws Exception {
        JsonArray array = JsonUtil.readJsonArray((String)queueControl.getFirstMessageAsJSON());
        JsonObject object = (JsonObject)array.get(0);
        return object.getJsonNumber("messageID").longValue();
    }

    protected void assertMessageMetrics(QueueControl queueControl, long messageCount, boolean durable) throws Exception {
        this.assertMetrics(queueControl, messageCount, durable, () -> ((QueueControl)queueControl).getMessageCount(), () -> ((QueueControl)queueControl).getPersistentSize(), () -> ((QueueControl)queueControl).getDurableMessageCount(), () -> ((QueueControl)queueControl).getDurablePersistentSize());
    }

    protected void assertScheduledMetrics(QueueControl queueControl, long messageCount, boolean durable) throws Exception {
        this.assertMetrics(queueControl, messageCount, durable, () -> ((QueueControl)queueControl).getScheduledCount(), () -> ((QueueControl)queueControl).getScheduledSize(), () -> ((QueueControl)queueControl).getDurableScheduledCount(), () -> ((QueueControl)queueControl).getDurableScheduledSize());
    }

    protected void assertDeliveringMetrics(QueueControl queueControl, long messageCount, boolean durable) throws Exception {
        this.assertMetrics(queueControl, messageCount, durable, () -> ((QueueControl)queueControl).getDeliveringCount(), () -> ((QueueControl)queueControl).getDeliveringSize(), () -> ((QueueControl)queueControl).getDurableDeliveringCount(), () -> ((QueueControl)queueControl).getDurableDeliveringSize());
    }

    protected void assertMetrics(QueueControl queueControl, long messageCount, boolean durable, Supplier<Number> count, Supplier<Number> size, Supplier<Number> durableCount, Supplier<Number> durableSize) throws Exception {
        Assertions.assertTrue((boolean)Wait.waitFor(() -> ((Number)count.get()).longValue() == messageCount, (long)3000L, (long)100L));
        if (messageCount > 0L) {
            Assertions.assertTrue((boolean)Wait.waitFor(() -> ((Number)size.get()).longValue() > 0L, (long)3000L, (long)100L));
            if (durable) {
                Wait.assertEquals((Long)messageCount, () -> ((Number)durableCount.get()).longValue(), (long)3000L, (long)100L);
                Assertions.assertTrue((boolean)Wait.waitFor(() -> ((Number)durableSize.get()).longValue() > 0L, (long)3000L, (long)100L));
            } else {
                Wait.assertEquals((Long)0L, () -> ((Number)durableCount.get()).longValue(), (long)3000L, (long)100L);
                Wait.assertEquals((Long)0L, () -> ((Number)durableSize.get()).longValue(), (long)3000L, (long)100L);
            }
        } else {
            Wait.assertEquals((Long)0L, () -> ((Number)count.get()).longValue(), (long)3000L, (long)100L);
            Wait.assertEquals((Long)0L, () -> ((Number)durableCount.get()).longValue(), (long)3000L, (long)100L);
            Wait.assertEquals((Long)0L, () -> ((Number)size.get()).longValue(), (long)3000L, (long)100L);
            Wait.assertEquals((Long)0L, () -> ((Number)durableSize.get()).longValue(), (long)3000L, (long)100L);
        }
    }
}

